/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanAccessOptParamKeys;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.HAS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RootCrsCommand
extends SimpleShellCommand {
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String dstcrshomeOption = "-dstcrshome";
    private static final String nonrollingOption = "-nonrolling";
    Logger logger = Logger.getLogger(RootCrsCommand.class.getName());
    CommandAction automationAction;

    public RootCrsCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        String ohPath;
        this.logger.log(Level.FINE, "Generating rootcrs command.");
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String ohOrigPath = ohPath = oh.getPath();
        if (this.automationAction.isActsOnClone() && this.automationAction.getType().equals(DBCommandActionType.rootcrsswitchback.toString())) {
            OracleHome ohOrig = oh.getOriginalOracleHome();
            ohOrigPath = ohOrig.getPath();
            this.logger.log(Level.FINE, "OracleHome orig path = " + ohOrigPath);
        }
        this.logger.log(Level.FINE, "OracleHome path = " + ohPath);
        String plPath = "";
        String rootPlPath = PatchPlanner.getInstance().getOPlanEnv().getOptionalParam().get((Object)PatchPlanAccessOptParamKeys.rootCrsPlTempLoc);
        rootPlPath = rootPlPath == null || rootPlPath.trim().equals("") ? ohPath + "/crs/install" : DBCommandParameters.ROOT_CRS_PL_PATH.getValue();
        this.logger.log(Level.INFO, "rootPlPath: " + rootPlPath);
        if ("siha".equals(oh.getHomeType())) {
            plPath = rootPlPath + "/roothas.pl";
        } else if ("crs".equals(oh.getHomeType())) {
            plPath = rootPlPath + "/rootcrs.pl";
        } else {
            throw new PatchPlanInternalException("The root crs command can only work on crs or siha oracle home, current oracle home type is: " + oh.getHomeType());
        }
        String xagPath = null;
        String version = PatchPlanner.getInstance().getConfigGraph().getRootVertex().getVersion();
        if (DBPatchingUtil.isVersionEqalOrlater(version, "19.0.0.0.0")) {
            xagPath = PatchPlanner.getInstance().getOPlanEnv().getOptionalParam().get((Object)PatchPlanAccessOptParamKeys.xagFileTempLoc);
            xagPath = xagPath == null || xagPath.trim().equals("") ? ohPath + "/xag" : DBCommandParameters.XAG_PL_PATH.getValue();
        }
        String perlPath = ohPath + "/perl/bin/perl" + " -I" + ohPath + "/perl/lib" + " -I" + rootPlPath;
        if (xagPath != null) {
            perlPath = perlPath + " -I" + xagPath;
        }
        perlPath = perlPath + " ";
        String osname = System.getProperty("os.name", "");
        StringBuilder cmd = new StringBuilder();
        if (osname.equals("SunOS") || osname.equals("HP-UX")) {
            String ldLibPath = "LD_LIBRARY_PATH=" + OUIDriver.getEnv((String)LD_LIBRARY_PATH) + " ";
            cmd.append(ldLibPath);
            this.logger.log(Level.FINE, "LD_LIBRARY_PATH=" + OUIDriver.getEnv((String)LD_LIBRARY_PATH));
        }
        cmd.append(perlPath);
        cmd.append(plPath);
        List automationCommands = this.automationAction.getCommand();
        for (Command c : automationCommands) {
            for (String param : c.getParameter()) {
                if (dstcrshomeOption.equalsIgnoreCase(param)) {
                    cmd.append(" ").append(dstcrshomeOption).append(" ").append(ohPath);
                    continue;
                }
                if ("-rollback".equalsIgnoreCase(param)) {
                    if (!"crs".equals(oh.getHomeType())) continue;
                    cmd.append(" ").append(param.trim());
                    continue;
                }
                cmd.append(" ").append(param.trim());
            }
        }
        String runtimeDeploymentSubType = PatchPlanner.getInstance().getOPlanEnv().getProperty("runtimeDeploymentSubType");
        String autoDeploymentSubType = PatchPlanner.getInstance().getOPlanEnv().getProperty("autoDeploymentSubType");
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        if (runtimeDeploymentSubType != null) {
            if (DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(runtimeDeploymentSubType) && isTwelveVersion) {
                cmd.append(" ").append(nonrollingOption);
            }
        } else if (DeploymentSubType.NON_ROLLING_UPGRADE.toString().equalsIgnoreCase(autoDeploymentSubType) && isTwelveVersion) {
            cmd.append(" ").append(nonrollingOption);
        }
        return Collections.singletonList(cmd.toString());
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        List<? extends AbstractBaseTarget> applicableTargets = super.getApplicableTargets(g);
        ArrayList<AbstractBaseTarget> hubApplicableTargets = new ArrayList<AbstractBaseTarget>();
        ArrayList<AbstractBaseTarget> rimApplicableTargets = new ArrayList<AbstractBaseTarget>();
        ArrayList sortedApplicableTargets = new ArrayList();
        ArrayList<AbstractBaseTarget> noRoleApplicableTargets = new ArrayList<AbstractBaseTarget>();
        for (AbstractBaseTarget abstractBaseTarget : applicableTargets) {
            List<Host> hostList = g.getConnectedTargets(abstractBaseTarget, Host.class);
            if (hostList == null || hostList.size() <= 0) continue;
            Host host = hostList.get(0);
            String nodeRole = this.getNodeRoleByHost(g, host);
            if (nodeRole != null) {
                if (nodeRole.equals("leaf")) {
                    rimApplicableTargets.add(abstractBaseTarget);
                    continue;
                }
                hubApplicableTargets.add(abstractBaseTarget);
                continue;
            }
            noRoleApplicableTargets.add(abstractBaseTarget);
        }
        if (hubApplicableTargets != null && !hubApplicableTargets.isEmpty()) {
            if (hubApplicableTargets.size() > 1) {
                sortedApplicableTargets.addAll(hubApplicableTargets.subList(0, hubApplicableTargets.size() - 1));
                sortedApplicableTargets.addAll(rimApplicableTargets);
                sortedApplicableTargets.addAll(noRoleApplicableTargets);
                sortedApplicableTargets.add(hubApplicableTargets.get(hubApplicableTargets.size() - 1));
            } else {
                sortedApplicableTargets.add(hubApplicableTargets.get(0));
                sortedApplicableTargets.addAll(rimApplicableTargets);
                sortedApplicableTargets.addAll(noRoleApplicableTargets);
            }
        } else if (rimApplicableTargets != null && !rimApplicableTargets.isEmpty()) {
            sortedApplicableTargets.addAll(rimApplicableTargets);
            sortedApplicableTargets.addAll(noRoleApplicableTargets);
        } else {
            sortedApplicableTargets.addAll(noRoleApplicableTargets);
        }
        return sortedApplicableTargets;
    }

    private String getNodeRoleByHost(ConfigGraph configGraph, Host host) {
        List<HAS> hasList = configGraph.getConnectedTargets((AbstractBaseTarget)host, HAS.class);
        if (hasList == null || hasList.size() <= 0) {
            return null;
        }
        return hasList.get(0).getNodeRole();
    }

    public static class Builder
    implements CommandBuilder<RootCrsCommand> {
        @Override
        public RootCrsCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.rootcrs.toString()) && !a.getType().equals(DBCommandActionType.rootcrsswitchback.toString())) {
                return null;
            }
            RootCrsCommand com = new RootCrsCommand((CommandAction)a);
            return com;
        }
    }
}

