/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopCrsCommand
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(StopCrsCommand.class.getName());
    CommandAction automationAction;

    public StopCrsCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        List<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        if (DBCommandUtils.isNonRollingDeploymentMode() && (executionSteps = super.generateExecutionSteps(configGraph, actsOnlyOnTargets)).size() > 1) {
            executionSteps.remove(0);
        }
        return executionSteps;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        this.logger.log(Level.FINE, "Generating stopcrs command.");
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String crsHome = oh.getPath();
        this.logger.log(Level.FINE, "OracleHome path = " + crsHome);
        String cmd = crsHome + "/bin/crsctl stop crs";
        return Collections.singletonList(cmd);
    }

    public static class Builder
    implements CommandBuilder<StopCrsCommand> {
        @Override
        public StopCrsCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.StopCRS.toString())) {
                return null;
            }
            StopCrsCommand com = new StopCrsCommand((CommandAction)a);
            return com;
        }
    }
}

