/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.StopStartLogShipping;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopStartRedoApply
extends Command {
    static Logger logger = Logger.getLogger(StopStartLogShipping.class.getName());
    private final DBCommandActionType type;
    private final Strategy strat;

    public StopStartRedoApply(ActionType automationAction, DBCommandActionType type, Strategy strat) {
        super(automationAction);
        assert (DBCommandActionType.StartRedoApply.equals((Object)type) || DBCommandActionType.StopRedoApply.equals((Object)type));
        this.type = type;
        this.strat = strat;
    }

    private List<ExecutionStep.Command> getRedoApplyCommand(ExecutionStep es, CommandContext cc) {
        ArrayList<ExecutionStep.Command> executionCmds = new ArrayList<ExecutionStep.Command>();
        String dbName = null;
        OracleHome oracleHome = null;
        AbstractBaseTarget standby = cc.getPrimaryTarget();
        if (standby instanceof RACDatabase) {
            RACDatabase rac = (RACDatabase)standby;
            dbName = rac.getDatabaseName();
            oracleHome = cc.getFirstTarget(OracleHome.class);
        } else if (standby instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)standby;
            dbName = sidb.getDatabaseName();
            oracleHome = cc.getFirstTarget(OracleHome.class);
        }
        String OracleSid = DBCommandUtils.getOracleSID(es, standby);
        logger.info("Data guard broker have not been configed");
        String sqlplusCmd = "ORACLE_HOME=" + oracleHome.getPath() + " ORACLE_SID=" + OracleSid + " " + oracleHome.getPath() + "/bin/sqlplus / as sysdba";
        if (DBCommandActionType.StartRedoApply.equals((Object)this.type)) {
            String sqlCommand = "ALTER DATABASE RECOVER MANAGED STANDBY DATABASE DISCONNECT FROM SESSION;";
            if (ExecutionMode.STANDALONE.equals((Object)PatchPlanner.getInstance().getOPlanEnv().getExecutionMode())) {
                executionCmds.add(new ExecutionStep.Command(sqlplusCmd));
                executionCmds.add(new ExecutionStep.Command(sqlCommand, ExecutionStep.Command.CommandType.SQL));
            } else {
                String tmpSqlFile = this.getTmpSqlFile(cc);
                executionCmds.add(new ExecutionStep.Command(this.wrapSqlSteps(sqlCommand, tmpSqlFile, true)));
                executionCmds.add(new ExecutionStep.Command(this.wrapSqlSteps("EXIT;", tmpSqlFile)));
                sqlplusCmd = sqlplusCmd + " @" + tmpSqlFile;
                executionCmds.add(new ExecutionStep.Command(sqlplusCmd));
            }
        } else {
            executionCmds.add(new ExecutionStep.Command(sqlplusCmd));
        }
        return executionCmds;
    }

    private String wrapSqlSteps(String cmd, String tmpSqlFile) {
        return this.wrapSqlSteps(cmd, tmpSqlFile, false);
    }

    private String wrapSqlSteps(String cmd, String tmpSqlFile, boolean firstSqlCmd) {
        if (firstSqlCmd) {
            return "echo \"" + cmd + "\" > " + tmpSqlFile;
        }
        return "echo \"" + cmd + "\" >> " + tmpSqlFile;
    }

    private String getTmpSqlFile(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String ohName = oh.getName() == null ? "" : oh.getName().replace(" ", "");
        String user = oh.getOwner();
        String tmpSqlFile = "/tmp/" + ohName + "_" + user + ".sql";
        return tmpSqlFile;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            assert (abstractBaseTarget instanceof RACDatabase);
            if (!(abstractBaseTarget instanceof RACDatabase) && !(abstractBaseTarget instanceof SIDatabase)) {
                throw new PatchPlanException("StopStartRedoApply action can act only on RACDatabase and SIDatabase, but found: " + abstractBaseTarget.getClass().getName());
            }
            CommandContext cc = contextPopulator.populateContext(g, abstractBaseTarget, this.getHost());
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(cc);
            }
            if (!DBCommandUtils.isPhysicalStandbyDatabase(abstractBaseTarget)) continue;
            logger.info("Current Database is a standby database " + abstractBaseTarget.getName());
            if (DBCommandUtils.isUsingBroker(abstractBaseTarget)) continue;
            ExecutionStep es = CommandUtils.getBasicExecutionStep(this.automationAction, cc, null);
            es.getCommand().addAll(this.getRedoApplyCommand(es, cc));
            steps.add(es);
        }
        return steps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(DBCommandActionType.StartRedoApply.toString()) || a.getType().equals(DBCommandActionType.StopRedoApply.toString()))) {
                logger.info(" crate stop start log shipping command" + a.getType());
                return new StopStartRedoApply(a, DBCommandActionType.valueOf(a.getType()), s);
            }
            return null;
        }
    }
}

