/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.driver.jdbc.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import dbmodel.db_crs.Region;
import dbmodel.db_crs.ShardProperty;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class SDBCatalogConnection {
    Logger logger = Logger.getLogger(SDBCatalogConnection.class.getName());
    private Connection connectionDB = null;
    private Statement statement = null;
    private String host = null;
    private String port = null;
    private String sid = null;
    private String service = null;
    private String userID = null;
    private String password = null;

    private SDBCatalogConnection() {
    }

    public static SDBCatalogConnection getInstance() {
        return LoadConnection._connection;
    }

    public void init(String host, String port, String sid, String service, String userID, String password) {
        this.host = host;
        this.port = port;
        this.sid = sid;
        this.service = service;
        this.userID = userID;
        this.password = password;
    }

    public void connectToCatalogDB() throws SQLException {
        String connPrimaryString = null;
        if (!StringUtil.isNullOrEmpty((String)this.sid)) {
            connPrimaryString = this.host + ":" + this.port + ":" + this.sid;
        } else if (!StringUtil.isNullOrEmpty((String)this.service)) {
            connPrimaryString = this.host + ":" + this.port + "/" + this.service;
        } else {
            throw new ProductDriverException(OPatchAutoHelper.getLocalizedString((String)"SDBCatalogConnection.nosid.noservice", (Object[])new Object[0]));
        }
        this.logger.info("Connection string :: " + connPrimaryString);
        this.userID = this.userID + " as sysdba";
        try {
            this.connectionDB = DriverManager.getConnection("jdbc:oracle:thin:@" + connPrimaryString, this.userID, this.password);
            this.connectionDB.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.closeConnection();
            throw new SQLException(OPatchAutoHelper.getLocalizedString((String)"SDBCatalogConnection.connection.failure", (Object[])new Object[]{!StringUtil.isNullOrEmpty((String)this.sid) ? this.sid : this.service, e}));
        }
        this.logger.info("Connection established with db '" + this.sid + "' on host '" + this.host + "' on port '" + this.port + "'");
    }

    public void closeConnection() throws SQLException {
        if (null != this.connectionDB) {
            this.logger.fine("Closing connection");
            this.connectionDB.close();
        }
        this.logger.fine("Closed the connection");
    }

    private void closeStatement() throws SQLException {
        if (null != this.statement) {
            this.logger.fine("Closing statement.");
            this.statement.close();
        }
        this.logger.fine("Closed the statement.");
    }

    private void closeResultSet(ResultSet rset) throws SQLException {
        if (rset != null) {
            this.logger.fine("Closing resultset");
            rset.close();
        }
        this.logger.fine("Closed the resultset");
    }

    public List<ShardProperty> getAllShardDBDetails(boolean isOgg) throws SQLException {
        ArrayList<ShardProperty> shardPropList = new ArrayList<ShardProperty>();
        ResultSet rs = this.prepareAndExecuteQuery("SELECT DB_UNIQUE_NAME,REGION_NAME,CONNECT_STRING,VERSION,RAC_TYPE,SHARDGROUP,DG_BROKER_ID,SHARDSPACE,DB_UP,IS_PRIMARY,DB_HOST,ORACLE_HOME,STATUS FROM GSMADMIN_INTERNAL.SHA_DATABASES");
        try {
            while (rs.next()) {
                ShardProperty shardProperty = new ShardProperty();
                shardProperty.setShardName(rs.getString("DB_UNIQUE_NAME"));
                this.logger.info("DB_UNIQUE_NAME : " + rs.getString("DB_UNIQUE_NAME"));
                Region region = new Region();
                region.setRegionName(rs.getString("REGION_NAME"));
                this.logger.info("REGION_NAME : " + rs.getString("REGION_NAME"));
                shardProperty.setRegion(region);
                shardProperty.setConnectString(rs.getString("CONNECT_STRING"));
                this.logger.info("CONNECT_STRING : " + rs.getString("CONNECT_STRING"));
                shardProperty.setShardVersion(rs.getString("VERSION"));
                this.logger.info("VERSION : " + rs.getString("VERSION"));
                shardProperty.setDbType(rs.getString("RAC_TYPE"));
                this.logger.info("RAC_TYPE : " + rs.getString("RAC_TYPE"));
                shardProperty.setShardGroupName(rs.getString("SHARDGROUP"));
                this.logger.info("SHARDGROUP : " + rs.getString("SHARDGROUP"));
                shardProperty.setDrsetNumber(Integer.valueOf(rs.getInt("DG_BROKER_ID")));
                this.logger.info("DG_BROKER_ID : " + rs.getString("DG_BROKER_ID"));
                shardProperty.setShardSpaceName(rs.getString("SHARDSPACE"));
                this.logger.info("SHARDSPACE : " + rs.getString("SHARDSPACE"));
                shardProperty.setIsDatabaseUp(rs.getString("DB_UP"));
                this.logger.info("DB_UP : " + rs.getString("DB_UP"));
                shardProperty.setIsPrimary(rs.getString("IS_PRIMARY"));
                this.logger.info("IS_PRIMARY : " + rs.getString("IS_PRIMARY"));
                shardProperty.setShardHost(rs.getString("DB_HOST"));
                this.logger.info("DB_HOST : " + rs.getString("DB_HOST"));
                shardProperty.setOraceHomePath(PatchActionUtil.rectifyPath(rs.getString("ORACLE_HOME")));
                this.logger.info("ORACLE_HOME : " + PatchActionUtil.rectifyPath(rs.getString("ORACLE_HOME")));
                shardProperty.setStatus(rs.getString("STATUS"));
                this.logger.info("STATUS : " + rs.getString("STATUS"));
                if (isOgg) {
                    ResultSet rs1 = this.prepareAndExecuteQuery("SELECT OGG_HOME,GGSYS.REPCONF_DB.VERSION FROM GGSYS.REPCONF_DB,GSMADMIN_INTERNAL.DATABASE WHERE GGSYS.REPCONF_DB.DATABASE_NUM=GSMADMIN_INTERNAL.DATABASE.DATABASE_NUM AND GSMADMIN_INTERNAL.DATABASE.NAME='" + rs.getString("DB_UNIQUE_NAME") + "'");
                    try {
                        while (rs1.next()) {
                            shardProperty.setGoldenGateHome(PatchActionUtil.rectifyPath(rs1.getString("OGG_HOME")));
                            this.logger.info("OGG_HOME : " + PatchActionUtil.rectifyPath(rs1.getString("OGG_HOME")));
                            shardProperty.setGoldenGateVersion(rs1.getString("VERSION"));
                            this.logger.info("OGG VERSION : " + rs1.getString("VERSION"));
                        }
                    }
                    catch (Exception e) {
                        throw new SQLException("Unable to set ogg home details : ", e);
                    }
                    finally {
                        this.closeResultSet(rs1);
                    }
                }
                this.logger.info("\n\n");
                shardPropList.add(shardProperty);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to set shard properties : ", e);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement();
            this.closeConnection();
        }
        return shardPropList;
    }

    public int getShardViewDesc() throws SQLException {
        ResultSet rs = this.prepareAndExecuteQuery("SELECT COUNT(*) FROM  GSMADMIN_INTERNAL.SHA_DATABASES");
        int noOfRows = 0;
        try {
            while (rs.next()) {
                noOfRows = rs.getInt(1);
                this.logger.info("No of entries in sharded db view : " + noOfRows);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to get the count of rows from the view GSMADMIN_INTERNAL.SHA_DATABASES : ", e);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement();
        }
        return noOfRows;
    }

    public int getReplicationType() throws SQLException {
        this.connectToCatalogDB();
        ResultSet rs = this.prepareAndExecuteQuery("SELECT REPLICATION_TYPE FROM GSMADMIN_INTERNAL.CLOUD");
        int replicationType = 0;
        try {
            while (rs.next()) {
                replicationType = rs.getInt("REPLICATION_TYPE");
                this.logger.info("Replication type is : " + replicationType);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to get the replication type from GSMADMIN_INTERNAL.CLOUD ", e);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement();
        }
        return replicationType;
    }

    public int getShardingType() throws SQLException {
        ResultSet rs = this.prepareAndExecuteQuery("SELECT SHARDING_TYPE FROM GSMADMIN_INTERNAL.CLOUD");
        int shardingType = 0;
        try {
            while (rs.next()) {
                shardingType = rs.getInt("SHARDING_TYPE");
                this.logger.info("Sharding type is : " + shardingType);
            }
        }
        catch (Exception e) {
            throw new SQLException("Unable to get the sharding type from GSMADMIN_INTERNAL.CLOUD ", e);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement();
        }
        return shardingType;
    }

    private ResultSet prepareAndExecuteQuery(String query) throws SQLException {
        try {
            this.statement = this.connectionDB.createStatement(1004, 1008);
        }
        catch (SQLException e) {
            this.closeStatement();
            throw new SQLException("Unable to create statement : ", e);
        }
        ResultSet rset = null;
        this.logger.finer("Executing database query : " + query);
        try {
            rset = this.statement.executeQuery(query);
        }
        catch (SQLException e) {
            this.closeResultSet(rset);
            this.closeStatement();
            throw new SQLException("Unable to execute query : " + query + " : \n", e);
        }
        return rset;
    }

    private static class LoadConnection {
        static SDBCatalogConnection _connection = new SDBCatalogConnection();

        private LoadConnection() {
        }
    }
}

