/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.patchlevel.MultiHostCommandResultListener;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OHPatchLevelRequestParam;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.SshConnectionRequestParam;
import com.oracle.glcm.patch.auto.topology.Host;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class MultiHostCommandExecutor
implements Runnable {
    private static final String PERL_PATH = "/perl/bin/perl ";
    private OracleHomePatchLevel patchLevels;
    private final Host host;
    private final MultiHostCommandResultListener resultListener;
    private final Map<String, OHPatchLevelRequestParam> ownerRequestParamMap;
    private Logger logger = Logger.getLogger(MultiHostCommandExecutor.class.getName());

    public MultiHostCommandExecutor(Host host, MultiHostCommandResultListener resultListener, Map<String, OHPatchLevelRequestParam> ownerRequestParamMap) {
        this.host = host;
        this.resultListener = resultListener;
        this.ownerRequestParamMap = ownerRequestParamMap;
    }

    @Override
    public void run() {
        String hostName = this.host.getHost();
        this.logger.fine("Executing Thread on host: " + hostName);
        Set<String> ownerSet = this.ownerRequestParamMap.keySet();
        boolean isMultiUserSetUp = ownerSet.size() > 1;
        for (String owner : ownerSet) {
            this.logger.fine("[hostname: " + hostName + "] owner: " + owner);
            String queryCommand = this.ownerRequestParamMap.get(owner).getCommand();
            this.logger.fine("[hostname: " + hostName + "] queryCommand: " + queryCommand);
            String currentUser = System.getProperty("user.name");
            String command = queryCommand;
            String homePath = this.ownerRequestParamMap.get(owner).getOracleHomeLocations().get(0);
            try {
                String sshPrivateKeyLocation = null;
                if (!"root".equalsIgnoreCase(currentUser) && !isMultiUserSetUp) {
                    sshPrivateKeyLocation = this.host.getSSHPrivateKeyLocation();
                }
                if (!StringUtil.isNullOrEmpty((String)System.getProperty("OVERRIDDEN_ACCESS_KEY"), (boolean)true)) {
                    sshPrivateKeyLocation = System.getProperty("OVERRIDDEN_ACCESS_KEY");
                }
                if (this.host.isRemote()) {
                    String requestParamLocation = homePath + File.separator + "cfgtoollogs" + File.separator + "opatchautodb" + File.separator + "sshconnectionparam_" + owner + "_" + this.host.getHost() + ".obj";
                    command = this.prepareRemoteConnection(hostName, homePath, queryCommand, homePath, this.ownerRequestParamMap.get(owner).getResultLocation(), sshPrivateKeyLocation, requestParamLocation, owner);
                }
            }
            catch (OPatchAutoException e) {
                this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 102, "OPatchAutoException: " + e.getMessage(), this.host, null);
            }
            this.logger.fine("[hostname: " + hostName + "] command: " + command);
            byte[] password = this.host.getPassword();
            GISystemCall.ExecReturn ret = GISystemCall.process(command, owner, password);
            if (ret.isOK()) {
                this.logger.fine("[hostname: " + hostName + "] Patch information query successfull");
                String result = this.ownerRequestParamMap.get(owner).getResultLocation();
                this.deserializePatchLevel(result);
                new File(result).delete();
                continue;
            }
            this.logger.info("[hostname: " + hostName + "] Patch information query failed: " + ret.getErrorMessage());
            this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, ret.getReturnCode(), "Failed to get patch information" + ret.getErrorMessage(), this.host, null);
        }
        this.resultListener.notify(MultiHostCommandResultListener.ResultID.SUCCESS, 0, "Success", this.host, this.patchLevels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserializePatchLevel(String objectLoc) {
        FileInputStream fileIn = null;
        ObjectInputStream in = null;
        try {
            fileIn = new FileInputStream(objectLoc);
            in = new ObjectInputStream(fileIn);
            OracleHomePatchLevel e = (OracleHomePatchLevel)in.readObject();
            if (this.patchLevels == null) {
                this.patchLevels = e;
            } else {
                this.updatePatchLevelInfo(e);
            }
            this.logger.info("[hostname: " + this.host.getHost() + "] patchLevelsOnHost: " + this.patchLevels);
        }
        catch (IOException e) {
            this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 104, "Failed to get patch information due to FileNotFoundException: " + e.getMessage(), this.host, null);
        }
        catch (ClassNotFoundException e) {
            this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 104, "Failed to get patch information due to ClassNotFoundException: " + e.getMessage(), this.host, null);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException e) {
                this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 104, "Failed to get patch information due to FileNotFoundException: " + e.getMessage(), this.host, null);
            }
        }
    }

    private void updatePatchLevelInfo(OracleHomePatchLevel e) {
        Map<String, List<OPatchPatchInfo>> newPatchLevelInfo = e.getOracleHomePatchLevel();
        for (String oh : newPatchLevelInfo.keySet()) {
            List<OPatchPatchInfo> patchInfo = newPatchLevelInfo.get(oh);
            this.patchLevels.addOracleHomePatchLevel(oh, patchInfo);
        }
    }

    private String prepareRemoteConnection(String hostName, String perlPath, String command, String ohPath, String objectLoc, String accessKey, String paramLocation, String owner) {
        this.prepareRemoteCommandArguments(hostName, command, objectLoc, accessKey, paramLocation, owner);
        String remoteCommand = this.getPerlCommand(perlPath, ohPath, "RemoteCommandExecution.pl", paramLocation);
        return remoteCommand;
    }

    private String getPerlCommand(String perlPath, String ohPath, String perlFile, String args) {
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append(perlPath);
        remoteCommand.append(PERL_PATH);
        remoteCommand.append(ohPath);
        remoteCommand.append(File.separator);
        remoteCommand.append("OPatch");
        remoteCommand.append(File.separator);
        remoteCommand.append("auto");
        remoteCommand.append(File.separator);
        remoteCommand.append("database");
        remoteCommand.append(File.separator);
        remoteCommand.append("bin");
        remoteCommand.append(File.separator);
        remoteCommand.append(perlFile);
        remoteCommand.append(" ");
        remoteCommand.append(args);
        return remoteCommand.toString();
    }

    private void prepareRemoteCommandArguments(String hostName, String command, String objectLoc, String accessKey, String paramLocation, String owner) {
        SshConnectionRequestParam param = new SshConnectionRequestParam();
        param.setAccessKey(accessKey);
        param.setCommand(command);
        param.setHostName(hostName);
        param.setResultLocation(objectLoc);
        this.persistPatchInfo(paramLocation, param, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistPatchInfo(String location, SshConnectionRequestParam param, String owner) {
        File persistFile = new File(location);
        File parentDirectory = persistFile.getParentFile();
        if (!parentDirectory.exists()) {
            this.createDirectory(owner, parentDirectory.getAbsolutePath());
        }
        if (persistFile.exists()) {
            persistFile.delete();
        }
        FileOutputStream fileOut = null;
        ObjectOutputStream out = null;
        try {
            fileOut = new FileOutputStream(location);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(param);
        }
        catch (FileNotFoundException e) {
            this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 104, "FileNotFoundException: " + e.getMessage(), this.host, null);
        }
        catch (IOException e) {
            this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 104, "IOException: " + e.getMessage(), this.host, null);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 104, "IOException: " + e.getMessage(), this.host, null);
            }
        }
    }

    private void createDirectory(String owner, String parentDirectory) {
        Credential credential = this.host.getCredential();
        boolean isCreated = DBPatchingUtil.mkdirs(parentDirectory, owner, credential);
        if (!isCreated) {
            this.logger.info("[hostname: " + this.host.getHost() + "] Failed to create request object for remote patch information query");
            this.resultListener.notify(MultiHostCommandResultListener.ResultID.FAILED, 72105, "Failed to create request object for remote patch information query", this.host, null);
        }
    }
}

