/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.db.product.patchlevel.SshConnectionRequestParam;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class SshRemoteConnectionHandler {
    private static final Logger _log = Logger.getLogger(SshRemoteConnectionHandler.class.getName());

    public static void main(String[] args) {
        String requestParamObject = args[0];
        SshRemoteConnectionHandler connectionHandler = new SshRemoteConnectionHandler();
        try {
            connectionHandler.processRemoteCommand(requestParamObject);
        }
        catch (RemoteConnectionException e) {
            _log.info("RemoteConnectionException: Remote command execution failed due to " + e.getMessage());
            System.exit(101);
        }
        catch (OPatchAutoException e) {
            _log.info("OPatchAutoException: Failed due to " + e.getMessage());
            System.exit(e.getMessageID());
        }
    }

    private void processRemoteCommand(String requestParamObject) throws OPatchAutoException, RemoteConnectionException {
        _log.fine("Process remote command execution: " + requestParamObject);
        String hostname = null;
        String command = null;
        String resultLocation = null;
        SshConnectionRequestParam requestParam = this.deserializePatchLevel(requestParamObject);
        new File(requestParamObject).delete();
        hostname = requestParam.getHostName();
        command = requestParam.getCommand();
        resultLocation = requestParam.getResultLocation();
        _log.info("hostname: " + hostname);
        _log.info("command: " + command);
        _log.info("resultLocation: " + resultLocation);
        HostImpl host = new HostImpl();
        host.setHost(hostname);
        host.setRemoteConnectionType("linuxclisshuserequivalence");
        this.connectAndExecute(command, resultLocation, (Host)host);
    }

    private void connectAndExecute(String command, String resultLocation, Host host) throws OPatchAutoException, RemoteConnectionException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        RemoteConnectionHandler handler = null;
        try {
            handler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)host);
            handler.exec(command, (OutputStream)outputStream);
            String outPutMsg = outputStream.toString();
            _log.info("outPutMsg: " + outPutMsg);
            OracleHomePatchLevel patchLevel = (OracleHomePatchLevel)handler.getObject(resultLocation);
            _log.info("patchLevel: " + patchLevel);
            if (patchLevel != null) {
                this.persistPatchInfo(resultLocation, patchLevel);
            }
        }
        catch (IOException e) {
            throw new OPatchAutoException(e.getMessage(), 104);
        }
        finally {
            if (handler != null) {
                handler.close();
            }
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                throw new OPatchAutoException(e.getMessage(), 104);
            }
        }
    }

    private void persistPatchInfo(String location, OracleHomePatchLevel oracleHomePatchLevel) throws OPatchAutoException, IOException {
        File persistFile = new File(location);
        if (!persistFile.getParentFile().exists()) {
            persistFile.getParentFile().mkdirs();
        }
        if (persistFile.exists()) {
            persistFile.delete();
        }
        FileOutputStream fileOut = null;
        ObjectOutputStream out = null;
        try {
            fileOut = new FileOutputStream(location);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(oracleHomePatchLevel);
        }
        catch (FileNotFoundException e) {
            throw new OPatchAutoException(e.getMessage(), 104);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fileOut != null) {
                fileOut.close();
            }
        }
    }

    private SshConnectionRequestParam deserializePatchLevel(String objectLoc) throws OPatchAutoException {
        SshConnectionRequestParam param = null;
        FileInputStream fileIn = null;
        ObjectInputStream in = null;
        try {
            fileIn = new FileInputStream(objectLoc);
            in = new ObjectInputStream(fileIn);
            param = (SshConnectionRequestParam)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException e) {
            throw new OPatchAutoException(e.getMessage(), 104);
        }
        catch (ClassNotFoundException e) {
            throw new OPatchAutoException((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException(e.getMessage(), 104);
            }
        }
        return param;
    }
}

