/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.summary.generator;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.product.summary.ISummaryGenerator;
import com.oracle.glcm.patch.auto.db.product.summary.Summary;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryTarget;
import java.util.List;
import java.util.Map;

public class AnalyzeSummaryGenerator
implements ISummaryGenerator {
    @Override
    public void generateSummary(SummaryID id, Map<SummaryTarget, Summary> summaryTargetList, List<String> summaryList, OPatchAutoCommand command) {
        boolean isFailure = false;
        if (id == SummaryID.patching_analyze) {
            String sessionVal;
            String string = sessionVal = command.isRollback() ? OPatchAutoHelper.getLocalizedString((String)"rollingback.value", (Object[])new Object[0]) : OPatchAutoHelper.getLocalizedString((String)"applying.value", (Object[])new Object[0]);
            if (this.isFailure(summaryTargetList)) {
                isFailure = true;
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"Analyze.failure.message", (Object[])new Object[]{sessionVal}));
            } else {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"Analyze.success.message", (Object[])new Object[]{sessionVal}));
            }
            for (Map.Entry<SummaryTarget, Summary> summaryEntry : summaryTargetList.entrySet()) {
                Reporting.report((String)("Host:" + summaryEntry.getKey().getHost()));
                Reporting.report((String)(summaryEntry.getKey().getProductType() + " Home:" + summaryEntry.getKey().getHome()));
                if (!StringUtil.isNullOrEmpty((String)summaryEntry.getKey().getVersion(), (boolean)true)) {
                    Reporting.report((String)("Version:" + summaryEntry.getKey().getVersion()));
                }
                if (summaryEntry.getValue().getStatus() == 1) {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"Analyze.failed.message", (Object[])new Object[]{sessionVal}));
                }
                Reporting.report((String)(summaryEntry.getValue().getSummaryDetails() + "\n"));
            }
            if (isFailure) {
                Reporting.report((String)OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72053), (Object[])new Object[0]));
            }
        }
    }

    private boolean isFailure(Map<SummaryTarget, Summary> summaryTargetList) {
        boolean isFailure = false;
        for (Map.Entry<SummaryTarget, Summary> summaryEntry : summaryTargetList.entrySet()) {
            if (summaryEntry.getValue().getStatus() != 1) continue;
            isFailure = true;
            break;
        }
        return isFailure;
    }
}

