/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.OracleHome;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CRSExecutionModeValidator
implements IValidator {
    private final Logger logger = Logger.getLogger(CRSExecutionModeValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        boolean isNonRolling = (Boolean)params.get(ValidationParamKey.NONROLLING_OPTION.ordinal());
        boolean isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        String message = null;
        if (isOOPEnabled) {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            message = "Execution mode validation successful.";
            this.logger.log(Level.FINE, message);
        } else {
            for (BaseClass b : systemInst.getEntities()) {
                OracleHome oh;
                String hometype;
                if (!(b instanceof OracleHome) || !(hometype = (oh = (OracleHome)b).getHomeType()).equalsIgnoreCase("crs") || !oh.getIsShared() || isNonRolling) continue;
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_EXECUTION_MODE, oh));
                message = BundleUtils.getMessage(CRSExecutionModeValidator.class, "INVALID_EXECUTION_MODE", oh.getPath());
                break;
            }
            if (message == null) {
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
                message = "Execution mode validation successful.";
                this.logger.log(Level.FINE, message);
            } else {
                Reporting.report((String)message.toString());
                this.logger.log(Level.INFO, message);
            }
        }
        return multipleValidationResult;
    }
}

