/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class GIHomeValidator
implements IValidator {
    Logger logger = Logger.getLogger(GIHomeValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking rule to check if the GIHomes exist and include the host details.");
        ArrayList<BaseClass> list = new ArrayList<BaseClass>();
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        List homes = systemInst.getTargetsOfType(OracleHome.class);
        String message = null;
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        if (homes == null || homes.isEmpty()) {
            this.logger.log(Level.FINE, "The system instance contains no homes.");
            message = BundleUtils.getMessage(GIHomeValidator.class, "NO_HOMES_IN_SYSTEM_INSTANCE", new Object[0]);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_HOMES_IN_SYSTEM_INSTANCE, null));
            return multipleValidationResult;
        }
        ArrayList<OracleHome> giHomes = new ArrayList<OracleHome>();
        for (AbstractBaseTarget abt : homes) {
            OracleHome home = (OracleHome)abt;
            if (!home.getHomeType().equals("crs")) continue;
            this.logger.log(Level.FINEST, "Found GIHome at" + home.getPath());
            giHomes.add(home);
        }
        if (giHomes == null || giHomes.isEmpty()) {
            this.logger.log(Level.INFO, "The configuration contains no Grid Infrastructure homes. ");
            message = BundleUtils.getMessage(GIHomeValidator.class, "NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE", "Grid Infrastructure");
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE, null));
            return multipleValidationResult;
        }
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        boolean isOOPEnabled = false;
        if (params.get(ValidationParamKey.OOP_ENABLED.ordinal()) != null) {
            isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        }
        if (ClusterInformationLoader.getInstance().getCRSType().equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY) && isOOPEnabled) {
            this.logger.log(Level.INFO, "OOP patching is not supported on Software only GI homes. ");
            message = BundleUtils.getMessage(GIHomeValidator.class, "SOFTWARE_ONLY_GI_WITH_OOP", "Grid Infrastructure");
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.SOFTWARE_ONLY_GI_WITH_OOP, null));
            return multipleValidationResult;
        }
        for (OracleHome gihome : giHomes) {
            List hosts = gihome.getHosts();
            if (hosts != null && !hosts.isEmpty()) continue;
            this.logger.log(Level.FINE, "GIHome at path " + gihome.getPath() + " doesn't have the host information set.");
            list.add((BaseClass)gihome);
        }
        if (list != null && !list.isEmpty()) {
            message = BundleUtils.getMessage(GIHomeValidator.class, "MISSING_HOST", BundleUtils.makeStringOutOfList(list));
            Reporting.report((String)message);
            this.logger.log(Level.INFO, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_HOST, list));
            return multipleValidationResult;
        }
        message = " GIhome configuration is valid";
        this.logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }
}

