/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import model.common.AbstractBaseTarget;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchDeployException;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchFATarget;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchSOAConfigPlan;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUnDeployException;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.opatchsdk.SOASingleAPIReturnStatus;
import oracle.opatch.patchverbs.AutomationElement;

public class OPatchSOADeployAction
extends OPatchDeployAction
implements Cloneable {
    private OPatchSOAConfigPlan configPlanVal = OPatchSOAConfigPlan.NONE_CONFIG_PLAN;
    private WLDomain domainInfo = null;
    private String[] revHistory = new String[0];

    protected OPatchSOADeployAction(AutomationElement auto_el) {
        super(auto_el);
    }

    protected OPatchSOADeployAction() {
    }

    public String getSOACompositeName() {
        return this.dael.getSOADeployCompositeName();
    }

    public String getSOACompositeRevision() {
        return this.dael.getSOADeployRevision();
    }

    public boolean isBaseCompositeDeployment() {
        return this.dael.isBaseCompositeDeployment();
    }

    public void setConfigPlan(OPatchSOAConfigPlan plan) {
        this.configPlanVal = plan;
    }

    public OPatchSOAConfigPlan getConfigPlan() {
        return this.configPlanVal;
    }

    public WLDomain getBoundDomain() {
        return this.domainInfo;
    }

    @Override
    protected Map constructMap() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        Map superEnv = super.constructMap();
        env.putAll(superEnv);
        WLAdminServer adminServer = this.domainInfo.getWLAdminServer();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.COMMON_COMPONENTS_HOME", this.getCommonComponentsHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        env.put("CompRevisionsToUndoDeploy", this.revHistory);
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undoDeploy() throws OPatchUnDeployException {
        String stepMsg;
        String errorMsg;
        FMWClient client = null;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        this.setFailedClosingStep(null);
        String oracleHomePath = "";
        String logFile = "";
        boolean updatePrereqFailure = false;
        OPatchUnDeployException de = null;
        try {
            String errorMsg2;
            oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            try {
                if (patch == null) {
                    throw new OPatchUnDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String compName = OPatchUtils.norm(this.getSOACompositeName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "UndoDeploy_Composite_" + compName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg3 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg3, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchUnDeployException(errorMsg);
            }
            super.doPrereq(OPatchFAOperation.PREREQ_UNDEPLOY);
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                errorMsg2 = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg3 = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg3, errorMsg2, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            String[] revisionToUndeploy = OPatchUtils.getRevisionToUndeploy(OPatchFATarget.getConfigContext(), this, this.getBoundDomain());
            if (revisionToUndeploy == null || revisionToUndeploy.length != 2) {
                errorMsg2 = "OPatch was not able to find a previous revision ID to fall back and activate if the composite is to be undeployed.";
                String stepMsg4 = "Check if OPatch can get a previous revision for the composite from Configuration context - Revision history.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.SOA_GET_PREVIOUS_REVISION_TO_FALL_BACK, stepMsg4, errorMsg2, null);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchUnDeployException(errorMsg2);
            }
            this.revHistory = revisionToUndeploy;
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                String errorMsg4 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg5 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg5, errorMsg4, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            client.undeploy();
            OPatchUtils.updatePrereq(client, this);
            updatePrereqFailure = true;
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                throw new OPatchUnDeployException("OPatch failed in prerequisite checks prior to undeploy.");
            }
        }
        catch (Throwable t) {
            try {
                if (!updatePrereqFailure) {
                    OPatchUtils.updatePrereq(client, this);
                    updatePrereqFailure = true;
                }
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchUnDeployException re = new OPatchUnDeployException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                de = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg5 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg6 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg6, errorMsg5, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                OPatchStepOperation prereqStep = this.getFailedPrereqStep();
                if (prereqStep != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (de == null) return;
                    throw de;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.UNDEPLOY);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                if (client != null) {
                    SOAComposite s = client.getSOAComposite();
                    String revToDelete = s.getRevision();
                    String soaCompName = s.getName();
                    String prevRevision = s.getDefaultRevisionBeforeUndeploy();
                    String currRevision = s.getDefaultRevisionAfterUndeploy();
                    boolean failure = false;
                    if (de != null) {
                        failure = true;
                    }
                    OPatchUtils.updateConfig(this.domainInfo, soaCompName, prevRevision, currRevision, revToDelete, failure, client.getSOAHost(), client.getSOAPort());
                    if (this.getWrapperPatch() != null) {
                        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                    }
                    client.close();
                }
                if (de == null) return;
                throw de;
            }
        }
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        OPatchStepOperation prereqStep = this.getFailedPrereqStep();
        if (prereqStep != null) {
            if (client != null) {
                client.close();
            }
            if (de == null) return;
            throw de;
        }
        OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.UNDEPLOY);
        OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
        if (client != null) {
            SOAComposite s = client.getSOAComposite();
            String revToDelete = s.getRevision();
            String soaCompName = s.getName();
            String prevRevision = s.getDefaultRevisionBeforeUndeploy();
            String currRevision = s.getDefaultRevisionAfterUndeploy();
            boolean failure = false;
            if (de != null) {
                failure = true;
            }
            OPatchUtils.updateConfig(this.domainInfo, soaCompName, prevRevision, currRevision, revToDelete, failure, client.getSOAHost(), client.getSOAPort());
            if (this.getWrapperPatch() != null) {
                OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
            }
            client.close();
        }
        if (de == null) return;
        throw de;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deployWithMultipleSteps() throws OPatchDeployException {
        String stepMsg;
        String errorMsg;
        FMWClient client = null;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        this.setFailedClosingStep(null);
        String oracleHomePath = "";
        String logFile = "";
        boolean updatePrereqFailure = false;
        OPatchDeployException de = null;
        try {
            String errorMsg2;
            oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String compName = OPatchUtils.norm(this.getSOACompositeName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Deploy_Composite_" + compName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg3 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg3, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg);
            }
            super.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                errorMsg2 = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg3 = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg3, errorMsg2, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                errorMsg2 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg4 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg4, errorMsg2, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            client.setCompositeDeployWithMultipleSteps(true);
            client.deploy();
            OPatchUtils.updatePrereq(client, this);
            updatePrereqFailure = true;
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                throw new OPatchDeployException("OPatch failed in prerequisite checks prior to deploy.");
            }
        }
        catch (Throwable t) {
            try {
                if (!updatePrereqFailure) {
                    OPatchUtils.updatePrereq(client, this);
                    updatePrereqFailure = true;
                }
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchDeployException re = new OPatchDeployException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                de = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg5 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg5, errorMsg4, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                OPatchStepOperation prereqStep = this.getFailedPrereqStep();
                if (prereqStep != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (de == null) return;
                    throw de;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                if (client != null) {
                    SOAComposite s = client.getSOAComposite();
                    String revBeforeDeploy = s.getDefaultRevisionBeforeDeploy();
                    String revAfterDeploy = s.getDefaultRevisionAfterDeploy();
                    String soaCompName = s.getName();
                    boolean failure = false;
                    if (de != null) {
                        failure = true;
                    }
                    OPatchUtils.updateConfig(this.domainInfo, soaCompName, revBeforeDeploy, revAfterDeploy, failure, client.getSOAHost(), client.getSOAPort());
                    if (this.getWrapperPatch() != null) {
                        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                    }
                    client.close();
                }
                if (de == null) return;
                throw de;
            }
        }
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        OPatchStepOperation prereqStep = this.getFailedPrereqStep();
        if (prereqStep != null) {
            if (client != null) {
                client.close();
            }
            if (de == null) return;
            throw de;
        }
        OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
        OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
        if (client != null) {
            SOAComposite s = client.getSOAComposite();
            String revBeforeDeploy = s.getDefaultRevisionBeforeDeploy();
            String revAfterDeploy = s.getDefaultRevisionAfterDeploy();
            String soaCompName = s.getName();
            boolean failure = false;
            if (de != null) {
                failure = true;
            }
            OPatchUtils.updateConfig(this.domainInfo, soaCompName, revBeforeDeploy, revAfterDeploy, failure, client.getSOAHost(), client.getSOAPort());
            if (this.getWrapperPatch() != null) {
                OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
            }
            client.close();
        }
        if (de == null) return;
        throw de;
    }

    public SOASingleAPIReturnStatus deploy(String patchLocation) throws OPatchDeployException {
        SOASingleAPIReturnStatus apiStatus = null;
        try {
            this.inputPatchLoc = patchLocation;
            apiStatus = this.deploy();
        }
        catch (OPatchDeployException e) {
            throw e;
        }
        finally {
            this.inputPatchLoc = "";
        }
        return apiStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SOASingleAPIReturnStatus deploy() throws OPatchDeployException {
        FMWClient client;
        block38: {
            OPatchStepOperation prereqStep;
            String stepMsg;
            String errorMsg;
            client = null;
            OPatchStepOperation failedStep = null;
            this.setFailedPrereqStep(null);
            this.setFailedClosingStep(null);
            String oracleHomePath = "";
            String logFile = "";
            boolean updatePrereqFailure = false;
            OPatchDeployException de = null;
            try {
                String errorMsg2;
                oracleHomePath = this.getOracleHome();
                OPatchPatch patch = this.getWrapperPatch();
                try {
                    if (patch == null) {
                        throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                    }
                    String compName = OPatchUtils.norm(this.getSOACompositeName());
                    String domainName = "";
                    if (this.domainInfo != null) {
                        domainName = OPatchUtils.norm(this.domainInfo.getName());
                    }
                    logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Deploy_Composite_" + compName + "_" + domainName, true);
                    this.setLogFile(logFile);
                }
                catch (Throwable t) {
                    String stepMsg2 = "Check if log file is created properly for the operation.";
                    String errorMsg3 = t.getMessage();
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg3, new RuntimeException(t));
                    this.setFailedPrereqStep(failedStep);
                    throw t;
                }
                if (!this.isArtifactBoundtoConfigInstance()) {
                    errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                    stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    throw new OPatchDeployException(errorMsg);
                }
                if (this.inputPatchLoc != null && !this.inputPatchLoc.equals("")) {
                    this.doPrereqForPatchLoc(OPatchFAOperation.PREREQ_DEPLOY, this.inputPatchLoc);
                }
                super.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                try {
                    OPatchUtils.lockHome(oracleHomePath);
                }
                catch (Throwable t) {
                    errorMsg2 = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg3 = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg3, errorMsg2, re);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    throw t;
                }
                try {
                    client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
                }
                catch (Throwable t) {
                    errorMsg2 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                    String stepMsg4 = "Check if OPatch can get the client for artifact execution";
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg4, errorMsg2, re);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    this.setFailedPrereqStep(failedStep);
                    throw t;
                }
                client.deploy();
                OPatchUtils.updatePrereq(client, this);
                updatePrereqFailure = true;
                OPatchStepOperation prereqStep2 = this.getFailedPrereqStep();
                if (prereqStep2 != null) {
                    throw new OPatchDeployException("OPatch failed in prerequisite checks prior to deploy.");
                }
            }
            catch (Throwable t) {
                try {
                    if (!updatePrereqFailure) {
                        OPatchUtils.updatePrereq(client, this);
                        updatePrereqFailure = true;
                    }
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    OPatchDeployException re = new OPatchDeployException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    de = re;
                    return de;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg5 = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re = new RuntimeException(t2.getMessage());
                        re.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg5, errorMsg4, re);
                        this.setFailedClosingStep(failedStep);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    }
                    OPatchUtils.closeLogFile();
                    prereqStep = this.getFailedPrereqStep();
                    if (prereqStep != null) {
                        if (client != null) {
                            client.close();
                        }
                        if (de == null) return null;
                        throw de;
                    }
                    OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                    OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                    if (client != null) {
                        SOAComposite s = client.getSOAComposite();
                        String revBeforeDeploy = s.getDefaultRevisionBeforeDeploy();
                        String revAfterDeploy = s.getDefaultRevisionAfterDeploy();
                        String soaCompName = s.getName();
                        boolean failure = false;
                        if (de != null) {
                            failure = true;
                        }
                        OPatchUtils.updateConfig(this.domainInfo, soaCompName, revBeforeDeploy, revAfterDeploy, failure, client.getSOAHost(), client.getSOAPort());
                        if (this.getWrapperPatch() != null) {
                            OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                        }
                        client.close();
                    }
                    if (de != null) {
                        throw de;
                    }
                    break block38;
                }
            }
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                stepMsg = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                this.setFailedClosingStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
            }
            OPatchUtils.closeLogFile();
            prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                if (client != null) {
                    client.close();
                }
                if (de == null) return null;
                throw de;
            }
            OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
            OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
            if (client != null) {
                SOAComposite s = client.getSOAComposite();
                String revBeforeDeploy = s.getDefaultRevisionBeforeDeploy();
                String revAfterDeploy = s.getDefaultRevisionAfterDeploy();
                String soaCompName = s.getName();
                boolean failure = false;
                if (de != null) {
                    failure = true;
                }
                OPatchUtils.updateConfig(this.domainInfo, soaCompName, revBeforeDeploy, revAfterDeploy, failure, client.getSOAHost(), client.getSOAPort());
                if (this.getWrapperPatch() != null) {
                    OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                }
                client.close();
            }
            if (de != null) {
                throw de;
            }
        }
        SOASingleAPIReturnStatus wrapStatus = new SOASingleAPIReturnStatus();
        wrapStatus.setSOASingleAPIReturnStatus(client.getSOAOpResult());
        return wrapStatus;
    }

    @Override
    protected void doPrereq(OPatchFAOperation operation, String patchLocation) throws OPatchException {
        try {
            this.inputPatchLoc = patchLocation;
            this.doPrereq(operation);
        }
        catch (OPatchException e) {
            throw e;
        }
        finally {
            this.inputPatchLoc = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        String errorMsg;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        FMWClient client = null;
        String oracleHomePath = this.getOracleHome();
        OPatchPatch patch = this.getWrapperPatch();
        String logFile = "";
        this.setLogFile(logFile);
        OPatchException oe = null;
        try {
            String stepMsg;
            String errorMsg2;
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String compName = OPatchUtils.norm(this.getSOACompositeName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Prereq_Composite_" + compName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg3 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg3, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg2 = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg2, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg2);
            }
            if (this.inputPatchLoc != null && !this.inputPatchLoc.equals("")) {
                this.doPrereqForPatchLoc(operation, this.inputPatchLoc);
            }
            super.doPrereq(operation);
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg3 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg3, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                if (operation != OPatchFAOperation.PREREQ_DEPLOY) {
                    errorMsg2 = "OPatch does not support the operation \"" + operation.toString() + "\" for this artifact.";
                    stepMsg = "Check if operation \"" + operation.toString() + "\" is supported.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_OPERATION_SUPPORTED, stepMsg, errorMsg2, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    OPatchException re = new OPatchException(errorMsg2);
                    throw re;
                }
                client.prereq(true);
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException("OPatch fails in prereq on the artifact. " + t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        catch (Throwable t) {
            try {
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                oe = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                OPatchUtils.updatePrereq(client, this);
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg5 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg5, errorMsg4, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                if (client != null) {
                    client.close();
                }
                if (oe == null) return;
                throw oe;
            }
        }
        OPatchUtils.updatePrereq(client, this);
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg4 = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg4, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        if (client != null) {
            client.close();
        }
        if (oe == null) return;
        throw oe;
    }

    public void bindToClone(OPatchFAClonedConfigInstance faInstance, WLDomain domainInfo) throws OPatchException {
        if (faInstance == null) {
            throw new OPatchException("Please provide a non-null <OPatchFAClonedConfigInstance> object.");
        }
        if (!OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)domainInfo)) {
            throw new OPatchException("The system model object could not be binded to cloned config instances.");
        }
        this.setBoundToConfigInstance(true);
        this.domainInfo = domainInfo;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public Object clone() {
        OPatchSOADeployAction soa = (OPatchSOADeployAction)super.clone();
        return soa;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof OPatchSOADeployAction) {
            OPatchSOADeployAction soaAction = (OPatchSOADeployAction)o;
            return super.equals(o) && this.getSOACompositeName().equals(soaAction.getSOACompositeName()) && this.getSOACompositeRevision().equals(soaAction.getSOACompositeRevision());
        }
        return false;
    }
}

