/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote.linux;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.CommonConnectionHandlerImpl;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.linux.LinuxCommandExecutionHelper;
import com.oracle.cie.remote.linux.SSHLinuxFileTransferHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinuxSSHUserEquivalenceConnHandlerImpl
extends CommonConnectionHandlerImpl {
    public static final String SSH_OPTS = " -o FallBackToRsh=no -o PasswordAuthentication=no -o StrictHostKeyChecking=no -o NumberOfPasswordPrompts=0 ";
    private static final String CONNECTION_FAILURE_IDENTIFIER = "[CONN_FAIL]";
    private boolean isConnected = false;
    private SSHLinuxFileTransferHandler _linuxFileHandler;
    private static final Logger _logger = Logger.getLogger(LinuxSSHUserEquivalenceConnHandlerImpl.class.getName());

    @Override
    public String getType() {
        return "linuxclisshuserequivalence";
    }

    @Override
    public final String getFileHandlerType() {
        return "linuxtransfer";
    }

    private String getConnectCommand() {
        return LinuxCommandExecutionHelper.getSSHCmd() + SSH_OPTS + this.getHost().getHost();
    }

    @Override
    public void connect() throws RemoteConnectionException {
        if (!this.isConnected) {
            LinuxCommandExecutionHelper.ExecReturn ret = this.executeCommand(this.getConnectCommand() + " ls > /dev/null");
            if (ret.isOK()) {
                this.isConnected = true;
            } else if (ret.getReturnCode() == 255) {
                throw new RemoteConnectionException("[CONN_FAIL]Remote connection failed due to " + ret.getErrorMessage());
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public void put(String location, File sourceFile, boolean resume) throws RemoteConnectionException {
        block9: {
            block8: {
                if (location == null) {
                    throw new RemoteConnectionException("The location specified was null.");
                }
                if (sourceFile == null) {
                    throw new RemoteConnectionException("The source file specified was null.");
                }
                if (resume) {
                    throw new RemoteConnectionException("Resume feature is not supported");
                }
                if (!sourceFile.isDirectory()) break block8;
                this.mkdir(location);
                File[] files = sourceFile.listFiles();
                if (files == null) break block9;
                for (File f : files) {
                    String dest = location + "/" + f.getName();
                    this.put(dest, f);
                }
                break block9;
            }
            try {
                String command = this.getLinuxFileHandler().getFileTransferCommandToRemote(location, sourceFile);
                try {
                    String output = this.exec(command);
                    _logger.finest("result of transfer: " + output);
                }
                catch (RemoteConnectionException e) {
                    this.processException(e);
                }
            }
            catch (UnknownHostException e) {
                throw new RemoteConnectionException("UnknownHostException " + e.getMessage());
            }
        }
    }

    @Override
    public void put(String location, InputStream is) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (is == null) {
            throw new RemoteConnectionException("The input stream specified was null.");
        }
        File tmpLoc = null;
        try {
            String tmp = System.getProperty("java.io.tmpdir") + File.separator + "remoteFile_" + UUID.randomUUID().toString();
            tmpLoc = new File(tmp);
            this.getLinuxFileHandler().writeInputStreamToFile(tmpLoc, is);
            this.put(location, tmpLoc);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Transfer to " + location + " failed due to " + e.getMessage());
        }
        finally {
            if (tmpLoc != null) {
                tmpLoc.delete();
            }
        }
    }

    @Override
    public void get(String location, OutputStream os) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (os == null) {
            throw new RemoteConnectionException("The output stream specified was null.");
        }
        File remotFileCopyInLocal = new File(System.getProperty("java.io.tmpdir") + File.separator + "remotFileCopyInLocal_" + UUID.randomUUID().toString());
        this.getFile(location, remotFileCopyInLocal, false);
        try {
            this.getLinuxFileHandler().readFileToOutputStream(remotFileCopyInLocal, os);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Retrieval of " + location + " failed due to " + e.getMessage());
        }
        finally {
            remotFileCopyInLocal.delete();
        }
    }

    @Override
    public void get(String location, File destination, boolean resume) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (destination == null) {
            throw new RemoteConnectionException("The destination specified was null.");
        }
        this.getFile(location, destination, resume);
    }

    private void getFile(String location, File destination, boolean resume) throws RemoteConnectionException {
        if (resume) {
            throw new RemoteConnectionException("Resume feature is not supported");
        }
        File parent = destination.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new RemoteConnectionException("Failed to create parent directory of " + destination);
        }
        try {
            String command = this.getLinuxFileHandler().getFileTransferCommandFromRemote(location, destination);
            try {
                String output = this.exec(command);
                _logger.finest("Result of copy command: " + output);
            }
            catch (RemoteConnectionException e) {
                this.processException(e);
            }
        }
        catch (UnknownHostException e) {
            throw new RemoteConnectionException("UnknownHostException " + e.getMessage());
        }
    }

    @Override
    public void delete(String location, boolean force, boolean ignoreFailure) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        String command = "rm -r \"" + location + "\"";
        if (force) {
            command = "rm -rf \"" + location + "\"";
        }
        try {
            this.exec(command);
        }
        catch (RemoteConnectionException e) {
            if (ignoreFailure) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Ignored -- " + e.getMessage(), e);
                }
            }
            this.processException(e);
        }
    }

    @Override
    public boolean exists(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        boolean exists = true;
        try {
            this.exec("ls " + location + " > /dev/null");
        }
        catch (RemoteConnectionException e) {
            if (this.isConnectionException(e)) {
                this.processException(e);
            }
            exists = false;
        }
        _logger.finest("exists: " + exists);
        return exists;
    }

    private void processException(RemoteConnectionException e) throws RemoteConnectionException {
        if (this.isConnectionException(e)) {
            String msg = e.getMessage().substring(CONNECTION_FAILURE_IDENTIFIER.length());
            throw new RemoteConnectionException(msg);
        }
        throw e;
    }

    private boolean isConnectionException(RemoteConnectionException e) {
        return e.getMessage().startsWith(CONNECTION_FAILURE_IDENTIFIER);
    }

    @Override
    public long size(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            throw new RemoteConnectionException("Feature not supported");
        }
        return 0L;
    }

    @Override
    public boolean isDirectory(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        boolean isDirectory = true;
        try {
            this.exec("cd " + location);
        }
        catch (RemoteConnectionException e) {
            if (this.isConnectionException(e)) {
                this.processException(e);
            }
            isDirectory = false;
        }
        _logger.finest("isDirectory: " + isDirectory);
        return isDirectory;
    }

    @Override
    public void mkdir(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        String command = this.getLinuxFileHandler().getMakeDirCommand(location, false);
        try {
            String output = this.exec(command);
            _logger.finest("Result of make directory: " + output);
        }
        catch (RemoteConnectionException e) {
            this.processException(e);
        }
    }

    @Override
    public void mkdirs(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        String command = this.getLinuxFileHandler().getMakeDirCommand(location, true);
        try {
            String output = this.exec(command);
            _logger.finest("Result of make directory: " + output);
        }
        catch (RemoteConnectionException e) {
            this.processException(e);
        }
    }

    @Override
    public void exec(String command, OutputStream output, Map<String, String> envVars) throws RemoteConnectionException {
        this.connect();
        LinuxCommandExecutionHelper.ExecReturn ret = this.executeCommand(this.getConnectCommand() + " " + command);
        if (ret.isOK()) {
            this.isConnected = true;
            try {
                output.write(ret.getNormalMessage().getBytes());
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Remote command execution failed due to " + e.getMessage());
            }
        } else {
            throw new RemoteConnectionException("Remote command execution failed due to " + ret.getErrorMessage());
        }
    }

    private LinuxCommandExecutionHelper.ExecReturn executeCommand(String command) {
        _logger.info("Command execution command: " + command);
        ArrayList<String> cmds = new ArrayList();
        cmds = Arrays.asList(command.split(" "));
        LinuxCommandExecutionHelper.ExecReturn ret = LinuxCommandExecutionHelper.execute(cmds, null);
        _logger.info("Command execution return code: " + ret.getReturnCode());
        _logger.info("command execution message: " + ret.getNormalMessage());
        _logger.info("command executon failure message: " + ret.getErrorMessage());
        return ret;
    }

    @Override
    public void chmod(String location, int mode) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        try {
            String command = this.getLinuxFileHandler().getChmodCommand(location, mode);
            String output = this.exec(command);
            _logger.finest("Result of chmod directory: " + output);
        }
        catch (RemoteConnectionException e) {
            this.processException(e);
        }
    }

    @Override
    public boolean isWindows() throws RemoteConnectionException {
        return false;
    }

    @Override
    public List<String> ls(String location) throws RemoteConnectionException {
        List<String> listing;
        block4: {
            if (location == null) {
                throw new RemoteConnectionException("The location specified was null.");
            }
            String output = null;
            listing = new ArrayList<String>();
            try {
                String command = this.getLinuxFileHandler().getLSCommand(location);
                output = this.exec(command);
            }
            catch (RemoteConnectionException e) {
                if (this.isConnectionException(e)) {
                    this.processException(e);
                }
                if (StringUtil.isNullOrEmpty((String)output, (boolean)true)) break block4;
                listing = this.getLinuxFileHandler().getLSList(output);
            }
        }
        return listing;
    }

    @Override
    protected void closeInternal() {
        this.isConnected = false;
        this._linuxFileHandler = null;
    }

    protected SSHLinuxFileTransferHandler getLinuxFileHandler() {
        if (this._linuxFileHandler == null) {
            this._linuxFileHandler = new SSHLinuxFileTransferHandler();
        }
        return this._linuxFileHandler;
    }
}

