/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import com.oracle.cie.common.net.DownloadFile;
import com.oracle.cie.common.util.Checksum;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.rest.FileInfo;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.impl.ArtifactoryRestHandlerImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ArtifactDownloadFileImpl
implements DownloadFile {
    private RestHandler _restHandler;
    private Artifact _artifact;
    private Repository _sourceRepository;
    private Repository _destRepository;
    private FileInfo _fileInfo;
    private File _destination;
    private File _tmpFile;
    private boolean _verify;
    private String _username;
    private String _password;

    public ArtifactDownloadFileImpl(RestHandler restHandler, Artifact artifact, Repository sourceRepository, Repository destRepository, FileInfo fileInfo, File destination, File tmpFile, boolean verify) {
        this._restHandler = restHandler;
        this._artifact = artifact;
        this._sourceRepository = sourceRepository;
        this._destRepository = destRepository;
        this._fileInfo = fileInfo;
        this._destination = destination;
        this._tmpFile = tmpFile;
        this._verify = verify;
    }

    public Artifact getArtifact() {
        return this._artifact;
    }

    public Repository getSourceRepository() {
        return this._sourceRepository;
    }

    public Repository getDestRepository() {
        return this._destRepository;
    }

    public FileInfo getFileInfo() {
        return this._fileInfo;
    }

    public long getExpectedFileSize() {
        return this._fileInfo.getSize();
    }

    public File getDestination() {
        return this._destination;
    }

    public File getFile() {
        return this._tmpFile;
    }

    public URL getUrl() throws MalformedURLException {
        return this._artifact.getRemoteLocation(this._sourceRepository.getURL().toString());
    }

    public String getChecksum() {
        return this._fileInfo.getChecksum().getMD5Checksum();
    }

    public Checksum.ChecksumAlgorithm getChecksumAlgorithm() {
        return Checksum.ChecksumAlgorithm.MD5;
    }

    public void setDownloadRequired(boolean b) {
    }

    public boolean isDownloadRequired() {
        return true;
    }

    public Exception verify() {
        try {
            ((ArtifactoryRestHandlerImpl)this._restHandler).verifyRetrievedArtifact(this._artifact, this._sourceRepository, this._destRepository, this._tmpFile, this._destination, this._fileInfo, this._verify);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String toString() {
        return this._artifact.toString();
    }
}

