/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.ItemProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.storage.ItemProperties+json"})
public class StorageItemProperties
implements MessageBodyReader<ItemProperties> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.storage.ItemProperties+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public ItemProperties readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (ItemProperties)mapper.readValue(baos.toByteArray(), ItemPropertiesImpl.class);
    }

    public static class ItemPropertiesImpl
    extends HashMap
    implements ItemProperties {
        private String _uri;
        private Properties _properties;

        @Override
        public String getURI() {
            Object o;
            if (this._uri == null && (o = this.get("uri")) instanceof String) {
                this._uri = (String)o;
            }
            return this._uri;
        }

        @Override
        public Properties getProperties() {
            if (this._properties == null) {
                this._properties = new Properties();
                Object o = this.get("properties");
                if (o instanceof HashMap) {
                    HashMap propMap = (HashMap)o;
                    for (String name : propMap.keySet()) {
                        String value = null;
                        List values = (List)propMap.get(name);
                        if (values.isEmpty()) {
                            value = "";
                        } else if (values.size() > 1) {
                            for (String val : values) {
                                if (value != null) {
                                    value = value + "," + val;
                                    continue;
                                }
                                value = val;
                            }
                        } else {
                            value = (String)values.iterator().next();
                        }
                        this._properties.setProperty(name, value);
                    }
                }
            }
            return this._properties;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("uri:").append(this.getURI());
            buf.append(", properties:").append(this.getProperties());
            return buf.toString();
        }
    }
}

