/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.emrepo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import oracle.osysmodel.driver.sdk.emrepo.EMRepoDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEMProductDriver {
    protected Map<Class, List<Method>> requestedAttributes = new HashMap<Class, List<Method>>();
    protected Map<Class, Map<Method, List<BaseClass>>> requestedAssociations = new HashMap<Class, Map<Method, List<BaseClass>>>();
    protected Map<Class, Map<String, Method>> properySetters = new HashMap<Class, Map<String, Method>>();
    private static Logger logger = Logger.getLogger(BaseEMProductDriver.class.getName());
    private long time = System.currentTimeMillis();
    private long timeInDB = 0L;
    private int numOfQueries;
    private Map<String, Integer> queryStat = new HashMap<String, Integer>();
    protected EMRepoDriver emGeneric = null;
    protected Connection connection = null;
    protected boolean needToCloseConnection = false;
    protected Map<String, PreparedStatement> sqlToSt = new HashMap<String, PreparedStatement>();
    protected Map<String, PreparedStatement> executedSQL = new HashMap<String, PreparedStatement>();
    protected List<ResultSet> openResultSets = new ArrayList<ResultSet>();

    public abstract AbstractBaseTarget requestObj(String var1);

    protected abstract void propertyMapping();

    protected BaseEMProductDriver(Connection connection) {
        this.connection = connection;
        this.emGeneric = new EMRepoDriver(connection);
        this.propertyMapping();
    }

    protected BaseEMProductDriver(String string, String string2, String string3) throws Exception {
        this.emGeneric = new EMRepoDriver(string, string2, string3);
        this.propertyMapping();
        try {
            this.connection = DriverManager.getConnection("jdbc:oracle:thin:@" + string, string2, string3);
            this.needToCloseConnection = true;
        }
        catch (Exception exception) {
            System.out.println("Failed to get DB connection " + exception.getMessage());
            throw new RuntimeException(exception);
        }
    }

    protected void releaseDBConnection() {
        try {
            String string;
            if (this.openResultSets.size() != 0) {
                System.out.println(" there are some opened ResultSet objs " + this.openResultSets.size());
            }
            for (ResultSet object : this.openResultSets) {
                object.close();
            }
            for (Map.Entry entry : this.sqlToSt.entrySet()) {
                ((PreparedStatement)entry.getValue()).close();
                string = (String)entry.getKey();
                this.executedSQL.remove(string);
            }
            for (Map.Entry entry : this.executedSQL.entrySet()) {
                string = (String)entry.getKey();
                System.out.println(" did not close " + string.substring(6, string.indexOf("*/") + 2));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
            this.openResultSets.remove(resultSet);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.needToCloseConnection) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            super.finalize();
        }
    }

    protected void requestProperties(Map<String, String> map, BaseClass baseClass) {
        Class[] classArray = new Class[]{String.class};
        String string = null;
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (String string2 : map.keySet()) {
            try {
                string = map.get(string2);
                Method method = baseClass.getClass().getMethod(string, classArray);
                hashMap.put(string2, method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.severe(" failed to find setter " + baseClass.getClass().getName() + "." + string + "(" + classArray[0].getName() + ")");
            }
        }
        this.properySetters.put(baseClass.getClass(), hashMap);
    }

    protected void addRequested(BaseClass baseClass) {
        this.requestedAttributes.put(baseClass.getClass(), baseClass.getRequestedAttributeGetters());
        this.requestedAssociations.put(baseClass.getClass(), baseClass.getRequestedAssociationGetters());
    }

    protected ResultSet executeQuery(PreparedStatement preparedStatement, String string, String string2, String string3, BaseClass baseClass) throws SQLException {
        if (!this.executedSQL.containsKey(string)) {
            this.executedSQL.put(string, preparedStatement);
        }
        String string4 = string;
        int n = string.indexOf("?");
        if (n > 0) {
            string4 = string.substring(0, n + 1).replace("?", "'" + string2 + "'");
            string4 = string4.concat(string.substring(n + 1, string.length()));
            if (string3 != null) {
                string4 = string4.replace("?", "'" + string3 + "'");
            }
        }
        int n2 = 0;
        if (this.queryStat.containsKey(string4)) {
            n2 = this.queryStat.get(string4);
        }
        this.queryStat.put(string4, new Integer(n2 + 1));
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            this.openResultSets.add(resultSet);
        }
        catch (SQLException sQLException) {
            System.out.println(" Failed in query \n" + string4);
            logger.severe(" Failed in query \n" + string4);
            throw sQLException;
        }
        this.timeInDB += System.currentTimeMillis() - l;
        ++this.numOfQueries;
        return resultSet;
    }

    protected void getSystemInstance(BaseClass baseClass, BaseClass baseClass2) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Map<Method, List<BaseClass>> map = this.requestedAssociations.get(baseClass2.getClass());
        if (map == null) {
            return;
        }
        block0: for (Map.Entry<Method, List<BaseClass>> entry : map.entrySet()) {
            if (this.emGeneric.getInvokedMethods().containsKey(entry.getKey()) && baseClass.getGUID().equals(this.emGeneric.getInvokedMethods().get(entry.getKey()).getGUID())) continue;
            List<BaseClass> list = this.emGeneric.addAssociated(baseClass, entry);
            BaseClass baseClass3 = null;
            for (BaseClass baseClass4 : list) {
                for (BaseClass baseClass5 : entry.getValue()) {
                    if (!baseClass5.getClass().equals(baseClass4.getClass())) continue;
                    baseClass3 = baseClass5;
                }
                if (baseClass3 == null) {
                    logger.severe("Failed to find request object for added " + baseClass4.toString());
                    continue block0;
                }
                this.getSystemInstance(baseClass4, baseClass3);
            }
        }
    }

    public SystemInstance getSystemInstances(AbstractBaseTarget abstractBaseTarget, Map<Class, Map<Method, List<BaseClass>>> map, Map<Class, Map<String, Method>> map2) {
        BaseClass baseClass22;
        try {
            if (abstractBaseTarget == null) {
                return null;
            }
            this.properySetters = map2;
            this.requestedAssociations = map;
            for (BaseClass baseClass22 : this.emGeneric.getRoots((BaseClass)abstractBaseTarget)) {
                logger.finer("************************** ");
                this.getSystemInstance(baseClass22, (BaseClass)abstractBaseTarget);
            }
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
            exception.printStackTrace();
            throw new IllegalArgumentException(exception);
        }
        ArrayList<BaseClass> arrayList = new ArrayList();
        baseClass22 = null;
        for (Map.Entry<String, AbstractBaseTarget> entry : this.emGeneric.getMapOut().entrySet()) {
            AbstractBaseTarget abstractBaseTarget2 = entry.getValue();
            arrayList.add((BaseClass)abstractBaseTarget2);
            if (!abstractBaseTarget.getClass().equals(abstractBaseTarget2.getClass())) continue;
            baseClass22 = abstractBaseTarget2;
        }
        this.emGeneric.setOracleHomesAndHosts((List<BaseClass>)arrayList);
        this.releaseDBConnection();
        arrayList = new ArrayList<BaseClass>();
        for (Map.Entry<String, AbstractBaseTarget> entry : this.emGeneric.getMapOut().entrySet()) {
            arrayList.add((BaseClass)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.queryStat.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            logger.finer(entry.getKey() + " executed " + entry.getValue() + " times");
        }
        this.time = System.currentTimeMillis() - this.time;
        logger.fine("\n\n **** time=" + this.time + " time in DB=" + this.timeInDB + " num of queries = " + this.numOfQueries + " number of objects retreived " + this.emGeneric.getMapOut().size());
        return this.getProductSystemInstance(arrayList, (AbstractBaseTarget)baseClass22);
    }

    public abstract SystemInstance getProductSystemInstance(List<BaseClass> var1, AbstractBaseTarget var2);
}

