/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.database.Database;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.util.NotExistsException;
import oracle.opatch.Crs;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PrereqSession;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;

public class CrsImpl
extends Crs {
    private static String gridHome = "";
    private static ClusterwareInfo info = new ClusterwareInfo();
    private static CrsImpl crsInstance = null;
    private static Crs.CrsType type = Crs.CrsType.NONE;
    private static HashMap<File, Crs.CrsType> homeMap = new HashMap();
    private IIPMReadServices readServices = null;

    private CrsImpl(IIPMReadServices rs) {
        this.readServices = rs;
    }

    public CrsImpl() {
    }

    public synchronized Crs getInstance(String runningOracleHome) throws NullPointerException {
        String ctrInvLoc;
        StringBuffer buff = new StringBuffer("Crs::getInstance() running from Oracle Home \"");
        buff.append(runningOracleHome);
        buff.append("\".");
        OLogger.debug((StringBuffer)buff);
        if (crsInstance != null) {
            return crsInstance;
        }
        String invPtrLoc = OPatchEnv.getInvPtrLoc();
        boolean badInvPtrFlag = true;
        if (invPtrLoc != null && !invPtrLoc.equals("") && !(ctrInvLoc = OPatchEnv.getCentralInvLoc()).equals("n/a")) {
            badInvPtrFlag = false;
            System.setProperty("oracle.installer.custom_inventory", ctrInvLoc);
        }
        if (badInvPtrFlag) {
            throw new RuntimeException("Oralce Home's central inventory pointer location \"" + OPatchEnv.getUserSpecifiedInvPtrLoc() + "\" is not valid.");
        }
        String ouiLoc = runningOracleHome + File.separator + "oui";
        File ouiPath = new File(ouiLoc);
        if (!ouiPath.exists()) {
            throw new NullPointerException("The Oracle Home opatch runs from is not an OUI based home.");
        }
        try {
            type = CrsImpl.getCrsType(runningOracleHome);
        }
        catch (Exception e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException("Failed to detect Grid Infrastructure.  " + e.getMessage());
        }
        IIPMReadServices rs = null;
        if (type != Crs.CrsType.NONE && !OPatchEnv.isSrvmUtil()) {
            try {
                rs = PrereqSession.getReadServices((String)gridHome);
            }
            catch (Throwable t) {
                OLogger.printStackTrace((Throwable)t);
                throw new RuntimeException("Failed to load home inventory for \"" + gridHome + "\"", t);
            }
        }
        crsInstance = new CrsImpl(rs);
        return crsInstance;
    }

    public IIPMReadServices getGridHomeInventory() {
        return this.readServices;
    }

    public boolean isGridEnv() {
        return type != Crs.CrsType.NONE;
    }

    public Crs.CrsType getCrsType() {
        return type;
    }

    public String getGridHome() {
        return gridHome;
    }

    private static Crs.CrsType getCrsType(String runningOracleHome) throws InstallException {
        StringBuffer buff = new StringBuffer("Crs::getCrsType() called");
        OLogger.debug((StringBuffer)buff);
        String ouiLoc = runningOracleHome + File.separator + "oui";
        Crs.CrsType crstype = Crs.CrsType.NONE;
        String olrLoc = OPatchEnv.getOLRLocation();
        if (OPatchEnv.isWindows() || new File(olrLoc).exists()) {
            if (info.isCRSConfigured(runningOracleHome)) {
                crstype = Crs.CrsType.CRS;
                gridHome = info.getCRSHome(new Version());
                homeMap.put(new File(gridHome), crstype);
            } else if (info.isHAConfigured(runningOracleHome)) {
                crstype = Crs.CrsType.SIHA;
                gridHome = info.getHAHome(ouiLoc);
                homeMap.put(new File(gridHome), crstype);
            }
        }
        if (crstype != Crs.CrsType.CRS && crstype != Crs.CrsType.SIHA) {
            try {
                IIPMReadServices readServices = PrereqSession.getReadServices((String)runningOracleHome);
                if (!readServices.isInventoryLoaded()) {
                    buff = new StringBuffer("Crs::getCrsType() could not load inventory");
                    OLogger.debug((StringBuffer)buff);
                    throw new NullPointerException(buff.toString());
                }
                String gridHomeLoc = readServices.findGridHomeLocation();
                if (gridHomeLoc != null) {
                    gridHome = gridHomeLoc;
                    crstype = Crs.CrsType.SOFTWARE_INSTALLATION_ONLY;
                    homeMap.put(new File(gridHome), crstype);
                }
            }
            catch (NullPointerException e) {
                buff = new StringBuffer("GIPatching cannot load inventory from the given Oracle Home.\n");
                buff.append("Possible causes are:\n");
                buff.append("    Oracle Home dir. path does not exist in Central Inventory\n");
                buff.append("    Oracle Home is a symbolic link\n");
                buff.append("    Oracle Home inventory is corrupted");
                throw new RuntimeException(buff.toString(), e);
            }
            catch (Throwable e) {
                OLogger.printStackTrace((Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return crstype;
    }

    public Crs.CrsType getCrsTypeOfHome(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Crs::getCrsTypeOfHome() called");
        OLogger.debug((StringBuffer)buff);
        File ghome = new File(oracleHomePath);
        if (homeMap.get(ghome) != null) {
            buff = new StringBuffer("CrsType is in homeMap. It is ");
            buff.append(homeMap.get(ghome));
            OLogger.debug((StringBuffer)buff);
            return homeMap.get(ghome);
        }
        if (!this.readServices.isInventoryLoaded()) {
            throw new RuntimeException("Home inventory is not loaded.");
        }
        Crs.CrsType type = Crs.CrsType.NONE;
        if (this.readServices.isGridHome(oracleHomePath)) {
            type = Crs.CrsType.SOFTWARE_INSTALLATION_ONLY;
        }
        return type;
    }

    public String getCrsVersion() throws IllegalAccessException {
        if (type == Crs.CrsType.NONE) {
            throw new IllegalAccessException("No CRS Enviroment detected on current system.");
        }
        String version = "12.1.0.0.0";
        try {
            if (type == Crs.CrsType.CRS) {
                version = info.getCRSReleaseVersionString(gridHome);
            } else if (type == Crs.CrsType.SIHA) {
                version = info.getSIHAReleaseVersionString(gridHome);
            } else {
                InstalledComponent[] topComps = this.readServices.getTopLevelInstalledComponents();
                if (topComps.length < 1) {
                    throw new RuntimeException("No top-level component detected in current Oracle Home.");
                }
                version = topComps[0].getVersion();
            }
        }
        catch (Exception e) {
            OLogger.printStackTrace((Throwable)e);
        }
        return version;
    }

    public HashMap<String, String> getPatchingLevel(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Crs::getPatchingLevel call");
        OLogger.debug((StringBuffer)buff);
        try {
            OPatchSessionHelper.loadRACRelatedLibFile();
            OPatchSessionHelper.loadCRSRelatedLibFiles((String)oracleHomePath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to load jlib files: " + e.getMessage(), e);
        }
        try {
            CommonFactory commonFac = CommonFactory.getInstance();
            oracle.cluster.common.Cluster cluster = commonFac.getCluster();
            HashMap levelMap = cluster.getPatchLevel();
            return levelMap;
        }
        catch (ClusterException e) {
            RuntimeException re = new RuntimeException("CRS cluster exception happens : " + e.getMessage());
            re.setStackTrace(e.getStackTrace());
            OLogger.printStackTrace((Throwable)e);
            throw re;
        }
        catch (ManageableEntityException e) {
            RuntimeException re = new RuntimeException("ManageableEntityException happens : " + e.getMessage());
            re.setStackTrace(e.getStackTrace());
            OLogger.printStackTrace((Throwable)e);
            throw re;
        }
    }

    public String getLocalNode() {
        int dotPos;
        String local = "";
        try {
            local = this.readServices.getLocalNode();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch the local node name by OUI.", e);
        }
        if ((local == null || "".equals(local)) && (local = IPMUtil.getLocalHostName((boolean)false)) != null && (dotPos = local.indexOf(46)) != -1) {
            local = local.substring(0, dotPos);
        }
        return local;
    }

    public String[] getClusterNodeList(String oracleHomePath) {
        String localNode;
        String[] nodes;
        StringBuffer buff;
        block14: {
            buff = new StringBuffer("Crs::getClusterNodeList() called");
            OLogger.debug((StringBuffer)buff);
            nodes = new String[]{};
            try {
                if (type != Crs.CrsType.CRS || !this.isStackRunning()) {
                    return nodes;
                }
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            localNode = "";
            try {
                HashMap nodeMap = info.getClusterNodeActiveRoles(gridHome);
                nodes = new String[nodeMap.keySet().size()];
                nodeMap.keySet().toArray(nodes);
                localNode = Cluster.getLocalNode();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to retrieve the clusterware nodes.", e);
            }
            try {
                if (new File(oracleHomePath).equals(new File(gridHome))) break block14;
                CommonFactory cf = CommonFactory.getInstance();
                oracle.cluster.common.Cluster cluster = cf.getCluster();
                List databases = null;
                try {
                    databases = cluster.fetchDatabases();
                }
                catch (NotExistsException nee) {
                    // empty catch block
                }
                HashSet<String> filterNodes = new HashSet<String>();
                for (int i = 0; i < nodes.length; ++i) {
                    if (!OiipgClusterOps.fileExistsOnNode((String)nodes[i], (String)oracleHomePath)) continue;
                    filterNodes.add(nodes[i]);
                }
                nodes = new String[filterNodes.size()];
                filterNodes.toArray(nodes);
                if (databases == null) break block14;
                for (Database sdb : databases) {
                    if (!new File(sdb.getOracleHome()).equals(new File(oracleHomePath))) continue;
                    if (!sdb.isClusterDatabase()) {
                        nodes = new String[]{};
                    }
                    break;
                }
            }
            catch (ManageableEntityException e) {
                throw new RuntimeException("Failed to handle configured databases.", e);
            }
            catch (OiipgRemoteOpsException e) {
                throw new RuntimeException("Failed to detect if Oracle Home exists in specific node or not.", e);
            }
        }
        NodeComparator nc = new NodeComparator();
        buff = new StringBuffer("Local node is \"" + localNode + "\"");
        OLogger.debug((StringBuffer)buff);
        nc.setLocalNode(localNode.toLowerCase());
        buff = new StringBuffer("Detected nodes as below: \n");
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = nodes[i].toLowerCase();
            buff.append(nodes[i] + " ");
        }
        OLogger.debug((StringBuffer)buff);
        Arrays.sort(nodes, nc);
        return nodes;
    }

    public boolean isStackRunning() throws IllegalAccessException {
        boolean isStackRunning = false;
        switch (type) {
            case NONE: {
                throw new IllegalAccessException("No CRS Enviroment detected on current system.");
            }
            case CRS: 
            case SIHA: {
                isStackRunning = this.isClusterwareRunning(null);
                break;
            }
        }
        return isStackRunning;
    }

    public boolean isClusterwareRunning(String nodeName) throws IllegalAccessException {
        String localNode;
        boolean isRunning = false;
        if (type != Crs.CrsType.CRS && type != Crs.CrsType.SIHA) {
            throw new IllegalAccessException("There is no clusterware env detected on current platform.");
        }
        boolean isRoot = false;
        try {
            isRoot = OUIReplacer.isRootAccess((String)gridHome);
        }
        catch (Exception e1) {
            OLogger.printStackTrace((Throwable)e1);
            throw new RuntimeException("Failed to check if user is root user.", e1);
        }
        if (nodeName != null && !nodeName.equalsIgnoreCase(localNode = this.getLocalNode()) && isRoot) {
            return SystemCall.isClusterwareUp((String)gridHome, (String)nodeName);
        }
        String crsVerStr = this.getCrsVersion();
        Version crsV = null;
        try {
            crsV = Version.getVersion((String)crsVerStr);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to get cluster version.", e);
        }
        try {
            isRunning = nodeName != null && !nodeName.equals("") ? (type == Crs.CrsType.CRS ? info.isCRSRunning(gridHome, nodeName, crsV) : info.isHARunning(gridHome, nodeName)) : (type == Crs.CrsType.CRS ? info.isCRSRunning(gridHome, crsV) : info.isHARunning(gridHome));
        }
        catch (InstallException e) {
            // empty catch block
        }
        return isRunning;
    }

    class NodeComparator
    implements Comparator<String> {
        String localNode = "";

        NodeComparator() {
        }

        @Override
        public int compare(String node1, String node2) {
            if (node1.equalsIgnoreCase(this.localNode)) {
                return -1;
            }
            if (node2.equalsIgnoreCase(this.localNode)) {
                return 1;
            }
            return node1.compareTo(node2);
        }

        protected void setLocalNode(String localNode) {
            this.localNode = localNode;
        }
    }
}

