/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation;

import java.util.List;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import oracle.oplan.db.validation.SIHAValidationFilterForPatching;
import oracle.oplan.db.validation.SIValidationFilterForPatching;
import oracle.oplan.db.validation.rules.CRSLogicalStandbyNotUsed;
import oracle.oplan.db.validation.rules.CRSRAChomeNotShared;
import oracle.oplan.db.validation.rules.CRSRACsValid;
import oracle.oplan.db.validation.rules.CRSobjectValid;
import oracle.oplan.db.validation.rules.CRSplatformAsRequested;
import oracle.oplan.db.validation.rules.CRSplatformValid;
import oracle.oplan.db.validation.rules.CRSversionGreater;
import oracle.oplan.db.validation.rules.GIHomeValid;
import oracle.oplan.db.validation.rules.OracleHomeTypeValid;
import oracle.oplan.db.validation.rules.RACOneVersionRule;
import oracle.oplan.db.validation.rules.RACVersionGreater;
import oracle.oplan.db.validation.rules.RACversionCRS;
import oracle.oplan.db.validation.rules.SIHAVersionCheckIfSupported;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cookies.SkipTargetCookie;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.validation.IsConfigSupported;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.rules.CheckForNullValues;
import oracle.osysmodel.validation.rules.HomeNotShared;

public class IsCRSConfigSupported
extends IsConfigSupported {
    final Logger logger = Logger.getLogger(IsCRSConfigSupported.class.getName());

    public IsCRSConfigSupported(SystemInstance config, ExecutionMode exeMode) throws ConfigValidationException {
        super(config, exeMode);
        this.platforms.add("267");
        this.platforms.add("226");
        this.platforms.add("23");
        this.platforms.add("212");
        this.platforms.add("197");
        this.platforms.add("59");
        if (ExecutionMode.OPATCH.equals((Object)exeMode)) {
            this.platforms.add("46");
            this.platforms.add("209");
            this.rulesToEvaluate.add(new CRSplatformAsRequested(config, this.platforms));
            OPlan oplan = OPlan.getInstance();
            ConfigGraph graph = oplan.getConfigGraph(config);
            List homes = graph.getTargets(OracleHome.class);
            boolean hasCrs = false;
            boolean hasRac = false;
            for (OracleHome home : homes) {
                if (home.getHomeType().equalsIgnoreCase("crs")) {
                    hasCrs = true;
                    continue;
                }
                if (!home.getHomeType().equalsIgnoreCase("rac")) continue;
                hasRac = true;
            }
            if (hasCrs) {
                this.rulesToEvaluate.add(new CRSobjectValid(config));
                this.rulesToEvaluate.add(new GIHomeValid(config));
                this.rulesToEvaluate.add(new CRSversionGreater(config, "11.2.0.2"));
                if (hasRac) {
                    this.rulesToEvaluate.add(new RACversionCRS(config));
                    this.rulesToEvaluate.add(new RACOneVersionRule(config, "12.1.0.1.0"));
                }
            } else if (hasRac) {
                this.rulesToEvaluate.add(new RACVersionGreater(config, "11.2.0.2"));
                this.rulesToEvaluate.add(new RACOneVersionRule(config, "12.1.0.1.0"));
            }
        } else if (ExecutionMode.EM.equals((Object)exeMode)) {
            if (config.getTop() instanceof CRSCluster) {
                this.rulesToEvaluate.add(new CRSobjectValid(config));
                this.rulesToEvaluate.add(new CheckForNullValues(config, SIValidationFilterForPatching.getObjectsToValidate()));
                this.rulesToEvaluate.add(new GIHomeValid(config));
                this.rulesToEvaluate.add(new CRSplatformValid(config));
                this.rulesToEvaluate.add(new CRSobjectValid(config));
                this.rulesToEvaluate.add(new CRSRACsValid(config));
                this.rulesToEvaluate.add(new HomeNotShared(config, "crs"));
                this.rulesToEvaluate.add(new HomeNotShared(config, "rac"));
                this.rulesToEvaluate.add(new CRSRAChomeNotShared(config));
                this.rulesToEvaluate.add(new CRSversionGreater(config, "11.2.0.2"));
                if (config.getTop().getProperty(SkipTargetCookie.class) != null) {
                    this.rulesToEvaluate.add(new RACVersionGreater(config, "11.2.0.2"));
                }
                this.rulesToEvaluate.add(new RACversionCRS(config));
                this.rulesToEvaluate.add(new CRSplatformAsRequested(config, this.platforms));
                this.rulesToEvaluate.add(new CRSLogicalStandbyNotUsed(config));
                this.rulesToEvaluate.add(new OracleHomeTypeValid(config));
                this.rulesToEvaluate.add(new RACOneVersionRule(config, "12.1.0.1.0"));
            } else if (config.getTop() instanceof HAS) {
                this.rulesToEvaluate.add(new CheckForNullValues(config, SIHAValidationFilterForPatching.getObjectsToValidate()));
                this.rulesToEvaluate.add(new OracleHomeTypeValid(config));
                this.rulesToEvaluate.add(new SIHAVersionCheckIfSupported(config));
            }
        } else if (ExecutionMode.STANDALONE.equals((Object)exeMode)) {
            if (config.getTop() instanceof CRSCluster) {
                this.rulesToEvaluate.add(new CRSplatformAsRequested(config, this.platforms));
                this.rulesToEvaluate.add(new CRSobjectValid(config));
                this.rulesToEvaluate.add(new CheckForNullValues(config, SIValidationFilterForPatching.getObjectsToValidate()));
                this.rulesToEvaluate.add(new GIHomeValid(config));
                this.rulesToEvaluate.add(new CRSRACsValid(config));
                this.rulesToEvaluate.add(new CRSversionGreater(config, "11.2.0.2"));
                this.rulesToEvaluate.add(new RACVersionGreater(config, "11.2.0.2"));
                this.rulesToEvaluate.add(new HomeNotShared(config, "crs"));
                this.rulesToEvaluate.add(new HomeNotShared(config, "rac"));
                this.rulesToEvaluate.add(new RACversionCRS(config));
                this.rulesToEvaluate.add(new OracleHomeTypeValid(config));
                this.rulesToEvaluate.add(new RACOneVersionRule(config, "12.1.0.1.0"));
            } else if (config.getTop() instanceof HAS) {
                this.rulesToEvaluate.add(new CheckForNullValues(config, SIHAValidationFilterForPatching.getObjectsToValidate()));
                this.rulesToEvaluate.add(new OracleHomeTypeValid(config));
                this.rulesToEvaluate.add(new SIHAVersionCheckIfSupported(config));
            }
        }
    }
}

