/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import model.db_crs.SIDatabase;
import oracle.oplan.db.validation.causes.DataGuardPresent;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.oplan.db.validation.rules.CRSRACsValid;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.BaseCause;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSDataGuardNotUsed
extends BaseRule {
    public CRSDataGuardNotUsed(SystemInstance config) {
        super(config);
        this.successMessage = " There is no data-guarded DB managed by this CRS";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that data guard is not set between databases.");
        ArrayList<BaseCause> nullCauses = new ArrayList<BaseCause>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSRACsValid.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add(new MultipleCRSObject(null, BundleUtils.getMessage(CRSRACsValid.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSRACsValid.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            this.logger.log(Level.FINE, "The CRS cluster has no RAC Databases associated with it.");
            list.add(crs);
            nullCauses.add(new NoRAC(list, BundleUtils.getMessage(CRSRACsValid.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<Object> dataguarded = new ArrayList<Object>();
        for (Object rac : racs) {
            String status = rac.getDataguardStatus();
            if (status == null || status.trim().length() == 0) continue;
            dataguarded.add(rac);
        }
        List sidbs = crs.getDbSI();
        if (sidbs != null) {
            for (SIDatabase si : sidbs) {
                String status = si.getDataguardStatus();
                if (status == null || status.trim().length() == 0) continue;
                dataguarded.add(si);
            }
        }
        ArrayList<DataGuardPresent> failureCauses = new ArrayList<DataGuardPresent>();
        if (!dataguarded.isEmpty()) {
            failureCauses.add(new DataGuardPresent(dataguarded, BundleUtils.getMessage(CRSDataGuardNotUsed.class, (String)"DATA_GUARD", (Object[])new Object[]{BundleUtils.makeStringOutOfList(dataguarded)})));
        }
        if (!failureCauses.isEmpty()) {
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

