/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.oplan.db.validation.causes.NoRACinstances;
import oracle.oplan.db.validation.rules.RACversionCRS;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.causes.UnequalVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class RACUnequalVersion
extends BaseRule {
    Logger logger = Logger.getLogger(RACUnequalVersion.class.getName());

    public RACUnequalVersion(SystemInstance config) {
        super(config);
        this.successMessage = "All RAC Versions are same";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that all the RACs have the same version. ");
        ArrayList<Object> nullCauses = new ArrayList<Object>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(RACUnequalVersion.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add((Object)new MultipleCRSObject(null, BundleUtils.getMessage(RACUnequalVersion.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add((Object)new NoCRS(null, BundleUtils.getMessage(RACUnequalVersion.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            this.logger.log(Level.FINE, "The CRS cluster has no RAC Databases associated with it.");
            list.add(crs);
            nullCauses.add((Object)new NoRAC(list, BundleUtils.getMessage(RACUnequalVersion.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDatabase> noInstances = new ArrayList<RACDatabase>();
        for (RACDatabase rac : racs) {
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
            this.logger.log(Level.FINE, "There are RAC Databases with no instances associated");
            noInstances.add(rac);
        }
        if (!noInstances.isEmpty()) {
            nullCauses.add((Object)new NoRACinstances(noInstances, BundleUtils.getMessage(RACUnequalVersion.class, (String)"NO_RACINSTANCE", (Object[])new Object[]{BundleUtils.makeStringOutOfList(noInstances)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDBInstance> instMissingVersion = new ArrayList<RACDBInstance>();
        ArrayList unequalVersion = new ArrayList();
        HashMap racVersions = new HashMap();
        for (RACDatabase rac : racs) {
            String racVer = null;
            for (RACDBInstance instance : rac.getDbInstances()) {
                if (instance.getVersion() == null || instance.getVersion().trim().length() == 0) {
                    this.logger.log(Level.FINE, "The instance is missing version information.");
                    instMissingVersion.add(instance);
                    continue;
                }
                if (racVer != null) continue;
                racVer = instance.getVersion().trim();
                if (!racVersions.containsKey(racVer)) {
                    ArrayList<RACDatabase> racdb = new ArrayList<RACDatabase>();
                    racdb.add(rac);
                    racVersions.put(racVer, racdb);
                    continue;
                }
                ((List)racVersions.get(racVer)).add(rac);
            }
        }
        if (!instMissingVersion.isEmpty()) {
            nullCauses.add(new MissingVersion(instMissingVersion, BundleUtils.getMessage(RACversionCRS.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(instMissingVersion)})));
        }
        if (!nullCauses.isEmpty()) {
            return new RuleResult((Rule)this, (Boolean)null, nullCauses);
        }
        if (racVersions.keySet().size() != 1) {
            for (String version : racVersions.keySet()) {
                unequalVersion.add(((List)racVersions.get(version)).get(0));
            }
        }
        ArrayList<UnequalVersion> failureCauses = new ArrayList<UnequalVersion>();
        if (!unequalVersion.isEmpty()) {
            failureCauses.add(new UnequalVersion(unequalVersion, BundleUtils.getMessage(RACUnequalVersion.class, (String)"INSTANCE_UNEQUAL_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(unequalVersion)})));
        }
        if (!failureCauses.isEmpty()) {
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

