/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.patchanalyzer.PatchPackageException;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.HashComputeFunction;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.IncludeAutomationXml;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.InventoryAndActionOnly;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.InventoryAndActionOnlyV2;
import org.xml.sax.SAXException;

public class EngSystemPatchValidator {
    private static String xsdFileName = "oracle/opatchauto/core" + File.separator + "patchanalyzer" + "/" + "system_patch_bundle.xsd";
    private static HashMap<Integer, HashComputeFunction> hashFunctions = new HashMap();

    public void validate(SystemPatchBundleXML systemPatchContent, Map<String, String> params) throws PatchPackageException {
        String function;
        HashComputeFunction trueFunc;
        String hv = params.get("value");
        if (hv == null) {
            hv = new String();
        }
        if ((trueFunc = hashFunctions.get(new Integer(function = params.get("function")))) != null) {
            List<String> metaList = trueFunc.fileList(systemPatchContent.getPatchLocation(), systemPatchContent);
            String valueComp = trueFunc.computeHash(metaList);
            if (!valueComp.equals(hv)) {
                throw new PatchPackageException("Engineered System Patch may be modified. Please try the same patch from MOS");
            }
        } else {
            StringBuffer bundleXMLLoc = new StringBuffer(systemPatchContent.getPatchLocation());
            bundleXMLLoc.append(File.separator);
            bundleXMLLoc.append("bundle.xml");
            File bxml = new File(bundleXMLLoc.toString());
            throw new PatchPackageException("Hash function of fvalue in \"" + bxml.getAbsolutePath() + "\" is not supported in current version.");
        }
    }

    public void validate(String patchLocation) throws PatchPackageException {
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        File bxml = new File(bundleXMLLoc.toString());
        if (!bxml.exists()) {
            OACLogger.severe("Bundle.xml was not found at the given patch location.");
            throw new PatchPackageException("Bundle.xml was not found at the given patch location " + bundleXMLLoc.toString());
        }
        if (!bxml.isFile()) {
            OACLogger.severe("Bundle.xml was found but it is not a file.");
            throw new PatchPackageException("Bundle.xml was found at location " + bxml.getAbsolutePath() + " but it is not a file");
        }
        if (!this.isValidSchema(bxml)) {
            throw new PatchPackageException("xml file schema is not supported");
        }
    }

    private boolean isValidSchema(File xmlFile) {
        boolean isValid = true;
        try {
            StreamSource xmlSource = new StreamSource(xmlFile);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.getClass().getResource("/" + xsdFileName));
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (SAXException e) {
            OACLogger.severe("xml file is not valid " + e.getLocalizedMessage());
            isValid = false;
        }
        catch (IOException e) {
            OACLogger.severe("xml file is not valid " + e.getLocalizedMessage());
            isValid = false;
        }
        return isValid;
    }

    static {
        hashFunctions.put(1, new InventoryAndActionOnly());
        hashFunctions.put(2, new IncludeAutomationXml());
        hashFunctions.put(3, new InventoryAndActionOnlyV2());
    }
}

