/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.remote.ssh;

import com.oracle.helper.remote.RemoteCommandListenerObject;
import com.oracle.helper.remote.RemoteExecutionResult;
import com.oracle.helper.remote.RemoteHandlerListener;
import com.oracle.helper.remote.RemoteRequestParam;
import com.oracle.helper.remote.ssh.RemoteSSHCommandListener;
import com.oracle.helper.remote.ssh.SSHEquivalenceCommandExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SSHEquivalenceThreadHandler {
    List<RemoteCommandListenerObject> listenerObjects = new ArrayList<RemoteCommandListenerObject>();
    private List<Thread> cmdExecutorHandlers = new ArrayList<Thread>();
    private RemoteHandlerListener remoteHandlerListener;
    private Logger logger = Logger.getLogger(SSHEquivalenceThreadHandler.class.getName());
    private List<RemoteRequestParam> remoteRequestParams;
    private int threadCount = 0;

    public SSHEquivalenceThreadHandler(List<RemoteRequestParam> remoteRequestParams, RemoteHandlerListener remoteHandlerListener) {
        this.remoteRequestParams = remoteRequestParams;
        this.remoteHandlerListener = remoteHandlerListener;
    }

    public void executeCommand() {
        for (RemoteRequestParam remoteRequestParam : this.remoteRequestParams) {
            this.cmdExecutorHandlers.add(this.createExecutionThread(remoteRequestParam));
        }
        this.threadCount = this.cmdExecutorHandlers.size();
        this.startRemoteExecution();
    }

    public Thread createExecutionThread(RemoteRequestParam remoteRequestParam) {
        SSHEquivalenceCommandExecutor remoteCmdExecutor = new SSHEquivalenceCommandExecutor(remoteRequestParam.getRequestParams(), remoteRequestParam.getHost(), new SSHEquiCommandListener(), remoteRequestParam.isExitOnFailure());
        Thread thread = new Thread(remoteCmdExecutor);
        return thread;
    }

    private void startRemoteExecution() {
        for (Thread t : this.cmdExecutorHandlers) {
            t.start();
        }
        for (Thread t : this.cmdExecutorHandlers) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.warning("InterruptedException: " + e.getMessage());
            }
        }
    }

    private class SSHEquiCommandListener
    implements RemoteSSHCommandListener {
        private SSHEquiCommandListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyResult(String host, List<RemoteExecutionResult> remoteExecutionResults) {
            SSHEquivalenceThreadHandler.this.logger.info("Received command execution result for host " + host);
            for (RemoteRequestParam remoteExecutionParam : SSHEquivalenceThreadHandler.this.remoteRequestParams) {
                if (!host.equals(remoteExecutionParam.getHost())) continue;
                RemoteCommandListenerObject listenerObject = new RemoteCommandListenerObject();
                listenerObject.setHost(host);
                listenerObject.setRemoteExecutionResults(remoteExecutionResults);
                List<RemoteCommandListenerObject> list = SSHEquivalenceThreadHandler.this.listenerObjects;
                synchronized (list) {
                    SSHEquivalenceThreadHandler.this.listenerObjects.add(listenerObject);
                }
            }
            if (SSHEquivalenceThreadHandler.this.listenerObjects.size() == SSHEquivalenceThreadHandler.this.threadCount) {
                SSHEquivalenceThreadHandler.this.logger.fine("Notifying request status.");
                SSHEquivalenceThreadHandler.this.threadCount = 0;
                SSHEquivalenceThreadHandler.this.remoteHandlerListener.notifyResult(SSHEquivalenceThreadHandler.this.listenerObjects);
            }
        }
    }
}

