/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.utils.configdiff;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import oracle.osysmodel.utils.configdiff.ConfigDiff;
import oracle.osysmodel.utils.configdiff.ConfigDiffException;
import oracle.osysmodel.utils.configdiff.EquivalentMethodFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigDiffUtil
extends ConfigDiff {
    static Logger logger = Logger.getLogger(ConfigDiffUtil.class.getName());
    EqualsMap<AbstractBaseTarget> equivalenceMap = new EqualsMap();

    public ConfigDiffUtil(SystemInstance source, SystemInstance destination, HashMap<Class<? extends AbstractBaseTarget>, List<Method>> mapAttributes) {
        super(source, destination);
        this.mapAttributes = mapAttributes == null ? EquivalentMethodFilter.getAttributesMap() : mapAttributes;
    }

    @Override
    public boolean diff() throws ConfigDiffException {
        StringBuilder sb;
        if (this.source == null || this.destination == null) {
            if (this.source == null && this.destination == null) {
                throw new NullPointerException("Both the SystemInstances given are null.");
            }
            if (this.source == null) {
                throw new NullPointerException("System Instance for the first system configuration is null.");
            }
            if (this.destination == null) {
                throw new NullPointerException("System Instance for the second system configuration is null.");
            }
        }
        logger.log(Level.INFO, "Number of entities Source: " + this.source.getEntities().size() + " Destination: " + this.destination.getEntities().size());
        if (logger.isLoggable(Level.FINEST)) {
            sb = new StringBuilder();
            for (BaseClass b : this.source.getEntities()) {
                sb.append(b).append("(" + b.hashCode() + ")").append("\n");
            }
            logger.log(Level.FINEST, sb.toString());
        }
        logger.log(Level.INFO, "Destination List: " + this.destination.getEntities());
        if (logger.isLoggable(Level.FINEST)) {
            sb = new StringBuilder();
            for (BaseClass b : this.destination.getEntities()) {
                sb.append(b).append("(" + b.hashCode() + ")").append("\n");
            }
            logger.log(Level.FINEST, sb.toString());
        }
        this.diff(this.source, this.destination, this.getSourceEntitiesNotFoundInDestination());
        this.diff(this.destination, this.source, this.getDestinationEntitiesNotFoundInSource());
        boolean bl = this.isDifferent = !this.getSourceEntitiesNotFoundInDestination().isEmpty() || !this.getDestinationEntitiesNotFoundInSource().isEmpty();
        if (this.isDifferent) {
            logger.log(Level.INFO, "The two system configurations are different.");
        } else {
            logger.log(Level.INFO, "The configuration of the systems are same.");
        }
        this.equalsMap = this.equivalenceMap.getSourceToTargetEquivalenceMap();
        return this.isDifferent;
    }

    private void diff(SystemInstance src, SystemInstance dst, ArrayList<AbstractBaseTarget> notfoundItems) throws ConfigDiffException {
        for (BaseClass sbc : src.getEntities()) {
            assert (sbc instanceof AbstractBaseTarget);
            if (this.mapAttributes.get(sbc.getClass()) == null || ((List)this.mapAttributes.get(sbc.getClass())).size() == 0) {
                logger.log(Level.INFO, "Method Filter's for " + sbc.getClass() + " don't exist or is empty in the Attribute map. This class will be ignored for comparision");
                continue;
            }
            boolean found = false;
            for (BaseClass tbc : dst.getEntities()) {
                assert (tbc instanceof AbstractBaseTarget);
                if (!this.isEqual((AbstractBaseTarget)sbc, (AbstractBaseTarget)tbc)) continue;
                found = true;
                break;
            }
            if (found) continue;
            notfoundItems.add((AbstractBaseTarget)sbc);
        }
    }

    private boolean isEqual(AbstractBaseTarget src, AbstractBaseTarget dst) throws ConfigDiffException {
        if (this.equivalenceMap.isEqual(src, dst)) {
            return true;
        }
        EqualsMap<AbstractBaseTarget> visited = new EqualsMap<AbstractBaseTarget>();
        try {
            boolean result = this.isEqualRecursive(src, dst, visited);
            if (result) {
                this.equivalenceMap.equals(src, dst);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "IllegalAccessException: ", ex.getCause());
            throw new ConfigDiffException(ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, "IllegalArgumentException: ", ex.getCause());
            throw new ConfigDiffException(ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.SEVERE, "InvocationTargetException: ", ex.getCause());
            throw new ConfigDiffException(ex);
        }
    }

    private boolean isEqualRecursive(AbstractBaseTarget src, AbstractBaseTarget dst, EqualsMap<AbstractBaseTarget> visited) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (src == dst) {
            logger.log(Level.FINEST, "Both src and dst are null in isEqualRecursive");
            return true;
        }
        if (dst == null && src != null || src == null && dst != null) {
            logger.log(Level.FINEST, "Only one of src or dst is null, but other is not");
            return false;
        }
        if (!src.getClass().equals(dst.getClass())) {
            return false;
        }
        if (visited.isEqual(src, dst)) {
            logger.log(Level.FINE, "Hit a cycle: " + src + " & " + dst);
            return true;
        }
        visited.equals(src, dst);
        List attributes = (List)this.mapAttributes.get(src.getClass());
        if (attributes == null || attributes.size() == 0) {
            throw new RuntimeException("Error: Bug in the Method Filter!! There are no diff methods speficied for the class " + src.getClass() + " in the method filter class. But, there is another class in method filter using " + src.getClass() + " for filtering. This will produce incorrect diff results. Please remove all the references to " + src.getClass() + " in the method filter class");
        }
        if (!this.areScalarValuesEqual(src, dst)) {
            return false;
        }
        if (!this.areVectorValuesEqual(src, dst, visited)) {
            return false;
        }
        return this.areListValuesEqual(src, dst, visited);
    }

    private boolean areScalarValuesEqual(AbstractBaseTarget src, AbstractBaseTarget dst) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        assert (src.getClass() == dst.getClass());
        List attributes = (List)this.mapAttributes.get(src.getClass());
        for (Method m : attributes) {
            if (AbstractBaseTarget.class.isAssignableFrom(m.getReturnType()) || List.class.isAssignableFrom(m.getReturnType())) continue;
            logger.log(Level.FINEST, "Choosing metod " + m + " Return Type:" + m.getReturnType());
            Object sval = m.invoke((Object)src, new Object[0]);
            Object dval = m.invoke((Object)dst, new Object[0]);
            if (sval == dval || sval != null && sval.equals(dval) || dval != null && dval.equals(sval)) {
                logger.log(Level.FINEST, "Scalar values are EQUAL (" + m + ") :" + sval + " & " + dval);
                continue;
            }
            logger.log(Level.FINEST, "Scalar values are NOT equal (" + m + ") :" + sval + " & " + dval);
            return false;
        }
        return true;
    }

    private boolean areVectorValuesEqual(AbstractBaseTarget src, AbstractBaseTarget dst, EqualsMap<AbstractBaseTarget> visited) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        assert (src.getClass() == dst.getClass());
        List attributes = (List)this.mapAttributes.get(src.getClass());
        for (Method m : attributes) {
            AbstractBaseTarget dval;
            if (!AbstractBaseTarget.class.isAssignableFrom(m.getReturnType()) || List.class.isAssignableFrom(m.getReturnType())) continue;
            AbstractBaseTarget sval = (AbstractBaseTarget)m.invoke((Object)src, new Object[0]);
            if (sval == (dval = (AbstractBaseTarget)m.invoke((Object)dst, new Object[0]))) {
                logger.log(Level.FINEST, "Both values are null for :" + m + " src:" + src + " dst:" + dst);
                continue;
            }
            if (this.isEqualRecursive(sval, dval, visited)) continue;
            logger.log(Level.FINEST, "Vector values are NOT equal (" + m + ") :" + sval + " & " + dval);
            return false;
        }
        return true;
    }

    private boolean areListValuesEqual(AbstractBaseTarget src, AbstractBaseTarget dst, EqualsMap<AbstractBaseTarget> visited) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        assert (src.getClass() == dst.getClass());
        List attributes = (List)this.mapAttributes.get(src.getClass());
        for (Method m : attributes) {
            if (!List.class.isAssignableFrom(m.getReturnType())) continue;
            List sval = (List)m.invoke((Object)src, new Object[0]);
            List dval = (List)m.invoke((Object)dst, new Object[0]);
            sval = sval == null || sval.isEmpty() ? Collections.EMPTY_LIST : sval;
            List list = dval = dval == null || dval.isEmpty() ? Collections.EMPTY_LIST : dval;
            if (sval == dval) {
                logger.log(Level.FINEST, "Both List values are null/empty for " + m + " :\n\t src:" + src + " dst:" + dst);
                continue;
            }
            if (sval.size() != dval.size()) {
                logger.log(Level.FINEST, "List sizes are different for " + m + " :\n\t src List:" + sval + " dst List:" + dval);
                return false;
            }
            if (sval.size() <= 0) continue;
            if (sval.get(0) instanceof AbstractBaseTarget) {
                for (Object obj1 : sval) {
                    AbstractBaseTarget sbc = (AbstractBaseTarget)obj1;
                    boolean found = false;
                    for (Object obj2 : dval) {
                        AbstractBaseTarget dbc = (AbstractBaseTarget)obj2;
                        if (!this.isEqualRecursive(sbc, dbc, visited)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                continue;
            }
            for (Object obj : sval) {
                if (dval.contains(obj)) continue;
                logger.log(Level.FINEST, "List returned are different for " + m + " :\n\t src List:" + sval + " dst List:" + dval);
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualsMap<T> {
        HashMap<T, T> src2tgt = new HashMap();
        HashMap<T, T> tgt2src = new HashMap();

        public void equals(T lhs, T rhs) {
            if (rhs.equals(this.src2tgt.get(lhs)) || lhs.equals(this.src2tgt.get(rhs))) {
                logger.log(Level.FINEST, "Equality already established between " + lhs + " " + rhs);
                return;
            }
            T t = this.src2tgt.put(lhs, rhs);
            if (t != null) {
                // empty if block
            }
            if ((t = this.tgt2src.put(rhs, lhs)) != null) {
                // empty if block
            }
        }

        public boolean isEqual(T lhs, T rhs) {
            return rhs.equals(this.src2tgt.get(lhs)) || lhs.equals(this.src2tgt.get(rhs));
        }

        public HashMap<T, T> getSourceToTargetEquivalenceMap() {
            return this.src2tgt;
        }

        public void printMap() {
            int i = 0;
            System.out.println("Src size: " + this.src2tgt.size());
            for (T t : this.src2tgt.keySet()) {
                System.out.println(++i + ": " + t + "(" + t.hashCode() + ") = " + this.src2tgt.get(t) + "(" + this.src2tgt.get(t).hashCode() + ")");
            }
            i = 0;
            System.out.println("dst size: " + this.tgt2src.size());
            for (T t : this.tgt2src.keySet()) {
                System.out.println(++i + ": " + t + "(" + t.hashCode() + ") = " + this.tgt2src.get(t) + "(" + this.tgt2src.get(t).hashCode() + ")");
            }
        }
    }
}

