/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.graph.DefaultEdge;
import com.oracle.cie.dependency.graph.DefaultVertex;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.DirectedGraphHelper;
import com.oracle.cie.dependency.graph.EdgeFactory;
import com.oracle.cie.dependency.graph.EdgeFilter;
import com.oracle.cie.dependency.graph.GraphPrePostVisitor;
import com.oracle.cie.dependency.graph.Vertex;
import com.oracle.cie.dependency.graph.VertexFactory;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.LegacyHome;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.PatchLoader;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.AuxiliaryDirectoryMap;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.PatchInfo;
import com.oracle.cie.gdr.dao.rgy.ProductFamily;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.external.FederatedSorting;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioFileLockService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Home {
    private static final Logger _log = Logger.getLogger(Home.class.getName());
    public static final String INVENTORY_DIRECTORY = "inventory";
    public static final String LOCKS_DIRECTORY = "locks";
    public static final String LOCK_FILE = "oh.lock";
    public static final String FEDERATED_MARKER = "federated";
    private Path _home;
    private Path _registryFilePath;
    private FileTime _registryFileTimeStamp = null;
    private FileChannel _registryFC;
    private Registry _registry;
    private Collection<DistributionTarget> _installedDistributions;
    private Collection<Patch> _installedPatches;
    private static Map<Path, Home> _cache = new HashMap<Path, Home>();
    private RegistryHelper _registryHelper;
    private MetaDataHome _metaDataHome;
    private boolean _metaDataLoaded;
    private Set<FederatedHomeWrapper> _federatedHomes = new LinkedHashSet<FederatedHomeWrapper>();
    private FederatedHomeWrapper _selfFederatedHomeWrapper;
    private Collection<Path> _sessionFederatedHomes;
    private DirectedGraph<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> _federatedHomesGraph;
    private boolean _lazyLoad = false;

    public static Home getHome(File homeDir) throws IOException, DataHandlerException, GdrException {
        return Home.getHome(homeDir, false);
    }

    public static Home getHome(Path homePath) throws IOException, DataHandlerException, GdrException {
        return Home.getHome(homePath, false);
    }

    public static Home getHome(File homeDir, boolean lazyLoad) throws IOException, DataHandlerException, GdrException {
        return Home.getHome(NioHelper.getInstance().getPath(homeDir), lazyLoad);
    }

    public static Home getHome(Path homeDir, boolean lazyLoad) throws IOException, DataHandlerException, GdrException {
        if (homeDir == null) {
            GdrException ex = new GdrException("The home directory provided was null.");
            _log.throwing(Home.class.getName(), "getHome", ex);
            throw ex;
        }
        Home home = _cache.get(homeDir);
        if (home == null) {
            home = new Home(homeDir, lazyLoad);
            _cache.put(homeDir, home);
        } else {
            boolean registryExists = Files.exists(home._registryFilePath, new LinkOption[0]);
            if (home._registryFileTimeStamp == null && registryExists || home._registryFileTimeStamp != null && (!registryExists || !home._registryFileTimeStamp.equals(Files.getLastModifiedTime(home._registryFilePath, new LinkOption[0])))) {
                if (!lazyLoad) {
                    home.setLazyLoad(false);
                }
                home.refresh();
            } else if (home.isLazyLoad() && !lazyLoad) {
                home.disableLazyLoad();
            }
        }
        return home;
    }

    public static void clearCache() {
        _cache.clear();
    }

    protected Home() {
    }

    private Home(Path home) throws IOException, DataHandlerException, GdrException {
        this(home, false);
    }

    private Home(Path home, boolean lazyLoad) throws IOException, DataHandlerException, GdrException {
        this._lazyLoad = lazyLoad;
        this.setHome(home);
    }

    public void setHome(Path home) throws GdrException, IOException, DataHandlerException {
        if (home == null) {
            GdrException ex = new GdrException("The home directory provided was null.");
            _log.throwing(Home.class.getName(), "setHome", ex);
            throw ex;
        }
        this._home = home;
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Using home: " + this._home);
        }
        this._registryHelper = this.getRegistryHelper(this._home);
        this._registryFilePath = this.getInventoryDirectoryPath().resolve("registry.xml");
        this.refresh();
    }

    protected RegistryHelper getRegistryHelper(File home) {
        return this.getRegistryHelper(NioHelper.getInstance().getPath(home));
    }

    protected RegistryHelper getRegistryHelper(Path home) {
        return RegistryHelper.getInstance(RegistryHelper.getConfiguredClassLoader(home.resolve(System.getProperty("HOME_MODULES_PATH", "oui/modules"))));
    }

    public File getHome() {
        return this._home != null ? this._home.toFile() : null;
    }

    public Path getHomePath() {
        return this._home;
    }

    public Registry getRegistry() {
        return this._registry;
    }

    public File getInventoryDirectory() {
        return Home.getInventoryDirectory(this._home).toFile();
    }

    public Path getInventoryDirectoryPath() {
        return Home.getInventoryDirectory(this._home);
    }

    public static File getInventoryDirectory(File home) {
        return Home.getInventoryDirectory(NioHelper.getInstance().getPath(home)).toFile();
    }

    public static Path getInventoryDirectory(Path home) {
        return home.resolve(INVENTORY_DIRECTORY);
    }

    public File getRegistryFile() {
        return this._registryFilePath.toFile();
    }

    public Path getRegistryFilePath() {
        return this._registryFilePath;
    }

    public ClassLoader getClassLoader() {
        return this._registryHelper.getClassLoader();
    }

    public RegistryHelper getRegistryHelper() {
        return this._registryHelper;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    void setLazyLoad(boolean lazyLoad) {
        this._lazyLoad = lazyLoad;
    }

    public void disableLazyLoad() throws GdrException, IOException, DataHandlerException {
        if (this.isLazyLoad()) {
            this.setLazyLoad(false);
            this.loadInstalledMetaData();
        }
    }

    public Set<Home> getDirectDependencyFederatedHomes(boolean includeSelf) {
        return this.getFederatedHomes(FederatedRelationship.DIRECT_DEPENDENCY, includeSelf);
    }

    public Set<Home> getChainedFederatedHomes(boolean includeSelf) {
        return this.getFederatedHomes(FederatedRelationship.CHAINED_DEPENDENCY, includeSelf);
    }

    public Set<Home> getAffiliateFederatedHomes(boolean includeSelf) {
        return this.getFederatedHomes(FederatedRelationship.AFFILIATE, includeSelf);
    }

    public Set<Home> getAllFederatedHomes(boolean includeSelf) {
        return this.getFederatedHomes(FederatedRelationship.ALL, includeSelf);
    }

    public Set<Home> getFederatedHomes(FederatedRelationship relationship, boolean includeSelf) {
        return this.getFederatedHomes(relationship, FederatedSorting.DIRECT_FIRST, includeSelf);
    }

    public Set<Home> getFederatedHomes(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) {
        LinkedHashSet<Home> homes = new LinkedHashSet<Home>();
        LinkedHashSet<FederatedHomeWrapper> federatedHomes = new LinkedHashSet<FederatedHomeWrapper>();
        if (sorting == null || sorting.isDirect()) {
            federatedHomes.addAll(this._federatedHomes);
        } else {
            federatedHomes.addAll(this.getSortedFederatedHomes(sorting));
        }
        for (FederatedHomeWrapper federatedHome : federatedHomes) {
            if (federatedHome.isSelf()) {
                if (!includeSelf) continue;
                homes.add(federatedHome.getHome());
                continue;
            }
            if (!(relationship.isAll() || relationship.isDirectDependency() && federatedHome.isDirect() || relationship.isChainedDependency() && federatedHome.isChained() || relationship.isIncomingDirect() && federatedHome.isIncomingDirect() || relationship.isIncomingChained() && federatedHome.isIncomingChained() || relationship.isBidirectionalChained() && (federatedHome.isChained() || federatedHome.isIncomingChained())) && (!relationship.isAffiliate() || federatedHome.isDirect() || federatedHome.isChained())) continue;
            homes.add(federatedHome.getHome());
        }
        return homes;
    }

    public Collection<Path> getSessionFederatedHomes() {
        return this._sessionFederatedHomes != null ? new LinkedHashSet<Path>(this._sessionFederatedHomes) : null;
    }

    public void setSessionFederatedHomes(Collection<Path> homes) throws DataHandlerException, GdrException, IOException {
        if (homes != null && !homes.isEmpty()) {
            for (Path home : homes) {
                if (home == null) {
                    GdrException ex = new GdrException("The federated home directory provided was null.");
                    _log.throwing(Home.class.getName(), "addFederatedHomes", ex);
                    throw ex;
                }
                if (!Files.isDirectory(home, new LinkOption[0])) {
                    GdrException ex = new GdrException("Federated home does not exist: " + home);
                    _log.throwing(Home.class.getName(), "addFederatedHomes", ex);
                    throw ex;
                }
                if (!home.equals(this.getHomePath())) continue;
                GdrException ex = new GdrException("Cannot add home to itself as a federated home: " + home);
                _log.throwing(Home.class.getName(), "addFederatedHomes", ex);
                throw ex;
            }
        }
        this._sessionFederatedHomes = homes == null ? null : new LinkedHashSet<Path>(homes);
        this.loadFederatedHomes();
    }

    public boolean isFederatedHome() {
        return !this.getFederatedHomes(FederatedRelationship.ALL, false).isEmpty();
    }

    private boolean hasFederatedHome(Path homeDir) {
        if (homeDir != null && this.isFederatedHome()) {
            for (FederatedHomeWrapper federatedHome : this._federatedHomes) {
                if (!homeDir.equals(federatedHome.getHome().getHomePath())) continue;
                return true;
            }
        }
        return false;
    }

    public MetaDataHome getMetaDataHome() throws GdrException {
        if (this._metaDataHome == null) {
            this._metaDataHome = new MetaDataHome(this.getInventoryDirectoryPath());
            this._metaDataHome.setClassLoader(this.getClassLoader());
        }
        return this._metaDataHome;
    }

    public Collection<DistributionTarget> getInstalledDistributions() {
        if (this.isLazyLoad()) {
            throw new IllegalStateException("Home meta-data has not been loaded. Call getHome with lazy loading disable to get home meta-data loaded.");
        }
        return new ArrayList<DistributionTarget>(this._installedDistributions);
    }

    public Collection<DistributionTarget> getFederatedInstalledDistributions(FederatedRelationship relationship) throws GdrException, IOException, DataHandlerException {
        return this.getFederatedInstalledDistributions(relationship, true);
    }

    public Collection<DistributionTarget> getFederatedInstalledDistributions(FederatedRelationship relationship, boolean includeSelf) throws GdrException, IOException, DataHandlerException {
        ArrayList<DistributionTarget> installed;
        ArrayList<DistributionTarget> arrayList = installed = includeSelf ? this.getInstalledDistributions() : new ArrayList<DistributionTarget>();
        if (this.isFederatedHome()) {
            for (Home federatedHome : this.getFederatedHomes(relationship, false)) {
                if (federatedHome.isLazyLoad()) {
                    federatedHome.disableLazyLoad();
                }
                installed.addAll(federatedHome.getInstalledDistributions());
            }
        }
        return installed;
    }

    public DistributionTarget getInstalledDistribution(String name, String version) {
        Collection<DistributionTarget> installedDistributions;
        if (!(StringUtil.isNullOrEmpty((String)name, (boolean)true) || StringUtil.isNullOrEmpty((String)version, (boolean)true) || (installedDistributions = this.getInstalledDistributions()) == null || installedDistributions.isEmpty())) {
            for (DistributionTarget installedDistribution : installedDistributions) {
                if (!name.equals(installedDistribution.getDistributionName()) || !version.equals(installedDistribution.getDistributionVersion())) continue;
                return installedDistribution;
            }
        }
        return null;
    }

    public Collection<DistributionTarget> getInstalledDistributions(FeatureSet featureSet) throws GdrException {
        if (null == featureSet) {
            GdrException ex = new GdrException("Method Argument featureSet is Null");
            _log.throwing(Home.class.getName(), "getInstalledDistributions", ex);
            throw ex;
        }
        HashSet<DistributionTarget> parentDistributions = new HashSet<DistributionTarget>();
        for (DistributionTarget installedDistribution : this.getInstalledDistributions()) {
            for (FeatureSet installedFeatureSet : installedDistribution.getFeatureSets()) {
                if (!featureSet.equals(installedFeatureSet)) continue;
                parentDistributions.add(installedDistribution);
            }
        }
        return parentDistributions;
    }

    public Collection<DistributionTarget> getInstalledDistributions(ComponentReference component) throws GdrException {
        if (null == component) {
            GdrException ex = new GdrException("Method Argument Component is Null");
            _log.throwing(Home.class.getName(), "getInstalledDistributions", ex);
            throw ex;
        }
        HashSet<DistributionTarget> parentDistributions = new HashSet<DistributionTarget>();
        for (FeatureSet installedFeatureSet : this.getInstalledFeatureSets(component)) {
            parentDistributions.addAll(this.getInstalledDistributions(installedFeatureSet));
        }
        return parentDistributions;
    }

    public Set<FeatureSet> getInstalledFeatures() {
        HashSet<FeatureSet> installed = new HashSet<FeatureSet>();
        Collection<DistributionTarget> installedDists = this.getInstalledDistributions();
        if (installedDists != null && !installedDists.isEmpty()) {
            for (DistributionTarget target : installedDists) {
                installed.addAll(target.getInstalledFeatureSets());
            }
        }
        return installed;
    }

    public Set<FeatureSet> getFederatedInstalledFeatures(FederatedRelationship relationship) throws GdrException, IOException, DataHandlerException {
        return this.getFederatedInstalledFeatures(relationship, true);
    }

    public Set<FeatureSet> getFederatedInstalledFeatures(FederatedRelationship relationship, boolean includeSelf) throws GdrException, IOException, DataHandlerException {
        HashSet<FeatureSet> installed;
        HashSet<FeatureSet> hashSet = installed = includeSelf ? this.getInstalledFeatures() : new HashSet<FeatureSet>();
        if (this.isFederatedHome()) {
            for (Home federatedHome : this.getFederatedHomes(relationship, false)) {
                if (federatedHome.isLazyLoad()) {
                    federatedHome.disableLazyLoad();
                }
                installed.addAll(federatedHome.getInstalledFeatures());
            }
        }
        return installed;
    }

    public Home getFeatureSetFederatedHome(FeatureSet featureSet, FederatedRelationship relationship) throws GdrException, IOException, DataHandlerException {
        if (featureSet != null && this.isFederatedHome()) {
            for (Home federatedHome : this.getFederatedHomes(relationship, false)) {
                if (federatedHome.isLazyLoad()) {
                    federatedHome.disableLazyLoad();
                }
                if (!federatedHome.isFeatureInstalled(featureSet.getName(), featureSet.getVersion())) continue;
                return federatedHome;
            }
        }
        return null;
    }

    public FeatureSet getInstalledFeature(Reference reference) {
        FeatureSet feature = null;
        Set<FeatureSet> installedFeatureSets = this.getInstalledFeatures();
        if (installedFeatureSets != null && !installedFeatureSets.isEmpty()) {
            for (FeatureSet installedFeatureSet : installedFeatureSets) {
                if (!installedFeatureSet.getName().equals(reference.getName()) || !installedFeatureSet.getVersion().equals(reference.getVersion())) continue;
                feature = installedFeatureSet;
                break;
            }
        }
        return feature;
    }

    public boolean isFeatureInstalled(Reference reference) {
        return this.getInstalledFeature(reference) != null;
    }

    public boolean isFeatureInstalled(String name, String version) {
        return this.isFeatureInstalled(new QuickReference(name, version));
    }

    public Set<FeatureSet> getInstalledFeatureSets(ComponentReference component) throws GdrException {
        if (null == component) {
            GdrException ex = new GdrException("Method Argument component is Null");
            _log.throwing(Home.class.getName(), "getInstalledFeatureSets", ex);
            throw ex;
        }
        HashSet<FeatureSet> parentFeatureSet = new HashSet<FeatureSet>();
        for (FeatureSet installedFeatureSet : this.getInstalledFeatures()) {
            for (ComponentReference compRef : installedFeatureSet.getComponentReferences()) {
                if (!component.equals((Object)compRef)) continue;
                parentFeatureSet.add(installedFeatureSet);
            }
        }
        return parentFeatureSet;
    }

    public Set<ComponentReference> getInstalledComponents() {
        HashSet<ComponentReference> installed = new HashSet<ComponentReference>();
        Collection<DistributionTarget> installedDists = this.getInstalledDistributions();
        if (installedDists != null && !installedDists.isEmpty()) {
            for (DistributionTarget target : installedDists) {
                installed.addAll(target.getInstalledComponents());
            }
        }
        return installed;
    }

    public ComponentReference getInstalledComponent(String name, String version) throws GdrException {
        return this.getInstalledComponent(name, version, null);
    }

    public ComponentReference getInstalledComponent(String name, String version, String patchLevel) throws GdrException {
        if (null == name || null == version) {
            GdrException ex = new GdrException("Method Argument Name is " + name + " and method argument Version is " + version + "  One of these is null");
            _log.throwing(Home.class.getName(), "getInstalledComponent", ex);
            throw ex;
        }
        for (ComponentReference component : this.getInstalledComponents()) {
            if (!name.equals(component.getName()) || !version.equals(component.getVersion()) || patchLevel != null && !patchLevel.equals(component.getPatchLevel())) continue;
            return component;
        }
        return null;
    }

    public boolean isComponentInstalled(String name, String version) {
        return this.isComponentInstalled(name, version, null);
    }

    public boolean isComponentInstalled(String name, String version, String patchLevel) {
        try {
            return this.getInstalledComponent(name, version, patchLevel) != null;
        }
        catch (GdrException e) {
            return false;
        }
    }

    public Collection<DistributionTarget> getDistributionTargetsForFeature(FeatureSet feature) {
        ArrayList<DistributionTarget> targets = new ArrayList<DistributionTarget>();
        Collection<DistributionTarget> installedDists = this.getInstalledDistributions();
        if (installedDists != null && !installedDists.isEmpty()) {
            for (DistributionTarget target : installedDists) {
                if (!target.getInstalledFeatureSets().contains(feature)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public Collection<DistributionTarget> getAllDistributionTargetsForFeature(FeatureSet feature) {
        ArrayList<DistributionTarget> targets = new ArrayList<DistributionTarget>();
        Collection<DistributionTarget> installedDists = this.getInstalledDistributions();
        if (installedDists != null && !installedDists.isEmpty()) {
            for (DistributionTarget target : installedDists) {
                if (!target.getFeatureSets().contains(feature)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public Collection<DistributionTarget> getReferencingDistributionTargets(FeatureSet feature) {
        Collection<DistributionTarget> targetsWithInstalledReference = this.getDistributionTargetsForFeature(feature);
        Collection<DistributionTarget> targets = this.getAllDistributionTargetsForFeature(feature);
        for (DistributionTarget target : targetsWithInstalledReference) {
            if (!targets.contains(target)) continue;
            targets.remove(target);
        }
        return targets;
    }

    public void refresh() throws IOException, DataHandlerException, GdrException {
        if (this._metaDataHome != null) {
            DistributionLoaderFactory.clearCache(this._metaDataHome);
            this._metaDataHome = null;
        }
        if (this._metaDataLoaded) {
            this._installedDistributions = null;
            this._installedPatches = null;
            this._metaDataLoaded = false;
        }
        this.loadHomeMetaData();
    }

    protected synchronized void loadHomeMetaData() throws GdrException, IOException, DataHandlerException {
        Path registryDir;
        this._registry = null;
        Path registryPath = this.getRegistryFilePath();
        this._registryFileTimeStamp = Files.exists(registryPath, new LinkOption[0]) ? Files.getLastModifiedTime(registryPath, new LinkOption[0]) : null;
        if (Files.exists(this._home, new LinkOption[0]) && Files.exists(registryDir = this.getInventoryDirectoryPath(), new LinkOption[0]) && Files.exists(registryPath, new LinkOption[0])) {
            this._registry = this._registryHelper.getRegistry(this.getRegistryFilePath());
        }
        if (this._registry == null) {
            this._registry = (Registry)this._registryHelper.getRootWrapper();
            this._registry.setHome(this._home.toString());
            this._registry.setPlatform(PlatformInfoHelper.getInstance().getCurrentPlatformId());
        }
        if (!this.isLazyLoad()) {
            this.loadInstalledMetaData();
        }
    }

    protected void loadInstalledMetaData() throws GdrException, IOException, DataHandlerException {
        if (!this._metaDataLoaded) {
            this.loadFederatedHomes();
            this.loadInstalledDistributions();
            this.loadInstalledPatches();
            this._metaDataLoaded = true;
        }
    }

    protected void loadFederatedHomes() throws DataHandlerException, GdrException, IOException {
        Path homeParent;
        this._federatedHomes.clear();
        this._federatedHomesGraph = new OrderedDirectedGraph((VertexFactory<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>>)new DefaultVertex.DefaultVertexFactory(), (EdgeFactory<String, DefaultVertex<FederatedHomeWrapper>, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>>)new DefaultEdge.DefaultEdgeFactory());
        this._selfFederatedHomeWrapper = new FederatedHomeWrapper(this, false, true);
        DefaultVertex currentHomeVertex = (DefaultVertex)this._federatedHomesGraph.insertVertex((Object)this._selfFederatedHomeWrapper);
        this._federatedHomes.add(this._selfFederatedHomeWrapper);
        if (this._registry != null) {
            for (String federatedHome : this._registry.getFederatedHomes()) {
                Path federatedHomePath = NioHelper.getInstance().getPath(federatedHome, new String[0]);
                if (!Home.isValidHome(federatedHomePath)) {
                    throw new GdrException("The federated home " + federatedHomePath + " referenced by home " + this.getHomePath() + " is not a valid home.");
                }
                this.addDirectFederatedHome(federatedHomePath);
            }
        }
        if (this._sessionFederatedHomes != null) {
            for (Path sessionFederatedHome : this._sessionFederatedHomes) {
                this.addDirectFederatedHome(sessionFederatedHome);
            }
        }
        if ((homeParent = this.getHomeParent()) != null && Files.isDirectory(homeParent, new LinkOption[0])) {
            this.scanPeers(homeParent);
            FederatedHomeVisitor visitor = new FederatedHomeVisitor(null);
            visitor.setMarkChained(true);
            DirectedGraphHelper.depthFirstEdgeTraversal(this._federatedHomesGraph, (GraphPrePostVisitor)visitor, (Vertex)currentHomeVertex, (boolean)true);
            visitor.setMarkChained(false);
            for (FederatedHomeWrapper chain : new LinkedHashSet<FederatedHomeWrapper>(visitor.getVisited())) {
                DefaultVertex chainVertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)chain);
                DirectedGraphHelper.depthFirstEdgeTraversal(this._federatedHomesGraph, (GraphPrePostVisitor)visitor, (Vertex)chainVertex, (boolean)false);
            }
            this._federatedHomes.addAll(visitor.getVisited());
            for (DefaultVertex vertex : this._federatedHomesGraph.getVertices()) {
                if (this._federatedHomes.contains(vertex.getKey())) continue;
                _log.fine("Removing unrelated federated home: " + vertex.getKey());
                this._federatedHomesGraph.removeVertex(vertex.getKey());
            }
            DefaultVertex selfVertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)this._selfFederatedHomeWrapper);
            List incoming = this._federatedHomesGraph.getIncomingEdges((Vertex)selfVertex);
            this.setFederatedIncoming(incoming, true);
            this._federatedHomes = this.getSortedFederatedHomes(FederatedSorting.DIRECT_FIRST);
        }
    }

    private void scanPeers(Path homeParent) throws DataHandlerException, GdrException, IOException {
        ArrayList<Path> peerDirs = new ArrayList<Path>();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(homeParent);){
            for (Path path : files) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                peerDirs.add(path);
            }
        }
        LinkedHashMap<Path, Home> peerHomes = new LinkedHashMap<Path, Home>();
        LinkedHashMap<Path, Home> peerLegacyHomes = new LinkedHashMap<Path, Home>();
        if (!peerDirs.isEmpty()) {
            Collections.sort(peerDirs, new Comparator<Path>(){

                @Override
                public int compare(Path o1, Path o2) {
                    return o1.getFileName().toString().compareTo(o2.getFileName().toString());
                }
            });
            for (Path peerDir : peerDirs) {
                Path peerDirPath = NioHelper.getInstance().getPath(peerDir.toString(), new String[0]);
                if (peerDirPath.equals(this.getHomePath()) || this.hasFederatedHome(peerDirPath)) continue;
                if (Home.isValidHome(peerDirPath) && this.isFederatedHome(peerDirPath)) {
                    peerHomes.put(peerDirPath, Home.getHome(peerDirPath, true));
                    continue;
                }
                if (HomeHelper.isLegacyHome(peerDirPath) && HomeHelper.isLegacyFederatedHome(peerDirPath)) {
                    peerLegacyHomes.put(peerDirPath, LegacyHome.getHome(peerDirPath, true));
                    continue;
                }
                try (DirectoryStream<Path> files = Files.newDirectoryStream(peerDir);){
                    for (Path path : files) {
                        if (!Files.isDirectory(path, new LinkOption[0]) || !HomeHelper.isLegacyHome(path) || !HomeHelper.isLegacyFederatedHome(path)) continue;
                        peerLegacyHomes.put(path, LegacyHome.getHome(path, true));
                    }
                }
            }
        }
        for (Map.Entry entry : peerHomes.entrySet()) {
            Path registryHomeLocation = NioHelper.getInstance().getPath(((Home)entry.getValue()).getRegistry().getHome(), new String[0]);
            if (!((Path)entry.getKey()).equals(registryHomeLocation)) {
                _log.fine("Ignoring peer federated oracle home whose physical location (" + entry.getKey() + ") does not match its registry's home location (" + registryHomeLocation + ").");
                continue;
            }
            FederatedHomeWrapper federatedHome = new FederatedHomeWrapper((Home)entry.getValue(), false, false);
            DefaultVertex vertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)federatedHome);
            if (vertex == null) {
                _log.fine("Adding peer federated home: " + federatedHome);
                vertex = (DefaultVertex)this._federatedHomesGraph.insertVertex((Object)federatedHome);
            }
            this.addChildFederatedHomes((DefaultVertex<FederatedHomeWrapper>)vertex);
        }
        for (Map.Entry legacyHome : peerLegacyHomes.entrySet()) {
            FederatedHomeWrapper federatedHome = new FederatedHomeWrapper((Home)legacyHome.getValue(), false, false);
            DefaultVertex vertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)federatedHome);
            if (vertex == null) {
                _log.fine("Adding peer federated home: " + federatedHome);
                vertex = (DefaultVertex)this._federatedHomesGraph.insertVertex((Object)federatedHome);
            }
            this.addChildFederatedHomes((DefaultVertex<FederatedHomeWrapper>)vertex);
        }
    }

    private void setFederatedIncoming(List<DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> incoming, boolean direct) {
        if (incoming != null) {
            for (DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String> incomingEdge : incoming) {
                DefaultVertex incomingVertex = (DefaultVertex)incomingEdge.getSource();
                if (direct) {
                    ((FederatedHomeWrapper)incomingVertex.getKey()).setIncomingDirect(true);
                }
                ((FederatedHomeWrapper)incomingVertex.getKey()).setIncomingChained(true);
                this.setFederatedIncoming(this._federatedHomesGraph.getIncomingEdges((Vertex)incomingVertex), false);
            }
        }
    }

    private void addDirectFederatedHome(Path home) throws DataHandlerException, GdrException, IOException {
        if (this.getHomePath().equals(home)) {
            _log.fine("Ignoring attempt to add self as a federated home: " + home);
            return;
        }
        FederatedHomeWrapper existingFederatedHome = null;
        for (FederatedHomeWrapper federatedHome : this._federatedHomes) {
            if (!federatedHome.getHome().getHomePath().equals(home)) continue;
            existingFederatedHome = federatedHome;
            break;
        }
        DefaultVertex childVertex = null;
        if (existingFederatedHome == null) {
            _log.fine("Adding federated home: " + home);
            existingFederatedHome = new FederatedHomeWrapper(Home.getHome(home, true), true, false);
            this._federatedHomes.add(existingFederatedHome);
            childVertex = (DefaultVertex)this._federatedHomesGraph.insertVertex((Object)existingFederatedHome);
        } else if (!existingFederatedHome.isDirect()) {
            _log.fine("Updating existing federated home to be direct: " + home);
            existingFederatedHome.setDirect(true);
            existingFederatedHome.setChained(true);
            childVertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)existingFederatedHome);
        }
        if (childVertex != null) {
            DefaultVertex vertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)this._selfFederatedHomeWrapper);
            String edgeKey = this.getFederatedGraphEdgeKey((DefaultVertex<FederatedHomeWrapper>)vertex, childVertex);
            if (this._federatedHomesGraph.getEdge((Object)edgeKey) == null) {
                _log.fine("Inserting federated home edge: " + edgeKey);
                this._federatedHomesGraph.insertDirectedEdge((Vertex)vertex, (Vertex)childVertex, (Object)edgeKey);
            }
            this.addChildFederatedHomes((DefaultVertex<FederatedHomeWrapper>)childVertex);
        }
    }

    private void addChildFederatedHomes(DefaultVertex<FederatedHomeWrapper> vertex) throws DataHandlerException, GdrException, IOException {
        if (vertex != null) {
            List<Object> childHomes = new ArrayList();
            childHomes = HomeHelper.isLegacyHome(((FederatedHomeWrapper)vertex.getKey()).getHome().getHomePath()) ? HomeHelper.getFederatesHomesForLegacyHome(((FederatedHomeWrapper)vertex.getKey()).getHome().getHomePath()) : ((FederatedHomeWrapper)vertex.getKey()).getHome().getRegistry().getFederatedHomes();
            for (String string : childHomes) {
                String edgeKey;
                Path childHome = NioHelper.getInstance().getPath(string, new String[0]);
                FederatedHomeWrapper childFederatedHome = childHome.equals(this.getHomePath()) ? this._selfFederatedHomeWrapper : new FederatedHomeWrapper(Home.getHome(childHome, true), false, false);
                DefaultVertex childVertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)childFederatedHome);
                if (childVertex == null) {
                    childVertex = (DefaultVertex)this._federatedHomesGraph.insertVertex((Object)childFederatedHome);
                }
                if (this._federatedHomesGraph.getEdge((Object)(edgeKey = this.getFederatedGraphEdgeKey(vertex, (DefaultVertex<FederatedHomeWrapper>)childVertex))) == null) {
                    _log.fine("Inserting federated home edge: " + edgeKey);
                    this._federatedHomesGraph.insertDirectedEdge(vertex, (Vertex)childVertex, (Object)edgeKey);
                }
                this.addChildFederatedHomes((DefaultVertex<FederatedHomeWrapper>)childVertex);
            }
        }
    }

    private String getFederatedGraphEdgeKey(DefaultVertex<FederatedHomeWrapper> vertex, DefaultVertex<FederatedHomeWrapper> childVertex) {
        return vertex.getKey() + "->" + childVertex.getKey();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Set<FederatedHomeWrapper> getSortedFederatedHomes(FederatedSorting sorting) {
        LinkedHashSet<FederatedHomeWrapper> federatedHomes = new LinkedHashSet<FederatedHomeWrapper>();
        if (this._federatedHomesGraph.getNumberOfVertices() > 1) {
            if (sorting == null || sorting.isDirect()) {
                DefaultVertex startVertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)this._selfFederatedHomeWrapper);
                FederatedHomeVisitor visitor = new FederatedHomeVisitor(null);
                DirectedGraphHelper.depthFirstEdgeTraversal(this._federatedHomesGraph, (GraphPrePostVisitor)visitor, (Vertex)startVertex, (boolean)true, (EdgeFilter)new ReverseEdgeFilter());
                federatedHomes.addAll(visitor.getVisited());
                for (FederatedHomeWrapper wrapper : new ArrayList<FederatedHomeWrapper>(visitor.getVisited())) {
                    visitor.clearVisited();
                    startVertex = (DefaultVertex)this._federatedHomesGraph.getVertex((Object)wrapper);
                    DirectedGraphHelper.depthFirstEdgeTraversal(this._federatedHomesGraph, (GraphPrePostVisitor)visitor, (Vertex)startVertex, (boolean)false, (EdgeFilter)new ReverseEdgeFilter());
                    federatedHomes.addAll(visitor.getVisited());
                }
                return federatedHomes;
            } else {
                if (!sorting.isCommonFirst()) {
                    IllegalArgumentException ex = new IllegalArgumentException("The FederatedSorting specified is not supported:" + (Object)((Object)sorting));
                    _log.throwing(Home.class.getName(), "getSortedFederatedHomes", ex);
                    throw ex;
                }
                ArrayList vertices = new ArrayList(this._federatedHomesGraph.getVertices());
                Collections.sort(vertices, new Comparator<DefaultVertex<FederatedHomeWrapper>>(){

                    @Override
                    public int compare(DefaultVertex<FederatedHomeWrapper> vertex1, DefaultVertex<FederatedHomeWrapper> vertex2) {
                        int outgoing2;
                        int outgoing1 = Home.this._federatedHomesGraph.getOutgoingEdges(vertex1).size();
                        int result = outgoing1 - (outgoing2 = Home.this._federatedHomesGraph.getOutgoingEdges(vertex2).size());
                        if (result == 0) {
                            int incoming1 = Home.this._federatedHomesGraph.getIncomingEdges(vertex1).size();
                            int incoming2 = Home.this._federatedHomesGraph.getIncomingEdges(vertex2).size();
                            result = incoming2 - incoming1;
                            if (result == 0) {
                                result = ((FederatedHomeWrapper)vertex1.getKey()).getHomeDir().getFileName().compareTo(((FederatedHomeWrapper)vertex2.getKey()).getHomeDir().getFileName());
                            }
                        }
                        return result;
                    }
                });
                for (DefaultVertex vertex : vertices) {
                    federatedHomes.add((FederatedHomeWrapper)vertex.getKey());
                }
            }
            return federatedHomes;
        }
        federatedHomes.addAll(this._federatedHomes);
        return federatedHomes;
    }

    public static boolean isHome(File directory) {
        return Home.isHome(NioHelper.getInstance().getPath(directory));
    }

    public static boolean isHome(Path directory) {
        return directory != null && Files.isDirectory(directory, new LinkOption[0]) && Files.exists(Home.getRegistryFilePath(directory), new LinkOption[0]);
    }

    private boolean isFederatedHome(Path directory) {
        return Home.isHome(directory) && Files.exists(Home.getFederatedMarker(directory), new LinkOption[0]);
    }

    public static File getRegistryFile(File homeDir) {
        return Home.getRegistryFilePath(NioHelper.getInstance().getPath(homeDir)).toFile();
    }

    public static Path getRegistryFilePath(Path homeDir) {
        return Home.getInventoryDirectory(homeDir).resolve("registry.xml");
    }

    public static File getFederatedMarker(File homeDir) {
        return Home.getFederatedMarker(NioHelper.getInstance().getPath(homeDir)).toFile();
    }

    public static Path getFederatedMarker(Path homeDir) {
        return Home.getInventoryDirectory(homeDir).resolve(FEDERATED_MARKER);
    }

    public static boolean isValidHome(File homeDir) {
        return Home.isValidHome(NioHelper.getInstance().getPath(homeDir));
    }

    public static boolean isValidHome(Path homeDir) {
        return homeDir != null && Files.isDirectory(homeDir, new LinkOption[0]) && Files.exists(Home.getRegistryFilePath(homeDir), new LinkOption[0]);
    }

    public Path getHomeParent() throws IOException {
        Path homeParentDir = this.getHomePath().getParent();
        if (homeParentDir == null && (homeParentDir = this.getHomePath().toAbsolutePath().getParent()) == null) {
            homeParentDir = this.getHomePath().toRealPath(new LinkOption[0]).getParent();
        }
        return homeParentDir;
    }

    protected void loadInstalledDistributions() throws GdrException, IOException, DataHandlerException {
        List<DistributionInfo> distributions;
        this._installedDistributions = new ArrayList<DistributionTarget>();
        if (this._registry != null && (distributions = this._registry.getDistributions()) != null && !distributions.isEmpty()) {
            MetaDataHome metaDataHome = this.getMetaDataHome();
            for (DistributionInfo distInfo : distributions) {
                if (!distInfo.getStatus().isInstalled()) continue;
                DistributionLoader distLoader = DistributionLoaderFactory.getDistributionLoader(metaDataHome, distInfo.getName(), distInfo.getVersion());
                this._registryHelper.setInstallationStatus(this, distLoader);
                DistributionTarget target = distLoader.getDistributionTarget();
                target.setDynamicFeatureSets(this._registryHelper.getDynamicFeatureSets(distInfo, metaDataHome));
                target.setOverrideDirectoryMap(this.getMergedDirectoryMap(target, distInfo));
                target.getDistribution().setProductFamilies(this.getProductFamilies(distInfo));
                this._installedDistributions.add(target);
            }
        }
    }

    public DirectoryMap getMergedDirectoryMap(DistributionTarget distributionTarget, DistributionInfo distInfo) {
        DirectoryMap directoryMap = null;
        Collection<ComponentInfo> installedComponentInfos = this._registryHelper.getInstalledComponentInfos(distInfo);
        if (installedComponentInfos != null && !installedComponentInfos.isEmpty()) {
            boolean includeDefault = false;
            HashSet<String> directoryMapNames = new HashSet<String>();
            HashMap<String, Set<String>> dynamicMappings = new HashMap<String, Set<String>>();
            for (ComponentInfo componentInfo : installedComponentInfos) {
                boolean dynamic = componentInfo.isDynamic();
                List<TargetInfo> targetInfos = componentInfo.getTargets();
                if (targetInfos == null || targetInfos.isEmpty()) continue;
                for (TargetInfo targetInfo : targetInfos) {
                    String directoryMapName = targetInfo.getDirectoryMapName();
                    if (!StringUtil.isNullOrEmpty((String)directoryMapName, (boolean)true)) {
                        directoryMapNames.add(directoryMapName);
                    } else {
                        includeDefault = true;
                    }
                    if (!dynamic) continue;
                    String location = targetInfo.getLocation();
                    String symbol = targetInfo.getSymbol();
                    if (StringUtil.isNullOrEmpty((String)location, (boolean)true) || StringUtil.isNullOrEmpty((String)symbol, (boolean)true)) continue;
                    HashSet<String> symbols = (HashSet<String>)dynamicMappings.get(location);
                    if (symbols == null) {
                        symbols = new HashSet<String>();
                        dynamicMappings.put(location, symbols);
                    }
                    symbols.add(symbol);
                }
            }
            ArrayList<DirectoryMap> directoryMaps = new ArrayList<DirectoryMap>();
            if (!directoryMapNames.isEmpty()) {
                if (includeDefault) {
                    directoryMaps.add(distributionTarget.getDistribution().getDirectoryMap());
                }
                List<AuxiliaryDirectoryMap> auxiliaryDirectoryMaps = distributionTarget.getDistribution().getAuxiliaryDirectoryMaps();
                block2: for (String directoryMapName : directoryMapNames) {
                    for (AuxiliaryDirectoryMap auxiliaryDirectoryMap : auxiliaryDirectoryMaps) {
                        if (!auxiliaryDirectoryMap.getName().equals(directoryMapName)) continue;
                        directoryMaps.add(auxiliaryDirectoryMap);
                        continue block2;
                    }
                }
            }
            if (!dynamicMappings.isEmpty()) {
                if (directoryMaps.isEmpty()) {
                    directoryMaps.add(distributionTarget.getDistribution().getDirectoryMap());
                }
                directoryMaps.add(DistributionHelper.getInstance(this.getClassLoader()).createDirectoryMap(dynamicMappings));
            }
            if (!directoryMaps.isEmpty()) {
                directoryMap = DistributionHelper.getInstance(this.getClassLoader()).mergeDirectoryMaps(directoryMaps);
            }
        }
        return directoryMap;
    }

    protected void loadInstalledPatches() throws GdrException, IOException, DataHandlerException {
        this._installedPatches = new LinkedHashSet<Patch>();
        Collection<DistributionTarget> installedDistributions = this.getInstalledDistributions();
        if (installedDistributions != null && !installedDistributions.isEmpty()) {
            MetaDataHome metaDataHome = this.getMetaDataHome();
            for (DistributionTarget distTarget : installedDistributions) {
                DistributionLoader distLoader = DistributionLoaderFactory.getDistributionLoader(metaDataHome, distTarget.getDistributionName(), distTarget.getDistributionVersion());
                PatchLoader pchLoader = distLoader.getPatchLoader();
                pchLoader.refresh();
                this._registryHelper.setInstallationStatus(this, distLoader);
                this._installedPatches.addAll(pchLoader.getPatches());
                ArrayList<ComponentReference> components = new ArrayList<ComponentReference>();
                for (FeatureSet dinamicFeature : distTarget.getDynamicFeatureSets()) {
                    components.addAll(dinamicFeature.getComponentReferences());
                }
                Set<Patch> patches = PatchHelper.getInstance(this.getClassLoader()).getPatches(this.getMetaDataHome().getGdrMetaDataHomePath());
                for (Patch patch : patches) {
                    List<ComponentReference> patchComponents = patch.getComponents();
                    for (ComponentReference componentRef : patchComponents) {
                        if (!components.contains((Object)componentRef) || this._installedPatches.contains((Object)patch)) continue;
                        this._installedPatches.add(patch);
                    }
                }
            }
        }
        if (this._registry != null) {
            ArrayList<PatchInfo> patchInfos = new ArrayList<PatchInfo>();
            for (DistributionInfo distInfo : this._registry.getDistributions()) {
                for (FeatureInfo featureInfo : distInfo.getFeatures()) {
                    for (ComponentInfo compInfo : featureInfo.getComponents()) {
                        for (PatchInfo patchInfo : compInfo.getPatches()) {
                            patchInfos.add(patchInfo);
                        }
                    }
                }
            }
            for (Patch patch : this._installedPatches) {
                for (PatchInfo patchInfo : patchInfos) {
                    if (!patchInfo.getPatchId().equals(patch.getPatchId())) continue;
                    patch.setStatus(patchInfo.getStatus());
                    patch.setInstallDate(patchInfo.getInstallDate());
                }
            }
        }
    }

    public Registry lockRegistry() throws IOException, DataHandlerException, GdrException {
        if (!NioFileLockService.getFileLock((Path)this.getRegistryFilePath())) {
            GdrException ex = new GdrException("Unable to obtain lock on registry.");
            _log.throwing(Home.class.getName(), "lockRegistry", ex);
            throw ex;
        }
        this._registryFC = NioFileLockService.getFileChannel((Path)this.getRegistryFilePath());
        if (this._registryFC.size() > 0L) {
            this._registry = this._registryHelper.getRegistry(this._registryFC);
        }
        this.loadInstalledDistributions();
        return this._registry;
    }

    public void unlockRegistry() throws IOException, DataHandlerException, GdrException {
        if (this._registryFC == null) {
            GdrException ex = new GdrException("Registry is not locked.");
            _log.throwing(Home.class.getName(), "unlockRegistry", ex);
            throw ex;
        }
        if (this._registry.isEmpty()) {
            Path registryFile = this.getRegistryFilePath();
            _log.fine("Registry is empty, deleting registry file " + registryFile);
            NioFileLockService.releaseFileLock((Path)registryFile);
            this._registryFC = null;
            if (!NioDelete.delete((Path)registryFile, (boolean)false)) {
                _log.warning("Unable to delete registry file " + registryFile);
            }
        } else {
            if (this._sessionFederatedHomes != null && !this._sessionFederatedHomes.isEmpty()) {
                Path federatedHomeMarker = Home.getFederatedMarker(this.getHomePath());
                if (Files.notExists(federatedHomeMarker, new LinkOption[0])) {
                    Files.createFile(federatedHomeMarker, new FileAttribute[0]);
                }
                this._sessionFederatedHomes = null;
            }
            this._registryHelper.save((IDataHandlerWrapper)this._registry, this._registryFC);
            NioFileLockService.releaseFileLock((Path)this.getRegistryFilePath());
            this._registryFC = null;
        }
        this.refresh();
    }

    public void releaseRegistryLock() throws IOException, DataHandlerException, GdrException {
        if (this._registryFC == null) {
            GdrException ex = new GdrException("Registry is not locked.");
            _log.throwing(Home.class.getName(), "releaseRegistryLock", ex);
            throw ex;
        }
        NioFileLockService.releaseFileLock((Path)this.getRegistryFilePath());
        this._registryFC = null;
        this.refresh();
    }

    public boolean isRegistryLocked() {
        return this._registryFC != null;
    }

    public Patch getInstalledPatch(String patchId) throws GdrException {
        if (null == patchId) {
            GdrException ex = new GdrException("The patch id specified was null.");
            _log.throwing(Home.class.getName(), "getInstalledPatch", ex);
            throw ex;
        }
        for (Patch installedPatch : this.getInstalledPatches()) {
            if (!patchId.equals(installedPatch.getPatchId())) continue;
            return installedPatch;
        }
        return null;
    }

    public Collection<Patch> getInstalledPatches() throws GdrException {
        return new LinkedHashSet<Patch>(this._installedPatches);
    }

    public Collection<Patch> getInstalledPatches(Component component) throws GdrException {
        LinkedHashSet<Patch> componentInstalledPatches = new LinkedHashSet<Patch>();
        block0: for (Patch installedPatch : this._installedPatches) {
            for (ComponentReference componentRef : installedPatch.getComponents()) {
                if (!component.getName().equals(componentRef.getName()) || !component.getVersion().equals(componentRef.getVersion())) continue;
                componentInstalledPatches.add(installedPatch);
                continue block0;
            }
        }
        return componentInstalledPatches;
    }

    public Collection<Patch> getInstalledPatches(FeatureSet featureSet) throws GdrException {
        LinkedHashSet<Patch> componentInstalledPatches = new LinkedHashSet<Patch>();
        if (featureSet != null) {
            for (ComponentReference componentRef : featureSet.getComponentReferences()) {
                componentInstalledPatches.addAll(this.getInstalledPatches(new Component(componentRef.getDataHandler())));
            }
        }
        return componentInstalledPatches;
    }

    public Collection<Patch> getInstalledPatches(Distribution distribution) throws GdrException {
        LinkedHashSet<Patch> componentInstalledPatches = new LinkedHashSet<Patch>();
        for (DistributionTarget distTarget : this.getInstalledDistributions()) {
            if (!distribution.equals(distTarget.getDistribution())) continue;
            for (ComponentReference componentRef : distTarget.getComponents()) {
                componentInstalledPatches.addAll(this.getInstalledPatches(new Component(componentRef.getDataHandler())));
            }
        }
        return componentInstalledPatches;
    }

    public boolean isPatchInstalled(String patchId) throws GdrException {
        Collection<Patch> installedPatches = this.getInstalledPatches();
        for (Patch installedPatch : installedPatches) {
            if (!patchId.equals(installedPatch.getPatchId())) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getProductFamilies() {
        LinkedHashSet<String> productFamilies = new LinkedHashSet<String>();
        for (DistributionInfo dist : this.getRegistry().getDistributions()) {
            if (!dist.getStatus().isInstalled()) continue;
            productFamilies.addAll(this.getProductFamilies(dist));
        }
        return productFamilies;
    }

    private List<String> getProductFamilies(DistributionInfo distributionInfo) {
        ArrayList<String> productFamilies = new ArrayList<String>();
        for (ProductFamily prodFamily : distributionInfo.getProductFamilies()) {
            productFamilies.add(prodFamily.getName());
        }
        return productFamilies;
    }

    public boolean lockInventory(boolean block, int attempts, int waitTime, boolean shared) throws IOException {
        Path p = this.getInventoryLockFile();
        if (block) {
            if (shared) {
                if (!NioFileLockService.getSharedLock((Path)p, (boolean)true)) {
                    _log.warning("Unable to obtain shared lock on Oracle Home inventory.");
                    return false;
                }
            } else if (!NioFileLockService.getFileLock((Path)p, (boolean)true)) {
                _log.warning("Unable to obtain exclusive lock on Oracle Home inventory.");
                return false;
            }
        } else if (shared) {
            if (!NioFileLockService.getSharedLockWithLimitedWait((Path)p, (int)attempts, (int)waitTime)) {
                _log.warning("Unable to obtain shared lock on Oracle Home inventory.");
                return false;
            }
        } else if (!NioFileLockService.getFileLockWithLimitedWait((Path)p, (int)attempts, (int)waitTime)) {
            _log.warning("Unable to obtain exclusive lock on Oracle Home inventory.");
            return false;
        }
        return true;
    }

    public void unlockInventory() throws IOException {
        NioFileLockService.releaseFileLock((Path)this.getInventoryLockFile());
    }

    public Path getInventoryLockFile() {
        Path f = this.getInventoryDirectoryPath().resolve(LOCKS_DIRECTORY).resolve(LOCK_FILE);
        try {
            return f.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return f.toAbsolutePath();
        }
    }

    public String toString() {
        return this._home.toString();
    }

    class ReverseEdgeFilter
    implements EdgeFilter<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>, DirectedGraph<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>>> {
        ReverseEdgeFilter() {
        }

        public List<DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> filter(DirectedGraph<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> graph, DefaultVertex<FederatedHomeWrapper> vertex, List<DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> edges) {
            if (edges != null) {
                ArrayList<DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> reverseEdges = new ArrayList<DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>>(edges);
                Collections.reverse(reverseEdges);
                return reverseEdges;
            }
            return null;
        }
    }

    class FederatedHomeVisitor
    extends VisitorAdaptor<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>, DirectedGraph<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>>> {
        protected Set<FederatedHomeWrapper> _visited;
        protected boolean _markChained;

        public FederatedHomeVisitor(PrintStream traceOut) {
            super(traceOut);
            this._visited = new LinkedHashSet<FederatedHomeWrapper>();
        }

        public Set<FederatedHomeWrapper> getVisited() {
            return this._visited;
        }

        public void clearVisited() {
            this._visited.clear();
        }

        public void setMarkChained(boolean markChained) {
            this._markChained = markChained;
        }

        public boolean preVisit(DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String> edge, DefaultVertex<FederatedHomeWrapper> vertex) {
            super.visit(edge, vertex);
            this._visited.add((FederatedHomeWrapper)vertex.getKey());
            if (this._markChained) {
                ((FederatedHomeWrapper)vertex.getKey()).setChained(true);
            }
            return true;
        }
    }

    class OrderedDirectedGraph
    extends DirectedGraph<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>, String, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> {
        public OrderedDirectedGraph(VertexFactory<FederatedHomeWrapper, DefaultVertex<FederatedHomeWrapper>> vFactory, EdgeFactory<String, DefaultVertex<FederatedHomeWrapper>, DefaultEdge<DefaultVertex<FederatedHomeWrapper>, String>> eFactory) {
            super(vFactory, eFactory);
            this._vMap = new LinkedHashMap();
            this._eMap = new LinkedHashMap();
        }
    }

    class FederatedHomeWrapper {
        Home _home;
        Path _homeDir;
        boolean _direct;
        boolean _chained;
        boolean _self;
        private boolean _incomingDirect;
        private boolean _incomingChained;

        public FederatedHomeWrapper(Home home, boolean direct, boolean self) {
            this._home = home;
            this._homeDir = home.getHomePath();
            this._direct = direct;
            this._self = self;
        }

        public Home getHome() {
            return this._home;
        }

        public Path getHomeDir() {
            return this._homeDir;
        }

        public boolean isDirect() {
            return this._direct;
        }

        public void setDirect(boolean direct) {
            this._direct = direct;
        }

        public boolean isChained() {
            return this._chained;
        }

        public void setChained(boolean chained) {
            this._chained = chained;
        }

        public boolean isIncomingDirect() {
            return this._incomingDirect;
        }

        public void setIncomingDirect(boolean incomingDirect) {
            this._incomingDirect = incomingDirect;
        }

        public boolean isIncomingChained() {
            return this._incomingChained;
        }

        public void setIncomingChained(boolean incomingChained) {
            this._incomingChained = incomingChained;
        }

        public boolean isSelf() {
            return this._self;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FederatedHomeWrapper)) {
                return false;
            }
            FederatedHomeWrapper that = (FederatedHomeWrapper)o;
            return this._homeDir.equals(that._homeDir);
        }

        public int hashCode() {
            return this._homeDir.hashCode();
        }

        public String toString() {
            return this._homeDir.toString();
        }
    }
}

