/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.carbdiff.DependentDiffHandler;
import com.oracle.cie.common.dao.tree.TreeDiffHandler;
import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.ElfDiffHelper;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.FileDiff;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.carbdiff.DefaultContentFilterer;
import com.oracle.cie.gdr.carbdiff.FileDiffResolver;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.carbdiff.handlers.ElfDiffHandler;
import com.oracle.cie.gdr.carbdiff.handlers.PropertiesDiffHandler;
import com.oracle.cie.gdr.carbdiff.handlers.TextDiffHandler;
import com.oracle.cie.gdr.dao.pad.FileType;
import com.oracle.cie.gdr.dao.pad.TextFileDiffFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ReplacementResolver
implements FileDiffResolver {
    private static Logger _log = Logger.getLogger(ReplacementResolver.class.getName());
    private File _releaseDataFile;
    private File _patchDataFile;
    private File _deltaCarbDestination;
    private Strategy _strategy;
    private TextFileDiffFilter _textFileDiffFilter;
    private Map<String, File> _baseFilteredArchives;
    private Map<String, File> _patchedFilteredArchives;
    private static JarHelper _releaseJarHelper;
    private static JarHelper _patchJarHelper;
    private static List<JarDiff.DiffHandler> _diffHandlers;
    private DiffReport _report;
    private static boolean _replacementFlag;
    private static boolean _includeParentClass;
    private static Map<File, JarDiff> _archiveCache;
    private static List<String> _includedManifest;
    private DependentDiffHandler _dependentDiffHandler;
    private List<FileTarget> _fileTargetsToDelete;

    public ReplacementResolver(File releaseCarb, File patchCarb, File deltaCarbDestination, Strategy strategy) {
        this._releaseDataFile = releaseCarb;
        this._patchDataFile = patchCarb;
        _releaseJarHelper = null;
        _patchJarHelper = null;
        this._deltaCarbDestination = deltaCarbDestination;
        this._strategy = strategy;
        _replacementFlag = strategy.isReplacement();
        _archiveCache = new HashMap<File, JarDiff>();
        this._dependentDiffHandler = new DependentDiffHandler();
        this.initializeDiffHandlers();
    }

    private void initializeDiffHandlers() {
        _diffHandlers = new ArrayList<JarDiff.DiffHandler>();
        _diffHandlers.add(new PropertiesDiffHandler(this._report));
        _diffHandlers.add((JarDiff.DiffHandler)new TreeDiffHandler(new String[]{"xml", "pom", "portlet", "xsd", "book", "xmlp", "xlf", "layout", "tld", "dependencies", "hs", "jhm", "wsdl", "os_xml", "portal", "jspx", "menu", "jpr", "shell", "theme", "laf", "jws", "tpl", "edl", "rules", "csproj", "iml", "page", "vsto", "out", "cpx", "jsf", "plist", "wsil", "esf", "xconf", "project", "vcproj", "actionScriptProperties", "mxml", "episode"}, this._report));
        if (ElfDiffHelper.getInstance().isLoaded()) {
            _log.info("Adding ElfDiffHandler");
            _diffHandlers.add(new ElfDiffHandler(ElfDiffHelper.getInstance().getExtesnions(), this._report));
        }
    }

    @Override
    public Collection<FileTarget> diffFiles(Map<String, FileTarget> releaseFileTargets, Map<String, FileTarget> patchFileTargets) throws CarbDiffException {
        ArrayList<FileTarget> diffFileTargets = new ArrayList<FileTarget>();
        ArrayList<Object> modularFileTargets = new ArrayList<Object>();
        HashMap<FileTarget, Object> helpsetFileTargets = new HashMap<FileTarget, Object>();
        try {
            Object patchFileTarget;
            for (Map.Entry<String, FileTarget> entry : patchFileTargets.entrySet()) {
                String dest = entry.getKey();
                patchFileTarget = entry.getValue();
                FileTarget fileTarget = releaseFileTargets.get(dest);
                if (((FileTarget)patchFileTarget).isForced().booleanValue() || ((FileTarget)patchFileTarget).isPatchable().booleanValue() && !((FileTarget)patchFileTarget).isDirectory() && (fileTarget == null || ReplacementResolver.isDifferent(this._releaseDataFile, fileTarget.getSource(), this._patchDataFile, ((FileTarget)patchFileTarget).getSource(), this._textFileDiffFilter, false, this._baseFilteredArchives, this._patchedFilteredArchives, this._report))) {
                    if (this._dependentDiffHandler.includeOnlyIfChanged(((FileTarget)patchFileTarget).getSource(), null)) {
                        helpsetFileTargets.put(fileTarget, patchFileTarget);
                    } else {
                        this.processDeltaEntry(fileTarget, (FileTarget)patchFileTarget);
                        if (!this.isEmpty(((FileTarget)patchFileTarget).getSource())) {
                            diffFileTargets.add((FileTarget)patchFileTarget);
                        }
                        if (_includeParentClass) {
                            modularFileTargets.add(patchFileTarget);
                        }
                    }
                }
                if (fileTarget == null) continue;
                releaseFileTargets.remove(dest);
            }
            for (FileTarget fileTarget : modularFileTargets) {
                Map<String, FileTarget> module = this.getInnerClasses(patchFileTargets.entrySet(), fileTarget, diffFileTargets);
                for (Map.Entry entry : module.entrySet()) {
                    String innerDest = (String)entry.getKey();
                    FileTarget innerPatchFileTarget = (FileTarget)entry.getValue();
                    FileTarget innerReleaseFileTarget = releaseFileTargets.get(innerDest);
                    this.processDeltaEntry(innerReleaseFileTarget, innerPatchFileTarget);
                    if (this.isEmpty(innerPatchFileTarget.getSource())) continue;
                    diffFileTargets.add(innerPatchFileTarget);
                }
            }
            if (!diffFileTargets.isEmpty()) {
                for (Map.Entry<String, FileTarget> entry : helpsetFileTargets.entrySet()) {
                    FileTarget releaseFileTarget = (FileTarget)((Object)entry.getKey());
                    patchFileTarget = entry.getValue();
                    if (!this._dependentDiffHandler.verifyDependentEntry(((FileTarget)patchFileTarget).getSource())) continue;
                    this.processDeltaEntry(releaseFileTarget, (FileTarget)patchFileTarget);
                    if (this.isEmpty(((FileTarget)patchFileTarget).getSource())) continue;
                    diffFileTargets.add((FileTarget)patchFileTarget);
                }
            }
            if (!releaseFileTargets.isEmpty()) {
                this._fileTargetsToDelete = new ArrayList<FileTarget>();
                for (FileTarget fileTarget : releaseFileTargets.values()) {
                    if (!fileTarget.isPatchable().booleanValue()) continue;
                    _log.finest(fileTarget.getDest() + " has not been found so marking as delete");
                    if (null == fileTarget.getSource()) continue;
                    FileTarget fileTarget2 = this.getFileTargetToDelete(fileTarget);
                    diffFileTargets.add(fileTarget2);
                    this._fileTargetsToDelete.add(fileTarget2);
                }
            }
        }
        catch (Exception exception) {
            throw new CarbDiffException(exception);
        }
        finally {
            ReplacementResolver.cleanup();
        }
        return diffFileTargets;
    }

    private FileTarget getFileTargetToDelete(FileTarget fileTargetToDelete) throws IOException {
        File destFile = new File(this._deltaCarbDestination, fileTargetToDelete.getDest());
        JarEntry releaseCarbJarEntry = CarbDiffUtils.getJarEntry(ReplacementResolver.getReleaseJarHelper(this._releaseDataFile), fileTargetToDelete.getSource());
        JarHelper jarHelper = ReplacementResolver.getReleaseJarHelper(this._releaseDataFile);
        jarHelper.extract(releaseCarbJarEntry, destFile);
        fileTargetToDelete.setSource(destFile.getAbsolutePath());
        fileTargetToDelete.setAction(Strategy.Delete.getXmlName());
        return fileTargetToDelete;
    }

    @Override
    public List<FileTarget> getFileTargetsToDelete() {
        return this._fileTargetsToDelete;
    }

    @Override
    public boolean hasFilesToDelete() {
        return null != this._fileTargetsToDelete && !this._fileTargetsToDelete.isEmpty();
    }

    private Map<String, FileTarget> getInnerClasses(Set<Map.Entry<String, FileTarget>> entrySet, FileTarget patchFileTarget, Collection<FileTarget> diffFileTargets) {
        HashMap<String, FileTarget> moduleFileTargets = new HashMap<String, FileTarget>();
        String parent = "";
        if (patchFileTarget.getDest().contains("$")) {
            parent = patchFileTarget.getDest().substring(0, patchFileTarget.getDest().indexOf("$"));
        } else if (parent.endsWith(".class")) {
            parent = patchFileTarget.getDest().substring(0, patchFileTarget.getDest().lastIndexOf("."));
        }
        if (!parent.isEmpty()) {
            _log.finest("Adding base class and inner classes as diff for module " + parent);
            for (Map.Entry<String, FileTarget> entry : entrySet) {
                if (!entry.getKey().startsWith(parent) || diffFileTargets.contains(entry.getValue())) continue;
                moduleFileTargets.put(entry.getKey(), entry.getValue());
            }
        }
        return moduleFileTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty(String source) throws IOException {
        if (StringUtil.isNullOrEmpty((String)source)) {
            return true;
        }
        if (!JarUtils.isArchive((File)new File(source))) {
            return false;
        }
        boolean isEmpty = true;
        try (JarHelper jarHelper = new JarHelper(source);){
            for (String entry : jarHelper.getEntries()) {
                if (jarHelper.getJarEntry(entry).isDirectory()) continue;
                if (JarUtils.isArchive((JarHelper)jarHelper, (String)entry)) {
                    File innerJar = JarUtils.extractIntoTempFile((JarHelper)jarHelper, (String)entry);
                    innerJar.deleteOnExit();
                    isEmpty = this.isEmpty(innerJar.getCanonicalPath());
                    continue;
                }
                isEmpty = false;
            }
        }
        return isEmpty;
    }

    private static JarHelper getReleaseJarHelper(File releaseJarFile) throws IOException {
        if (releaseJarFile != null && (_releaseJarHelper == null || _releaseJarHelper.getJar() == null)) {
            _releaseJarHelper = new JarHelper(releaseJarFile);
        }
        return _releaseJarHelper;
    }

    private static JarHelper getPatchJarHelper(File patchJarFile) throws IOException {
        if (patchJarFile != null && (_patchJarHelper == null || _patchJarHelper.getJar() == null)) {
            _patchJarHelper = new JarHelper(patchJarFile);
        }
        return _patchJarHelper;
    }

    private static void cleanup() {
        if (_releaseJarHelper != null) {
            _releaseJarHelper.close();
        }
        if (_patchJarHelper != null) {
            _patchJarHelper.close();
        }
    }

    public static boolean isDifferent(File releaseJar, String releaseJarEntry, File patchJar, String patchJarEntry, TextFileDiffFilter textFileDiffFilter, Map<String, File> baseFilteredArchives, Map<String, File> patchFilteredArchives, DiffReport report) throws Exception {
        return ReplacementResolver.isDifferent(releaseJar, releaseJarEntry, patchJar, patchJarEntry, textFileDiffFilter, true, baseFilteredArchives, patchFilteredArchives, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDifferent(File releaseJar, String releaseJarEntry, File patchJar, String patchJarEntry, TextFileDiffFilter textFileDiffFilter, boolean cleanup, Map<String, File> baseFilteredArchives, Map<String, File> patchedFilteredArchives, DiffReport report) throws Exception {
        File tmpRootInnerFile = null;
        File tmpDiffInnerFile = null;
        boolean isDifferent = false;
        boolean isHandled = false;
        DefaultContentFilterer fileDiffFilterer = null;
        if (textFileDiffFilter != null) {
            fileDiffFilterer = new DefaultContentFilterer(textFileDiffFilter);
        }
        JarHelper releaseCarbHelper = ReplacementResolver.getReleaseJarHelper(releaseJar);
        JarHelper patchCarbHelper = ReplacementResolver.getPatchJarHelper(patchJar);
        JarEntry releaseCarbJarEntry = CarbDiffUtils.getJarEntry(releaseCarbHelper, releaseJarEntry);
        JarEntry patchCarbJarEntry = CarbDiffUtils.getJarEntry(patchCarbHelper, patchJarEntry);
        for (JarDiff.DiffHandler diffHandler : _diffHandlers) {
            if (!diffHandler.isHandled(patchJar, patchJarEntry) || isHandled) continue;
            isHandled = true;
            try {
                tmpRootInnerFile = JarUtils.extractIntoTempFile((JarHelper)releaseCarbHelper, (String)releaseJarEntry);
                tmpDiffInnerFile = JarUtils.extractIntoTempFile((JarHelper)patchCarbHelper, (String)patchJarEntry);
                if (fileDiffFilterer != null && fileDiffFilterer.canFilter(patchJarEntry)) {
                    tmpRootInnerFile = fileDiffFilterer.filterPattern(tmpRootInnerFile, patchJarEntry);
                    tmpDiffInnerFile = fileDiffFilterer.filterPattern(tmpDiffInnerFile, patchJarEntry);
                }
                isDifferent = diffHandler.diff(patchJarEntry, tmpRootInnerFile, tmpDiffInnerFile);
            }
            catch (Exception e) {
                _log.warning("Failed to compare file " + releaseJarEntry + " changing to default byte compare. " + e);
                isHandled = false;
            }
            finally {
                if (tmpRootInnerFile != null) {
                    tmpRootInnerFile.deleteOnExit();
                }
                if (tmpDiffInnerFile == null) continue;
                tmpDiffInnerFile.deleteOnExit();
            }
        }
        if (!isHandled) {
            if (JarUtils.isArchive((JarHelper)patchCarbHelper, (String)patchJarEntry)) {
                isHandled = true;
                try {
                    if (baseFilteredArchives != null && baseFilteredArchives.containsKey(releaseJarEntry) && patchedFilteredArchives != null && patchedFilteredArchives.containsKey(patchJarEntry)) {
                        tmpRootInnerFile = baseFilteredArchives.get(releaseJarEntry);
                        tmpDiffInnerFile = patchedFilteredArchives.get(patchJarEntry);
                    } else {
                        tmpRootInnerFile = JarUtils.extractIntoTempFile((JarHelper)releaseCarbHelper, (String)releaseCarbJarEntry.getName());
                        tmpDiffInnerFile = JarUtils.extractIntoTempFile((JarHelper)patchCarbHelper, (String)patchCarbJarEntry.getName());
                    }
                    JarDiff jarDiff = new JarDiff(tmpRootInnerFile, _diffHandlers, (JarDiff.FileContentFilterer)fileDiffFilterer, report);
                    _log.finest("Comparing jar " + releaseJarEntry);
                    jarDiff.setIncludeParentClass(_includeParentClass);
                    jarDiff.setReplacementFlag(_replacementFlag);
                    if (_includedManifest != null && !_includedManifest.isEmpty()) {
                        if (_includedManifest.contains(patchJarEntry)) {
                            jarDiff.setIncludeManifest(true);
                        }
                        if (_includedManifest.contains(patchJarEntry + "!")) {
                            jarDiff.setRootJarEntry(patchJarEntry);
                            jarDiff.setIncludedManifest(_includedManifest);
                        }
                    }
                    jarDiff.diff(new File[]{tmpDiffInnerFile});
                    isDifferent = jarDiff.isEntriesDiff();
                    if (isDifferent) {
                        _archiveCache.put(tmpRootInnerFile, jarDiff);
                    }
                }
                finally {
                    if (tmpRootInnerFile != null) {
                        tmpRootInnerFile.deleteOnExit();
                    }
                    if (tmpDiffInnerFile != null) {
                        tmpDiffInnerFile.deleteOnExit();
                    }
                }
            }
            if (!isHandled) {
                if (textFileDiffFilter != null && fileDiffFilterer.canFilter(patchJarEntry)) {
                    File originalBase = JarUtils.extractIntoTempFile((JarHelper)releaseCarbHelper, (String)releaseJarEntry);
                    File originalPatch = JarUtils.extractIntoTempFile((JarHelper)patchCarbHelper, (String)patchJarEntry);
                    originalBase.deleteOnExit();
                    originalPatch.deleteOnExit();
                    tmpRootInnerFile = fileDiffFilterer.filterPattern(originalBase, patchJarEntry);
                    tmpDiffInnerFile = fileDiffFilterer.filterPattern(originalPatch, patchJarEntry);
                    isDifferent = !FileUtils.areFilesEqual((File)tmpRootInnerFile, (File)tmpDiffInnerFile);
                    isHandled = true;
                }
                try {
                    if (patchCarbJarEntry != null && releaseCarbJarEntry != null) {
                        isDifferent = releaseCarbJarEntry.getSize() != patchCarbJarEntry.getSize() ? true : CarbDiffUtils.hasDifferentBytes(releaseCarbHelper.getInputStream(releaseCarbJarEntry.getName()), patchCarbHelper.getInputStream(patchCarbJarEntry.getName()));
                    } else if (patchCarbJarEntry != null || releaseCarbJarEntry != null) {
                        isDifferent = true;
                    }
                }
                finally {
                    if (cleanup) {
                        ReplacementResolver.cleanup();
                    }
                }
            }
            if (isDifferent && null != report) {
                if (patchCarbJarEntry != null && releaseCarbJarEntry != null) {
                    File baseFile = JarUtils.extractIntoTempFile((JarHelper)releaseCarbHelper, (String)releaseCarbJarEntry.getName());
                    File patchFile = JarUtils.extractIntoTempFile((JarHelper)patchCarbHelper, (String)patchCarbJarEntry.getName());
                    baseFile.deleteOnExit();
                    patchFile.deleteOnExit();
                    report.addDiff(patchCarbJarEntry.getName(), FileDiff.diff((File)baseFile, (File)patchFile, (boolean)report.getShowBinaryDiff()), null);
                } else if (patchCarbJarEntry != null) {
                    report.addDiff(patchCarbJarEntry.getName(), "Entry " + patchCarbJarEntry.getName() + " was not found at base carb.", null);
                } else {
                    report.addDiff(releaseCarbJarEntry.getName(), "Entry " + releaseCarbJarEntry.getName() + " was not found at patch carb.", null);
                }
            }
        }
        return isDifferent;
    }

    @Override
    public void setIncludedManifest(List<String> includedManifest) {
        _includedManifest = includedManifest;
    }

    private void processDeltaEntry(FileTarget releaseFileTarget, FileTarget patchFileTarget) throws CarbDiffException {
        File destFile = null;
        try {
            Strategy strategy;
            destFile = new File(this._deltaCarbDestination, patchFileTarget.getDest());
            if (destFile.exists()) {
                destFile = File.createTempFile(destFile.getName(), ".dup", destFile.getParentFile());
            }
            if ((strategy = this._strategy).isInjection() && this.switchToReplacement(releaseFileTarget, patchFileTarget)) {
                strategy = Strategy.Replacement;
            }
            if (strategy.isInjection()) {
                if (releaseFileTarget != null && (JarUtils.isArchive((JarHelper)ReplacementResolver.getPatchJarHelper(this._patchDataFile), (String)patchFileTarget.getSource()) || JarUtils.isArchive((JarHelper)ReplacementResolver.getPatchJarHelper(this._patchDataFile), (String)patchFileTarget.getSource()) && patchFileTarget != null && patchFileTarget.getAction() != null && patchFileTarget.getAction().equals(strategy.getXmlName()))) {
                    File tmpBaseInnerJar = null;
                    File tmpDiffInnerJar = null;
                    if (this._baseFilteredArchives != null && this._baseFilteredArchives.containsKey(releaseFileTarget.getSource()) && this._patchedFilteredArchives != null && this._patchedFilteredArchives.containsKey(patchFileTarget.getSource())) {
                        tmpBaseInnerJar = this._baseFilteredArchives.get(releaseFileTarget.getSource());
                        tmpDiffInnerJar = this._patchedFilteredArchives.get(patchFileTarget.getSource());
                    } else {
                        JarEntry releaseCarbJarEntry = CarbDiffUtils.getJarEntry(ReplacementResolver.getReleaseJarHelper(this._releaseDataFile), releaseFileTarget.getSource());
                        JarEntry patchCarbJarEntry = CarbDiffUtils.getJarEntry(ReplacementResolver.getPatchJarHelper(this._patchDataFile), patchFileTarget.getSource());
                        tmpBaseInnerJar = JarUtils.extractIntoTempFile((JarHelper)ReplacementResolver.getReleaseJarHelper(this._releaseDataFile), (String)releaseCarbJarEntry.getName());
                        tmpDiffInnerJar = JarUtils.extractIntoTempFile((JarHelper)ReplacementResolver.getPatchJarHelper(this._patchDataFile), (String)patchCarbJarEntry.getName());
                        if (tmpBaseInnerJar != null) {
                            tmpBaseInnerJar.deleteOnExit();
                        }
                        if (tmpDiffInnerJar != null) {
                            tmpDiffInnerJar.deleteOnExit();
                        }
                    }
                    JarDiff jarDiff = _archiveCache.get(tmpBaseInnerJar);
                    if (jarDiff == null) {
                        jarDiff = new JarDiff(tmpBaseInnerJar, _diffHandlers, null, null);
                        jarDiff.setIncludeParentClass(_includeParentClass);
                        if (_includedManifest != null && !_includedManifest.isEmpty() && (_includedManifest.contains(patchFileTarget.getDest()) || _includedManifest.contains(patchFileTarget.getDest() + "!"))) {
                            jarDiff.setIncludeManifest(true);
                        }
                        jarDiff.diff(new File[]{tmpDiffInnerJar});
                    }
                    if (jarDiff.isEntriesDiff()) {
                        _log.finer("Entry " + patchFileTarget.getSource() + " is an archive, obtaining sparse jar.");
                        strategy = Strategy.Injection;
                        if (jarDiff.isCompleteReplacement() || jarDiff.isSignedJar()) {
                            strategy = Strategy.Replacement;
                        } else {
                            Map innerJars = jarDiff.createDeltaJar(destFile);
                            List entries = JarUtils.getJarEntries((File)((File)innerJars.get(tmpDiffInnerJar)), null);
                            if (entries == null || entries.isEmpty()) {
                                _log.fine("Archive " + tmpDiffInnerJar.getPath() + " does not have some entries in base archive.");
                                patchFileTarget.setSource(null);
                            } else {
                                if (!((File)innerJars.get(tmpDiffInnerJar)).renameTo(destFile)) {
                                    FileCopy.copy((File)((File)innerJars.get(tmpDiffInnerJar)), (File)destFile);
                                }
                                patchFileTarget.setSource(destFile.getAbsolutePath());
                            }
                        }
                    }
                } else if (releaseFileTarget != null || !JarUtils.isArchive((JarHelper)ReplacementResolver.getPatchJarHelper(this._patchDataFile), (String)patchFileTarget.getSource()) || !JarUtils.isArchive((JarHelper)ReplacementResolver.getReleaseJarHelper(this._releaseDataFile), (String)patchFileTarget.getSource())) {
                    strategy = Strategy.Replacement;
                }
            }
            if (strategy.isReplacement() || strategy.isReplacementInUse() || releaseFileTarget == null && JarUtils.isArchive((JarHelper)ReplacementResolver.getPatchJarHelper(this._patchDataFile), (String)patchFileTarget.getSource()) && JarUtils.isArchive((JarHelper)ReplacementResolver.getReleaseJarHelper(this._releaseDataFile), (String)patchFileTarget.getSource())) {
                _log.finest("Entry " + patchFileTarget.getDest() + " has changed so marking as replacement.");
                JarHelper patchJarHelper = ReplacementResolver.getPatchJarHelper(this._patchDataFile);
                if (this._patchedFilteredArchives != null && this._patchedFilteredArchives.containsKey(patchFileTarget.getDest())) {
                    FileCopy.copy((File)this._patchedFilteredArchives.get(patchFileTarget.getDest()), (File)destFile);
                } else {
                    JarEntry sourcePatch = CarbDiffUtils.getJarEntry(patchJarHelper, patchFileTarget.getSource());
                    if (sourcePatch != null) {
                        patchJarHelper.extract(sourcePatch, destFile);
                    }
                }
                patchFileTarget.setSource(destFile.getAbsolutePath());
            }
            _log.finest("Entry " + patchFileTarget.getDest() + " is different.");
            patchFileTarget.setAction(strategy.getXmlName());
        }
        catch (Exception anyException) {
            throw new CarbDiffException(anyException);
        }
        finally {
            destFile.deleteOnExit();
        }
    }

    @Override
    public void setReleaseDataFile(File releaseDataFile) {
        this._releaseDataFile = releaseDataFile;
    }

    @Override
    public void setPatchDataFile(File carbDataFile) {
        this._patchDataFile = carbDataFile;
    }

    @Override
    public void setTextFileDiffFilter(TextFileDiffFilter textFileDiffFilter) {
        TextDiffHandler textDiffHandler = new TextDiffHandler(this._report);
        if (textFileDiffFilter != null) {
            this._textFileDiffFilter = textFileDiffFilter;
            for (FileType fileType : this._textFileDiffFilter.getFileTypes()) {
                textDiffHandler.addTypePattern(fileType.getExtension(), Pattern.compile(fileType.getRegex()));
            }
        }
        _diffHandlers.add(textDiffHandler);
    }

    @Override
    public void setBaseFilteredArchives(Map<String, File> filteredArchives) {
        this._baseFilteredArchives = filteredArchives;
    }

    @Override
    public void setPatchedFilteredArchives(Map<String, File> filteredArchives) {
        this._patchedFilteredArchives = filteredArchives;
    }

    @Override
    public void setDiffReport(DiffReport report) {
        this._report = report;
        for (JarDiff.DiffHandler diffHandler : _diffHandlers) {
            diffHandler.setDiffReport(this._report);
        }
    }

    @Override
    public void setIncludeParentClass(boolean includeParentClass) {
        _includeParentClass = includeParentClass;
    }

    public boolean switchToReplacement(FileTarget releaseFileTarget, FileTarget patchFileTarget) throws IllegalArgumentException, IOException {
        boolean isRequired = false;
        if (patchFileTarget.isForced().booleanValue()) {
            isRequired = true;
        } else if (releaseFileTarget == null && patchFileTarget != null && !patchFileTarget.getSource().equals(patchFileTarget.getDest()) && JarUtils.isArchive((JarHelper)ReplacementResolver.getPatchJarHelper(this._releaseDataFile), (String)patchFileTarget.getSource())) {
            isRequired = true;
        }
        return isRequired;
    }

    static {
        _includeParentClass = true;
    }
}

