/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.common;

import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class NLS {
    private static final Logger _logger = Logger.getLogger(NLS.class.getName());
    public static final String GDR_NAMESPACE = "gdr";
    public static final String GDR_BUNDLE = "resources/gdr/gdr";
    public static final String GDR_PUBLISHED_BUNDLE = "resources/gdr/messages";
    public static final String GDR_MESSAGE_PREFIX = "GDR";

    public static String getString(String key) {
        return ResourceBundleManager.getString((String)GDR_NAMESPACE, (String)key);
    }

    public static String getMsg(String key, String ... args) {
        return NLS.getLocalizedString(key, args);
    }

    public static String getLocalizedString(String key, Object ... messageFormatting) {
        String message = NLS.getString(key);
        if (StringUtil.isNullOrEmpty((String)message)) {
            _logger.severe("Missing message key: " + key);
            message = key;
        }
        if (message != null && messageFormatting != null && messageFormatting.length > 0) {
            message = MessageFormat.format(message, messageFormatting);
        }
        return message;
    }

    public static String getPublishedMessage(String code, Object ... messageFormatting) {
        PublishedMessage publishedMessage = ResourceBundleManager.getPublishedMessage((String)GDR_NAMESPACE, (String)code, (Object[])messageFormatting);
        if (publishedMessage == null) {
            if (code != null && StringUtil.isPositiveInteger((String)code)) {
                return "GDR-" + code;
            }
            return code;
        }
        return publishedMessage.getFullMessage();
    }

    static {
        ResourceBundleManager.manageBundle((String)GDR_NAMESPACE, (String)GDR_BUNDLE);
        ResourceBundleManager.manageBundle((String)GDR_NAMESPACE, (String)GDR_PUBLISHED_BUNDLE);
        ResourceBundleManager.setPrefix((String)GDR_NAMESPACE, (String)GDR_MESSAGE_PREFIX);
    }
}

