/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cmn;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.ResourceBundle;

public class ResourceBundleInfo {
    private Path _resourceLocation;
    private Artifact _resourceArtifact;
    private String _name;
    private String _version;
    private GdrHelper _helper;

    public ResourceBundleInfo(File resourceLocation, String name, String version, GdrHelper helper) {
        this(NioHelper.getInstance().getPath(resourceLocation), name, version, helper);
    }

    public ResourceBundleInfo(Path resourceLocation, String name, String version, GdrHelper helper) {
        this._resourceLocation = resourceLocation;
        this._name = name;
        this._version = version;
        this._helper = helper;
    }

    public File getResourceLocation() {
        return this._resourceLocation != null ? this._resourceLocation.toFile() : null;
    }

    public Path getResourceLocationPath() {
        return this._resourceLocation;
    }

    public Artifact getResourceArtifact() {
        return this._resourceArtifact;
    }

    public void setResourceArtifact(Artifact resourceArtifact) {
        this._resourceArtifact = resourceArtifact;
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    public String getLocalizedString(String key) {
        ResourceBundle resourceBundle;
        String value = null;
        if (!StringUtil.isNullOrEmpty((String)key, (boolean)true) && (resourceBundle = this.getResourceBundle()) != null) {
            value = resourceBundle.getString(key);
        }
        return value;
    }

    public static String getLocalizedString(ResourceBundleInfo rbi, String key, String defaultValue) {
        String value = null;
        if (rbi != null) {
            value = rbi.getLocalizedString(key);
        }
        if (value == null) {
            value = defaultValue != null ? defaultValue : "";
        }
        return value;
    }

    public ResourceBundle getResourceBundle() {
        return this._helper.loadResourceBundle(this.getResourceLocationPath(), this.getName(), this.getVersion());
    }

    public void destroy() {
        this._resourceLocation = null;
        this._resourceArtifact = null;
    }
}

