/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.File;
import com.oracle.cie.gdr.dao.cpd.FileModifier;
import com.oracle.cie.gdr.dao.cpd.Mapping;
import com.oracle.cie.gdr.dao.cpd.Rule;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.RepositoryArtifact;
import java.util.List;

public class RepoFile
extends AbstractDataHandlerWrapper
implements RepositoryArtifact,
Mapping {
    public RepoFile(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public RepoFile() {
        super(ComponentHelper.getInstance().create("repo-file"));
    }

    @Override
    public String getGroup() {
        return this.getStringAttribute("group");
    }

    @Override
    public void setGroup(String group) {
        this.setAttribute("group", group);
    }

    @Override
    public String getArtifact() {
        return this.getStringAttribute("artifact");
    }

    @Override
    public void setArtifact(String artifact) {
        this.setAttribute("artifact", artifact);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    @Override
    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    @Override
    public boolean isIgnoreVersionKeywords() {
        return this.getBooleanAttribute("ignore-version-keywords");
    }

    @Override
    public void setIgnoreVersionKeywords(boolean ignore) {
        this.setAttribute("ignore-version-keywords", ignore);
    }

    @Override
    public String getBaseVersion() {
        return this.getStringAttribute("baseVersion");
    }

    @Override
    public void setBaseVersion(String version) {
        this.setAttribute("baseVersion", version);
    }

    @Override
    public String getClassifier() {
        String classifier = this.getStringAttribute("classifier");
        if (classifier != null && classifier.trim().length() < 1) {
            classifier = null;
        }
        return classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this.setAttribute("classifier", classifier);
    }

    @Override
    public String getType() {
        String type = this.getStringAttribute("type");
        if (type != null && type.trim().length() < 1) {
            type = null;
        }
        return type;
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public String getSource() {
        return this.getStringAttribute("source");
    }

    @Override
    public void setSource(String source) {
        this.setAttribute("source", source);
    }

    @Override
    public String getDest() {
        return this.getStringAttribute("dest");
    }

    @Override
    public void setDest(String dest) {
        this.setAttribute("dest", dest);
    }

    @Override
    public String getId() {
        return this.getStringAttribute("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public String getOsFamily() {
        return this.getStringAttribute("os-family");
    }

    public void setOsFamily(String osFamily) {
        this.setAttribute("os-family", osFamily);
    }

    public List<FileModifier> getModifiers() {
        return this.getComplexValueWrappedList("modifier", FileModifier.class);
    }

    public void setModifiers(List<FileModifier> modifiers) {
        this.setComplexValueWrappedList("modifier", modifiers);
    }

    public String getMode() {
        return this.getStringAttribute("mode");
    }

    public void setMode(String mode) {
        this.setAttribute("mode", mode);
    }

    public List<Rule> getRules() {
        return this.getComplexValueWrappedList("rule", Rule.class);
    }

    public void setRules(List<Rule> rules) {
        this.setComplexValueWrappedList("rule", rules);
    }

    public String getDestDir() {
        return this.getStringAttribute("dest-dir");
    }

    public void setDestDir(String destDir) {
        this.setAttribute("dest-dir", destDir);
    }

    public File createFile() {
        List<Rule> rules;
        List<FileModifier> modifiers;
        File file = new File();
        String tmpStr = this.getDest();
        if (tmpStr != null) {
            String destDir = this.getDestDir();
            if (!StringUtil.isNullOrEmpty((String)destDir, (boolean)true)) {
                tmpStr = destDir + "/" + tmpStr;
            }
            file.setDest(tmpStr);
        }
        if ((tmpStr = this.getSource()) != null) {
            file.setSource(tmpStr);
        }
        if ((tmpStr = this.getId()) != null) {
            file.setId(tmpStr);
        }
        if ((tmpStr = this.getMode()) != null) {
            file.setMode(tmpStr);
        }
        if ((tmpStr = this.getOsFamily()) != null) {
            file.setOsFamily(tmpStr);
        }
        if ((tmpStr = this.getGroup()) != null) {
            file.setGroup(tmpStr);
        }
        if ((tmpStr = this.getArtifact()) != null) {
            file.setArtifact(tmpStr);
        }
        if ((tmpStr = this.getVersion()) != null) {
            file.setVersion(tmpStr);
        }
        if ((tmpStr = this.getBaseVersion()) != null) {
            file.setBaseVersion(tmpStr);
        }
        if ((tmpStr = this.getType()) != null) {
            file.setType(tmpStr);
        }
        if ((tmpStr = this.getClassifier()) != null) {
            file.setClassifier(tmpStr);
        }
        if ((modifiers = this.getModifiers()) != null && !modifiers.isEmpty()) {
            file.setModifiers(modifiers);
        }
        if ((rules = this.getRules()) != null && !rules.isEmpty()) {
            file.setRules(rules);
        }
        return file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !RepoFile.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        RepoFile file = (RepoFile)o;
        String thisDest = this.getDest();
        String thatDest = file.getDest();
        String thisDestDir = this.getDestDir();
        String thatDesDir = file.getDestDir();
        if (thisDest != null ? !thisDest.equals(thatDest) : thatDest != null) {
            return false;
        }
        return !(thisDestDir != null ? !thisDestDir.equals(thatDesDir) : thatDesDir != null);
    }

    public int hashCode() {
        String dest = this.getDest();
        return dest != null ? dest.hashCode() : 0;
    }

    public Boolean getPatchable() {
        return (Boolean)this.getDataHandler().getAttributeValue("patchable");
    }

    public void setPatchable(boolean patchable) {
        this.setAttribute("patchable", patchable);
    }
}

