/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.rgy.BaseInfo;
import com.oracle.cie.gdr.dao.rgy.BaseInfoImpl;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.selection.Status;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BaseInfoReference
extends Reference
implements BaseInfo {
    private BaseInfo _baseInfo;

    public BaseInfoReference(IDataHandler dataHandler) {
        super(dataHandler);
        this._baseInfo = new BaseInfoImpl(dataHandler);
    }

    public BaseInfoReference(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("base-info-reference"));
    }

    public BaseInfoReference(ClassLoader classLoader, String name, String version) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
    }

    @Override
    public Status getStatus() {
        return this._baseInfo.getStatus();
    }

    @Override
    public void setStatus(Status status) {
        this._baseInfo.setStatus(status);
    }

    @Override
    public List<SessionInfo> getSessions() {
        return this._baseInfo.getSessions();
    }

    @Override
    public void setSessions(List<SessionInfo> sessions) {
        this._baseInfo.setSessions(sessions);
    }

    public List<SessionInfo> getSortedSessions() {
        List<SessionInfo> sessions = this._baseInfo.getSessions();
        Collections.sort(sessions, new Comparator<SessionInfo>(){

            @Override
            public int compare(SessionInfo o1, SessionInfo o2) {
                return o1.getId() - o2.getId();
            }
        });
        return sessions;
    }

    @Override
    public void addSession(SessionInfo session) {
        this._baseInfo.addSession(session);
    }

    @Override
    public void addSession(SessionInfo session, boolean copySession) {
        this._baseInfo.addSession(session, copySession);
    }

    @Override
    public boolean isDynamic() {
        return this._baseInfo.isDynamic();
    }

    @Override
    public void setDynamic(boolean dynamic) {
        this._baseInfo.setDynamic(dynamic);
    }

    public String getOriginalVersion() {
        String version = this.getStringAttribute("original-version");
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            version = this.getVersion();
        }
        return version;
    }

    public void setOriginalVersion(String version) {
        this.setAttribute("original-version", version);
    }

    public boolean isOriginalVersionSet() {
        String version = this.getStringAttribute("original-version");
        return !StringUtil.isNullOrEmpty((String)version, (boolean)true);
    }
}

