/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.SelectionTarget;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.deinstallation.DeInstallerShutdownHook;
import com.oracle.cie.gdr.dependency.FeatureSelectionConflictException;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.InstallerSession;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.installation.ComponentArchiveInstallationSession;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.installation.InstallationValidator;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureArchiveInstallationSession
extends InstallationSession
implements InstallerSession {
    private static final Logger _log = Logger.getLogger(FeatureArchiveInstallationSession.class.getName());
    private DirectoryMap _directoryMap;
    private DirectoryMap _mergedDirectoryMap;
    private FeatureLoader _featureLoader;
    private InstallerDistributionInfo _installerDistributionInfo;
    private ComponentLoader _componentLoader;
    private Map<FeatureSet, Set<DistributionTarget>> _featureToDistributionsMap;
    private Map<DistributionTarget, Set<FeatureSet>> _distributionToFeaturesMap;
    private File _tempDir;
    private boolean _force;

    public FeatureArchiveInstallationSession(File featureArchive, File homeDir, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo) throws GdrException, IOException, DataHandlerException {
        this(featureArchive, homeDir, directoryMap, platforms, locales, installerInfo, false);
    }

    public FeatureArchiveInstallationSession(File featureArchive, File homeDir, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo, boolean force) throws GdrException, IOException, DataHandlerException {
        super(FeatureArchiveInstallationSession.getMetaDataHome(NioHelper.getInstance().getPath(featureArchive)), homeDir, platforms, locales);
        this._directoryMap = directoryMap;
        this.setInstallerInfo(installerInfo);
        if (force) {
            _log.warning("Forced feature archive installation is enabled. Please note that forced installations are meant for private internal consumption only. Use of the force option when installing into an official home will not be supported.");
        }
        this._force = force;
        this.init();
        this.loadMetaData();
    }

    public FeatureArchiveInstallationSession(Path featureArchive, Path homeDir, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo, boolean force) throws GdrException, IOException, DataHandlerException {
        super(FeatureArchiveInstallationSession.getMetaDataHome(featureArchive), homeDir, platforms, locales);
        this._directoryMap = directoryMap;
        this.setInstallerInfo(installerInfo);
        if (force) {
            _log.warning("Forced feature archive installation is enabled. Please note that forced installations are meant for private internal consumption only. Use of the force option when installing into an official home will not be supported.");
        }
        this._force = force;
        this.init();
        this.loadMetaData();
    }

    @Override
    public void setHome(Home home) throws GdrException {
        super.setHome(home);
        this.loadMetaData();
    }

    public boolean isForce() {
        return this._force;
    }

    protected void loadMetaData() throws GdrException {
        Home home = this.getHome();
        if (home != null) {
            try {
                this._featureToDistributionsMap = new LinkedHashMap<FeatureSet, Set<DistributionTarget>>();
                Collection<DistributionTarget> distTargets = this.getHome().getInstalledDistributions();
                FeatureSelectionTarget featureSelectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(this._featureLoader.getFeatureSets(), this.getHome().getInstalledFeatures());
                for (FeatureSet featureSet : new LinkedHashSet<FeatureSet>(this._featureLoader.getFeatureSets())) {
                    featureSelectionTarget.unselectAll();
                    try {
                        featureSelectionTarget.selectWithPrerequisites(featureSet, true);
                        List directDependencies = featureSelectionTarget.getDirectDependencies(featureSet);
                        for (FeatureSet directDependency : directDependencies) {
                            for (DistributionTarget target : distTargets) {
                                Set<FeatureSet> installedFeatures = target.getInstalledFeatureSets();
                                if (!installedFeatures.contains(directDependency)) continue;
                                Set<DistributionTarget> distributions = this._featureToDistributionsMap.get(featureSet);
                                if (distributions == null) {
                                    distributions = new LinkedHashSet<DistributionTarget>();
                                    this._featureToDistributionsMap.put(featureSet, distributions);
                                }
                                distributions.add(target);
                            }
                        }
                    }
                    catch (FeatureSelectionConflictException e) {
                        if (this.isForce()) {
                            this.createDummyDistribution(featureSet);
                            continue;
                        }
                        throw new GdrException("Unable to locate dependency for feature archive's feature set " + featureSet, (Throwable)((Object)e));
                    }
                    catch (DependencyException e) {
                        if (this.isForce()) {
                            this.createDummyDistribution(featureSet);
                            continue;
                        }
                        if (e.getType().equals((Object)SelectionTarget.ErrorType.ALREADY_INSTALLED)) {
                            throw new GdrException("Feature archive's feature set " + featureSet + " is already installed. " + e.getMessage(), (Throwable)e);
                        }
                        throw new GdrException("Unable to resolve dependency for feature archive's feature set " + featureSet + ". " + e.getMessage(), (Throwable)e);
                    }
                }
                this.getDistributionToFeatureSetMap();
                if (this._directoryMap != null) {
                    this._mergedDirectoryMap = DistributionHelper.getInstance().mergeDirectoryMaps(this.getDistributions(), this._directoryMap);
                }
                this._installerDistributionInfo = InstallerInfoHelper.getInstance().getInstallerDistributionInfo(this.getInstallerInfo());
                this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.INSTALL, this.getFeatureLoader().getFeatureSets(), this.getDirectoryMap(), this.getInstallerDistributionInfo(), null);
                this.setInstallationStates(this._componentLoader.getComponentsMap());
            }
            catch (GdrException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        } else {
            this._featureToDistributionsMap = null;
            this._mergedDirectoryMap = null;
            this._installerDistributionInfo = null;
            this._componentLoader = null;
        }
    }

    private void createDummyDistribution(FeatureSet featureSet) throws GdrException {
        DistributionTarget dummyDistribution = null;
        if (this._directoryMap == null) {
            throw new GdrException("When forcing a feature archive installation the directory map must be provided.");
        }
        LinkedHashSet<DistributionTarget> distributions = new LinkedHashSet<DistributionTarget>();
        this._featureToDistributionsMap.put(featureSet, distributions);
        if (dummyDistribution == null) {
            HashSet<FeatureSet> dummyFeatures = new HashSet<FeatureSet>();
            FeatureSet dummyFeature = ComponentArchiveInstallationSession.getDummyFeatureSet(this.getHome(), new HashSet<Reference>());
            dummyFeatures.add(dummyFeature);
            dummyDistribution = new DistributionTarget(ComponentArchiveInstallationSession.getDummyDistribution(this.getHome(), dummyFeatures, this._directoryMap), dummyFeatures);
            this.getFeatureLoader().addFeatureSet(dummyFeature);
            this._featureToDistributionsMap.put(dummyFeature, distributions);
        }
        distributions.add(dummyDistribution);
    }

    private static MetaDataHome getMetaDataHome(Path featureArchive) throws GdrException, IOException {
        if (featureArchive == null) {
            throw new GdrException("The feature archive specified was null.");
        }
        if (!Files.exists(featureArchive, new LinkOption[0]) || !Files.isRegularFile(featureArchive, new LinkOption[0])) {
            throw new GdrException("The feature archive specified did not exist or was not a file.");
        }
        return new MetaDataHome(featureArchive, false, true);
    }

    public void prepareFeatureArchiveForInstallation() throws GdrException, IOException {
        Set<Component> components = this.getComponentLoader().getComponents();
        if (components.iterator().next().isCarb()) {
            return;
        }
        if (this._tempDir == null) {
            File scratchFile = null;
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            if (!StringUtil.isNullOrEmpty((String)scratchPath)) {
                scratchFile = new File(scratchPath);
            }
            this._tempDir = TempFileHandler.getTempFolder((String)"feature_archive-", null, (boolean)false, (File)scratchFile);
            DeInstallerShutdownHook.add(this._tempDir);
            ComponentArchiveUtils.extractArchive(this.getMetaDataHome().getGdrMetaDataHome(), this._tempDir);
        }
        File stageDir = ComponentHelper.getStageDir(ComponentHelper.getInstallDir(this._tempDir));
        for (Component component : components) {
            File archiveDir = ComponentHelper.getInstance().getComponentArchiveDir(stageDir, component.getName(), component.getVersion());
            component.setArchiveLocation(archiveDir);
            Collection<ComponentTarget> componentTargets = component.getComponentTargets();
            if (componentTargets == null || componentTargets.isEmpty()) continue;
            for (ComponentTarget componentTarget : componentTargets) {
                componentTarget.setArchiveLocation(archiveDir);
                componentTarget.setSourceFile((Path)null);
            }
        }
    }

    @Override
    public InstallerDistributionInfo getInstallerDistributionInfo() {
        return this._installerDistributionInfo;
    }

    public FeatureLoader getFeatureLoader() {
        return this._featureLoader;
    }

    @Override
    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getFeatureLoader().getFeatureSets();
    }

    @Override
    public DirectoryMap getDirectoryMap() {
        return this._mergedDirectoryMap == null ? this._directoryMap : this._mergedDirectoryMap;
    }

    protected void init() throws GdrException, IOException, DataHandlerException {
        this._featureLoader = new FeatureLoader(this.getMetaDataHome());
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featureLoader.getFeatureSets().size() + " feature sets.");
        }
    }

    @Override
    public void validateInstallation() throws DependencyException, GdrException {
        super.validateInstallation();
        if (!this.isForce()) {
            Map<DistributionTarget, Set<FeatureSet>> distMap = this.getDistributionToFeatureSetMap();
            for (DistributionTarget target : distMap.keySet()) {
                InstallationValidator.validate(target, this.getDistributionInfo(), distMap.get(target), this.getComponentLoader(), this.getDirectoryMap(), this.getHome());
            }
        }
    }

    public Set<DistributionTarget> getDistributions(FeatureSet featureSet) {
        return this._featureToDistributionsMap.get(featureSet);
    }

    public Map<DistributionTarget, Set<FeatureSet>> getDistributionToFeatureSetMap() throws GdrException {
        if (this._distributionToFeaturesMap == null) {
            this._distributionToFeaturesMap = new LinkedHashMap<DistributionTarget, Set<FeatureSet>>();
            for (FeatureSet selectedFeature : this.getFeatureLoader().getFeatureSets()) {
                Set<DistributionTarget> distributions = this.getDistributions(selectedFeature);
                if (distributions != null && !distributions.isEmpty()) {
                    for (DistributionTarget target : distributions) {
                        Set<FeatureSet> distFeatures = this._distributionToFeaturesMap.get(target);
                        if (distFeatures == null) {
                            distFeatures = new LinkedHashSet<FeatureSet>();
                            this._distributionToFeaturesMap.put(target, distFeatures);
                        }
                        distFeatures.add(selectedFeature);
                    }
                    continue;
                }
                throw new GdrException("Failed to locate distribution which is compatible with " + selectedFeature + " in home directory " + this.getHomeDir());
            }
        }
        return this._distributionToFeaturesMap;
    }

    public Set<Distribution> getDistributions() {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        for (Set<DistributionTarget> targets : this._featureToDistributionsMap.values()) {
            for (DistributionTarget target : targets) {
                distributions.add(target.getDistribution());
            }
        }
        return distributions;
    }

    @Override
    public DistributionTarget getDistributionTarget() {
        for (Set<DistributionTarget> targets : this._featureToDistributionsMap.values()) {
            Iterator<DistributionTarget> iterator = targets.iterator();
            if (!iterator.hasNext()) continue;
            DistributionTarget target = iterator.next();
            return target;
        }
        return null;
    }

    @Override
    public void reload() {
    }
}

