/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class HK2Generator {
    private static ClassLoader _loader;
    private static final Logger _log;
    private static final String _sharedLibCompName = "oracle.wls.jrf.tenancy.common.sharedlib";
    private static final String _sharedLibJarName = "javax.inject.javax.inject.jar";
    private static final String _hk2CompName1 = "oracle.wls.shared.with.inst";
    private static final String _hk2CompName2 = "oracle.wls.shared.with.inst.sharedlib";
    private static final String _hk2InstallerAPIComp = "oracle.wls.inst.only";
    private static boolean _hk2Available;
    public static final String _hk2SystemProperty = "hk2.verbose";
    private static final Set<Path> _hk2Jars;

    private static synchronized void init(InstallerWrapper installerWrapper) throws GdrException, IOException, DataHandlerException {
        if (_loader == null && _hk2Available) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (FeatureSet feature : installerWrapper.getFeatureSets()) {
                for (Component comp : installerWrapper.getComponents(feature)) {
                    Path lib;
                    Path relativeLib;
                    if (comp.getName().equals(_sharedLibCompName)) {
                        for (ComponentTarget compTarget : comp.getComponentTargets()) {
                            for (FileTarget fileTarget : compTarget.getFileTargets()) {
                                if (!fileTarget.getDest().endsWith(_sharedLibJarName)) continue;
                                relativeLib = NioHelper.getInstance().getPath(fileTarget.getDest(), new String[0]);
                                lib = installerWrapper.getHome().getHomePath().resolve(relativeLib);
                                urls.add(lib.toUri().toURL());
                                _hk2Jars.add(relativeLib);
                                _log.finer("Found " + lib.toAbsolutePath() + " file for HK2 classpath");
                            }
                        }
                    }
                    if (comp.getName().equals(_hk2CompName1) || comp.getName().equals(_hk2CompName2) || comp.getName().equals(_hk2InstallerAPIComp)) {
                        for (ComponentTarget compTarget : comp.getComponentTargets()) {
                            for (FileTarget fileTarget : compTarget.getFileTargets()) {
                                if (!fileTarget.getDest().endsWith(".jar")) continue;
                                relativeLib = NioHelper.getInstance().getPath(fileTarget.getDest(), new String[0]);
                                lib = installerWrapper.getHome().getHomePath().resolve(relativeLib);
                                urls.add(lib.toUri().toURL());
                                _hk2Jars.add(relativeLib);
                                _log.finer("Found " + lib.toAbsolutePath() + " file for HK2 classpath");
                            }
                        }
                    }
                    if (urls.size() < 6) continue;
                    _log.finer("Creating HK2 classloader with Jars: " + urls);
                    _loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
                    return;
                }
            }
            _log.warning("HK2 Jars missing. Can't execute HK2 metadata generation");
            _log.fine("Jars found for HK2 classloader: " + urls);
            _hk2Available = false;
        }
    }

    public static void generateHK2Metadata(Path jarFile, String hk2Location, InstallerWrapper installerWrapper) throws IllegalArgumentException, IOException, GdrException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, DataHandlerException {
        if (_hk2Available) {
            HK2Generator.init(installerWrapper);
            if (_loader != null) {
                try {
                    Object generatorFactory = _loader.loadClass("com.oracle.weblogic.hk2.installer.plugin.HK2InstallationMetadataGeneratorFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    Object hk2Generator = _loader.loadClass("com.oracle.weblogic.hk2.installer.plugin.HK2InstallationMetadataGeneratorFactory").getMethod("getHK2InstallationMetadataGenerator", ClassLoader.class).invoke(generatorFactory, _loader);
                    String locationInJar = StringUtil.isNullOrEmpty((String)hk2Location) ? null : hk2Location;
                    boolean verbose = Boolean.valueOf(System.getProperty(_hk2SystemProperty));
                    _log.fine("Generating HK2 metadata for library " + jarFile.toAbsolutePath());
                    _loader.loadClass("com.oracle.weblogic.hk2.installer.plugin.HK2InstallationMetadataGenerator").getMethod("generateIntoJARFile", File.class, List.class, String.class, Boolean.TYPE, File.class).invoke(hk2Generator, jarFile.toFile(), null, locationInJar, verbose, null);
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    _log.warning("HK2 metadata for file " + jarFile.toAbsolutePath() + " not generated, HK2 classes missing");
                    _hk2Available = false;
                }
            } else {
                _log.warning("HK2 metadata for file " + jarFile.toAbsolutePath() + " not generated");
            }
        } else {
            _log.warning("HK2 metadata for file " + jarFile.toAbsolutePath() + " not generated");
        }
    }

    public static Set<Path> getHK2Jars(InstallerWrapper installerWrapper) throws GdrException, IOException, DataHandlerException {
        if (_hk2Available) {
            HK2Generator.init(installerWrapper);
        }
        return _hk2Jars;
    }

    static {
        _log = Logger.getLogger(HK2Generator.class.getName());
        _hk2Available = true;
        _hk2Jars = new HashSet<Path>();
    }
}

