/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.maven;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandler;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.GroupNameVersion;
import com.oracle.cie.dependency.mgmt.LegalInformation;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.impl.DependencyImpl;
import com.oracle.cie.dependency.mgmt.impl.LegalInformationImpl;
import com.oracle.cie.dependency.mgmt.impl.ModuleImpl;
import com.oracle.cie.dependency.mgmt.xml.mvn.Model;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.LocationFile;
import com.oracle.cie.gdr.dao.cpd.PomReference;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.pom.PomArtifact;
import com.oracle.cie.gdr.dao.pom.PomComponentDefinition;
import com.oracle.cie.gdr.dao.pom.PomFeaturesetDefinition;
import com.oracle.cie.gdr.dao.pom.PomFile;
import com.oracle.cie.gdr.dao.pom.PomGroup;
import com.oracle.cie.gdr.dao.pom.PomGroupRef;
import com.oracle.cie.gdr.dao.pom.PomLibraryRef;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVersion;
import com.oracle.cie.gdr.libraries.LibraryVisibility;
import com.oracle.cie.gdr.maven.PomException;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ComponentGroupIdService;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PomProcessor {
    private static final Logger _log = Logger.getLogger(PomProcessor.class.getName());
    public static final String POM_LEGAL_INFO_FILE_NAME = "pom-legal-information.xml";
    public static final String POM_DIRECTORY = "plugins" + File.separator + "maven";
    public static final String POM_PREFIX = "com.oracle.";
    public static final String FEATURE_GROUP;
    public static final String FEATURE_LIBRARY_GROUP;
    public static final String COMPONENT_GROUP;
    public static final String COMP_LIBRARY_GROUP;
    public static final String OVERWRITE_PROPERTY = "POM_OVERWRITE";
    private static final Map<Component, Map<String, Module>> compModules;
    private static final Map<Component, Map<String, Module>> defaultComponentModules;
    private static final Map<FeatureSet, Map<String, Module>> featureModules;
    private static final Map<LibraryKey, LibraryTargetHolder> pendingPoms;
    private static final Map<FeatureSet, Module> featureAggregatePoms;
    private static final Map<Component, Module> componentAggregatePoms;
    private static final Map<String, String> artifactProductHomes;
    private static final Map<FeatureSet, String> featureProductHomes;
    public static final Map<FeatureSet, String> featureGroupIds;
    public static final Map<Module, String> moduleCollisionList;
    private static DependencyFileHandler fileHandler;
    private static Model _legalModelInfo;
    private static final int BUFFER_SIZE = 1024;
    private static int errorsFound;
    private static boolean _overwritePoms;

    private static void initFileHandler() throws DependencyManagementException {
        if (fileHandler == null) {
            fileHandler = DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom);
        }
    }

    private static Map<PomComponentDefinition, List<Module>> processCustomComponentPom(Component comp, DirectoryMap dirMap, Mode mode, LibraryTargetHolder holder, InstallerWrapper installerWrapper) throws GdrException, IOException, DependencyManagementException, DataHandlerException {
        HashMap<PomComponentDefinition, List<Module>> fileRefModules = new HashMap<PomComponentDefinition, List<Module>>();
        HashMap<String, Module> customModules = new HashMap<String, Module>();
        boolean componentIsInstalled = installerWrapper.getHome().getInstalledComponents().contains((Object)new ComponentReference(comp.getName(), comp.getVersion()));
        boolean generateFiles = !componentIsInstalled || PomProcessor.componentNeedsRegen(comp, componentIsInstalled) || comp.hasReplaces();
        for (PomGroup pomGroup : comp.getPomGroups()) {
            ArrayList<Path> compPomFiles = new ArrayList<Path>();
            String productHome = PomProcessor.getProductHome(pomGroup.getSymbol(), dirMap);
            String pomsDir = installerWrapper.getHome().getHomePath().toAbsolutePath().resolve(productHome).resolve(POM_DIRECTORY).toString();
            for (PomComponentDefinition compPom : pomGroup.getPoms()) {
                List<String> modulePaths;
                ArrayList<Module> fileRefList = new ArrayList<Module>();
                if (compPom.getLocations() != null && !compPom.getLocations().isEmpty()) {
                    PomProcessor.validateArtifact(compPom);
                    modulePaths = PomProcessor.getCompPomLocations(compPom, comp.getComponentTargets(), mode);
                    if (modulePaths != null && !modulePaths.isEmpty()) {
                        compPomFiles.addAll(PomProcessor.processCompPomLocations(modulePaths, compPom, pomsDir, customModules, generateFiles));
                    }
                } else if (compPom.getLibraryRef() != null && holder != null) {
                    PomProcessor.validateArtifact(compPom);
                    modulePaths = PomProcessor.getLibraryLocation(compPom.getLibraryRef(), holder, comp, mode);
                    if (modulePaths != null && !modulePaths.isEmpty()) {
                        compPomFiles.addAll(PomProcessor.processCompPomLocations(modulePaths, compPom, pomsDir, customModules, generateFiles));
                    }
                } else if (!StringUtil.isNullOrEmpty((String)compPom.getRefId()) && (modulePaths = PomProcessor.getRepoFileLocations(compPom, comp.getComponentTargets())) != null && !modulePaths.isEmpty()) {
                    compPomFiles.addAll(PomProcessor.processRepoFileLocations(modulePaths, pomsDir, compPom, fileRefList, customModules, generateFiles));
                }
                if (fileRefList.isEmpty()) continue;
                fileRefModules.put(compPom, fileRefList);
            }
            if (compPomFiles.isEmpty()) continue;
            installerWrapper.addExtraFilesToDeInstallInfo(comp.getName(), comp.getVersion(), compPomFiles, false);
        }
        compModules.put(comp, customModules);
        return fileRefModules;
    }

    private static Collection<Path> processCompPomLocations(List<String> modulePaths, PomComponentDefinition compPom, String pomsDir, Map<String, Module> customModules, boolean generateFiles) throws IOException, DependencyManagementException {
        ArrayList<Path> compPomFiles = new ArrayList<Path>();
        ModuleImpl subModule = new ModuleImpl(compPom.getGroup(), compPom.getArtifact(), compPom.getVersion(), compPom.getType());
        if (!StringUtil.isNullOrEmpty((String)compPom.getDependencyVersion())) {
            Properties props = new Properties();
            props.put("dependency-version", compPom.getDependencyVersion());
            subModule.setProperties(props);
        }
        if (generateFiles) {
            PomProcessor.generatePomAndLocationFiles(pomsDir, (Module)subModule, compPomFiles, modulePaths);
        }
        moduleCollisionList.put((Module)subModule, null);
        if (compPom.getIncludeInAggregatePom()) {
            for (String modulePath : modulePaths) {
                customModules.put(PomProcessor.getFilePath(modulePath), (Module)subModule);
            }
        }
        return compPomFiles;
    }

    private static Collection<Path> processRepoFileLocations(Map<String, FileTarget> modulePaths, String pomsDir, PomComponentDefinition compPom, List<Module> fileRefList, Map<String, Module> customModules, boolean generateFiles) throws IOException, DependencyManagementException {
        ArrayList<Path> compPomFiles = new ArrayList<Path>();
        for (Map.Entry<String, FileTarget> modulePath : modulePaths.entrySet()) {
            FileTarget fileTarget = modulePath.getValue();
            String type = StringUtil.isNullOrEmpty((String)fileTarget.getType()) ? "jar" : fileTarget.getType();
            ModuleImpl subModule = new ModuleImpl(fileTarget.getGroup(), fileTarget.getArtifact(), fileTarget.getVersion(), type);
            fileRefList.add((Module)subModule);
            if (generateFiles) {
                PomProcessor.generatePomAndLocationFiles(pomsDir, (Module)subModule, compPomFiles, modulePath.getKey());
            }
            moduleCollisionList.put((Module)subModule, FileUtils.formatPath(fileTarget.getDest()));
            if (!compPom.getIncludeInAggregatePom()) continue;
            customModules.put(FileUtils.formatPath(modulePath.getKey()), (Module)subModule);
        }
        return compPomFiles;
    }

    private static Map<Component, Module> processDefaultComponentPom(Component comp, DirectoryMap dirMap, Mode mode, InstallerWrapper installerWrapper, LibraryTargetHolder holder) throws DependencyManagementException, GdrException, IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, DataHandlerException {
        boolean generateFiles;
        HashMap<String, Module> fileModules = new HashMap<String, Module>();
        HashMap<String, Module> libraryModules = new HashMap<String, Module>();
        HashMap<Component, Module> moduleMap = new HashMap<Component, Module>();
        String compProductHome = PomProcessor.getComponentProductHome(comp, dirMap);
        boolean componentIsInstalled = installerWrapper.getHome().getInstalledComponents().contains((Object)new ComponentReference(comp.getName(), comp.getVersion()));
        boolean bl = generateFiles = !componentIsInstalled || PomProcessor.componentNeedsRegen(comp, componentIsInstalled) || comp.hasReplaces();
        if (comp.getPomGen().equals("true") || comp.getPomGen().equals("static-poms-only")) {
            if (comp.getPomGen().equals("true")) {
                fileModules.putAll(PomProcessor.processDefaultComponentArtifacts(comp, dirMap));
                defaultComponentModules.put(comp, fileModules);
                libraryModules.putAll(PomProcessor.processDefaultComponentLibraryPom(comp, mode, installerWrapper, holder, generateFiles));
            } else if (comp.getPomGen().equals("static-poms-only")) {
                fileModules.putAll(PomProcessor.processStaticComponentArtifacts(comp, installerWrapper.getHome(), dirMap));
            }
            ArrayList<DependencyImpl> dependencies = new ArrayList<DependencyImpl>();
            for (Object module : libraryModules.values()) {
                dependencies.add(new DependencyImpl(module.getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType()));
            }
            Map<String, Module> customModules = compModules.get(comp);
            if (customModules != null && !customModules.isEmpty()) {
                for (Module module : customModules.values()) {
                    String version;
                    Properties props = module.getProperties();
                    String string = version = props != null && !StringUtil.isNullOrEmpty((String)props.getProperty("dependency-version")) ? props.getProperty("dependency-version") : PomProcessor.generateDependencyVersion(module.getVersionString());
                    DependencyImpl dependency = new DependencyImpl(module.getGroup(), module.getName(), version, module.getType());
                    if (dependencies.contains(dependency)) continue;
                    dependencies.add(dependency);
                }
            }
            for (Module module : fileModules.values()) {
                dependencies.add(new DependencyImpl(module.getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType()));
            }
            if (!dependencies.isEmpty()) {
                String groupId = comp.getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)comp.getDefaultPomOverride().getGroup()) ? (StringUtil.isNullOrEmpty((String)comp.getGroupId()) ? COMPONENT_GROUP : comp.getGroupId()) : comp.getDefaultPomOverride().getGroup();
                String version = comp.getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)comp.getDefaultPomOverride().getVersion()) ? PomProcessor.generateVersion(comp.getVersion()) : comp.getDefaultPomOverride().getVersion();
                String artifact = comp.getName();
                boolean artifactOverride = false;
                if (comp.getDefaultPomOverride() != null && !StringUtil.isNullOrEmpty((String)comp.getDefaultPomOverride().getArtifact())) {
                    artifact = comp.getDefaultPomOverride().getArtifact();
                    artifactOverride = true;
                }
                String pomsDir = installerWrapper.getHome().getHomePath().toAbsolutePath().resolve(compProductHome).resolve(POM_DIRECTORY).toString();
                ModuleImpl module = new ModuleImpl(groupId, artifact, version, "pom");
                String compKey = "component:" + comp.toString();
                if (!artifactOverride) {
                    PomProcessor.recalculateModule((Module)module, compKey);
                }
                moduleCollisionList.put((Module)module, compKey);
                module.setDependencies(dependencies);
                componentAggregatePoms.put(comp, (Module)module);
                if (generateFiles) {
                    ArrayList<Path> compPomFiles = new ArrayList<Path>();
                    Path pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "pom");
                    if (RegenerationHelper.getInstance().getQueryMode() && Files.exists(pomFile, new LinkOption[0])) {
                        RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
                    }
                    PomProcessor.writePomFile((Module)module, pomFile, comp);
                    compPomFiles.add(pomFile);
                    if (!compPomFiles.isEmpty() && installerWrapper != null) {
                        installerWrapper.addExtraFilesToDeInstallInfo(comp.getName(), comp.getVersion(), compPomFiles, false);
                    }
                }
                moduleMap.put(comp, (Module)module);
                compModules.get(comp).putAll(fileModules);
                compModules.get(comp).putAll(libraryModules);
            } else {
                _log.fine("Skipping aggregate POM generation for component " + comp.getName() + " since its POM doesn't contain any dependencies.");
            }
        }
        return moduleMap;
    }

    private static Map<String, Module> processDefaultComponentArtifacts(Component comp, DirectoryMap dirMap) throws DependencyManagementException, GdrException, IOException {
        Map<String, Module> customModules = compModules.get(comp);
        List<String> suppressedArtifacts = PomProcessor.generateSuppressList(comp.getSuppressPoms(), dirMap);
        HashMap<String, Module> fileModules = new HashMap<String, Module>();
        for (ComponentTarget compTarget : comp.getComponentTargets()) {
            if (!compTarget.getComponentFileMap().hasPomGen()) continue;
            String productHome = PomProcessor.getProductHome(compTarget.getSymbol(), dirMap);
            for (FileTarget file : compTarget.getFileTargets()) {
                String dest = FileUtils.formatPath(file.getDest());
                if (!file.isFile() || !PomProcessor.isMavenType(dest) || PomProcessor.isMavenPlugin(dest) || customModules.keySet().contains(dest) || suppressedArtifacts.contains(dest)) continue;
                Module fileModule = PomProcessor.generateArtifactModule(comp, file);
                fileModules.put(dest, fileModule);
                moduleCollisionList.put(fileModule, dest);
                artifactProductHomes.put(dest, productHome);
            }
        }
        return fileModules;
    }

    private static Map<String, Module> processStaticComponentArtifacts(Component comp, Home home, DirectoryMap dirMap) throws GdrException, DependencyManagementException, IOException {
        HashMap<String, Module> fileModules = new HashMap<String, Module>();
        for (PomReference pomRef : comp.getStaticPoms()) {
            String productHome = PomProcessor.getProductHome(pomRef.getSymbol(), dirMap);
            if (!StringUtil.isNullOrEmpty((String)productHome)) {
                Path staticPomFile = home.getHomePath().resolve(productHome).resolve(pomRef.getFile());
                if (Files.exists(staticPomFile, new LinkOption[0])) {
                    InputStream is = Files.newInputStream(staticPomFile, new OpenOption[0]);
                    try {
                        Module module = fileHandler.readDependenciesFile(is);
                        fileModules.put(PomProcessor.getStaticPomFilePath(staticPomFile), module);
                        moduleCollisionList.put(module, PomProcessor.getStaticPomFilePath(staticPomFile));
                        continue;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        continue;
                    }
                }
                _log.warning("Static POM file doesn't exist: " + staticPomFile.toAbsolutePath());
                continue;
            }
            _log.warning("Symbol " + pomRef.getSymbol() + " not found for static POM " + pomRef.getFile());
        }
        return fileModules;
    }

    private static Map<String, Module> processDefaultComponentLibraryPom(Component comp, Mode mode, InstallerWrapper installerWrapper, LibraryTargetHolder holder, boolean generateFiles) throws DependencyManagementException, GdrException, IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, DataHandlerException {
        Map<String, Module> customModules = compModules.get(comp);
        HashMap<String, Module> libraryModules = new HashMap<String, Module>();
        if (comp.getPomGen().equals("true")) {
            ArrayList<Path> compPomFiles = new ArrayList<Path>();
            for (LibraryKey key : holder.getLibraryKeys()) {
                if (LibraryType.none.equals((Object)key.getType()) || key.getVisibility().equals((Object)LibraryVisibility.none) || !key.getPomGen()) continue;
                for (LibraryTarget target : holder.getLibraryTargets(key)) {
                    if (!target.getComponent().equals(comp)) continue;
                    boolean pendingPom = false;
                    JarLibraryHandler libHandler = (JarLibraryHandler)key.getType().getHandler();
                    libHandler.setHome(installerWrapper.getHome());
                    libHandler.setInstallerWrapper(installerWrapper);
                    String modulePath = FileUtils.formatPath(libHandler.getAbsoluteComponentJarPaths(key, target).get(0));
                    modulePath = FileUtils.formatPath(modulePath, "/");
                    String regex = FileUtils.formatPath(installerWrapper.getHome().toString(), "/");
                    String productHome = target.getProductHome(mode);
                    String libPath = FileUtils.formatPath(productHome + modulePath.replaceFirst(regex, ""));
                    if (customModules.containsKey(libPath)) continue;
                    ArrayList<DependencyImpl> dependencies = new ArrayList<DependencyImpl>();
                    if (LibraryType.manifest.equals((Object)key.getType())) {
                        for (LibraryEntryLocation entry : target.getEntryLocations(mode)) {
                            Module module;
                            DependencyImpl dep;
                            String filePath = FileUtils.formatPath(entry.getFullPath());
                            Map<String, Module> fileModules = defaultComponentModules.get(comp);
                            if (fileModules != null && fileModules.containsKey(filePath)) {
                                Module fileModule = fileModules.get(filePath);
                                dep = new DependencyImpl(fileModule.getGroup(), fileModule.getName(), PomProcessor.generateDependencyVersion(fileModule.getVersionString()), fileModule.getType());
                                dependencies.add(dep);
                                continue;
                            }
                            if (!customModules.containsKey(filePath) || dependencies.contains(dep = new DependencyImpl((module = customModules.get(filePath)).getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType()))) continue;
                            dependencies.add(dep);
                        }
                    } else if (LibraryType.mergedJar.equals((Object)key.getType()) && target.getLibrary().getClasspathJars() != null) {
                        pendingPom = true;
                    }
                    String groupId = target.getLibrary().getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)target.getLibrary().getDefaultPomOverride().getGroup()) ? (StringUtil.isNullOrEmpty((String)comp.getGroupId()) ? COMP_LIBRARY_GROUP : comp.getGroupId()) : target.getLibrary().getDefaultPomOverride().getGroup();
                    String artifact = comp.getName() + "." + key.getName();
                    boolean artifactOverride = false;
                    if (target.getLibrary().getDefaultPomOverride() != null && !StringUtil.isNullOrEmpty((String)target.getLibrary().getDefaultPomOverride().getArtifact())) {
                        artifact = target.getLibrary().getDefaultPomOverride().getArtifact();
                    }
                    String version = target.getLibrary().getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)target.getLibrary().getDefaultPomOverride().getVersion()) ? PomProcessor.generateVersion(target.getCompleteVersion()) : target.getLibrary().getDefaultPomOverride().getVersion();
                    String type = LibraryType.manifest.equals((Object)key.getType()) ? "pom" : "jar";
                    String pomsDir = installerWrapper.getHome().getHomePath().toAbsolutePath().resolve(productHome).resolve(POM_DIRECTORY).toString();
                    ModuleImpl module = new ModuleImpl(groupId, artifact, version, type);
                    if (!artifactOverride) {
                        PomProcessor.recalculateModule((Module)module, libPath);
                    }
                    moduleCollisionList.put((Module)module, libPath);
                    if (!pendingPom) {
                        if (!dependencies.isEmpty()) {
                            module.setDependencies(dependencies);
                        }
                        if (generateFiles) {
                            Path pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "pom");
                            Path locationFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "location");
                            if (RegenerationHelper.getInstance().getQueryMode()) {
                                if (Files.exists(pomFile, new LinkOption[0])) {
                                    RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
                                }
                                if (!LibraryType.manifest.equals((Object)key.getType()) && Files.exists(locationFile, new LinkOption[0])) {
                                    RegenerationHelper.getInstance().addFilesToRegenerate(locationFile);
                                }
                            } else {
                                PomProcessor.writePomFile((Module)module, pomFile, comp, key);
                                compPomFiles.add(pomFile);
                                if (!LibraryType.manifest.equals((Object)key.getType())) {
                                    PomProcessor.writeLocationFile((Module)module, locationFile, libPath);
                                    compPomFiles.add(locationFile);
                                }
                            }
                        }
                    } else if (generateFiles) {
                        pendingPoms.put(key, holder);
                    }
                    libraryModules.put(libPath, (Module)module);
                }
            }
            if (!compPomFiles.isEmpty()) {
                installerWrapper.addExtraFilesToDeInstallInfo(comp.getName(), comp.getVersion(), compPomFiles, false);
            }
        }
        return libraryModules;
    }

    private static void processLocationFiles(Component comp, DirectoryMap dirMap, InstallerWrapper installerWrapper) throws GdrException, IOException, DataHandlerException {
        ArrayList<Path> locationFiles = new ArrayList<Path>();
        boolean componentIsInstalled = installerWrapper.getHome().getInstalledComponents().contains((Object)new ComponentReference(comp.getName(), comp.getVersion()));
        boolean generateFiles = !componentIsInstalled || PomProcessor.componentNeedsRegen(comp, componentIsInstalled) || comp.hasReplaces();
        for (LocationFile locFile : comp.getLocationFiles()) {
            String productHome = PomProcessor.getProductHome(locFile.getSymbol(), dirMap);
            String content = productHome + File.separator + FileUtils.formatPath(locFile.getContent());
            Path file = null;
            for (ComponentTarget compTarget : comp.getComponentTargets()) {
                if (!compTarget.getSymbol().equals(locFile.getSymbol())) continue;
                for (FileTarget fileTarget : compTarget.getFileTargets()) {
                    if (!FileUtils.formatPath(fileTarget.getDest()).equals(content)) continue;
                    file = installerWrapper.getHome().getHomePath().resolve(productHome).resolve(locFile.getPath());
                    break;
                }
                if (file == null || !generateFiles) continue;
                if (RegenerationHelper.getInstance().getQueryMode()) {
                    if (!Files.exists(file, new LinkOption[0])) break;
                    RegenerationHelper.getInstance().addFilesToRegenerate(file);
                    break;
                }
                PomProcessor.writeLocationFile(null, file, content);
                locationFiles.add(file);
                break;
            }
            if (locationFiles.isEmpty() || installerWrapper == null) continue;
            installerWrapper.addExtraFilesToDeInstallInfo(comp.getName(), comp.getVersion(), locationFiles, false);
        }
    }

    private static void processCustomLibraryPoms(FeatureSet feature, LibraryTargetHolder holder, InstallerWrapper installerWrapper, Mode mode, DirectoryMap dirMap) throws GdrException, IOException, DependencyManagementException, DataHandlerException {
        ArrayList<Path> pomFiles = new ArrayList<Path>();
        HashMap<String, ModuleImpl> featureLibraryModules = new HashMap<String, ModuleImpl>();
        boolean generateFiles = !installerWrapper.getHome().getInstalledFeatures().contains(feature) || PomProcessor.featureNeedsRegen(feature);
        for (PomFeaturesetDefinition pom : feature.getPoms()) {
            if (pom.getLibraryRef() == null) continue;
            PomProcessor.validateArtifact(pom);
            String modulePath = "";
            for (LibraryKey key : holder.getFeatureLibraryKeys()) {
                if (!key.getName().equals(pom.getLibraryRef().getName()) || !key.getVersion().equals(pom.getLibraryRef().getVersion())) continue;
                FeatureLibrary flib = holder.getFeatureLibrary(key);
                modulePath = FileUtils.formatPath(holder.getProductHome(flib, mode) + File.separator + holder.getFeaturesetJarLocations(key).get(0));
            }
            if (StringUtil.isNullOrEmpty((String)modulePath)) continue;
            String productHome = PomProcessor.getProductHome(pom.getSymbol(), dirMap);
            String pomsDir = installerWrapper.getHome().getHomePath().toAbsolutePath().resolve(productHome).resolve(POM_DIRECTORY).toString();
            ModuleImpl subModule = new ModuleImpl(pom.getGroup(), pom.getArtifact(), pom.getVersion(), "jar");
            if (generateFiles) {
                PomProcessor.generatePomAndLocationFiles(pomsDir, (Module)subModule, pomFiles, modulePath);
            }
            moduleCollisionList.put((Module)subModule, null);
            featureLibraryModules.put(FileUtils.formatPath(modulePath, "/"), subModule);
        }
        if (!pomFiles.isEmpty() && installerWrapper != null) {
            installerWrapper.addExtraFilesToDeInstallInfo(feature.getName(), feature.getVersion(), pomFiles, true);
        }
        featureModules.put(feature, featureLibraryModules);
    }

    private static void processCustomFeaturePom(FeatureSet feature, Set<Component> components, DirectoryMap dirMap, InstallerWrapper installerWrapper, Map<PomComponentDefinition, List<Module>> fileRefModules) throws GdrException, IOException, DependencyManagementException, DataHandlerException {
        ComponentHelper compHelper = ComponentHelper.getInstance();
        ArrayList<Path> pomFiles = new ArrayList<Path>();
        boolean generateFiles = !installerWrapper.getHome().getInstalledFeatures().contains(feature) || PomProcessor.featureNeedsRegen(feature);
        for (PomFeaturesetDefinition pom : feature.getPoms()) {
            DependencyImpl dependency;
            String dependencyVersion;
            if (pom.getLibraryRef() != null) continue;
            PomProcessor.validateArtifact(pom);
            ArrayList<DependencyImpl> dependencies = new ArrayList<DependencyImpl>();
            String productHome = PomProcessor.getProductHome(pom.getSymbol(), dirMap);
            String pomsDir = installerWrapper.getHome().getHomePath().toAbsolutePath().resolve(productHome).resolve(POM_DIRECTORY).toString();
            for (PomArtifact pomRef : pom.getPomRefs()) {
                FeatureSetHelper helper = FeatureSetHelper.getInstance();
                HashSet<FeatureSet> cycleCheck = new HashSet<FeatureSet>();
                PomProcessor.validateArtifact(pomRef);
                PomArtifact dependencyPom = PomProcessor.getPomArtifact(pomRef, components, feature, installerWrapper, compHelper, helper, cycleCheck);
                if (dependencyPom != null) {
                    dependencyVersion = PomProcessor.getDependencyVersion(dependencyPom, pomRef.getDependencyVersion());
                    dependency = new DependencyImpl(pomRef.getGroup(), pomRef.getArtifact(), dependencyVersion, dependencyPom.getType());
                    dependencies.add(dependency);
                    continue;
                }
                _log.warning("Unable to locate pom-ref in feature " + feature + " :" + pomRef);
            }
            for (PomGroupRef pomGroupRef : pom.getPomGroupRefs()) {
                PomGroup pomGroup = PomProcessor.getPomGroup(pomGroupRef, components);
                if (pomGroup != null) {
                    for (PomComponentDefinition compPom : pomGroup.getPoms()) {
                        dependencyVersion = PomProcessor.getDependencyVersion(compPom, pomGroupRef.getDependencyVersion());
                        if (!StringUtil.isNullOrEmpty((String)compPom.getRefId())) {
                            List<Module> moduleList = fileRefModules.get(compPom);
                            for (Module module : moduleList) {
                                DependencyImpl dependency2 = new DependencyImpl(module.getGroup(), module.getName(), dependencyVersion, "jar");
                                dependencies.add(dependency2);
                            }
                            continue;
                        }
                        dependency = new DependencyImpl(compPom.getGroup(), compPom.getArtifact(), dependencyVersion, "jar");
                        dependencies.add(dependency);
                    }
                    continue;
                }
                _log.warning("Unable to locate pom-group-ref in feature " + feature + " :" + (Object)((Object)pomGroupRef));
            }
            ModuleImpl module = new ModuleImpl(pom.getGroup(), pom.getArtifact(), pom.getVersion(), "pom");
            module.setDependencies(dependencies);
            moduleCollisionList.put((Module)module, null);
            if (!generateFiles) continue;
            Path pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "pom");
            if (RegenerationHelper.getInstance().getQueryMode() && Files.exists(pomFile, new LinkOption[0])) {
                RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
            }
            PomProcessor.writePomFile((Module)module, pomFile, feature);
            pomFiles.add(pomFile);
        }
        if (!pomFiles.isEmpty() && installerWrapper != null) {
            installerWrapper.addExtraFilesToDeInstallInfo(feature.getName(), feature.getVersion(), pomFiles, true);
        }
    }

    private static void processDefaultFeaturePom(Set<Component> components, LibraryTargetHolder holder, Mode mode, DirectoryMap dirMap, InstallerWrapper installerWrapper, FeatureSelectionTarget selectionTarget, Map<Component, Module> compModules) throws DependencyManagementException, GdrException, IOException, DataHandlerException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        FeatureSet feature = holder.getFeature();
        ArrayList<Module> componentModules = new ArrayList<Module>();
        if (feature.hasPomGen()) {
            String groupId = PomProcessor.generateFeatureGroupId(feature, components, installerWrapper, selectionTarget);
            PomProcessor.processDefaultFeatureLibraryPom(installerWrapper, holder, mode);
            ArrayList<DependencyImpl> dependencies = new ArrayList<DependencyImpl>();
            String productHome = PomProcessor.getFeatureSetProductHome(feature, holder, mode, dirMap, installerWrapper);
            if (!StringUtil.isNullOrEmpty((String)productHome)) {
                featureProductHomes.put(feature, productHome);
                for (Module module : featureModules.get(feature).values()) {
                    DependencyImpl dep = new DependencyImpl(module.getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType());
                    dependencies.add(dep);
                }
                for (ComponentReference compRef : feature.getComponentReferences()) {
                    Module compModule;
                    Component comp;
                    if (!compRef.hasPomGen() || (comp = ComponentHelper.getInstance().getComponent(components, compRef)) == null || (compModule = compModules.get(comp)) == null) continue;
                    DependencyImpl dep = new DependencyImpl(compModule.getGroup(), compModule.getName(), PomProcessor.generateDependencyVersion(compModule.getVersionString()), compModule.getType());
                    dependencies.add(dep);
                    componentModules.add(compModule);
                }
                if (!dependencies.isEmpty()) {
                    String version = feature.getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)feature.getDefaultPomOverride().getVersion()) ? PomProcessor.generateVersion(feature.getVersion()) : feature.getDefaultPomOverride().getVersion();
                    String artifact = feature.getName();
                    boolean artifactOverride = false;
                    if (feature.getDefaultPomOverride() != null && !StringUtil.isNullOrEmpty((String)feature.getDefaultPomOverride().getArtifact())) {
                        artifact = feature.getDefaultPomOverride().getArtifact();
                        artifactOverride = true;
                    }
                    ModuleImpl module = new ModuleImpl(groupId, artifact, version, "pom");
                    String featureKey = "featureset:" + feature.toString();
                    if (!artifactOverride) {
                        PomProcessor.recalculateModule((Module)module, featureKey);
                    }
                    moduleCollisionList.put((Module)module, featureKey);
                    module.setDependencies(dependencies);
                    featureAggregatePoms.put(feature, (Module)module);
                } else {
                    _log.fine("Skipping aggregate POM generation for featureset " + feature.getName() + " since its POM doesn't contain any dependencies.");
                }
            }
        }
    }

    private static void processDefaultFeatureLibraryPom(InstallerWrapper installerWrapper, LibraryTargetHolder holder, Mode mode) throws DependencyManagementException, IOException, GdrException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Home home = installerWrapper.getHome();
        FeatureSet feature = holder.getFeature();
        HashMap<String, ModuleImpl> featureLibraryModules = new HashMap<String, ModuleImpl>();
        boolean generateFiles = !home.getInstalledFeatures().contains(feature) || PomProcessor.featureNeedsRegen(feature);
        for (LibraryKey key : holder.getFeatureLibraryKeys()) {
            FeatureLibrary library;
            String productHome;
            if (LibraryType.none.equals((Object)key.getType()) || !key.getPomGen() || StringUtil.isNullOrEmpty((String)(productHome = holder.getProductHome(library = holder.getFeatureLibrary(key), mode)))) continue;
            JarLibraryHandler libHandler = (JarLibraryHandler)key.getType().getHandler();
            libHandler.setHome(home);
            libHandler.setInstallerWrapper(installerWrapper);
            String modulePath = FileUtils.formatPath(libHandler.getAbsoluteFeaturesetJarPaths(key, holder).get(0));
            modulePath = FileUtils.formatPath(modulePath, "/");
            String regex = FileUtils.formatPath(home.toString(), "/");
            String libPath = productHome + modulePath.replaceFirst(regex, "");
            if (featureModules.get(feature).containsKey(libPath)) continue;
            String groupId = library.getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)library.getDefaultPomOverride().getGroup()) ? (featureGroupIds.containsKey(feature) ? featureGroupIds.get(feature) : FEATURE_LIBRARY_GROUP) : library.getDefaultPomOverride().getGroup();
            String artifact = feature.getName() + "." + key.getName();
            boolean artifactOverride = false;
            if (library.getDefaultPomOverride() != null && !StringUtil.isNullOrEmpty((String)library.getDefaultPomOverride().getArtifact())) {
                artifact = library.getDefaultPomOverride().getArtifact();
            }
            String version = library.getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)library.getDefaultPomOverride().getVersion()) ? PomProcessor.generateVersion(key.getCompleteVersion()) : library.getDefaultPomOverride().getVersion();
            String type = LibraryType.manifest.equals((Object)key.getType()) ? "pom" : "jar";
            ModuleImpl module = new ModuleImpl(groupId, artifact, version, type);
            if (!artifactOverride) {
                PomProcessor.recalculateModule((Module)module, libPath);
            }
            moduleCollisionList.put((Module)module, libPath);
            if (generateFiles) {
                pendingPoms.put(key, holder);
            }
            featureLibraryModules.put(libPath, module);
        }
        featureModules.get(feature).putAll(featureLibraryModules);
    }

    public static void process(FeatureSet feature, InstallerWrapper installerWrapper, FeatureSelectionTarget selectionTarget, Mode mode, DirectoryMap dirMap, LibraryTargetHolder holder, boolean overwritePoms) throws GdrException {
        boolean isFeatureInstalled = PomProcessor.isFeatureInstalled(feature, installerWrapper.getHome());
        if (!featureModules.containsKey(feature) && (!isFeatureInstalled || isFeatureInstalled && PomProcessor.hasReplaces(feature, installerWrapper) || RegenerationHelper.isRegenerateState())) {
            if (overwritePoms) {
                _log.fine("POM_OVERWRITE set to true. POM and location files will be overwritten for featureset " + feature);
                _overwritePoms = true;
            }
            HashMap<PomComponentDefinition, List<Module>> fileRefModules = new HashMap<PomComponentDefinition, List<Module>>();
            HashMap<Component, Module> defaultCompModules = new HashMap<Component, Module>();
            try {
                Set<Component> components = installerWrapper.getComponents(feature);
                PomProcessor.initFileHandler();
                for (Component comp : components) {
                    if (compModules.containsKey(comp)) continue;
                    fileRefModules.putAll(PomProcessor.processCustomComponentPom(comp, dirMap, mode, holder, installerWrapper));
                    defaultCompModules.putAll(PomProcessor.processDefaultComponentPom(comp, dirMap, mode, installerWrapper, holder));
                    PomProcessor.processLocationFiles(comp, dirMap, installerWrapper);
                }
                PomProcessor.processCustomLibraryPoms(feature, holder, installerWrapper, mode, dirMap);
                PomProcessor.processCustomFeaturePom(feature, components, dirMap, installerWrapper, fileRefModules);
                PomProcessor.processDefaultFeaturePom(components, holder, mode, dirMap, installerWrapper, selectionTarget, defaultCompModules);
            }
            catch (DependencyManagementException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (IOException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (DataHandlerException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (ClassNotFoundException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (NoSuchMethodException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (InvocationTargetException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (IllegalAccessException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
            catch (InstantiationException e) {
                PomException ex = new PomException(e);
                _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
                throw ex;
            }
        }
    }

    private static boolean hasReplaces(FeatureSet feature, InstallerWrapper installerWrapper) throws PomException {
        try {
            for (Component comp : installerWrapper.getComponents(feature)) {
                if (!comp.hasReplaces()) continue;
                return true;
            }
        }
        catch (GdrException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
            throw ex;
        }
        catch (DataHandlerException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "process", (Throwable)((Object)ex));
            throw ex;
        }
        return false;
    }

    private static boolean isFeatureInstalled(FeatureSet feature, Home home) {
        return home.getInstalledFeatures().contains(feature);
    }

    public static void processPendingPOMs(InstallerWrapper installerWrapper, Mode mode) throws GdrException {
        try {
            PomProcessor.initFileHandler();
            PomProcessor.generateComponentArtifactPoms(installerWrapper);
            PomProcessor.processPendingFeatureAggregatePoms(installerWrapper);
            for (Map.Entry<LibraryKey, LibraryTargetHolder> mapEntry : pendingPoms.entrySet()) {
                LibraryKey key = mapEntry.getKey();
                LibraryTargetHolder holder = mapEntry.getValue();
                JarLibraryHandler libHandler = (JarLibraryHandler)key.getType().getHandler();
                libHandler.setHome(installerWrapper.getHome());
                libHandler.setInstallerWrapper(installerWrapper);
                FeatureLibrary library = holder.getFeatureLibrary(key);
                if (library != null) {
                    PomProcessor.processPendingFeaturePom(library, holder, mode, key, installerWrapper, libHandler);
                    continue;
                }
                PomProcessor.processPendingComponentPom(key, holder, libHandler, mode, installerWrapper);
            }
            if (errorsFound > 0) {
                PomException ex = new PomException("Errors were found during POM generation. Please check the logs for more information.");
                _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
                throw ex;
            }
        }
        catch (DependencyManagementException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (ClassNotFoundException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (NoSuchMethodException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (InvocationTargetException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (IllegalAccessException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (InstantiationException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        catch (DataHandlerException e) {
            PomException ex = new PomException(e);
            _log.throwing(PomProcessor.class.getName(), "processPendingPOMs", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            PomProcessor.resetStatus();
        }
    }

    private static void recalculateModule(Module module, String path) {
        int i = 1;
        String originalArtifactId = module.getName();
        while (PomProcessor.moduleHasCollision(module, path)) {
            module.setName(originalArtifactId + "." + i);
            ++i;
        }
    }

    private static boolean moduleHasCollision(Module module, String path) {
        for (Map.Entry<Module, String> listModule : moduleCollisionList.entrySet()) {
            if (!listModule.getKey().getName().equalsIgnoreCase(module.getName()) || !listModule.getKey().getGroup().equalsIgnoreCase(module.getGroup()) || !listModule.getKey().getVersionString().equalsIgnoreCase(module.getVersionString()) || listModule.getValue().equals(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateComponentArtifactPoms(InstallerWrapper installerWrapper) throws GdrException, IOException, DependencyManagementException, DataHandlerException {
        Path homeDir = installerWrapper.getHome().getHomePath();
        for (Map.Entry<Component, Map<String, Module>> map : defaultComponentModules.entrySet()) {
            Component comp = map.getKey();
            ArrayList<Path> compPomFiles = new ArrayList<Path>();
            boolean componentIsInstalled = installerWrapper.getHome().getInstalledComponents().contains((Object)new ComponentReference(comp.getName(), comp.getVersion()));
            boolean generateFiles = !componentIsInstalled || PomProcessor.componentNeedsRegen(comp, componentIsInstalled) || comp.hasReplaces();
            if (!generateFiles) continue;
            for (Map.Entry<String, Module> entry : map.getValue().entrySet()) {
                Module module = entry.getValue();
                String filePath = entry.getKey();
                if (PomProcessor.hasJarFormat(filePath)) {
                    try (ZipFile jar = null;){
                        Attributes attrs;
                        String classpath;
                        Manifest man;
                        Path jarFile = homeDir.resolve(filePath);
                        if (Files.exists(jarFile, new LinkOption[0]) && (man = ((JarFile)(jar = new JarFile(jarFile.toFile()))).getManifest()) != null && !StringUtil.isNullOrEmpty((String)(classpath = (attrs = man.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)))) {
                            String[] paths;
                            ArrayList<Dependency> deps = new ArrayList<Dependency>();
                            for (String path : paths = classpath.split("\\s")) {
                                String regex;
                                Path classpathFile = homeDir.resolve(filePath).getParent().resolve(path);
                                String canonicalPath = FileUtils.formatPath(classpathFile.toFile().getCanonicalPath(), "/");
                                String destPath = canonicalPath.replaceFirst(regex = FileUtils.formatPath(homeDir.normalize().toString(), "/") + "/", "");
                                Dependency dep = PomProcessor.getDependencyModule(FileUtils.formatPath(destPath));
                                if (dep == null) continue;
                                deps.add(dep);
                            }
                            if (!deps.isEmpty()) {
                                module.setDependencies(deps);
                            }
                        }
                    }
                }
                StringBuilder pomsDir = new StringBuilder().append(homeDir.toAbsolutePath()).append(File.separator).append(artifactProductHomes.get(filePath)).append(File.separator).append(POM_DIRECTORY);
                Path pomFile = PomProcessor.getFilePath(pomsDir.toString(), (GroupNameVersion)module, "pom");
                Path locationFile = PomProcessor.getFilePath(pomsDir.toString(), (GroupNameVersion)module, "location");
                if (RegenerationHelper.getInstance().getQueryMode()) {
                    if (Files.exists(pomFile, new LinkOption[0])) {
                        RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
                    }
                    if (!Files.exists(locationFile, new LinkOption[0])) continue;
                    RegenerationHelper.getInstance().addFilesToRegenerate(locationFile);
                    continue;
                }
                PomProcessor.writePomFile(module, pomFile, comp, filePath);
                compPomFiles.add(pomFile);
                PomProcessor.writeLocationFile(module, locationFile, filePath);
                compPomFiles.add(locationFile);
            }
            if (compPomFiles.isEmpty() || installerWrapper == null) continue;
            installerWrapper.addExtraFilesToDeInstallInfo(comp.getName(), comp.getVersion(), compPomFiles, false);
        }
    }

    private static void processPendingFeatureAggregatePoms(InstallerWrapper installerWrapper) throws GdrException, IOException, DataHandlerException, DependencyManagementException {
        for (Map.Entry<FeatureSet, Module> entry : featureAggregatePoms.entrySet()) {
            FeatureSet feature = entry.getKey();
            Module featureModule = entry.getValue();
            List dependencies = featureModule.getDependencies();
            boolean generateFiles = !installerWrapper.getHome().getInstalledFeatures().contains(feature) || PomProcessor.featureNeedsRegen(feature);
            String pomsDir = installerWrapper.getHome().getHomePath().toAbsolutePath().resolve(featureProductHomes.get(feature)).resolve(POM_DIRECTORY).toString();
            ArrayList<Path> pomFiles = new ArrayList<Path>();
            if (feature.getDependency() != null && feature.getDependency().hasPomGen()) {
                for (DependencyRef depRef : FeatureSetHelper.getInstance().getFeatureDependencies(feature)) {
                    if (!depRef.hasPomGen()) continue;
                    FeatureSet depFeature = FeatureSetHelper.getInstance().getFeatureDependency(depRef, installerWrapper.getSelectedFeatures());
                    if (depFeature == null) {
                        depFeature = FeatureSetHelper.getInstance().getFeatureDependency(depRef, installerWrapper.getHome().getInstalledFeatures());
                    }
                    if (depFeature == null) {
                        _log.warning("FeatureSet dependency " + depRef + " from FeatureSet " + feature + " was not found.");
                        continue;
                    }
                    if (depFeature.hasPomGen() && featureAggregatePoms.containsKey(depFeature)) {
                        Module depModule = featureAggregatePoms.get(depFeature);
                        DependencyImpl dep = new DependencyImpl(depModule.getGroup(), depModule.getName(), PomProcessor.generateDependencyVersion(depModule.getVersionString()), "pom");
                        dependencies.add(dep);
                        continue;
                    }
                    _log.fine("POM generation for dependent feature " + depFeature + " has been disabled");
                }
            }
            featureModule.setDependencies(dependencies);
            if (generateFiles) {
                Path pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)featureModule, "pom");
                if (RegenerationHelper.getInstance().getQueryMode() && Files.exists(pomFile, new LinkOption[0])) {
                    RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
                }
                PomProcessor.writePomFile(featureModule, pomFile, feature);
                pomFiles.add(pomFile);
            }
            if (pomFiles.isEmpty() || installerWrapper == null) continue;
            installerWrapper.addExtraFilesToDeInstallInfo(feature.getName(), feature.getVersion(), pomFiles, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void processPendingFeaturePom(FeatureLibrary library, LibraryTargetHolder holder, Mode mode, LibraryKey key, InstallerWrapper installerWrapper, JarLibraryHandler libHandler) throws GdrException, DependencyManagementException, IOException, DataHandlerException {
        productHome = holder.getProductHome(library, mode);
        modulePath = FileUtils.formatPath(libHandler.getAbsoluteFeaturesetJarPaths(key, holder).get(0), "/");
        regex = FileUtils.formatPath(installerWrapper.getHome().toString(), "/");
        libPath = productHome + modulePath.replaceFirst(regex, "");
        dependencies = new ArrayList<Object>();
        feature = holder.getFeature();
        pomFiles = new ArrayList<Path>();
        if (LibraryType.manifest.equals((Object)key.getType())) {
            block5: for (LibraryEntryLocation entry : libHandler.getFeatureLibraryEntryLocations(holder, key)) {
                target = entry.getLibraryTarget();
                if (target != null) {
                    comp = target.getComponent();
                    componentModules = PomProcessor.compModules.get(comp);
                    if (componentModules != null && componentModules.containsKey(FileUtils.formatPath(entry.getFullPath()))) {
                        depModule = componentModules.get(FileUtils.formatPath(entry.getFullPath()));
                        dep = new DependencyImpl(depModule.getGroup(), depModule.getName(), PomProcessor.generateDependencyVersion(depModule.getVersionString()), depModule.getType());
                        if (dependencies.contains(dep)) continue;
                        dependencies.add(dep);
                        continue;
                    }
                    PomProcessor._log.warning("POM for entry " + entry + " not found for library " + key.getName() + " " + key.getVersion());
                    continue;
                }
                for (Map featureEntry : PomProcessor.featureModules.values()) {
                    if (!featureEntry.containsKey(entry.getFullPath())) continue;
                    depModule = (Module)featureEntry.get(entry.getFullPath());
                    dep = new DependencyImpl(depModule.getGroup(), depModule.getName(), PomProcessor.generateDependencyVersion(depModule.getVersionString()), depModule.getType());
                    if (dependencies.contains(dep)) continue block5;
                    dependencies.add(dep);
                    continue block5;
                }
            }
        } else if (LibraryType.mergedJar.equals((Object)key.getType())) {
            jar = null;
            try {
                jarFile = installerWrapper.getHome().getHomePath().resolve(libPath);
                if (!Files.exists(jarFile, new LinkOption[0]) || (man = (jar = new JarFile(jarFile.toFile())).getManifest()) == null || StringUtil.isNullOrEmpty((String)(classpath = (attrs = man.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)))) ** GOTO lbl59
                for (String path : paths = classpath.split("\\s")) {
                    parentPath = installerWrapper.getHome().getHomePath().resolve(libPath).getParent();
                    classpathFile = parentPath.resolve(path);
                    canonicalPath = FileUtils.formatPath(classpathFile.normalize().toString(), "/");
                    destPath = canonicalPath.replaceFirst(localRegex = FileUtils.formatPath(installerWrapper.getHome().getHomePath().normalize().toString(), "/") + "/", "");
                    dep = PomProcessor.resolveClasspathDependency(feature, installerWrapper, destPath);
                    if (dep != null) {
                        if (dependencies.contains(dep)) continue;
                        dependencies.add(dep);
                        continue;
                    }
                    PomProcessor._log.warning("POM for entry " + destPath + " not found for library " + key.getName() + " " + key.getVersion());
                }
            }
            catch (ZipException e) {
                PomProcessor._log.warning("Jar file " + libPath + " is empty or corrupt. Skipping dependencies for that file's POM");
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
            }
        }
lbl59:
        // 6 sources

        pomsDir = installerWrapper.getHome().getHomePath().resolve(productHome).resolve(PomProcessor.POM_DIRECTORY).toString();
        module = PomProcessor.featureModules.get(feature).get(libPath);
        if (!dependencies.isEmpty()) {
            module.setDependencies(dependencies);
        }
        pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "pom");
        locationFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "location");
        if (RegenerationHelper.getInstance().getQueryMode()) {
            if (Files.exists(pomFile, new LinkOption[0])) {
                RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
            }
            if (!LibraryType.manifest.equals((Object)key.getType()) && Files.exists(locationFile, new LinkOption[0])) {
                RegenerationHelper.getInstance().addFilesToRegenerate(locationFile);
            }
        } else {
            PomProcessor.writePomFile(module, pomFile, feature, key);
            pomFiles.add(pomFile);
            if (!LibraryType.manifest.equals((Object)key.getType())) {
                PomProcessor.writeLocationFile(module, locationFile, libPath);
                pomFiles.add(locationFile);
            }
            if (installerWrapper != null) {
                installerWrapper.addExtraFilesToDeInstallInfo(feature.getName(), feature.getVersion(), pomFiles, true);
            }
        }
    }

    private static Dependency resolveClasspathDependency(FeatureSet feature, InstallerWrapper installerWrapper, String destPath) throws GdrException, IOException, DataHandlerException {
        Set<Component> components = installerWrapper.getComponents(feature);
        for (Component comp : components) {
            Map<String, Module> componentModules = compModules.get(comp);
            if (componentModules == null || !componentModules.containsKey(FileUtils.formatPath(destPath))) continue;
            Module module = componentModules.get(FileUtils.formatPath(destPath));
            return new DependencyImpl(module.getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType());
        }
        Map<String, Module> featureMods = featureModules.get(feature);
        if (featureMods != null && featureMods.containsKey(destPath)) {
            Module module = featureMods.get(destPath);
            return new DependencyImpl(module.getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType());
        }
        if (feature.getDependency() != null && feature.getDependency().hasPomGen()) {
            for (DependencyRef depRef : FeatureSetHelper.getInstance().getFeatureDependencies(feature)) {
                if (!depRef.hasPomGen()) continue;
                FeatureSet depFeature = FeatureSetHelper.getInstance().getFeatureDependency(depRef, installerWrapper.getSelectedFeatures());
                if (depFeature == null) {
                    depFeature = FeatureSetHelper.getInstance().getFeatureDependency(depRef, installerWrapper.getHome().getInstalledFeatures());
                }
                if (depFeature == null) {
                    GdrException e = new GdrException("FeatureSet dependency " + depRef + " from FeatureSet " + feature + " was not found.");
                    _log.throwing(PomProcessor.class.getName(), "resolveClasspathDependency", e);
                    throw e;
                }
                Dependency dep = PomProcessor.resolveClasspathDependency(depFeature, installerWrapper, destPath);
                if (dep == null) continue;
                return dep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingComponentPom(LibraryKey key, LibraryTargetHolder holder, LibraryHandler libHandler, Mode mode, InstallerWrapper installerWrapper) throws DependencyManagementException, GdrException, IOException, DataHandlerException {
        Home home = installerWrapper.getHome();
        ArrayList<Path> compPomFiles = new ArrayList<Path>();
        for (LibraryTarget target : holder.getLibraryTargets(key)) {
            String modulePath = FileUtils.formatPath(((JarLibraryHandler)libHandler).getAbsoluteComponentJarPaths(key, target).get(0));
            modulePath = FileUtils.formatPath(modulePath, "/");
            String regex = FileUtils.formatPath(home.toString(), "/");
            String productHome = target.getProductHome(mode);
            String libPath = FileUtils.formatPath(productHome + modulePath.replaceFirst(regex, ""));
            Component comp = target.getComponent();
            Map<String, Module> customModules = compModules.get(comp);
            ArrayList<DependencyImpl> dependencies = new ArrayList<DependencyImpl>();
            if (LibraryType.mergedJar.equals((Object)key.getType()) && target.getLibrary().getClasspathJars() != null) {
                try (ZipFile jar = null;){
                    Attributes attrs;
                    String classpath;
                    Manifest man;
                    Path jarFile = home.getHomePath().resolve(libPath);
                    if (Files.exists(jarFile, new LinkOption[0]) && (man = ((JarFile)(jar = new JarFile(jarFile.toFile()))).getManifest()) != null && !StringUtil.isNullOrEmpty((String)(classpath = (attrs = man.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)))) {
                        String[] paths;
                        for (String path : paths = classpath.split("\\s")) {
                            Path classpathFile = home.getHomePath().resolve(libPath).getParent().resolve(path);
                            String canonicalPath = FileUtils.formatPath(classpathFile.normalize().toString(), "/");
                            String localRegex = FileUtils.formatPath(home.getHomePath().normalize().toString(), "/") + "/";
                            String destPath = canonicalPath.replaceFirst(localRegex, "");
                            DependencyImpl dep = null;
                            if (customModules.containsKey(FileUtils.formatPath(destPath))) {
                                Module module = customModules.get(FileUtils.formatPath(destPath));
                                dep = new DependencyImpl(module.getGroup(), module.getName(), PomProcessor.generateDependencyVersion(module.getVersionString()), module.getType());
                            }
                            if (dep == null || dependencies.contains(dep)) continue;
                            dependencies.add(dep);
                        }
                    }
                }
            }
            String groupId = target.getLibrary().getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)target.getLibrary().getDefaultPomOverride().getGroup()) ? (StringUtil.isNullOrEmpty((String)comp.getGroupId()) ? COMP_LIBRARY_GROUP : comp.getGroupId()) : target.getLibrary().getDefaultPomOverride().getGroup();
            String artifact = target.getLibrary().getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)target.getLibrary().getDefaultPomOverride().getArtifact()) ? comp.getName() + "." + key.getName() : target.getLibrary().getDefaultPomOverride().getArtifact();
            String version = target.getLibrary().getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)target.getLibrary().getDefaultPomOverride().getVersion()) ? PomProcessor.generateVersion(target.getVersion().toString()) : target.getLibrary().getDefaultPomOverride().getVersion();
            String pomsDir = home.getHomePath().toAbsolutePath().resolve(productHome).resolve(POM_DIRECTORY).toString();
            ModuleImpl module = new ModuleImpl(groupId, artifact, version, "jar");
            if (!dependencies.isEmpty()) {
                module.setDependencies(dependencies);
            }
            Path pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "pom");
            Path locationFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)module, "location");
            if (RegenerationHelper.getInstance().getQueryMode()) {
                if (Files.exists(pomFile, new LinkOption[0])) {
                    RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
                }
                if (!Files.exists(locationFile, new LinkOption[0])) continue;
                RegenerationHelper.getInstance().addFilesToRegenerate(locationFile);
                continue;
            }
            PomProcessor.writePomFile((Module)module, pomFile, comp, key);
            compPomFiles.add(pomFile);
            PomProcessor.writeLocationFile((Module)module, locationFile, libPath);
            compPomFiles.add(locationFile);
            if (compPomFiles.isEmpty() || installerWrapper == null) continue;
            installerWrapper.addExtraFilesToDeInstallInfo(comp.getName(), comp.getVersion(), compPomFiles, false);
        }
    }

    private static void resetStatus() {
        _overwritePoms = false;
        compModules.clear();
        featureModules.clear();
        pendingPoms.clear();
        defaultComponentModules.clear();
        featureAggregatePoms.clear();
        artifactProductHomes.clear();
        featureProductHomes.clear();
        componentAggregatePoms.clear();
        featureGroupIds.clear();
        moduleCollisionList.clear();
    }

    private static Map<String, FileTarget> getRepoFileLocations(PomComponentDefinition compPom, Collection<ComponentTarget> componentTargets) throws GdrException {
        HashMap<String, FileTarget> modulePaths = new HashMap<String, FileTarget>();
        String pomId = compPom.getRefId();
        for (ComponentTarget compTarget : componentTargets) {
            for (FileTarget fileTarget : compTarget.getFileTargets()) {
                if (fileTarget.getId() == null || !fileTarget.getId().equals(pomId)) continue;
                PomProcessor.validateFileTarget(fileTarget);
                Path dest = NioHelper.getInstance().getPath(fileTarget.getDest(), new String[0]);
                if (Files.isDirectory(dest, new LinkOption[0])) continue;
                modulePaths.put(fileTarget.getDest(), fileTarget);
            }
        }
        return modulePaths;
    }

    private static String getFeatureSetProductHome(FeatureSet feature, LibraryTargetHolder holder, Mode mode, DirectoryMap dirMap, InstallerWrapper installerWrapper) throws GdrException, IOException, DataHandlerException {
        String productHome = "";
        Set<Component> components = installerWrapper.getComponents(feature);
        if (components != null && !components.isEmpty()) {
            productHome = PomProcessor.getProductHome(components.iterator().next().getComponentTargets().iterator().next().getSymbol(), dirMap);
        }
        if (!StringUtil.isNullOrEmpty((String)productHome)) {
            return productHome;
        }
        Collection<LibraryKey> libKeys = holder.getFeatureLibraryKeys();
        if (libKeys != null && !libKeys.isEmpty()) {
            productHome = holder.getProductHome(holder.getFeatureLibrary(libKeys.iterator().next()), mode);
        }
        if (!StringUtil.isNullOrEmpty((String)productHome)) {
            return productHome;
        }
        if (feature.getDependency() != null) {
            for (DependencyRef depRef : FeatureSetHelper.getInstance().getFeatureDependencies(feature)) {
                if (!depRef.hasPomGen()) continue;
                FeatureSet depFeature = FeatureSetHelper.getInstance().getFeatureDependency(depRef, installerWrapper.getSelectedFeatures());
                if (depFeature == null) {
                    depFeature = FeatureSetHelper.getInstance().getFeatureDependency(depRef, installerWrapper.getHome().getInstalledFeatures());
                }
                if (depFeature == null) {
                    GdrException e = new GdrException("FeatureSet dependency " + depRef + " from FeatureSet " + feature + " was not found.");
                    _log.throwing(PomProcessor.class.getName(), "getFeatureSetProductHome", e);
                    throw e;
                }
                productHome = PomProcessor.getFeatureSetProductHome(depFeature, holder, mode, dirMap, installerWrapper);
                if (StringUtil.isNullOrEmpty((String)productHome)) continue;
                return productHome;
            }
        }
        if (StringUtil.isNullOrEmpty((String)productHome)) {
            _log.warning("Could not determine symbol for featureset POM in feature " + feature);
        }
        return productHome;
    }

    private static boolean isMavenPlugin(String dest) {
        String[] dirs = FileUtils.formatPath(dest, "/").split("/");
        return dirs.length > 3 && dirs[1].equals("plugins") && dirs[2].equals("maven");
    }

    private static boolean isMavenType(String dest) {
        return dest.endsWith(".jar") || dest.endsWith(".ejb") || dest.endsWith(".rar") || dest.endsWith(".par");
    }

    private static boolean hasJarFormat(String dest) {
        return dest.endsWith(".jar") || dest.endsWith(".ejb") || dest.endsWith(".rar");
    }

    public static String getFileName(String dest) {
        String[] fileDirs = dest.split("/");
        String[] fileParts = fileDirs[fileDirs.length - 1].split("\\.");
        StringBuilder finalName = new StringBuilder();
        finalName.append(fileParts[0]);
        for (int i = 1; i < fileParts.length - 1; ++i) {
            finalName.append(".").append(fileParts[i]);
        }
        return finalName.toString();
    }

    public static String getFileExtension(String dest) {
        String[] fileDirs = dest.split("\\.");
        return fileDirs[fileDirs.length - 1];
    }

    private static String getFilePath(String path) {
        if (path.contains(":")) {
            String[] pathParts = path.split(":");
            return FileUtils.formatPath(pathParts[1].trim());
        }
        return path;
    }

    private static String getStaticPomFilePath(Path staticPom) throws IOException {
        Path locationFile = staticPom.getParent().resolve(PomProcessor.getFileName(staticPom.toString()) + ".location");
        String path = staticPom.toString();
        if (Files.exists(locationFile, new LinkOption[0])) {
            try (BufferedReader br = Files.newBufferedReader(locationFile, StandardCharsets.UTF_8);){
                String tempPath = br.readLine();
                if (!StringUtil.isNullOrEmpty((String)tempPath)) {
                    path = FileUtils.formatPath(tempPath);
                }
                _log.warning("Empty path provided in location file " + locationFile.toAbsolutePath() + ". POM " + staticPom.toAbsolutePath() + " will not be added to any library dependencies.");
            }
        } else {
            _log.warning("A location file for static POM " + staticPom.toAbsolutePath() + " could not be found. This POM will not be added to any library dependencies.");
        }
        return path;
    }

    public static String getArtifactName(String name) {
        if (name.startsWith("oracle.")) {
            name = name.replaceFirst("oracle.", "");
        }
        return name;
    }

    public static Module generateArtifactModule(Component comp, FileTarget file) {
        String groupId = comp.getDefaultPomOverride() == null || StringUtil.isNullOrEmpty((String)comp.getDefaultPomOverride().getGroup()) ? (StringUtil.isNullOrEmpty((String)comp.getGroupId()) ? POM_PREFIX + PomProcessor.getArtifactName(comp.getName()) : comp.getGroupId()) : comp.getDefaultPomOverride().getGroup();
        ModuleImpl module = new ModuleImpl(groupId, PomProcessor.getFileName(file.getDest()), PomProcessor.generateVersion(comp.getVersion()), PomProcessor.getFileExtension(file.getDest()));
        PomProcessor.recalculateModule((Module)module, FileUtils.formatPath(file.getDest()));
        return module;
    }

    private static List<String> generateSuppressList(List<PomReference> suppressPoms, DirectoryMap dirMap) throws GdrException {
        ArrayList<String> suppressedArtifacts = new ArrayList<String>();
        for (PomReference sup : suppressPoms) {
            String productHome = PomProcessor.getProductHome(sup.getSymbol(), dirMap);
            String dest = productHome + File.separator + FileUtils.formatPath(sup.getFile());
            suppressedArtifacts.add(dest);
        }
        return suppressedArtifacts;
    }

    private static String generateFeatureGroupId(FeatureSet feature, Collection<Component> comps, InstallerWrapper installerWrapper, FeatureSelectionTarget selectionTarget) throws GdrException, IOException, DataHandlerException {
        String groupId;
        if (!featureGroupIds.containsKey(feature) && !StringUtil.isNullOrEmpty((String)(groupId = PomProcessor.retrieveGroupId(feature, comps, installerWrapper, selectionTarget)))) {
            featureGroupIds.put(feature, groupId);
        }
        if (feature.getDefaultPomOverride() != null && !StringUtil.isNullOrEmpty((String)feature.getDefaultPomOverride().getGroup())) {
            return feature.getDefaultPomOverride().getGroup();
        }
        if (featureGroupIds.containsKey(feature)) {
            return featureGroupIds.get(feature);
        }
        return FEATURE_GROUP;
    }

    private static String retrieveGroupId(FeatureSet feature, Collection<Component> comps, InstallerWrapper installerWrapper, FeatureSelectionTarget selectionTarget) throws GdrException, IOException, DataHandlerException {
        for (Component comp : comps) {
            if (StringUtil.isNullOrEmpty((String)comp.getGroupId())) continue;
            return comp.getGroupId();
        }
        if (feature.getDependency() != null && selectionTarget != null) {
            for (FeatureSet depFeature : selectionTarget.getDirectDependencies(feature)) {
                String groupId = PomProcessor.retrieveGroupId(depFeature, installerWrapper.getComponents(depFeature), installerWrapper, selectionTarget);
                if (StringUtil.isNullOrEmpty((String)groupId)) continue;
                return groupId;
            }
        }
        return null;
    }

    public static String generateVersion(String version) {
        int i;
        String[] versionDigits = version.split("\\.");
        String[] completeVersionDigits = new String[5];
        for (i = 0; i < versionDigits.length; ++i) {
            completeVersionDigits[i] = versionDigits[i];
        }
        while (i < completeVersionDigits.length) {
            completeVersionDigits[i] = "0";
            ++i;
        }
        return completeVersionDigits[0] + "." + completeVersionDigits[1] + "." + completeVersionDigits[2] + "-" + completeVersionDigits[3] + "-" + completeVersionDigits[4];
    }

    private static String generateDependencyVersion(String version) {
        String lowVersion = PomProcessor.generateShortenedVersion(version);
        String[] versionDigits = lowVersion.split("-");
        versionDigits[versionDigits.length - 1] = Long.parseLong(versionDigits[versionDigits.length - 1]) + 1L + "";
        StringBuilder hiVersion = new StringBuilder();
        for (int i = 0; i < versionDigits.length; ++i) {
            if (i < versionDigits.length - 1) {
                hiVersion.append(versionDigits[i]).append("-");
                continue;
            }
            hiVersion.append(versionDigits[i]);
        }
        return "[" + lowVersion + "," + hiVersion + ")";
    }

    private static String generateShortenedVersion(String version) {
        int index = version.lastIndexOf("-");
        if (index > -1) {
            return version.substring(0, index);
        }
        _log.warning("Incorrect POM module version found: " + version);
        String newVersion = ComponentHelper.getShortenedVersion(version);
        return newVersion + "-0";
    }

    private static String getDependencyVersion(PomArtifact dependencyPom, String pomRef) throws PomException {
        String dependencyVersion = dependencyPom.getDependencyVersion();
        if (StringUtil.isNullOrEmpty((String)dependencyVersion) && !StringUtil.isNullOrEmpty((String)pomRef)) {
            dependencyVersion = pomRef;
        }
        PomProcessor.validateDependencyVersion(dependencyVersion);
        return dependencyVersion;
    }

    private static Dependency getDependencyModule(String destPath) throws GdrException {
        for (Map<String, Module> map : compModules.values()) {
            if (!map.containsKey(destPath)) continue;
            Module mod = map.get(destPath);
            return new DependencyImpl(mod.getGroup(), mod.getName(), PomProcessor.generateDependencyVersion(mod.getVersionString()), mod.getType());
        }
        return null;
    }

    private static void validateDependencyVersion(String dependencyVersion) throws PomException {
        if (StringUtil.isNullOrEmpty((String)dependencyVersion)) {
            PomException ex = new PomException("Dependency-version needs to be specified for pom reference " + dependencyVersion);
            _log.throwing(PomProcessor.class.getName(), "validateDependencyVersion", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private static String getComponentProductHome(Component comp, DirectoryMap dirMap) throws GdrException {
        String symbol = comp.getFileMaps().get(0).getSymbol();
        return PomProcessor.getProductHome(symbol, dirMap);
    }

    private static String getProductHome(String symbol, DirectoryMap dirMap) throws GdrException {
        Collection<String> rootDirs = DistributionHelper.getInstance().getRootDirsForSymbol(dirMap, symbol);
        if (rootDirs.size() > 1) {
            _log.warning("The symbol " + symbol + " is mapped to more than one directory. Use a different symbol for the POM");
        }
        if (!rootDirs.isEmpty()) {
            return rootDirs.iterator().next();
        }
        PomException ex = new PomException("Unable to locate symbol " + symbol + " for POM generation.");
        _log.throwing(PomProcessor.class.getName(), "getProductHome", (Throwable)((Object)ex));
        throw ex;
    }

    private static List<String> getCompPomLocations(PomComponentDefinition artifact, Collection<ComponentTarget> compTargets, Mode mode) throws GdrException {
        ArrayList<String> modulePaths = new ArrayList<String>();
        if (compTargets != null && !compTargets.isEmpty()) {
            for (PomFile pomFile : artifact.getLocations()) {
                String path = FileUtils.formatPath(pomFile.getLocation());
                if (artifact.getLocations().size() > 1 && StringUtil.isNullOrEmpty((String)pomFile.getClassifier())) {
                    GdrException e = new GdrException("Empty classifier found for file " + path + " in POM definition");
                    _log.throwing(PomProcessor.class.getName(), "getCompPomLocations", e);
                    throw e;
                }
                String productHome = null;
                for (ComponentTarget compTarget : compTargets) {
                    FileTarget fileTarget = compTarget.locateFileTarget(path, mode);
                    if (fileTarget == null) continue;
                    productHome = compTarget.getLocation();
                    path = productHome + File.separator + path;
                    if (artifact.getLocations().size() > 1) {
                        path = pomFile.getClassifier() + ": " + path;
                    }
                    modulePaths.add(path);
                    break;
                }
                if (productHome != null) continue;
                _log.warning("Unable to locate file or directory corresponding to POM location: " + path);
                return null;
            }
        } else {
            _log.warning("Could not validate artifact " + artifact + ", the provided directory map was empty");
        }
        return modulePaths;
    }

    private static List<String> getLibraryLocation(PomLibraryRef libRef, LibraryTargetHolder holder, Component comp, Mode mode) throws GdrException {
        if (holder != null) {
            for (LibraryKey key : holder.getLibraryKeys(LibraryType.getLibraryType(libRef.getType()), libRef.getName(), new LibraryVersion(libRef.getVersion()), false, holder.getFeature().isSingleton())) {
                List<LibraryTarget> targets = holder.getLibraryTargets(key);
                if (targets == null || targets.isEmpty() || key.getType().isNone() || key.getVisibility().isNone()) continue;
                for (LibraryTarget target : targets) {
                    if (!target.getComponent().equals(comp)) continue;
                    ArrayList<String> modulePaths = new ArrayList<String>();
                    modulePaths.add(FileUtils.formatPath(target.getProductHome(mode) + File.separator + target.getLibraryJarLocations().get(0)));
                    return modulePaths;
                }
            }
        }
        _log.warning("Unable to locate library " + libRef.getName() + " " + libRef.getVersion() + " ");
        return null;
    }

    private static void validateArtifact(PomArtifact artifact) throws PomException {
        if (StringUtil.isNullOrEmpty((String)artifact.getArtifact()) || StringUtil.isNullOrEmpty((String)artifact.getVersion()) || StringUtil.isNullOrEmpty((String)artifact.getGroup())) {
            PomException ex = new PomException("Invalid artifact: " + artifact);
            _log.throwing(PomProcessor.class.getName(), "validateArtifact", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private static void validateFileTarget(FileTarget fileTarget) throws PomException {
        if (StringUtil.isNullOrEmpty((String)fileTarget.getArtifact()) || StringUtil.isNullOrEmpty((String)fileTarget.getVersion()) || StringUtil.isNullOrEmpty((String)fileTarget.getGroup())) {
            PomException ex = new PomException("Invalid file target: " + fileTarget);
            _log.throwing(PomProcessor.class.getName(), "validateFileTarget", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private static void generatePomFile(String pomsDir, Module subModule, Collection<Path> generatedFiles) throws IOException, DependencyManagementException {
        Path pomFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)subModule, "pom");
        if (RegenerationHelper.getInstance().getQueryMode() && Files.exists(pomFile, new LinkOption[0])) {
            RegenerationHelper.getInstance().addFilesToRegenerate(pomFile);
        } else {
            if (!PomProcessor.writePomFile(subModule, pomFile)) {
                _log.severe("POM file already exists in " + pomFile.toAbsolutePath() + ".");
            }
            generatedFiles.add(pomFile);
        }
    }

    private static void generatePomAndLocationFiles(String pomsDir, Module subModule, Collection<Path> generatedFiles, String modulePath) throws IOException, DependencyManagementException {
        ArrayList<String> modulePaths = new ArrayList<String>();
        modulePaths.add(modulePath);
        PomProcessor.generatePomAndLocationFiles(pomsDir, subModule, generatedFiles, modulePaths);
    }

    private static void generatePomAndLocationFiles(String pomsDir, Module subModule, Collection<Path> generatedFiles, List<String> modulePaths) throws IOException, DependencyManagementException {
        PomProcessor.generatePomFile(pomsDir, subModule, generatedFiles);
        Path locationFile = PomProcessor.getFilePath(pomsDir, (GroupNameVersion)subModule, "location");
        if (RegenerationHelper.getInstance().getQueryMode() && Files.exists(locationFile, new LinkOption[0])) {
            RegenerationHelper.getInstance().addFilesToRegenerate(locationFile);
        } else {
            PomProcessor.writeLocationFile(subModule, locationFile, modulePaths);
            generatedFiles.add(locationFile);
        }
    }

    private static Path getFilePath(String parentDir, GroupNameVersion artifact, String ext) {
        String[] moduleDirs;
        StringBuilder moduleSubPath = new StringBuilder();
        for (String dir : moduleDirs = artifact.getGroup().split("\\.")) {
            moduleSubPath.append(dir).append(File.separator);
        }
        moduleSubPath.append(artifact.getName()).append(File.separator);
        moduleSubPath.append(ComponentHelper.getShortenedVersion(artifact.getVersionString())).append(File.separator);
        moduleSubPath.append(artifact.getName()).append("-").append(ComponentHelper.getShortenedVersion(artifact.getVersionString())).append(".").append(ext);
        return NioHelper.getInstance().getPath(parentDir, new String[0]).resolve(moduleSubPath.toString());
    }

    private static void writePomFile(Module module, Path pomFile, Component comp) throws IOException, DependencyManagementException {
        if (!PomProcessor.writePomFile(module, pomFile)) {
            _log.severe("POM file already exists in " + pomFile.toAbsolutePath() + ". Aggregate POM for Component " + comp + " couldn't be generated.");
        }
    }

    private static void writePomFile(Module module, Path pomFile, FeatureSet feature) throws IOException, DependencyManagementException {
        if (!PomProcessor.writePomFile(module, pomFile)) {
            _log.severe("POM file already exists in " + pomFile.toAbsolutePath() + ". Aggregate POM for FeatureSet " + feature + " couldn't be generated.");
        }
    }

    private static void writePomFile(Module module, Path pomFile, Component comp, String path) throws IOException, DependencyManagementException {
        if (!PomProcessor.writePomFile(module, pomFile)) {
            if (moduleCollisionList.get(module).equals(path)) {
                --errorsFound;
            } else {
                _log.severe("POM file already exists in " + pomFile.toAbsolutePath() + ". POM for file " + path + " from component " + comp + " couldn't be generated.");
            }
        }
    }

    private static void writePomFile(Module module, Path pomFile, Component comp, LibraryKey key) throws IOException, DependencyManagementException {
        if (!PomProcessor.writePomFile(module, pomFile)) {
            _log.severe("POM file already exists in " + pomFile.toAbsolutePath() + ". POM for library " + key.getName() + " from component " + comp + " couldn't be generated.");
        }
    }

    private static void writePomFile(Module module, Path pomFile, FeatureSet feature, LibraryKey key) throws IOException, DependencyManagementException {
        if (!PomProcessor.writePomFile(module, pomFile)) {
            _log.severe("POM file already exists in " + pomFile.toAbsolutePath() + ". POM for library " + key.getName() + " from FeatureSet " + feature + " couldn't be generated.");
        }
    }

    private static boolean writePomFile(Module module, Path pomFilePath) throws IOException, DependencyManagementException {
        if (pomFilePath.getParent() == null) {
            IOException ex = new IOException("Invalid file path detected: " + pomFilePath);
            _log.throwing(PomProcessor.class.getName(), "generatePomFile", ex);
            throw ex;
        }
        if (!Files.exists(pomFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(pomFilePath.getParent(), new FileAttribute[0]);
            if (!Files.exists(pomFilePath.getParent(), new LinkOption[0])) {
                IOException ex = new IOException("Couldn't create directory " + pomFilePath.getParent());
                _log.throwing(PomProcessor.class.getName(), "generatePomFile", ex);
                throw ex;
            }
        }
        if (!_overwritePoms) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(pomFilePath.getParent());){
                for (Path file : directoryStream) {
                    if (RegenerationHelper.isRegenerateState() || !file.toAbsolutePath().equals(pomFilePath.toAbsolutePath())) continue;
                    ++errorsFound;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        PomProcessor.legalizeModule(module);
        Files.deleteIfExists(pomFilePath);
        try (OutputStream is = Files.newOutputStream(pomFilePath, new OpenOption[0]);){
            fileHandler.writeDependenciesFile(module, is);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void legalizeModule(Module module) {
        Map<String, String> additionalInfo = null;
        LegalInformationImpl legalInfo = null;
        if (_legalModelInfo == null) {
            _legalModelInfo = new Model();
            Path legalFile = PomProcessor.loadLegalInfoFile();
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                docFactory.setExpandEntityReferences(false);
                docFactory.setNamespaceAware(true);
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                try (InputStream is = Files.newInputStream(legalFile, new OpenOption[0]);){
                    Document document = docBuilder.parse(is);
                    JAXBContext contextReader = JAXBContext.newInstance((String)"com.oracle.cie.dependency.mgmt.xml.mvn");
                    Unmarshaller unmarshaller = contextReader.createUnmarshaller();
                    JAXBElement je = (JAXBElement)unmarshaller.unmarshal((Node)document);
                    _legalModelInfo = (Model)je.getValue();
                }
            }
            catch (JAXBException e) {
                _log.warning("Unable to parse the Legal Information XML file, please verify. Cause: " + (Object)((Object)e));
            }
            catch (SAXException e) {
                _log.warning("Unable to parse the Legal Information XML file, please verify. Cause: " + e);
            }
            catch (IOException e) {
                _log.warning("Unable to parse the Legal Information XML file, please verify. Cause: " + e);
            }
            catch (ParserConfigurationException e) {
                _log.warning("Unable to parse the Legal Information XML file, please verify. Cause: " + e);
            }
            finally {
                try {
                    Files.delete(legalFile);
                }
                catch (IOException e) {}
            }
        }
        try {
            additionalInfo = ComponentGroupIdService.getInstance().getLegaleseInformation(module.getGroup());
        }
        catch (GdrException e) {
            _log.warning("Unable to retrieve information from the Component Group ID Service. Cause: " + (Object)((Object)e));
        }
        catch (IOException e) {
            _log.warning("Unable to load the Legalese Information Properties file, please verify. Cause: " + e);
        }
        legalInfo = new LegalInformationImpl();
        legalInfo.setDescription(additionalInfo.get("description"));
        legalInfo.setUrl(additionalInfo.get("url"));
        legalInfo.setInceptionYear(additionalInfo.get("inception-year"));
        legalInfo.setOrganization(_legalModelInfo.getOrganization());
        legalInfo.setLicenses(_legalModelInfo.getLicenses());
        module.setLegalInformation((LegalInformation)legalInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path loadLegalInfoFile() {
        InputStream is = null;
        OutputStream fos = null;
        Path legalInfo = null;
        try {
            is = PomProcessor.class.getResourceAsStream("/resources/pom-legal-information.xml");
            if (is == null) {
                throw new IOException("Unable to locate POM Legal Information File for module legalization.");
            }
            legalInfo = NioHelper.getInstance().getPath(POM_LEGAL_INFO_FILE_NAME, new String[0]);
            fos = Files.newOutputStream(legalInfo, new OpenOption[0]);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
        }
        catch (IOException ioe) {
            _log.warning("Unable to process legalese resources. " + ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _log.warning(e + e.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    _log.warning(e + e.getMessage());
                }
            }
        }
        return legalInfo;
    }

    private static void writeLocationFile(Module module, Path locationFile, String contents) throws IOException {
        ArrayList<String> contentsList = new ArrayList<String>();
        contentsList.add(contents);
        PomProcessor.writeLocationFile(module, locationFile, contentsList);
    }

    private static boolean writeLocationFile(Module module, Path locationFile, List<String> contents) throws IOException {
        if (!Files.exists(locationFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(locationFile.getParent(), new FileAttribute[0]);
            if (!Files.exists(locationFile.getParent(), new LinkOption[0])) {
                IOException ex = new IOException("Couldn't create directory " + locationFile.getParent());
                _log.throwing(PomProcessor.class.getName(), "generateLocationFile", ex);
                throw ex;
            }
        }
        if (!_overwritePoms) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(locationFile.getParent());){
                for (Path file : directoryStream) {
                    if (!file.toAbsolutePath().equals(locationFile.toAbsolutePath())) continue;
                    for (String content : contents) {
                        if (module != null && moduleCollisionList.get(module).contains(content)) continue;
                        _log.severe("Location file already exists in " + locationFile.toAbsolutePath());
                        ++errorsFound;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        Files.deleteIfExists(locationFile);
        try (BufferedWriter bw = Files.newBufferedWriter(locationFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
            bw.write(FileUtils.formatPath(contents.get(0)));
            for (int i = 1; i < contents.size(); ++i) {
                bw.newLine();
                bw.write(FileUtils.formatPath(contents.get(i)));
            }
            boolean bl = true;
            return bl;
        }
    }

    private static PomArtifact getPomArtifact(PomArtifact pomRef, Set<Component> components, FeatureSet feature, InstallerWrapper installerWrapper, ComponentHelper compHelper, FeatureSetHelper helper, Set<FeatureSet> cycleCheck) throws PomException {
        cycleCheck.add(feature);
        for (PomArtifact pomArtifact : feature.getPoms()) {
            if (!pomArtifact.getGroup().equals(pomRef.getGroup()) || !pomArtifact.getArtifact().equals(pomRef.getArtifact()) || !pomArtifact.getVersion().equals(pomRef.getVersion())) continue;
            if (pomArtifact.getLibraryRef() == null) {
                pomArtifact.setType("pom");
            } else {
                pomArtifact.setType("jar");
            }
            return pomArtifact;
        }
        if (feature.hasPomGen() && pomRef.getGroup().equals(FEATURE_GROUP) && pomRef.getArtifact().equals(feature.getName()) && pomRef.getVersion().equals(PomProcessor.generateVersion(feature.getVersion()))) {
            return new PomArtifact(FEATURE_GROUP, feature.getName(), PomProcessor.generateVersion(feature.getVersion()), "pom");
        }
        for (ComponentReference componentReference : feature.getComponentReferences()) {
            Component comp = compHelper.getComponent(components, componentReference);
            if (comp == null) continue;
            for (PomGroup pomGroup : comp.getPomGroups()) {
                for (PomArtifact pomArtifact : pomGroup.getPoms()) {
                    if (!pomRef.getGroup().equals(pomArtifact.getGroup()) || !pomRef.getArtifact().equals(pomArtifact.getArtifact()) || !pomRef.getVersion().equals(pomArtifact.getVersion())) continue;
                    return pomArtifact;
                }
            }
            if (!comp.getPomGen().equals("true") || !pomRef.getGroup().equals(COMPONENT_GROUP) || !pomRef.getArtifact().equals(comp.getName()) || !pomRef.getVersion().equals(PomProcessor.generateVersion(comp.getVersion()))) continue;
            return new PomArtifact(COMPONENT_GROUP, comp.getName(), PomProcessor.generateVersion(comp.getVersion()), "pom");
        }
        Set<DependencyRef> dependencyRefs = helper.getFeatureDependencies(feature);
        if (dependencyRefs != null && !dependencyRefs.isEmpty()) {
            for (DependencyRef depRef : dependencyRefs) {
                PomException ex;
                try {
                    PomArtifact found;
                    FeatureSet dep = helper.getFeatureDependency(depRef, installerWrapper.getFeatureSets());
                    if (cycleCheck.contains(dep) || (found = PomProcessor.getPomArtifact(pomRef, components, dep, installerWrapper, compHelper, helper, cycleCheck)) == null) continue;
                    return found;
                }
                catch (GdrException e) {
                    ex = new PomException(e);
                    _log.throwing(PomProcessor.class.getName(), "getPomArtifact", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (IOException e) {
                    ex = new PomException(e);
                    _log.throwing(PomProcessor.class.getName(), "getPomArtifact", (Throwable)((Object)ex));
                    throw ex;
                }
                catch (DataHandlerException e) {
                    ex = new PomException(e);
                    _log.throwing(PomProcessor.class.getName(), "getPomArtifact", (Throwable)((Object)ex));
                    throw ex;
                }
            }
        }
        return null;
    }

    private static PomGroup getPomGroup(PomGroupRef pomGroupRef, Set<Component> components) {
        for (Component comp : components) {
            for (PomGroup pomGroup : comp.getPomGroups()) {
                if (pomGroup == null || !pomGroup.getName().equals(pomGroupRef.getName()) || !pomGroup.getVersion().equals(pomGroupRef.getVersion())) continue;
                return pomGroup;
            }
        }
        return null;
    }

    private static boolean componentNeedsRegen(Component comp, boolean componentIsInstalled) throws GdrException, IOException, DataHandlerException {
        if (RegenerationHelper.isRegenerateState()) {
            if (RegenerationHelper.getInstance().getPomComponentsToRegenerate().contains(comp) || RegenerationHelper.getInstance().getModifiedComponents().contains(comp) || RegenerationHelper.getInstance().needToRegenerateAllFiles()) {
                return true;
            }
            for (ComponentTarget compTarget : comp.getComponentTargets()) {
                for (FileTarget fileTarget : compTarget.getFileTargets()) {
                    Path destFile = NioHelper.getInstance().getPath(fileTarget.getDest(), new String[0]);
                    if (!RegenerationHelper.getInstance().getModifiedFiles().containsKey(destFile)) continue;
                    return true;
                }
            }
            return false;
        }
        return !componentIsInstalled;
    }

    private static boolean featureNeedsRegen(FeatureSet feature) {
        if (RegenerationHelper.isRegenerateState()) {
            return RegenerationHelper.getInstance().getPomFeatureSetsToRegenerate().contains(feature) || RegenerationHelper.getInstance().getModifiedFeatureSets().contains(feature) || RegenerationHelper.getInstance().needToRegenerateAllFiles();
        }
        return true;
    }

    static {
        FEATURE_LIBRARY_GROUP = FEATURE_GROUP = POM_PREFIX.substring(0, 10);
        COMP_LIBRARY_GROUP = COMPONENT_GROUP = POM_PREFIX.substring(0, 10);
        compModules = new HashMap<Component, Map<String, Module>>();
        defaultComponentModules = new HashMap<Component, Map<String, Module>>();
        featureModules = new HashMap<FeatureSet, Map<String, Module>>();
        pendingPoms = new HashMap<LibraryKey, LibraryTargetHolder>();
        featureAggregatePoms = new HashMap<FeatureSet, Module>();
        componentAggregatePoms = new HashMap<Component, Module>();
        artifactProductHomes = new HashMap<String, String>();
        featureProductHomes = new HashMap<FeatureSet, String>();
        featureGroupIds = new HashMap<FeatureSet, String>();
        moduleCollisionList = new HashMap<Module, String>();
        fileHandler = null;
        _legalModelInfo = null;
        errorsFound = 0;
        _overwritePoms = false;
    }
}

