/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.ReflectionHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.carbdiff.CarbDiff;
import com.oracle.cie.gdr.carbdiff.CarbDiffGenerator;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.MaintenanceAliasUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataPatchGenerator {
    private static MetadataPatchGenerator _instance;
    private Logger _log = Logger.getLogger(MetadataPatchGenerator.class.getName());
    private static String OPACK_METADATA_FACTORY_CLASS;
    private static String OPACK_METADATA_COMPONENT_CLASS;
    private static String OPACK_METADATA_PATCHING_JAR_ACTION;
    private static String OPACK_METADATA_MAINTENANCE_ALIAS;
    private static String OPACK_METADATA_MAINTENANCE_ALIAS_INFO;
    private static String OPACK_METADATA_MAINTENANCE_ALIAS_MAP;
    private static String OPACK_PATCH_GENERATOR;
    private String _version = "1.0";
    private ClassLoader _classLoader;

    private MetadataPatchGenerator(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public static MetadataPatchGenerator getInstance(ClassLoader classLoader) {
        if (null == _instance || _instance.getClassLoader() != classLoader) {
            _instance = new MetadataPatchGenerator(classLoader);
        }
        return _instance;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public File createMetaDataPatch(File outputDir, Map<String, String> bugs, CarbDiffGenerator carbDiffGen, String maintenanceAlias, String maintenanceAliasMappings) throws GdrException {
        File patch;
        ArrayList argTypes = new ArrayList();
        argTypes.add(Map.class);
        argTypes.add(File.class);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(bugs);
        args.add(outputDir);
        try {
            Object patchGenerator;
            Object ma;
            ArrayList<Object> componentList;
            if (carbDiffGen != null && !(componentList = new ArrayList<Object>(this.getComponentPatchingActions(carbDiffGen))).isEmpty()) {
                argTypes.add(List.class);
                args.add(componentList);
            }
            if (!StringUtil.isNullOrEmpty((String)maintenanceAlias) && (ma = this.getMaintenanceAliasInformation(maintenanceAlias, maintenanceAliasMappings)) != null) {
                argTypes.add(Class.forName(OPACK_METADATA_MAINTENANCE_ALIAS));
                args.add(ma);
            }
            if ((patch = (File)ReflectionHelper.process((String)OPACK_PATCH_GENERATOR, (Object)(patchGenerator = ReflectionHelper.processStaticMethod((String)OPACK_PATCH_GENERATOR, (String)"getInstance", null, null, (ClassLoader)this.getClassLoader())), (String)"buildMetadataPatch", (Class[])argTypes.toArray(new Class[0]), (Object[])args.toArray(), (ClassLoader)this.getClassLoader())) != null && patch.exists()) {
                this._log.finest("Metadata patch generated in the following location: " + patch.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new GdrException("Unable to generate metadata patch due to the following cause: " + e.getMessage(), (Throwable)e);
        }
        return patch;
    }

    private Object getMaintenanceAliasInformation(String maintenanceAliasList, String maintenanceAliasMappings) throws GdrException {
        Object metaDataFactory = this.getMetadataFactory();
        Object maintenanceAlias = null;
        try {
            String message;
            if (maintenanceAliasList == null || maintenanceAliasList.isEmpty()) {
                this._log.warning(MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY + " information was not specified.");
                return null;
            }
            String[] actionList = maintenanceAliasList.trim().split(MaintenanceAliasUtils.ACTION_SEPARATOR);
            try {
                if (actionList.length == 0 || actionList.length > 3) {
                    String message2 = "Unable to generate the maintenance alias information, incorrect format for " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY;
                    this._log.severe(message2);
                    throw new GdrException(message2);
                }
                for (String actionString : actionList) {
                    String[] maList;
                    String action = actionString.substring(0, actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR));
                    MaintenanceAliasUtils.ActionType actionType = MaintenanceAliasUtils.ActionType.getEnum(action);
                    if (actionType == null) {
                        message = "Undefined action: " + action + " found in " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY;
                        this._log.severe(message);
                        throw new GdrException(message);
                    }
                    for (String maString : maList = actionString.substring(actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR) + 1).split(MaintenanceAliasUtils.ARTIFACT_SEPARATOR)) {
                        String[] attributes = maString.split(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR);
                        if (attributes.length > 7 || attributes.length < 6) {
                            String message3 = "The " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY + " format is incorrect. Length: " + attributes.length + " value: " + attributes;
                            this._log.severe(message3);
                            throw new GdrException(message3);
                        }
                        String productFamily = "fmw";
                        String patchLevel = "";
                        String maintenanceAliasKey = attributes[0];
                        String product = "Product";
                        String bundleType = "BundleType";
                        String version = "Version";
                        String timestamp = "Timestamp";
                        String patchType = "Patch";
                        if (!actionType.isDelete()) {
                            product = attributes[1];
                            bundleType = attributes[2];
                            version = attributes[3];
                            timestamp = attributes[4];
                            patchType = attributes[5];
                            if (attributes.length == 7) {
                                patchLevel = attributes[6];
                            }
                        }
                        maintenanceAlias = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createMaintenanceAlias", null, null, (ClassLoader)this.getClassLoader());
                        Object maInfo = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createMaintenanceAliasInfo", (Class[])new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class}, (Object[])new Object[]{actionType.getShortName(), maintenanceAliasKey, patchLevel, product, productFamily, bundleType, version, timestamp, patchType}, (ClassLoader)this.getClassLoader());
                        ReflectionHelper.process((String)OPACK_METADATA_MAINTENANCE_ALIAS, (Object)maintenanceAlias, (String)"addMaintenanceAliasInfo", (Class[])new Class[]{Class.forName(OPACK_METADATA_MAINTENANCE_ALIAS_INFO)}, (Object[])new Object[]{maInfo}, (ClassLoader)this.getClassLoader());
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                String message4 = "Unable to generate maintenance alias information, invalid format for " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_PROPERTY + " value: " + actionList;
                this._log.severe(message4);
                throw new GdrException(message4, (Throwable)e);
            }
            Object maintenanceAliasMap = null;
            if (maintenanceAliasMappings == null || maintenanceAliasMappings.isEmpty()) {
                this._log.warning(MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY + " information was not specified.");
                return null;
            }
            for (String actionString : actionList = maintenanceAliasMappings.trim().split(MaintenanceAliasUtils.ACTION_SEPARATOR)) {
                try {
                    String action = actionString.substring(0, actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR));
                    actionString = actionString.substring(actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR) + 1);
                    MaintenanceAliasUtils.ActionType actionType = MaintenanceAliasUtils.ActionType.getEnum(action);
                    if (actionType == null) {
                        String message5 = "Undefined action: " + action + " found in " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY;
                        this._log.severe(message5);
                        throw new GdrException(message5);
                    }
                    String maintenanceAliasKey = actionString.substring(0, actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR));
                    String artifactTypeString = (actionString = actionString.substring(actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR) + 1)).substring(0, actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR));
                    MaintenanceAliasUtils.ArtifactType artifactType = MaintenanceAliasUtils.ArtifactType.getEnum(artifactTypeString);
                    if (artifactType == null) {
                        String message6 = "Undefined artifactType: " + artifactTypeString + " found in " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY;
                        this._log.severe(message6);
                        throw new GdrException(message6);
                    }
                    if (artifactType.isCarbType()) {
                        artifactTypeString = "C";
                    } else if (artifactType.isFeatureSetType()) {
                        artifactTypeString = "F";
                    } else if (artifactType.isDistributionType()) {
                        artifactTypeString = "D";
                    }
                    String[] actionArray = actionString.substring(actionString.indexOf(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR) + 1).split(MaintenanceAliasUtils.ARTIFACT_SEPARATOR);
                    ArrayList artifactInfos = new ArrayList();
                    for (String artifactRef : actionArray) {
                        String[] attributes = artifactRef.split(MaintenanceAliasUtils.ATTRIBUTE_SEPARATOR);
                        if (attributes.length != 2) {
                            String message7 = "The " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY + " format is incorrect. Artifact: " + artifactRef + " Length: " + attributes.length;
                            this._log.severe(message7);
                            throw new GdrException(message7);
                        }
                        Object artifactInfo = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createArtifactInfo", (Class[])new Class[]{String.class, String.class, String.class}, (Object[])new Object[]{artifactTypeString, attributes[0], attributes[1]}, (ClassLoader)this.getClassLoader());
                        artifactInfos.add(artifactInfo.getClass().cast(artifactInfo));
                    }
                    maintenanceAliasMap = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createMaintenanceAliasMap", (Class[])new Class[]{String.class, String.class, List.class}, (Object[])new Object[]{actionType.getShortName(), maintenanceAliasKey, artifactInfos}, (ClassLoader)this.getClassLoader());
                }
                catch (IndexOutOfBoundsException e) {
                    message = "Unable to generate maintenance alias mappint information, invalid format for " + MaintenanceAliasUtils.MAINTENANCE_ALIAS_MAPPING_PROPERTY + " value: " + actionString;
                    this._log.severe(message);
                    throw new GdrException(message);
                }
            }
            ReflectionHelper.process((String)OPACK_METADATA_MAINTENANCE_ALIAS, maintenanceAlias, (String)"addMaintenanceAliasMap", (Class[])new Class[]{Class.forName(OPACK_METADATA_MAINTENANCE_ALIAS_MAP)}, (Object[])new Object[]{maintenanceAliasMap}, (ClassLoader)this.getClassLoader());
        }
        catch (Exception e) {
            String message = "Unable to generate Maintenance Alias information due to the following cause: ";
            this._log.log(Level.SEVERE, message + e.getMessage(), e);
            throw new GdrException(message + e.getMessage(), (Throwable)e);
        }
        return maintenanceAlias;
    }

    private Collection<Object> getComponentPatchingActions(CarbDiffGenerator carbDiffGen) throws GdrException {
        ArrayList<Object> componentList = new ArrayList<Object>();
        try {
            Object metaDataFactory = this.getMetadataFactory();
            for (CarbDiff carbDiff : carbDiffGen.getCarbDiffList()) {
                Component aComponent = carbDiff.getDeltaComponent();
                HashMap<String, ArrayList<FileMap>> symbolToFileMaps = new HashMap<String, ArrayList<FileMap>>();
                for (FileMap fileMap : aComponent.getFileMaps()) {
                    String symbol = fileMap.getSymbol();
                    ArrayList<FileMap> fileMapList = (ArrayList<FileMap>)symbolToFileMaps.get(symbol);
                    if (null == fileMapList) {
                        fileMapList = new ArrayList<FileMap>();
                        symbolToFileMaps.put(symbol, fileMapList);
                    }
                    fileMapList.add(fileMap);
                }
                String patchLevel = aComponent.getPatchLevel();
                if (StringUtil.isNullOrEmpty((String)patchLevel)) {
                    throw new GdrException("The patch level can not be null or empty.");
                }
                String optReq = carbDiff.getRequired() != null ? (carbDiff.getRequired().booleanValue() ? "R" : "O") : "R";
                for (Map.Entry entry : symbolToFileMaps.entrySet()) {
                    String symbol = (String)entry.getKey();
                    Object component = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createComponent", (Class[])new Class[]{String.class, String.class, String.class, String.class, String.class}, (Object[])new Object[]{aComponent.getName(), aComponent.getVersion(), patchLevel, optReq, symbol}, (ClassLoader)this.getClassLoader());
                    for (FileMap fileMap : (List)entry.getValue()) {
                        Map<com.oracle.cie.gdr.dao.cpd.File, List<String>> targets = carbDiffGen.getFileTargets(fileMap);
                        for (com.oracle.cie.gdr.dao.cpd.File fileTarget : targets.keySet()) {
                            Object copyAction;
                            List<String> files = targets.get(fileTarget);
                            if (fileTarget.getAction().equalsIgnoreCase(Strategy.Injection.getXmlName())) {
                                if (null == files) continue;
                                for (String path : files) {
                                    Object jarAction;
                                    try {
                                        jarAction = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createJarAction", (Class[])new Class[]{String.class}, (Object[])new Object[]{path}, (ClassLoader)this.getClassLoader());
                                    }
                                    catch (Exception e) {
                                        throw new GdrException("Failed to execute \"createJarAction\" with path: " + path + " for component:" + aComponent, (Throwable)e);
                                    }
                                    try {
                                        ReflectionHelper.process((String)OPACK_METADATA_COMPONENT_CLASS, (Object)component, (String)"addPatchingAction", (Class[])new Class[]{Class.forName(OPACK_METADATA_PATCHING_JAR_ACTION, true, this.getClassLoader())}, (Object[])new Object[]{jarAction}, (ClassLoader)this.getClassLoader());
                                    }
                                    catch (Exception e) {
                                        throw new GdrException("Failed to execute \"addPatchingAction\" with path: " + path + " for component:" + aComponent, (Throwable)e);
                                    }
                                }
                                continue;
                            }
                            if (null != files) continue;
                            try {
                                copyAction = ReflectionHelper.process((String)OPACK_METADATA_FACTORY_CLASS, (Object)metaDataFactory, (String)"createCopyAction", (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{fileTarget.getDest(), this._version}, (ClassLoader)this.getClassLoader());
                            }
                            catch (Exception e) {
                                throw new GdrException("Failed to execute \"createCopyAction\" with dest: " + fileTarget.getDest() + " for component:" + aComponent, (Throwable)e);
                            }
                            try {
                                ReflectionHelper.process((String)OPACK_METADATA_COMPONENT_CLASS, (Object)component, (String)"addPatchingAction", (Class[])new Class[]{Class.forName(OPACK_METADATA_PATCHING_JAR_ACTION, true, this.getClassLoader())}, (Object[])new Object[]{copyAction}, (ClassLoader)this.getClassLoader());
                            }
                            catch (Exception e) {
                                throw new GdrException("Failed to execute \"addPatchingAction\" with dest: " + fileTarget.getDest() + " for component:" + aComponent, (Throwable)e);
                            }
                        }
                        componentList.add(component.getClass().cast(component));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new GdrException("Unable to generate Component Patching Actions due to the following cause: " + e.getMessage(), (Throwable)e);
        }
        return componentList;
    }

    private Object getMetadataFactory() throws GdrException {
        try {
            return ReflectionHelper.processStaticMethod((String)OPACK_METADATA_FACTORY_CLASS, (String)"getInstance", null, null, (ClassLoader)this.getClassLoader());
        }
        catch (Exception e) {
            throw new GdrException("Unable to generate metadata patch due to the following cause: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        OPACK_METADATA_FACTORY_CLASS = "oracle.glcm.opack.tools.metadata.MetadataFactory";
        OPACK_METADATA_COMPONENT_CLASS = "oracle.glcm.opack.tools.metadata.Component";
        OPACK_METADATA_PATCHING_JAR_ACTION = "oracle.glcm.opack.tools.metadata.PatchingAction";
        OPACK_METADATA_MAINTENANCE_ALIAS = "oracle.glcm.opack.tools.metadata.MaintenanceAlias";
        OPACK_METADATA_MAINTENANCE_ALIAS_INFO = "oracle.glcm.opack.tools.metadata.MaintenanceAliasInfo";
        OPACK_METADATA_MAINTENANCE_ALIAS_MAP = "oracle.glcm.opack.tools.metadata.MaintenanceAliasMap";
        OPACK_PATCH_GENERATOR = "oracle.glcm.opack.tools.PatchGenerator";
    }
}

