/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.session;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.external.InstallerConfig;
import com.oracle.cie.gdr.external.Session;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.selection.Selectable;
import com.oracle.cie.gdr.selection.SelectableFeatureSet;
import com.oracle.cie.gdr.selection.SelectableFeatureSetGroup;
import com.oracle.cie.gdr.session.BaseSession;
import com.oracle.cie.gdr.session.DistributionSession;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class CommonSession
extends BaseSession
implements Session,
DistributionSession {
    public CommonSession(File homeDir) throws GdrException, IOException, DataHandlerException {
        super(homeDir);
    }

    public CommonSession(Path homeDir) throws GdrException, IOException, DataHandlerException {
        super(homeDir);
    }

    public CommonSession(MetaDataHome metaDataHome, Home home, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, home, platforms, locales);
    }

    public CommonSession(MetaDataHome metaDataHome, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales);
        this.init();
    }

    public CommonSession(MetaDataHome metaDataHome, Path homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales);
        this.init();
    }

    private void init() throws MalformedURLException, GdrException, DataHandlerException {
        String compatibilityFileProperty = System.getProperty("oracle.installer.compatibilityFile");
        if (!StringUtil.isNullOrEmpty((String)compatibilityFileProperty)) {
            this.getMetaDataHome().getFeatureDependencyManager().loadDistributionCompatibilityFile(NioHelper.getInstance().getPath(compatibilityFileProperty, new String[0]));
        }
    }

    @Override
    public abstract DistributionLoader getDistributionLoader();

    public DistributionInfo getDistributionInfo() {
        return this.getDistributionLoader() != null ? this.getDistributionLoader().getDistributionInfo() : null;
    }

    public abstract DistributionTarget getDistributionTarget();

    @Override
    public abstract FeatureSelectionTarget getFeatureSelectionTarget();

    @Override
    public abstract Set<FeatureSet> getSelectedFeatures();

    public abstract ComponentLoader getComponentLoader();

    @Override
    public abstract void setSelectedFeatures(Set<Reference> var1) throws GdrException, DependencyException;

    public Reference getFeatureReference(String name, String version) throws GdrException {
        DistributionLoader distLoader = this.getDistributionLoader();
        if (distLoader == null) {
            throw new IllegalStateException("The distribution loader was null in this session.");
        }
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new GdrException("The feature set name specified was null or empty.");
        }
        boolean versionProvided = !StringUtil.isNullOrEmpty((String)version, (boolean)true);
        LinkedHashSet<FeatureSet> matchingFeatureSets = new LinkedHashSet<FeatureSet>();
        Set<FeatureSet> featureSets = distLoader.getFeatureSets();
        if (featureSets != null && !featureSets.isEmpty()) {
            for (FeatureSet featureSet : featureSets) {
                if (!featureSet.getName().equals(name) || versionProvided && !featureSet.getVersion().equals(version)) continue;
                matchingFeatureSets.add(featureSet);
            }
        }
        if (matchingFeatureSets.isEmpty()) {
            String message = "Unable to locate a feature with the name " + name;
            if (versionProvided) {
                message = message + " and version " + version;
            }
            message = message + " in use by this session.";
            throw new GdrException(message);
        }
        if (matchingFeatureSets.size() > 1) {
            throw new GdrException("Found multiple feature sets which match the specified feature name \"" + name + "\" " + matchingFeatureSets);
        }
        FeatureSet featureSet = (FeatureSet)matchingFeatureSets.iterator().next();
        return InstallerConfig.createReference(featureSet.getName(), featureSet.getVersion());
    }

    public boolean isFeatureSelected(Reference reference) throws GdrException {
        FeatureSelectionTarget selectionTarget = this.getFeatureSelectionTarget();
        if (selectionTarget == null) {
            throw new IllegalStateException("The feature selection target was null in this session.");
        }
        DistributionLoader distLoader = this.getDistributionLoader();
        if (distLoader == null) {
            throw new IllegalStateException("The distribution loader was null in this session.");
        }
        if (reference == null) {
            throw new GdrException("The feature reference specified was null.");
        }
        String featureName = reference.getName();
        String featureVersion = reference.getVersion();
        if (StringUtil.isNullOrEmpty((String)featureName, (boolean)true) || StringUtil.isNullOrEmpty((String)featureVersion, (boolean)true)) {
            throw new GdrException("The feature reference specified was invalid " + (Object)((Object)reference));
        }
        FeatureSet featureSet = distLoader.getDistributionTarget().getFeatureSet(featureName, featureVersion);
        if (featureSet == null) {
            throw new GdrException("Unable to locate specified feature in this session: " + (Object)((Object)reference));
        }
        return selectionTarget.isSelected(featureSet);
    }

    public boolean isFeatureInstalled(Reference reference) throws GdrException {
        Home home = this.getHome();
        if (home == null) {
            throw new IllegalStateException("The home was null in this session.");
        }
        if (reference == null) {
            throw new GdrException("The feature reference specified was null.");
        }
        return home.isFeatureInstalled(reference);
    }

    public Reference getComponentReference(String name, String version) throws GdrException {
        Set<Component> matchingComponents = this.getMatchingComponents(name, version);
        if (matchingComponents.isEmpty()) {
            String message = "Unable to locate a component with the name " + name;
            if (!StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                message = message + " and version " + version;
            }
            message = message + " in use by this session.";
            throw new GdrException(message);
        }
        if (matchingComponents.size() > 1) {
            throw new GdrException("Found multiple components which match the specified component name \"" + name + "\" " + matchingComponents);
        }
        Component component = matchingComponents.iterator().next();
        return InstallerConfig.createReference(component.getName(), component.getVersion());
    }

    public boolean containsComponent(String name, String version) throws GdrException {
        Set<Component> matchingComponents = this.getMatchingComponents(name, version);
        return !matchingComponents.isEmpty();
    }

    protected Set<Component> getMatchingComponents(String name, String version) throws GdrException {
        ComponentLoader componentLoader = this.getComponentLoader();
        if (componentLoader == null) {
            throw new IllegalStateException("The component loader was null in this session.");
        }
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new GdrException("The component set name specified was null or empty.");
        }
        boolean versionProvided = !StringUtil.isNullOrEmpty((String)version, (boolean)true);
        LinkedHashSet<Component> matchingComponents = new LinkedHashSet<Component>();
        Set<Component> components = componentLoader.getComponents();
        if (components != null && !components.isEmpty()) {
            for (Component component : components) {
                if (!component.getName().equals(name) || versionProvided && !component.getVersion().equals(version)) continue;
                matchingComponents.add(component);
            }
        }
        return matchingComponents;
    }

    public String getDistributionLocalizedExternalName() {
        DistributionLoader distLoader = this.getDistributionLoader();
        if (distLoader == null) {
            throw new IllegalStateException("The distribution loader was null in this session.");
        }
        String name = distLoader.getDistribution().getLocalizedExternalName();
        return StringUtil.isNullOrEmpty((String)name, (boolean)true) ? distLoader.getDistribution().getName() : name;
    }

    public String getDistributionLocalizedExternalShortName() {
        DistributionLoader distLoader = this.getDistributionLoader();
        if (distLoader == null) {
            throw new IllegalStateException("The distribution loader was null in this session.");
        }
        String name = distLoader.getDistribution().getLocalizedExternalShortName();
        return StringUtil.isNullOrEmpty((String)name, (boolean)true) ? distLoader.getDistribution().getName() : name;
    }

    public String getDistributionExternalVersion() {
        DistributionLoader distLoader = this.getDistributionLoader();
        if (distLoader == null) {
            throw new IllegalStateException("The distribution loader was null in this session.");
        }
        String version = distLoader.getDistribution().getExternalVersion();
        return StringUtil.isNullOrEmpty((String)version, (boolean)true) ? distLoader.getDistribution().getVersion() : version;
    }

    public String getDistributionLocalizedDescription() {
        DistributionLoader distLoader = this.getDistributionLoader();
        if (distLoader == null) {
            throw new IllegalStateException("The distribution loader was null in this session.");
        }
        return distLoader.getDistribution().getLocalizedDescription();
    }

    public Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> getFeatureSelectionWrappers() {
        DistributionLoader distLoader = this.getDistributionLoader();
        FeatureSelectionTarget selectionTarget = this.getFeatureSelectionTarget();
        if (selectionTarget == null) {
            throw new IllegalStateException("The feature selection target was null in this session.");
        }
        Mode mode = selectionTarget.getMode();
        return CommonSession.getFeatureSelectionWrappers(distLoader.getDistributionTarget(), selectionTarget, mode.isDeInstallMode());
    }

    public List<SelectableFeatureSet> getSelectableFeatureSets(boolean visible, boolean selected) {
        ArrayList<SelectableFeatureSet> featureSets = new ArrayList<SelectableFeatureSet>();
        Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> wrappers = this.getFeatureSelectionWrappers();
        if (wrappers != null && !wrappers.isEmpty()) {
            for (Map.Entry<SelectableFeatureSetGroup, List<SelectableFeatureSet>> entry : wrappers.entrySet()) {
                featureSets.addAll(this.getSelectableFeatureSets(entry.getKey(), entry.getValue(), visible, selected));
            }
        }
        return featureSets;
    }

    private List<SelectableFeatureSet> getSelectableFeatureSets(SelectableFeatureSetGroup selGroup, List<SelectableFeatureSet> selFeatures, boolean visible, boolean selected) {
        ArrayList<SelectableFeatureSet> featureSets = new ArrayList<SelectableFeatureSet>();
        if (!visible || selGroup.isVisible()) {
            if (selGroup.hasFeatureSetGroups()) {
                Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> childGroups = selGroup.getFeatureSetGroups();
                for (Map.Entry<SelectableFeatureSetGroup, List<SelectableFeatureSet>> entry : childGroups.entrySet()) {
                    featureSets.addAll(this.getSelectableFeatureSets(entry.getKey(), entry.getValue(), visible, selected));
                }
            }
            if (selFeatures != null && !selFeatures.isEmpty()) {
                for (SelectableFeatureSet selFeature : selFeatures) {
                    if ((visible && !selFeature.isVisible() || selected && !selFeature.isSelected()) && !selFeature.isRequired()) continue;
                    featureSets.add(selFeature);
                }
            }
        }
        return featureSets;
    }

    static Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> getFeatureSelectionWrappers(DistributionTarget distTarget, FeatureSelectionTarget selectionTarget, boolean installedOnly) {
        return CommonSession.getFeatureSelectionWrappers(distTarget.getDistribution().getFeatureSetGroups(), distTarget.getFeatureSets(), selectionTarget, installedOnly);
    }

    static Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> getFeatureSelectionWrappers(Collection<FeatureSetGroup> featureGroups, Collection<FeatureSet> features, FeatureSelectionTarget selectionTarget, boolean installedOnly) {
        LinkedHashMap<SelectableFeatureSetGroup, List<SelectableFeatureSet>> wrappers = new LinkedHashMap<SelectableFeatureSetGroup, List<SelectableFeatureSet>>();
        Map<FeatureSetGroup, List<FeatureSet>> featureSetGroupMap = FeatureSetHelper.getInstance().getFeatureSetGroupMap(featureGroups, features);
        Mode mode = selectionTarget != null ? selectionTarget.getMode() : Mode.INSTALL;
        for (Map.Entry<FeatureSetGroup, List<FeatureSet>> entry : featureSetGroupMap.entrySet()) {
            Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> childSelectableGroups;
            FeatureSetGroup group = entry.getKey();
            ArrayList<SelectableFeatureSet> selFeatures = new ArrayList<SelectableFeatureSet>();
            List<FeatureSet> groupFeatures = entry.getValue();
            if (groupFeatures != null && !groupFeatures.isEmpty()) {
                for (FeatureSet feature : groupFeatures) {
                    if (installedOnly && !feature.getStatus().isInstalled()) continue;
                    selFeatures.add(new SelectableFeatureSet(feature, selectionTarget));
                }
            }
            List<FeatureSetGroup> childGroups = group.getFeatureSetGroups();
            if (selFeatures.isEmpty() && (childGroups == null || childGroups.isEmpty())) continue;
            SelectableFeatureSetGroup selGroup = new SelectableFeatureSetGroup(group, mode);
            if (childGroups != null && !childGroups.isEmpty() && (childSelectableGroups = CommonSession.getFeatureSelectionWrappers(childGroups, features, selectionTarget, installedOnly)) != null && !childSelectableGroups.isEmpty()) {
                selGroup.setFeatureSetGroups(childSelectableGroups);
            }
            wrappers.put(selGroup, selFeatures);
        }
        return wrappers;
    }

    public TreeModel getFeatureSelectionTreeModel() {
        return this.getFeatureSelectionTreeModel(false);
    }

    public TreeModel getFeatureSelectionTreeModel(boolean displayOnly) {
        Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> wrappers = this.getFeatureSelectionWrappers();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getDistributionLocalizedExternalName() + " " + this.getDistributionExternalVersion());
        for (Map.Entry<SelectableFeatureSetGroup, List<SelectableFeatureSet>> entry : wrappers.entrySet()) {
            SelectableFeatureSetGroup selGroup = entry.getKey();
            if (!selGroup.isVisible()) continue;
            MutableTreeNode groupNode = this.getSelectableFeatureGroupTreeNode(selGroup, entry.getValue(), displayOnly);
            if (displayOnly && groupNode.isLeaf()) continue;
            root.add(groupNode);
        }
        return this.getTreeModel(root, displayOnly);
    }

    public TreeModel getFeatureSelectionTreeModel(boolean displayOnly, boolean installTypeBased) {
        Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> wrappers = this.getFeatureSelectionWrappers();
        ArrayList<SelectableFeatureSet> featureSets = new ArrayList<SelectableFeatureSet>();
        if (wrappers != null && !wrappers.isEmpty()) {
            for (Map.Entry<SelectableFeatureSetGroup, List<SelectableFeatureSet>> entry : wrappers.entrySet()) {
                featureSets.addAll(this.getSelectableFeatureSets(entry.getKey(), entry.getValue(), true, true));
            }
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getDistributionLocalizedExternalName() + " " + this.getDistributionExternalVersion());
        for (Map.Entry<SelectableFeatureSetGroup, List<SelectableFeatureSet>> entry : wrappers.entrySet()) {
            ArrayList<SelectableFeatureSet> selectedFeatureSets = new ArrayList<SelectableFeatureSet>();
            SelectableFeatureSetGroup selectedGroup = entry.getKey();
            if (!selectedGroup.isVisible()) continue;
            for (SelectableFeatureSet selectedFeature : featureSets) {
                if (!entry.getValue().contains(selectedFeature)) continue;
                selectedFeatureSets.add(selectedFeature);
            }
            MutableTreeNode groupNode = this.getSelectableFeatureGroupTreeNode(selectedGroup, selectedFeatureSets, displayOnly);
            if (displayOnly && groupNode.isLeaf()) continue;
            root.add(groupNode);
        }
        return this.getTreeModel(root, displayOnly);
    }

    private TreeModel getTreeModel(DefaultMutableTreeNode root, boolean displayOnly) {
        DefaultTreeModel treeModel = displayOnly ? new DefaultTreeModel(root) : new DefaultTreeModel(root){

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
                if (newValue == null) {
                    newValue = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                }
                super.valueForPathChanged(path, newValue);
            }
        };
        return treeModel;
    }

    private MutableTreeNode getSelectableFeatureGroupTreeNode(SelectableFeatureSetGroup selGroup, List<SelectableFeatureSet> selFeatures, boolean displayOnly) {
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(displayOnly ? selGroup.toString() : selGroup);
        ArrayList<Selectable> children = new ArrayList<Selectable>();
        if (selGroup.hasFeatureSetGroups()) {
            Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> childGroups = selGroup.getFeatureSetGroups();
            for (Map.Entry<SelectableFeatureSetGroup, List<SelectableFeatureSet>> entry : childGroups.entrySet()) {
                SelectableFeatureSetGroup childSelGroup = entry.getKey();
                if (!childSelGroup.isVisible()) continue;
                children.add(childSelGroup);
                MutableTreeNode childGroupNode = this.getSelectableFeatureGroupTreeNode(childSelGroup, entry.getValue(), displayOnly);
                if (displayOnly && childGroupNode.isLeaf()) continue;
                groupNode.add(childGroupNode);
            }
        }
        if (selFeatures != null && !selFeatures.isEmpty()) {
            for (SelectableFeatureSet selFeature : selFeatures) {
                if (!selFeature.isVisible()) continue;
                children.add(selFeature);
                DefaultMutableTreeNode featureNode = new DefaultMutableTreeNode(displayOnly ? selFeature.toString() : selFeature);
                groupNode.add(featureNode);
            }
        }
        selGroup.setSelectableChildren(children);
        return groupNode;
    }

    public Map<Reference, Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>>> getInstalledDistributionInfo() {
        LinkedHashMap<Reference, Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>>> info = new LinkedHashMap<Reference, Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>>>();
        Collection<DistributionTarget> installedDists = this.getHome().getInstalledDistributions();
        if (installedDists != null && !installedDists.isEmpty()) {
            for (DistributionTarget distTarget : installedDists) {
                Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> selectionWrappers = CommonSession.getFeatureSelectionWrappers(distTarget, null, true);
                Reference distRef = InstallerConfig.createReference(distTarget.getDistribution().getName(), distTarget.getDistribution().getVersion());
                info.put(distRef, selectionWrappers);
            }
        }
        return info;
    }
}

