/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.services.ClassLoaderService;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.inv.Bug;
import com.oracle.cie.gdr.dao.inv.BugInfo;
import com.oracle.cie.gdr.dao.inv.ComponentGroupReference;
import com.oracle.cie.gdr.dao.inv.ComponentReference;
import com.oracle.cie.gdr.dao.inv.DistributionGroupReference;
import com.oracle.cie.gdr.dao.inv.DistributionReference;
import com.oracle.cie.gdr.dao.inv.FeatureSetGroupReference;
import com.oracle.cie.gdr.dao.inv.FeatureSetReference;
import com.oracle.cie.gdr.dao.inv.OracleHomeReference;
import com.oracle.cie.gdr.dao.inv.PatchGroupReference;
import com.oracle.cie.gdr.dao.inv.PatchReference;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.helpers.InventoryHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.LogManager;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.helpers.PatchHelper;

public class InventoryDump {
    private static final String dIndent = "   ";
    private static final String fIndent = "     ";
    private static final String cIndent = "       ";
    private static final String pIndent = "         ";
    private static final String ORACLE_HOME_ARG = "-oracle_home";
    private static final String OUTPUT_FILE_ARG = "-output_file";
    private static final String OUTPUT_TYPE_ARG = "-output_format";
    private static final String FEDERATED_ARG = "-federated_type";
    private static final String JRE_LOC = "-jreLoc";
    private static final String SHOW_BUG_LIST = "-show_bug_list";
    private static final String HELP = "-help";
    private static final String EXTENDED = "-extended";
    private static final String IGNORE_PARAMS = "2>&1";
    private static String _oraHomePath;
    private static String _outputFilePath;
    private static String _outputType;
    private static FederatedRelationship _federatedRelationship;
    private static boolean _help;
    private static boolean _isExtended;
    private static boolean _showBugList;
    private static BugInfo _bugInfo;

    private static void dumpToConsole(File oraHomeDir, FederatedRelationship federatedRelationship) throws InventoryException {
        Collection<OracleHomeInventory> federatedInventories;
        OracleHomeInventory oraHome = InventoryFactory.getOracleHomeInventory(oraHomeDir);
        InventoryDump.dumpToConsole(oraHome, false);
        if (federatedRelationship != null && (federatedInventories = oraHome.getFederatedOracleHomeInventories(federatedRelationship, false)) != null) {
            for (OracleHomeInventory inventory : federatedInventories) {
                InventoryDump.dumpToConsole(inventory, true);
            }
        }
    }

    private static void dumpToConsole(OracleHomeInventory oraHome, boolean federated) throws InventoryException {
        if (federated) {
            System.out.println("\n\nFederated Oracle Home: " + oraHome.getHomeDir().getAbsolutePath());
        } else {
            System.out.println("Oracle Home: " + oraHome.getHomeDir().getAbsolutePath());
        }
        Collection<Distribution> distributions = oraHome.getInstalledDistributions();
        ArrayList<Component> bugListPerComponent = null;
        if (_showBugList) {
            bugListPerComponent = new ArrayList<Component>();
        }
        for (Distribution dist : distributions) {
            System.out.println("   Distribution: " + dist.getName() + " " + dist.getVersion());
            Collection<FeatureSet> features = dist.getFeatureSets();
            for (FeatureSet feat : features) {
                if (!oraHome.isFeatureSetinstalled(feat.getName(), feat.getVersion())) continue;
                if (_isExtended && !StringUtil.isNullOrEmpty((String)feat.getType()) && !StringUtil.isNullOrEmpty((String)feat.getSubType())) {
                    System.out.println("     FeatureSet: " + feat.getName() + " " + feat.getVersion() + " type: " + feat.getType() + " subtype: " + feat.getSubType());
                } else {
                    System.out.println("     FeatureSet: " + feat.getName() + " " + feat.getVersion());
                }
                List<Component> components = feat.getComponents();
                for (Component comp : components) {
                    if (!oraHome.isComponentInstalled(comp.getName(), comp.getVersion())) continue;
                    System.out.println("       Component: " + comp.getName() + " " + comp.getVersion());
                    Collection<Patch> patches = oraHome.getInstalledPatches(comp);
                    for (Patch patch : patches) {
                        if (!oraHome.isPatchInstalled(patch.getPatchId())) continue;
                        System.out.println("         Patch: ID: " + patch.getPatchId() + " UID: " + patch.getUniquePatchId());
                    }
                    if (!_showBugList) continue;
                    if (null != comp.getBugInfo()) {
                        _bugInfo = InventoryDump.generateBugInfo(_bugInfo, comp.getBugInfo());
                    }
                    if (bugListPerComponent.contains(comp)) continue;
                    ((ComponentImpl)comp).setBugInfo(InventoryDump.retrieveBugList(_bugInfo));
                    bugListPerComponent.add(comp);
                }
            }
        }
        if (_showBugList && !bugListPerComponent.isEmpty()) {
            System.out.println(InventoryDump.generateBugList(bugListPerComponent, false));
        }
    }

    private static void dumpToXml(File oraHomeDir, FederatedRelationship federatedRelationship) throws InventoryException, DataHandlerException {
        Collection<OracleHomeInventory> federatedInventories;
        OracleHomeInventory oraHome = InventoryFactory.getOracleHomeInventory(oraHomeDir);
        InventoryDump.dumpToXml(oraHome, new File(_outputFilePath));
        if (federatedRelationship != null && (federatedInventories = oraHome.getFederatedOracleHomeInventories(federatedRelationship, false)) != null) {
            String[] split = InventoryDump.splitFileBaseVsExt(_outputFilePath);
            for (OracleHomeInventory inventory : federatedInventories) {
                String outputFilePath = split[0] + "_" + inventory.getHomeDir().getName();
                if (split[1] != null) {
                    outputFilePath = outputFilePath + split[1];
                }
                InventoryDump.dumpToXml(inventory, new File(outputFilePath));
            }
        }
    }

    private static void dumpToXml(OracleHomeInventory oraHome, File outputFile) throws InventoryException, DataHandlerException {
        OracleHomeReference inv;
        Collection<Distribution> distributions = oraHome.getInstalledDistributions();
        ArrayList<DistributionReference> distributionReferences = new ArrayList<DistributionReference>();
        for (Distribution dist : distributions) {
            Collection<FeatureSet> features = dist.getFeatureSets();
            ArrayList<FeatureSetReference> featureSetReferences = new ArrayList<FeatureSetReference>();
            for (FeatureSet feat : features) {
                if (!oraHome.isFeatureSetinstalled(feat.getName(), feat.getVersion())) continue;
                List<Component> components = feat.getComponents();
                ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
                for (Component comp : components) {
                    if (!oraHome.isComponentInstalled(comp.getName(), comp.getVersion())) continue;
                    Collection<Patch> patches = oraHome.getInstalledPatches(comp);
                    ArrayList<PatchReference> patchReferences = new ArrayList<PatchReference>();
                    for (Patch patch : patches) {
                        if (!oraHome.isPatchInstalled(patch.getPatchId())) continue;
                        patchReferences.add(new PatchReference(patch.getPatchId(), patch.getUniquePatchId()));
                    }
                    if (_showBugList && null != comp.getBugInfo()) {
                        _bugInfo = InventoryDump.generateBugInfo(_bugInfo, comp.getBugInfo());
                    }
                    if (!patchReferences.isEmpty()) {
                        PatchGroupReference patchGroup = new PatchGroupReference(patchReferences);
                        componentReferences.add(new ComponentReference(comp.getName(), comp.getVersion(), patchGroup, _bugInfo));
                        continue;
                    }
                    componentReferences.add(new ComponentReference(comp.getName(), comp.getVersion(), null, _bugInfo));
                }
                if (!componentReferences.isEmpty()) {
                    ComponentGroupReference componentGroup = new ComponentGroupReference(componentReferences);
                    featureSetReferences.add(new FeatureSetReference(feat.getName(), feat.getVersion(), componentGroup, feat.getType(), feat.getSubType()));
                    continue;
                }
                featureSetReferences.add(new FeatureSetReference(feat.getName(), feat.getVersion(), null, feat.getType(), feat.getSubType()));
            }
            if (!featureSetReferences.isEmpty()) {
                FeatureSetGroupReference featureSetGroup = new FeatureSetGroupReference(featureSetReferences);
                distributionReferences.add(new DistributionReference(dist.getName(), dist.getVersion(), featureSetGroup));
                continue;
            }
            distributionReferences.add(new DistributionReference(dist.getName(), dist.getVersion(), null));
        }
        if (!distributionReferences.isEmpty()) {
            DistributionGroupReference distributionGroup = new DistributionGroupReference(distributionReferences);
            inv = new OracleHomeReference(oraHome.getHomeDir().getAbsolutePath(), distributionGroup);
        } else {
            inv = new OracleHomeReference(oraHome.getHomeDir().getAbsolutePath(), null);
        }
        InventoryHelper.getInstance().save((IDataHandlerWrapper)inv, outputFile);
    }

    private static void dumpToCsv(File oraHomeDir, FederatedRelationship federatedRelationship) throws InventoryException, IOException {
        Collection<OracleHomeInventory> federatedInventories;
        OracleHomeInventory oraHome = InventoryFactory.getOracleHomeInventory(oraHomeDir);
        InventoryDump.dumpToCsv(oraHome, new File(_outputFilePath));
        if (federatedRelationship != null && (federatedInventories = oraHome.getFederatedOracleHomeInventories(federatedRelationship, false)) != null) {
            String[] split = InventoryDump.splitFileBaseVsExt(_outputFilePath);
            for (OracleHomeInventory inventory : federatedInventories) {
                String outputFilePath = split[0] + "_" + inventory.getHomeDir().getName();
                if (split[1] != null) {
                    outputFilePath = outputFilePath + split[1];
                }
                InventoryDump.dumpToCsv(inventory, new File(outputFilePath));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpToCsv(OracleHomeInventory oraHome, File outputFile) throws InventoryException, IOException {
        try (FileOutputStream out = null;){
            File parent = outputFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            out = new FileOutputStream(outputFile);
            out.write(("Oracle Home," + oraHome.getHomeDir().getAbsolutePath() + System.getProperty("line.separator")).getBytes());
            Collection<Distribution> distributions = oraHome.getInstalledDistributions();
            ArrayList<Component> bugListPerComponent = null;
            if (_showBugList) {
                bugListPerComponent = new ArrayList<Component>();
            }
            for (Distribution dist : distributions) {
                out.write(("Distribution," + dist.getName() + "," + dist.getVersion() + System.getProperty("line.separator")).getBytes());
                Collection<FeatureSet> features = dist.getFeatureSets();
                for (FeatureSet feat : features) {
                    if (!oraHome.isFeatureSetinstalled(feat.getName(), feat.getVersion())) continue;
                    if (_isExtended && !StringUtil.isNullOrEmpty((String)feat.getType()) && !StringUtil.isNullOrEmpty((String)feat.getSubType())) {
                        out.write(("FeatureSet," + feat.getName() + "," + feat.getVersion() + "," + feat.getType() + "," + feat.getSubType() + System.getProperty("line.separator")).getBytes());
                    } else {
                        out.write(("FeatureSet," + feat.getName() + "," + feat.getVersion() + System.getProperty("line.separator")).getBytes());
                    }
                    List<Component> components = feat.getComponents();
                    for (Component comp : components) {
                        if (!oraHome.isComponentInstalled(comp.getName(), comp.getVersion())) continue;
                        out.write(("Component," + comp.getName() + "," + comp.getVersion() + System.getProperty("line.separator")).getBytes());
                        Collection<Patch> patches = oraHome.getInstalledPatches(comp);
                        for (Patch patch : patches) {
                            if (!oraHome.isPatchInstalled(patch.getPatchId())) continue;
                            out.write(("Patch,ID: " + patch.getPatchId() + ",UID: " + patch.getUniquePatchId() + System.getProperty("line.separator")).getBytes());
                        }
                        if (!_showBugList) continue;
                        if (null != comp.getBugInfo()) {
                            _bugInfo = InventoryDump.generateBugInfo(_bugInfo, comp.getBugInfo());
                        }
                        if (bugListPerComponent.contains(comp)) continue;
                        ((ComponentImpl)comp).setBugInfo(InventoryDump.retrieveBugList(_bugInfo));
                        bugListPerComponent.add(comp);
                    }
                }
            }
            if (_showBugList && !bugListPerComponent.isEmpty()) {
                out.write(InventoryDump.generateBugList(bugListPerComponent, true).getBytes());
            }
            out.flush();
        }
    }

    private static String[] splitFileBaseVsExt(String path) {
        String basePath;
        int index = path.lastIndexOf(46);
        String ext = null;
        if (index > -1) {
            basePath = path.substring(0, index);
            ext = path.substring(index);
        } else {
            basePath = path;
        }
        return new String[]{basePath, ext};
    }

    public static void main(String[] args) {
        try {
            InventoryDump.processArgs(args);
            InventoryDump.validateArgs();
            if (!_help) {
                File oraHomeDir;
                if (StringUtil.isNullOrEmpty((String)_oraHomePath)) {
                    oraHomeDir = InventoryDump.getParentOracleHome();
                    if (oraHomeDir == null) {
                        throw new IllegalStateException("Failed to determine the home directory.");
                    }
                } else {
                    oraHomeDir = new File(_oraHomePath);
                }
                if (_showBugList) {
                    _bugInfo = InventoryDump.generateBugInfo(InventoryDump.createBugInfoFromPatch());
                }
                if (!StringUtil.isNullOrEmpty((String)_outputType) && _outputType.equalsIgnoreCase("report") || StringUtil.isNullOrEmpty((String)_outputFilePath)) {
                    InventoryDump.dumpToConsole(oraHomeDir, _federatedRelationship);
                } else if (!StringUtil.isNullOrEmpty((String)_outputType) && _outputType.equalsIgnoreCase("csv") || !StringUtil.isNullOrEmpty((String)_outputFilePath) && _outputFilePath.endsWith(".csv")) {
                    if (!_outputFilePath.endsWith(".csv")) {
                        _outputFilePath = _outputFilePath + ".csv";
                    }
                    InventoryDump.dumpToCsv(oraHomeDir, _federatedRelationship);
                } else if (!StringUtil.isNullOrEmpty((String)_outputType) && _outputType.equalsIgnoreCase("xml") || !StringUtil.isNullOrEmpty((String)_outputFilePath) && _outputFilePath.endsWith(".xml")) {
                    if (!_outputFilePath.endsWith(".xml")) {
                        _outputFilePath = _outputFilePath + ".xml";
                    }
                    InventoryDump.dumpToXml(oraHomeDir, _federatedRelationship);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processArgs(String[] args) throws Exception {
        String parameter = null;
        String value = null;
        for (int i = 0; i < args.length; ++i) {
            parameter = args[i];
            if (i + 1 < args.length) {
                value = args[i + 1];
            }
            if (parameter.equalsIgnoreCase(ORACLE_HOME_ARG)) {
                if (StringUtil.isNullOrEmpty((String)value)) {
                    throw new Exception("The -oracle_home hasn't been specified or is empty");
                }
                _oraHomePath = value;
                ++i;
            } else if (parameter.equalsIgnoreCase(OUTPUT_FILE_ARG)) {
                if (StringUtil.isNullOrEmpty((String)value)) {
                    throw new Exception("The -output_file hasn't been specified or is empty");
                }
                _outputFilePath = value;
                ++i;
            } else if (parameter.equalsIgnoreCase(OUTPUT_TYPE_ARG)) {
                if (StringUtil.isNullOrEmpty((String)value)) {
                    throw new Exception("The -output_format hasn't been specified or is empty");
                }
                _outputType = value;
                ++i;
            } else if (parameter.equalsIgnoreCase(FEDERATED_ARG)) {
                if (StringUtil.isNullOrEmpty((String)value)) {
                    throw new Exception("The -federated_type hasn't been specified or is empty");
                }
                _federatedRelationship = FederatedRelationship.valueOf(value.toUpperCase());
                ++i;
            } else if (parameter.equalsIgnoreCase(JRE_LOC)) {
                ++i;
            } else if (parameter.equalsIgnoreCase(EXTENDED)) {
                _isExtended = true;
            } else if (parameter.equalsIgnoreCase(SHOW_BUG_LIST)) {
                if (StringUtil.isNullOrEmpty((String)value)) {
                    throw new Exception("The value for-show_bug_list hasn't been specified or is empty");
                }
                _showBugList = Boolean.valueOf(value);
                ++i;
            } else if (parameter.equalsIgnoreCase(HELP)) {
                _help = true;
                InventoryDump.printUsageInstructions();
            } else if (!parameter.equalsIgnoreCase(IGNORE_PARAMS)) {
                throw new Exception("Invalid input parameter: " + parameter);
            }
            parameter = null;
            value = null;
        }
        if (args.length == 0 && null == InventoryDump.getParentOracleHome()) {
            InventoryDump.printUsageInstructions();
        }
    }

    private static File getParentOracleHome() throws InventoryException, IOException {
        File currentDir = new File(System.getProperty("user.dir")).getCanonicalFile();
        File registryFile = new File(Home.getInventoryDirectory(currentDir), "registry.xml");
        while (currentDir != null && !registryFile.exists()) {
            if ((currentDir = currentDir.getParentFile()) == null) continue;
            registryFile = new File(Home.getInventoryDirectory(currentDir), "registry.xml");
        }
        if (currentDir == null) {
            File containingJar = ClassLoaderService.getInstance().locateClass(InventoryDump.class, InventoryDump.class.getClassLoader());
            currentDir = containingJar.getParentFile();
            while (currentDir != null && !registryFile.exists()) {
                if ((currentDir = currentDir.getParentFile()) == null) continue;
                registryFile = new File(Home.getInventoryDirectory(currentDir), "registry.xml");
            }
        }
        if (currentDir != null) {
            InventoryFactory.getOracleHomeInventory(currentDir);
        }
        return currentDir;
    }

    private static BugInfo generateBugInfo(BugInfo bugInfo, com.oracle.cie.gdr.external.BugInfo aBugInfo) {
        BugInfo newBugInfo = null;
        List<com.oracle.cie.gdr.dao.cpd.Bug> list = aBugInfo.getBugInfoList();
        List<Bug> bugList = InventoryDump.retrieveBugList(list);
        if (null != bugInfo && null != bugInfo.getBugInfoList()) {
            for (Bug aBug : bugInfo.getBugInfoList()) {
                if (bugList.contains((Object)aBug)) continue;
                bugList.add(aBug);
            }
        }
        if (null != bugList && !bugList.isEmpty()) {
            newBugInfo = new BugInfo();
            newBugInfo.setBugInfoList(bugList);
        }
        return newBugInfo;
    }

    private static BugInfo generateBugInfo(com.oracle.cie.gdr.dao.cpd.BugInfo bugInfo) {
        BugInfo newBugInfo = null;
        List<Bug> bugList = InventoryDump.retrieveBugList(bugInfo.getBugInfoList());
        if (!bugList.isEmpty()) {
            newBugInfo = new BugInfo();
            newBugInfo.setBugInfoList(bugList);
        }
        return newBugInfo;
    }

    private static List<Bug> retrieveBugList(List<com.oracle.cie.gdr.dao.cpd.Bug> bugs) {
        ArrayList<Bug> bugList = new ArrayList<Bug>();
        for (com.oracle.cie.gdr.dao.cpd.Bug aBug : bugs) {
            Bug bug = new Bug();
            bug.setDescription(aBug.getDescription());
            bug.setNumber(aBug.getNumber());
            bugList.add(bug);
        }
        return bugList;
    }

    private static com.oracle.cie.gdr.dao.cpd.BugInfo retrieveBugList(BugInfo bugInfo) {
        com.oracle.cie.gdr.dao.cpd.BugInfo aBugInfo = new com.oracle.cie.gdr.dao.cpd.BugInfo();
        ArrayList<com.oracle.cie.gdr.dao.cpd.Bug> bugList = new ArrayList<com.oracle.cie.gdr.dao.cpd.Bug>();
        for (Bug aBug : bugInfo.getBugInfoList()) {
            com.oracle.cie.gdr.dao.cpd.Bug bug = new com.oracle.cie.gdr.dao.cpd.Bug();
            bug.setDescription(aBug.getDescription());
            bug.setNumber(aBug.getNumber());
            bugList.add(bug);
        }
        aBugInfo.setBugInfoList(bugList);
        return aBugInfo;
    }

    private static String generateBugList(List<Component> bugListPerComponent, boolean csv) throws InventoryException {
        StringBuilder sb = new StringBuilder();
        for (Component component : bugListPerComponent) {
            if (csv) {
                sb.append("Component," + component.getName() + "," + component.getVersion() + ",");
            } else {
                sb.append("Bugs fixed for Component " + component.getName() + " " + component.getVersion() + ": ");
            }
            int index = 1;
            for (com.oracle.cie.gdr.dao.cpd.Bug aBug : component.getBugInfo().getBugInfoList()) {
                sb.append(aBug.getNumber());
                if (index < component.getBugInfo().getBugInfoList().size()) {
                    sb.append(csv ? ";" : ", ");
                }
                ++index;
            }
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private static com.oracle.cie.gdr.dao.cpd.BugInfo createBugInfoFromPatch() throws InventoryException {
        LogManager.getLogManager().reset();
        com.oracle.cie.gdr.dao.cpd.BugInfo bugInfo = null;
        try {
            bugInfo = new com.oracle.cie.gdr.dao.cpd.BugInfo();
            ArrayList<com.oracle.cie.gdr.dao.cpd.Bug> bugsList = new ArrayList<com.oracle.cie.gdr.dao.cpd.Bug>();
            com.oracle.cie.gdr.dao.cpd.Bug bug = null;
            List patches = PatchHelper.getPatchesInOH((String)InventoryDump.getParentOracleHome().getAbsolutePath());
            for (oracle.glcm.opatch.common.api.Patch aPatch : patches) {
                List bugs = ((PatchInventory)aPatch.getPatchInventories().get(0)).getBugs();
                for (PatchInventory.Bug aBug : bugs) {
                    bug = new com.oracle.cie.gdr.dao.cpd.Bug();
                    bug.setNumber(aBug.getNumber());
                    bug.setDescription(aBug.getDescription());
                    if (bugsList.contains((Object)bug)) continue;
                    bugsList.add(bug);
                }
                bugInfo.setBugInfoList(bugsList);
            }
        }
        catch (IOException | InvalidPatchMetadataException | PatchMetadataLoadingException | PatchNotFoundException e) {
            throw new InventoryException(e.getCause());
        }
        return bugInfo;
    }

    private static void printUsageInstructions() {
        System.out.println("Usage: run viewInventory.cmd or viewInventory.sh with the following parameters:" + System.getProperty("line.separator"));
        System.out.println("-oracle_home <full path of the Oracle Home to analyze>: If not present if will use the parent oracle home.");
        System.out.println("-output_file <full path of the file to output the inventory>: if not present output will be redirected to the console." + System.getProperty("line.separator"));
        System.out.println("-output_format <xml, csv or report>: Indicate the output of this operation, value like xml and csv will create an output file of that format and report will print to the console, if not present the output will automatically detect it based on the output_file." + System.getProperty("line.separator"));
        System.out.println("-federated_type " + Arrays.toString((Object[])FederatedRelationship.values()).replace('[', '<').replace(']', '>') + ": If the output should include federated oracle homes and the relationship type that should be used when identifying them. When used with xml or csv output types an additional file will be created per federated home." + System.getProperty("line.separator"));
        System.out.println("-help Prints usage instructions");
        System.out.println("Notes:");
        System.out.println("*If the output_format parameter is not present then it automatically detect if the output file needs to be a csv file or xml file.");
    }

    private static boolean validateArgs() throws Exception {
        if (!_help && StringUtil.isNullOrEmpty((String)_oraHomePath, (boolean)true) && null == InventoryDump.getParentOracleHome()) {
            throw new Exception("The -oracle_home hasn't been specified or is empty");
        }
        if (!(_help || StringUtil.isNullOrEmpty((String)_outputFilePath, (boolean)true) || _outputFilePath.endsWith(".csv") || _outputFilePath.endsWith(".xml") || !StringUtil.isNullOrEmpty((String)_outputType))) {
            throw new Exception("The output file can be either a xml or csv file.");
        }
        if (!(StringUtil.isNullOrEmpty((String)_outputType) || _outputType.equals("xml") || _outputType.equals("csv") || _outputType.equals("report"))) {
            throw new Exception("The -output_format must be one of xml, csv and report.");
        }
        if (!StringUtil.isNullOrEmpty((String)_outputType) && (_outputType.equals("xml") || _outputType.equals("csv")) && StringUtil.isNullOrEmpty((String)_outputFilePath)) {
            throw new Exception("The -output_file must be specified.");
        }
        return true;
    }

    static {
        _help = false;
        _isExtended = false;
        _showBugList = false;
    }
}

