/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;

public class ConsistentProperties
extends Properties {
    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.store(writer, comments, new Date());
    }

    public void store(Writer writer, String comments, Date date) throws IOException {
        StringWriter stringWriter = new StringWriter();
        super.store(stringWriter, comments);
        BufferedWriter w = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        w.write(this.getFixedProperties(stringWriter.toString(), date));
        ((Writer)w).flush();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.store(out, comments, new Date());
    }

    public void store(OutputStream out, String comments, Date date) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        super.store(baos, comments);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        writer.write(this.getFixedProperties(baos.toString(), date));
        ((Writer)writer).flush();
    }

    protected String getFixedProperties(String properties, Date date) {
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : properties.split("\n")) {
            if (line.trim().isEmpty()) continue;
            if (line.startsWith("#")) {
                comments.add(line);
                continue;
            }
            lines.add(line);
        }
        Collections.sort(lines);
        if (!comments.isEmpty()) {
            comments.remove(comments.size() - 1);
        }
        if (date != null) {
            comments.add("#" + date.toString());
        }
        comments.addAll(lines);
        String fixed = null;
        for (String s : comments) {
            fixed = fixed == null ? s : fixed + "\n" + s;
        }
        return fixed;
    }
}

