/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.variables.impl;

import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.JDKQueryUtils;
import com.oracle.cie.gdr.variables.VariableQueryParamType;
import com.oracle.cie.gdr.variables.VariableQueryRequest;
import com.oracle.cie.gdr.variables.impl.CommonVariableQuery;
import java.util.List;

public class JavaPropertiesQuery
extends CommonVariableQuery {
    @Override
    public String getName() {
        return "getJavaProperty";
    }

    @Override
    public List<VariableQueryParamType> getParamTypes() {
        return this.getParamTypes(String.class);
    }

    @Override
    protected Object executeQuery(VariableQueryRequest variableQueryRequest) throws GdrException {
        InstallerWrapper installer = variableQueryRequest.getInstallerWrapper();
        String javaHome = installer.getServiceHolder().getVariableResolverService().get("JAVA_HOME");
        String propName = variableQueryRequest.getVariableQueryParams().get(0).getValue();
        return JDKQueryUtils.getInstance(installer, javaHome).getProperty(propName);
    }
}

