/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.command;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPCommandGenerator;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import com.oracle.glcm.patch.auto.rhp.executor.RHPResult;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class RHPSwitchHomeCommand
extends Command {
    @Override
    public List<String> generateCommand(RHPParams params) throws OPatchAutoException {
        OracleHomeInformationLoader.OracleHomeType homeType = OracleHomeInformationLoader.getInstance().getHomeType(params.getOracleHome());
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append(this.getRHPExecutable(params.getRHPClientHome()));
        commandBuilder.append(" ");
        commandBuilder.append("move");
        commandBuilder.append(" ");
        commandBuilder.append(this.getHomeType(homeType));
        commandBuilder.append(" ");
        commandBuilder.append(this.getDestinationHomeparam(homeType));
        commandBuilder.append(" ");
        commandBuilder.append(params.getWorkingCopyID());
        if (params.isContinued()) {
            commandBuilder.append(" ");
            commandBuilder.append("-continue");
        } else {
            commandBuilder.append(" ");
            commandBuilder.append("-sourcewc");
            commandBuilder.append(" ");
            commandBuilder.append(this.getSourceWorkingCopyID(params));
            if (!StringUtil.isNullOrEmpty((String)params.getBatches())) {
                commandBuilder.append(this.generateBatchesCommand(params.getBatches()));
            } else if (!StringUtil.isNullOrEmpty((String)params.getSAF())) {
                commandBuilder.append(" ");
                commandBuilder.append("-smartmove");
                commandBuilder.append(" ");
                commandBuilder.append("-saf");
                commandBuilder.append(" ");
                commandBuilder.append(params.getSAF());
            } else if (params.isNonRolling()) {
                commandBuilder.append(" ");
                commandBuilder.append("-nonrolling");
            }
            if (params.isAnalyze()) {
                commandBuilder.append(" ");
                commandBuilder.append("-eval");
            }
            if (!StringUtil.isNullOrEmpty((String)params.getStopOption())) {
                commandBuilder.append(" ");
                commandBuilder.append("-stopoption");
                commandBuilder.append(" ");
                commandBuilder.append(params.getStopOption());
            }
            if (!StringUtil.isNullOrEmpty((String)params.getDrainTimeout())) {
                commandBuilder.append(" ");
                commandBuilder.append("-drain_timeout");
                commandBuilder.append(" ");
                commandBuilder.append(params.getDrainTimeout());
            }
        }
        this._logger.fine("Generated command::" + commandBuilder.toString());
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandBuilder.toString());
        return commandList;
    }

    @Override
    public void preExecute(RHPParams params) throws OPatchAutoException {
        super.preExecute(params);
        String path = params.getPath();
        if (StringUtil.isNullOrEmpty((String)path)) {
            RHPCommandGenerator generator = new RHPCommandGenerator();
            List<Command> commandList = generator.getCommand(RHPOperation.QUERY_WORKINGCOPY);
            RHPCommandExecutor commandExecutor = new RHPCommandExecutor();
            List<RHPResult> resultList = null;
            for (Command command : commandList) {
                List<String> commands = generator.generateCommand(command, params);
                resultList = commandExecutor.executeRHPCommand(commands, null, null, false);
            }
            for (RHPResult result : resultList) {
                if (result.getReturnCode() == 0) {
                    String[] lines;
                    String outPut = result.getCommandOutput();
                    for (String tmp : lines = outPut.split("\\r?\\n")) {
                        String[] pathInfo;
                        if (!tmp.trim().startsWith("Software home path:") || (pathInfo = tmp.split(":")).length <= 1) continue;
                        path = pathInfo[1].trim();
                        break;
                    }
                }
                if (StringUtil.isNullOrEmpty((String)path)) continue;
                break;
            }
            this._logger.info("Path value read using working copy ID:" + params.getWorkingCopyID() + " is " + path);
        }
        if (StringUtil.isNullOrEmpty((String)path)) {
            return;
        }
        File destinationDir = new File(OPatchautoRHPHelper.getRHPMetadataLocation(path));
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        Properties rhpProperties = new Properties();
        File file = new File(destinationDir, "rhp.properties");
        try {
            if (file.exists()) {
                rhpProperties.load(new FileInputStream(file.getAbsolutePath()));
            }
            rhpProperties.setProperty("previousworkingcopyid", this.getSourceWorkingCopyID(params));
            FileOutputStream fileOut = new FileOutputStream(file);
            rhpProperties.store(fileOut, "rhp properties");
            fileOut.close();
            this._logger.info("Stored parent working copy ID in " + file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            this._logger.log(Level.WARNING, "Error while reading properties file", e);
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "Error while storing properties file", e);
            throw new OPatchAutoException((Throwable)e);
        }
    }

    private String getSourceWorkingCopyID(RHPParams params) throws OPatchAutoException {
        String workingCopyID = null;
        try {
            workingCopyID = OPatchautoRHPHelper.findWorkingCopyID(params.getOracleHome());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty((String)workingCopyID)) {
            throw new OPatchAutoException(Integer.toString(75052), new Object[]{params.getOracleHome()});
        }
        this._logger.info("Source working copy id for home " + params.getOracleHome() + " is::" + workingCopyID);
        return workingCopyID;
    }

    @Override
    public RHPOperation getOperationType() {
        return RHPOperation.SWITCH_HOME;
    }

    @Override
    public String getStatusMessage(RHPCommandExecutor.Status status, RHPParams params) {
        String statusMsg = "";
        switch (status) {
            case START: {
                if (params.isAnalyze()) {
                    statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchHomeCommand.status.msg.analyze.start", (Object[])new Object[]{params.getOracleHome(), this.getDestinationHomeInfo(params)});
                    break;
                }
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchHomeCommand.status.msg.start", (Object[])new Object[]{params.getOracleHome(), this.getDestinationHomeInfo(params)});
                break;
            }
            case SUCCESSFUL: {
                if (params.isAnalyze()) {
                    statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchHomeCommand.status.msg.analyze.successful", (Object[])new Object[]{params.getOracleHome(), this.getDestinationHomeInfo(params)});
                    break;
                }
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchHomeCommand.status.msg.successful", (Object[])new Object[]{params.getOracleHome(), this.getDestinationHomeInfo(params)});
                break;
            }
            case FAILED: {
                statusMsg = params.isAnalyze() ? OPatchAutoHelper.getLocalizedString((String)"RHPSwitchHomeCommand.status.msg.analyze.failed", (Object[])new Object[]{params.getOracleHome(), this.getDestinationHomeInfo(params)}) : OPatchAutoHelper.getLocalizedString((String)"RHPSwitchHomeCommand.status.msg.failed", (Object[])new Object[]{params.getOracleHome(), this.getDestinationHomeInfo(params)});
            }
        }
        return statusMsg;
    }

    private Object getDestinationHomeInfo(RHPParams params) {
        return StringUtil.isNullOrEmpty((String)params.getPath(), (boolean)true) ? params.getWorkingCopyID() : params.getPath();
    }

    private String getHomeType(OracleHomeInformationLoader.OracleHomeType homeType) {
        String type = null;
        switch (homeType) {
            case CRS: {
                type = "gihome";
                break;
            }
            case RAC: 
            case SIDB: {
                type = "database";
            }
        }
        this._logger.fine("The home type is " + type);
        return type;
    }

    private String getDestinationHomeparam(OracleHomeInformationLoader.OracleHomeType homeType) {
        String param = null;
        switch (homeType) {
            case CRS: {
                param = "-destwc";
                break;
            }
            case RAC: 
            case SIDB: {
                param = "-patchedwc";
            }
        }
        this._logger.fine("The destination param is " + param);
        return param;
    }
}

