/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.validation;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationFailureReason;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidator;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RHPSwitchbackProvisionedHomeValidator
implements RHPValidator {
    private final Logger _logger = Logger.getLogger(RHPSwitchbackProvisionedHomeValidator.class.getName());

    @Override
    public RHPValidationResult validate(OPatchAutoRHPOptions options) {
        RHPValidationResult result;
        block9: {
            result = null;
            try {
                String currentHome = options.getOption("home").getValue();
                String workingCopyID = null;
                try {
                    workingCopyID = OPatchautoRHPHelper.findWorkingCopyID(currentHome);
                }
                catch (IOException e) {
                    this._logger.log(Level.WARNING, "Failed while reading working copy id from " + currentHome, e);
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SWITCHBACK_PROVISION_HOME_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.SWITCHBACK_UNMANAGED_CURRENT_HOME, new Object[0]);
                }
                if (StringUtil.isNullOrEmpty((String)workingCopyID)) {
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SWITCHBACK_PROVISION_HOME_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.SWITCHBACK_UNMANAGED_CURRENT_HOME, new Object[0]);
                }
                if (result != null && result.getStatus() == RHPValidationResult.ValidationStatus.FAILED) break block9;
                try {
                    workingCopyID = OPatchautoRHPHelper.findPreviousHomeWorkingCopyID(currentHome);
                }
                catch (IOException e) {
                    this._logger.log(Level.WARNING, "Failed while reading previous working copy id from " + currentHome, e);
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SWITCHBACK_PROVISION_HOME_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.SWITCHBACK_UNMANAGED_PREVIOUS_HOME, currentHome);
                }
                if (StringUtil.isNullOrEmpty((String)workingCopyID)) {
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SWITCHBACK_PROVISION_HOME_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.SWITCHBACK_UNMANAGED_PREVIOUS_HOME, currentHome);
                }
            }
            catch (OPatchAutoException e) {
                this._logger.log(Level.WARNING, "Failed while getting option", e);
            }
        }
        if (result == null) {
            result = new RHPValidationResult(RHPValidator.ValidatorID.SWITCHBACK_PROVISION_HOME_VALIDATOR, RHPValidationResult.ValidationStatus.SUCCESS, null, new Object[0]);
        }
        return result;
    }
}

