/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

class InstalledItemsMarker
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private static Logger _log = Logger.getLogger(InstalledItemsMarker.class.getName());
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private List<TVertex> _ors;
    private boolean _hasConditionalConflicts;

    public InstalledItemsMarker(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
        this._ors = new ArrayList<TVertex>();
    }

    public boolean hasConditionalConflicts() {
        return this._hasConditionalConflicts;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._ors.clear();
        this._hasConditionalConflicts = false;
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        if (((VKey)vertex.getKey()).getType() == VKey.VType.OR_COND) {
            this._ors.add(vertex);
        }
        this.trace("Number of ORs: ", this._ors.size());
        return (edge == null || ((VKey)vertex.getKey()).getType() == VKey.VType.AND_COND || ((VKey)vertex.getKey()).getType() == VKey.VType.OR_COND) && ConditionHelper.hasCondPrereqs(this._graph, vertex);
    }

    @Override
    public void postVisit(TEdge edge, TVertex vertex) {
        super.postVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getType() == VKey.VType.OR_COND) {
            this._ors.remove(vertex);
        }
        this.trace("Number of ORs: ", this._ors.size());
        switch (vKey.getType()) {
            case TINFO: {
                if (edge != null) break;
                this.markVertexConflicts(vertex);
                break;
            }
            case AND_COND: {
                this.setAndVertexItemState(vertex);
                break;
            }
            case OR_COND: {
                this.setOrVertexItemState(vertex);
            }
        }
    }

    private void markVertexConflicts(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.TINFO);
        for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            VKey outVKey = (VKey)((TVertex)outEdge.getDest()).getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                assert (outVKey.getType() == VKey.VType.TINFO || outVKey.getType() == VKey.VType.UNRESOLVED);
                if (outVKey.getInstalledState() == VKey.InstalledState.INSTALLED) {
                    this.traceAction("ERROR: Two installed items conflict with each other: ", outVKey, " conflicts with ", vKey);
                    _log.severe("Invalid configuration. Two installed items conflict with each other: " + outVKey + " conflicts with " + vKey);
                    continue;
                }
                this.traceAction("MARK_CONFLICT_WITH_INSTALLED: ", outVKey);
                outVKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
                continue;
            }
            if (outVKey.getInstalledState() == VKey.InstalledState.INSTALLED || outVKey.getInstalledState() == VKey.InstalledState.COND_PREREQ_CANDIDATE) continue;
            this.traceAction("ERROR: unsatisfied prerequisite: ", outVKey, " required by ", vKey);
            _log.info("Potential configuration issue. Prerequisite " + outVKey + " required by " + vKey + " is not installed");
        }
    }

    private void setAndVertexItemState(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.AND_COND);
        VKey.InstalledState andState = VKey.InstalledState.INSTALLED;
        ArrayList<TVertex> unmarkedConflicts = new ArrayList<TVertex>();
        block8: for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                this.trace("Processing conflict " + outVKey);
                assert (outVKey.getType() == VKey.VType.TINFO || outVKey.getType() == VKey.VType.UNRESOLVED);
                if (outVKey.getType() == VKey.VType.UNRESOLVED) {
                    outVKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
                }
                switch (outVKey.getInstalledState()) {
                    case INSTALLED: {
                        if (this._ors.isEmpty()) {
                            this.traceAction("ERROR: Two installed items conflict with each other: ", outVKey, " conflicts with ", vKey);
                            _log.severe("Invalid configuration. Two installed items conflict with each other: " + outVKey + " conflicts with " + vKey);
                        } else {
                            this.trace("Found installed conditinally reachable conflict " + outVKey);
                        }
                        andState = VKey.InstalledState.NOTINSTALLED;
                        break block8;
                    }
                    case CONFLICTS_WITH_INSTALLED: {
                        this.trace("Conflict already marked " + outVKey);
                        break;
                    }
                    default: {
                        this.trace("Conflict is not installed or conflict candidate " + outVKey);
                        unmarkedConflicts.add(outV);
                        break;
                    }
                }
                continue;
            }
            this.trace("Processing prerequisite " + outVKey);
            switch (outVKey.getInstalledState()) {
                case INSTALLED: {
                    this.trace("Prerequisite already marked " + outVKey);
                    continue block8;
                }
                case COND_PREREQ_CANDIDATE: {
                    this.trace("Found conditionally reached prerequisite " + outVKey);
                    andState = VKey.InstalledState.COND_PREREQ_CANDIDATE;
                    continue block8;
                }
            }
            if (this._ors.isEmpty()) {
                this.traceAction("ERROR: unsatisfied prerequisite: ", outVKey, " required by ", vKey);
                _log.severe("Invalid configuration. Prerequisite " + outVKey + " required by " + vKey + " is not installed");
            } else {
                this.trace("Found missing conditinally reachable prerequisite " + outVKey);
            }
            andState = VKey.InstalledState.NOTINSTALLED;
            break;
        }
        this.trace("AND state after prerequisites evaluation: " + (Object)((Object)andState));
        if (!unmarkedConflicts.isEmpty()) {
            VKey conflKey;
            if (andState == VKey.InstalledState.INSTALLED) {
                if (this._ors.isEmpty()) {
                    for (TVertex confl : unmarkedConflicts) {
                        conflKey = (VKey)confl.getKey();
                        this.trace("Marked " + conflKey + " as " + (Object)((Object)VKey.InstalledState.CONFLICTS_WITH_INSTALLED));
                        conflKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
                    }
                } else {
                    andState = VKey.InstalledState.COND_PREREQ_CANDIDATE;
                }
            }
            if (andState == VKey.InstalledState.COND_PREREQ_CANDIDATE) {
                this._hasConditionalConflicts = true;
                for (TVertex confl : unmarkedConflicts) {
                    conflKey = (VKey)confl.getKey();
                    this.trace("Marked " + conflKey + " as " + (Object)((Object)VKey.InstalledState.COND_CONFL_CANDIDATE));
                    conflKey.setInstalledState(VKey.InstalledState.COND_CONFL_CANDIDATE);
                }
            }
        }
        this.trace("AND state after unresolved conflicts evaluation: " + (Object)((Object)andState));
        vKey.setInstalledState(andState);
    }

    private void setOrVertexItemState(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.OR_COND);
        VKey.InstalledState orState = VKey.InstalledState.NOTINSTALLED;
        ArrayList<TVertex> unmarkedConflicts = new ArrayList<TVertex>();
        int condPrereqs = 0;
        block8: for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                this.trace("Processing conflict " + outVKey);
                assert (outVKey.getType() == VKey.VType.TINFO || outVKey.getType() == VKey.VType.UNRESOLVED);
                if (outVKey.getType() == VKey.VType.UNRESOLVED) {
                    outVKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
                }
                switch (outVKey.getInstalledState()) {
                    case CONFLICTS_WITH_INSTALLED: {
                        orState = VKey.InstalledState.INSTALLED;
                        break block8;
                    }
                    case INSTALLED: {
                        break;
                    }
                    default: {
                        orState = VKey.InstalledState.COND_PREREQ_CANDIDATE;
                        unmarkedConflicts.add(outV);
                        break;
                    }
                }
                continue;
            }
            this.trace("Processing prerequisite " + outVKey);
            switch (outVKey.getInstalledState()) {
                case INSTALLED: {
                    orState = VKey.InstalledState.INSTALLED;
                    break block8;
                }
                case COND_PREREQ_CANDIDATE: {
                    orState = VKey.InstalledState.COND_PREREQ_CANDIDATE;
                    ++condPrereqs;
                }
                default: {
                    continue block8;
                }
            }
        }
        this.trace("OR state after prerequisites evaluation: " + (Object)((Object)orState));
        if (orState == VKey.InstalledState.COND_PREREQ_CANDIDATE && this._ors.isEmpty() && condPrereqs == 0 && unmarkedConflicts.size() == 1) {
            TVertex confl = (TVertex)unmarkedConflicts.get(0);
            VKey conflKey = (VKey)confl.getKey();
            this.trace("Marked " + conflKey + " as " + (Object)((Object)VKey.InstalledState.CONFLICTS_WITH_INSTALLED));
            conflKey.setInstalledState(VKey.InstalledState.CONFLICTS_WITH_INSTALLED);
            orState = VKey.InstalledState.INSTALLED;
        }
        if (orState == VKey.InstalledState.COND_PREREQ_CANDIDATE && !unmarkedConflicts.isEmpty()) {
            this._hasConditionalConflicts = true;
            for (TVertex confl : unmarkedConflicts) {
                VKey conflKey = (VKey)confl.getKey();
                this.trace("Marked " + conflKey + " as " + (Object)((Object)VKey.InstalledState.COND_CONFL_CANDIDATE));
                conflKey.setInstalledState(VKey.InstalledState.COND_CONFL_CANDIDATE);
            }
        }
        this.trace("OR state after unresolved conflicts evaluation: " + (Object)((Object)orState));
        vKey.setInstalledState(orState);
    }
}

