/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class TreePath {
    public static final String TREE_PATH_SEPARATOR = "/";
    private LinkedList<String> _list = new LinkedList();

    public TreePath() {
    }

    public TreePath(String path) {
        this.setPath(path);
    }

    public void setPath(String path) {
        this._list.clear();
        this.append(path);
    }

    public int getLength() {
        return this._list.size();
    }

    public void prepend(String path) {
        if (path != null) {
            String[] parts;
            for (String part : parts = path.split(TREE_PATH_SEPARATOR)) {
                this._list.add(0, part);
            }
        }
    }

    public TreePath prepend(TreePath path) {
        if (path != null) {
            this.prepend(path.toString());
        }
        return this;
    }

    public void append(String path) {
        if (path != null) {
            String[] parts = path.split(TREE_PATH_SEPARATOR);
            this._list.addAll(Arrays.asList(parts));
        }
    }

    public TreePath append(TreePath path) {
        if (path != null) {
            this.append(path.toString());
        }
        return this;
    }

    public boolean isPartialPath(String path) {
        return this.isPartialPath(new TreePath(path));
    }

    public boolean isPartialPath(TreePath partialPath) {
        int ppiLength = partialPath.getLength();
        if (ppiLength == 0 || this.getLength() == 0 || ppiLength > this.getLength()) {
            return false;
        }
        Iterator it = this.iterator();
        Iterator ppi = partialPath.iterator();
        while (ppi.hasNext()) {
            String partialPathElement;
            String pathElement = (String)it.next();
            if (pathElement.equals(partialPathElement = (String)ppi.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ListIterator lit = this._list.listIterator();
        while (lit.hasNext()) {
            sb.append((String)lit.next());
            if (!lit.hasNext()) continue;
            sb.append(TREE_PATH_SEPARATOR);
        }
        return sb.toString();
    }

    public Iterator iterator() {
        final Iterator it = this._list.iterator();
        return new Iterator(){

            public Object next() {
                return it.next();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object obj) {
        boolean match = false;
        if (obj instanceof TreePath) {
            match = this.toString().equals(obj.toString());
        }
        return match;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

