/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.productdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import oracle.osysmodel.driver.sdk.productdriver.HostComparatorCreator;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.osysmodel.driver.sdk.util.OsysUtility;

public abstract class ProductDriver {
    protected SystemInstance ti = null;
    protected LocalInfo localInfo = null;

    public abstract SystemInstance buildSystemInstance();

    public SystemInstance constructSystemInstance() throws ProductDriverException {
        if (this.ti != null) {
            return this.ti;
        }
        this.ti = this.buildSystemInstance();
        return this.ti;
    }

    public abstract LocalInfo getLocalInfo();

    public void setLocalInfoBySystemInstance(SystemInstance systemInstance) {
        OracleHome oracleHome2;
        Object object2;
        this.localInfo = new LocalInfo();
        this.localInfo.setOracleHomes(new ArrayList<OracleHome>());
        for (Object object2 : systemInstance.getEntities()) {
            if (!(object2 instanceof OracleHome)) continue;
            oracleHome2 = (OracleHome)object2;
            this.localInfo.getOracleHomes().add(oracleHome2);
        }
        ArrayList arrayList = new ArrayList();
        for (OracleHome oracleHome2 : systemInstance.getEntities()) {
            if (!(oracleHome2 instanceof Host)) continue;
            Host host = (Host)oracleHome2;
            arrayList.add(host);
        }
        object2 = HostComparatorCreator.getInstance();
        Collections.sort(arrayList, ((HostComparatorCreator)object2).getHostComparator());
        oracleHome2 = (Host)arrayList.get(0);
        this.localInfo.setLocalHostName(oracleHome2.getHostName());
        this.localInfo.setLocalHost((Host)oracleHome2);
    }

    @Deprecated
    public OracleHome copyHome(OracleHome oracleHome) {
        OracleHome oracleHome2 = new OracleHome();
        oracleHome2.setDescription(oracleHome.getDescription());
        oracleHome2.setDisplayName(oracleHome.getDisplayName());
        oracleHome2.setName(oracleHome.getName());
        oracleHome2.setHomeName(oracleHome.getHomeName());
        oracleHome2.setARUId(oracleHome.getARUId());
        oracleHome2.setPath(oracleHome.getPath());
        oracleHome2.setOriginalOracleHome(oracleHome.getOriginalOracleHome());
        oracleHome2.setARUId(oracleHome.getARUId());
        oracleHome2.setCentralInvPtr(oracleHome.getCentralInvPtr());
        oracleHome2.setHomeGuid(oracleHome.getHomeGuid());
        oracleHome2.setHomeType(oracleHome.getHomeType());
        oracleHome2.setHosts(oracleHome.getHosts());
        oracleHome2.setInstalledSWComponents(new ArrayList(oracleHome.getInstalledSWComponents()));
        oracleHome2.setOCM(oracleHome.getOCM());
        oracleHome2.setOwner(oracleHome.getOwner());
        oracleHome2.setPatches(oracleHome.getPatches());
        oracleHome2.setOracleBaseLocation(oracleHome.getOracleBaseLocation());
        oracleHome2.setPlatform(oracleHome.getPlatform());
        oracleHome2.setTopComponents(oracleHome.getTopComponents());
        oracleHome2.setTopLevelOUI(oracleHome.getTopLevelOUI());
        oracleHome2.setType(oracleHome.getType());
        oracleHome2.setVersion(oracleHome.getVersion());
        oracleHome2.setVersionOPatch(oracleHome.getVersionOPatch());
        oracleHome2.setId(UUID.randomUUID().toString());
        return oracleHome2;
    }

    protected void defaultValues(AbstractBaseTarget abstractBaseTarget) {
        abstractBaseTarget.setDisplayName(abstractBaseTarget.getName());
        abstractBaseTarget.setId("ID_" + UUID.randomUUID().toString());
        abstractBaseTarget.setPlatform("linux");
        abstractBaseTarget.setType(abstractBaseTarget.getClass().getName());
        abstractBaseTarget.setDescription("A " + abstractBaseTarget.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HostComparator
    implements Comparator<Host> {
        @Override
        public int compare(Host host, Host host2) {
            String string = OsysUtility.getHostname();
            if (host.getHostName().equals(string)) {
                return -1;
            }
            if (host2.getHostName().equals(string)) {
                return 1;
            }
            return host.getHostName().compareTo(host2.getHostName());
        }
    }
}

