/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeFilter;
import com.oracle.cie.common.comdev.TreeVisitor;
import java.io.PrintWriter;

public class TreePrintVisitor
extends TreeVisitor {
    public static final int TAB_SIZE = 4;
    private Tree _root;
    private int _rootDepth;
    private int _tabSize = 4;
    private int _offset = 4;
    private char _indexSeperator = (char)46;
    private boolean _useSpecialChar = ComdevHelper.cIsWin32;
    protected PrintWriter _out = new PrintWriter(System.out);
    protected Tree _currTree;
    private int _relDepth;
    private int[] _indicesInParent;
    private boolean[] _lastChildInParent;

    public TreePrintVisitor(Tree root) {
        this.init(root);
    }

    public TreePrintVisitor() {
        this.init(null);
    }

    @Override
    public Tree getRoot() {
        return this._root;
    }

    public void setOut(PrintWriter out) {
        this._out = out == null ? new PrintWriter(System.out) : out;
    }

    public PrintWriter getOut() {
        return this._out;
    }

    public void setTabSize(int t) {
        this._tabSize = t;
    }

    public void setOffset(int t) {
        this._offset = t;
    }

    public void setIndexSeperator(char sep) {
        this._indexSeperator = sep;
    }

    public char getIndexSeperator() {
        return this._indexSeperator;
    }

    @Override
    public void setRoot(Tree root) {
        this.init(root);
    }

    public void setUseSpecialChar(boolean b) {
        this._useSpecialChar = b;
    }

    public boolean isUseSpecialChar() {
        return this._useSpecialChar;
    }

    @Override
    public void visitTree(Tree t, TreeFilter filter) {
        this._currTree = t;
        this._relDepth = this._currTree.getDepth() - this._rootDepth;
        this._indicesInParent = new int[this._relDepth + 1];
        this._lastChildInParent = new boolean[this._relDepth + 1];
        if (this._relDepth > 0) {
            Tree p = t.getParent();
            for (int i = this._relDepth; i > 0; --i) {
                if (filter == null) {
                    this._indicesInParent[i] = p.getIndexOfSubtree(t);
                    this._lastChildInParent[i] = this._indicesInParent[i] == p.getDegree() - 1;
                } else {
                    this._indicesInParent[i] = filter.getIndexOfSubtree(p, t);
                    this._lastChildInParent[i] = this._indicesInParent[i] == filter.getDegree(p) - 1;
                }
                t = p;
                p = p.getParent();
            }
            this._indicesInParent[0] = -1;
            this._lastChildInParent[0] = false;
        }
        this.println(this.getTreeLine());
    }

    public String getName(Tree currTree) {
        return currTree.toString();
    }

    protected String getTreeLine() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this._offset; ++i) {
            sb.append(' ');
        }
        if (this._relDepth > 0) {
            for (i = 0; i < this._relDepth - 1; ++i) {
                sb.append((char)(this._lastChildInParent[i + 1] ? 32 : (this._useSpecialChar ? 179 : 124)));
                for (int j = 0; j < this._tabSize; ++j) {
                    sb.append(' ');
                }
            }
            if (this._useSpecialChar) {
                sb.append(this._lastChildInParent[this._relDepth] ? (char)'\u00c0' : '\u00c3');
            } else {
                sb.append("|_");
            }
            for (i = 0; i < this._tabSize; ++i) {
                sb.append(this._useSpecialChar ? (char)'\u00c4' : '_');
            }
        }
        sb.append(this.getName(this._currTree));
        return sb.toString();
    }

    protected String getIndicesString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" [");
        for (int i = 1; i < this._indicesInParent.length - 1; ++i) {
            sb.append(this._indicesInParent[i] + 1).append(this._indexSeperator);
        }
        sb.append(this._indicesInParent[this._relDepth] + 1).append("] ");
        return sb.toString();
    }

    protected void println(String s) {
        this._out.println(s);
        this._out.flush();
    }

    private void init(Tree root) {
        if (root != null) {
            this._root = root;
            this._rootDepth = root.getDepth();
        }
    }
}

