/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.CheckTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox _check;
    protected DefaultTreeCellRenderer _label;
    protected boolean _disabled;
    protected boolean _selectable;
    protected boolean _selected;
    protected Dimension _preferredSize = new Dimension();
    protected Dimension _checkPreferredSize;

    public CheckTreeCellRenderer() {
        this(new DefaultTreeCellRenderer());
    }

    public CheckTreeCellRenderer(DefaultTreeCellRenderer renderer) {
        this.setLayout(null);
        this._check = new JCheckBox();
        this.add(this._check);
        this._label = renderer;
        this.add(this._label);
        this._check.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    public void getNodeStates(CheckTree tree, Object value, boolean leaf) {
        this._selectable = tree.isSelectable(value);
        if (!leaf) {
            this._selected = false;
            int count = tree.getModel().getChildCount(value);
            for (int x = 0; x < count; ++x) {
                Object child = tree.getModel().getChild(value, x);
                if (!tree.isSelected(child)) continue;
                this._selected = tree.isSelected(value);
                break;
            }
        } else {
            this._selected = tree.isSelected(value);
        }
        this._disabled = tree.isDisabled(value);
    }

    public Dimension getCheckBoxPreferredSize() {
        if (this._checkPreferredSize == null) {
            this._checkPreferredSize = this._check.getPreferredSize();
        }
        return this._checkPreferredSize;
    }

    public JCheckBox getCheckBox() {
        return this._check;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this._label.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        this.getNodeStates((CheckTree)tree, value, leaf);
        if (leaf && this._selectable) {
            this._label.setIcon(null);
        }
        this._check.setBackground(tree.getBackground());
        this._check.setVisible(this._selectable);
        this._check.setEnabled(!this._disabled);
        this._check.setSelected(this._selected);
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimLabel = this._label.getPreferredSize();
        if (!this._selectable) {
            return dimLabel;
        }
        if (this._checkPreferredSize == null) {
            this._checkPreferredSize = this._check.getPreferredSize();
        }
        this._preferredSize.setSize(this._checkPreferredSize.width + dimLabel.width, this._checkPreferredSize.height < dimLabel.height ? dimLabel.height : this._checkPreferredSize.height);
        return this._preferredSize;
    }

    @Override
    public void doLayout() {
        Dimension dimLabel = this._label.getPreferredSize();
        if (!this._selectable) {
            this._label.setLocation(0, 0);
            this._label.setBounds(0, 0, dimLabel.width, dimLabel.height);
            return;
        }
        if (this._checkPreferredSize == null) {
            this._checkPreferredSize = this._check.getPreferredSize();
        }
        int yCheck = 0;
        int yLabel = 0;
        if (this._checkPreferredSize.height < dimLabel.height) {
            yCheck = (dimLabel.height - this._checkPreferredSize.height) / 2;
        } else {
            yLabel = (this._checkPreferredSize.height - dimLabel.height) / 2;
        }
        this._check.setLocation(0, yCheck);
        this._check.setBounds(0, yCheck, this._checkPreferredSize.width, this._checkPreferredSize.height);
        this._label.setLocation(this._checkPreferredSize.width, yLabel);
        this._label.setBounds(this._checkPreferredSize.width, yLabel, dimLabel.width, dimLabel.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }
}

