/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.FixedJTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GUIHelper {
    public static final Color ERROR_COLOR = new Color(204, 0, 0);
    public static final Color WARNING_COLOR = new Color(255, 153, 0);
    public static String PLAIN_SERVER_NAME_SCHEME = "http";
    public static String SSL_SERVER_NAME_SCHEME = "https";
    public static String SERVER_NAME_SCHEME_HOST_DELIMITER = "://";
    public static String SERVER_NAME_HOST_PORT_DELIMITER = ":";

    public static void initPLAF() {
        UIManager.put("ClassLoader", GUIHelper.class.getClassLoader());
        MetalTheme theme = null;
        try {
            Class<?> themeClazz = Class.forName("oracle.bali.ewt.olaf2.OracleFusionFXTheme");
            theme = (MetalTheme)themeClazz.newInstance();
        }
        catch (Throwable ex) {
            Logger.getLogger(GUIHelper.class.getName()).info("Unable to load FusionFX LaF theme");
        }
        try {
            Class<?> lafClazz = Class.forName("oracle.bali.ewt.olaf2.OracleLookAndFeel");
            LookAndFeel laf = (LookAndFeel)lafClazz.newInstance();
            if (theme != null) {
                Method m = lafClazz.getMethod("setCurrentTheme", MetalTheme.class);
                m.invoke(lafClazz, theme);
            }
            UIManager.setLookAndFeel(laf);
            Object[] jewtOverrides = new Object[]{"Button.margin", new InsetsUIResource(1, 13, 1, 13), "ScrollBar.thumbHighlight", new ColorUIResource(Color.WHITE), "ScrollBar.width", 13, "SplitPane.dividerSize", 4, "CheckBox.disabledText", UIManager.getLookAndFeelDefaults().getColor("textText"), "ToolTip.foregroundInactive", UIManager.getLookAndFeelDefaults().getColor("ToolTip.foreground"), "Tree.paintLines", Boolean.FALSE, "Tree.selectionBackground", UIManager.getLookAndFeelDefaults().get("activeCaption"), "Tree.selectionForeground", UIManager.getLookAndFeelDefaults().get("Tree.textForeground"), "Table.gridColor", UIManager.getLookAndFeelDefaults().get("controlDkShadow"), "TextField.margin", new InsetsUIResource(1, 4, 1, 2), "FormattedTextField.margin", new InsetsUIResource(1, 4, 1, 2), "PasswordField.margin", new InsetsUIResource(1, 4, 1, 2)};
            UIManager.getLookAndFeelDefaults().putDefaults(jewtOverrides);
        }
        catch (Exception x) {
            Logger.getLogger(GUIHelper.class.getName()).info("Unable to load LaF");
        }
    }

    public static int expandJTreeNode(JTree tree, Object node, int row, int depth) {
        TreeModel model = tree.getModel();
        if (node == null || model.isLeaf(node)) {
            return row;
        }
        boolean allRows = false;
        if (row == -1 || node == model.getRoot() && !tree.isRootVisible()) {
            row = 0;
            allRows = true;
        } else {
            tree.expandRow(row);
        }
        if (depth > 0) {
            for (int i = 0; row + 1 <= tree.getRowCount() && i < model.getChildCount(node); ++i) {
                TreePath path;
                Object child;
                if (!allRows) {
                    ++row;
                }
                if ((child = model.getChild(node, i)) == null) break;
                while ((path = tree.getPathForRow(row)) != null && path.getLastPathComponent() != child) {
                    ++row;
                }
                if (path == null) break;
                row = GUIHelper.expandJTreeNode(tree, child, row, depth - 1);
            }
        }
        return row;
    }

    public static JTable createDisplayTable(TableModel model) {
        FixedJTable table = new FixedJTable(model){

            @Override
            public void setModel(TableModel model) {
                super.setModel(model);
                Font font = UIManager.getFont("Table.font");
                FontMetrics fm = this.getFontMetrics(font);
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    int maxWidth = 0;
                    for (int row = 0; row < model.getRowCount(); ++row) {
                        String s;
                        int w;
                        Object val = model.getValueAt(row, col);
                        if (val == null || maxWidth >= (w = fm.stringWidth(s = val.toString()))) continue;
                        maxWidth = w;
                    }
                    TableColumnModel cm = this.getColumnModel();
                    TableColumn c = cm.getColumn(col);
                    c.setPreferredWidth(maxWidth += 10);
                    c.setMinWidth(maxWidth);
                }
            }
        };
        table.setAutoResizeMode(0);
        table.setBackground(UIManager.getColor("Panel.background"));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setBackground(UIManager.getColor("Panel.background"));
        table.setDefaultRenderer(Object.class, renderer);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        return table;
    }

    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int[] width = new int[columns.getColumnCount()];
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columns.getColumn(i);
            column.setMinWidth(75);
            if (!column.getResizable()) {
                width[i] = column.getWidth();
                continue;
            }
            int columnIndex = column.getModelIndex();
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                JComponent c = (JComponent)h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width[i] = c.getPreferredSize().width;
            }
            for (int row = rowCount - 1; row >= 0; --row) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width[i] = Math.max(width[i], c.getPreferredSize().width);
            }
            column.setPreferredWidth(width[i] + margin);
        }
    }

    public static GridBagConstraints getGridBagConstraints(int x, int y, int width, int height) {
        return new GridBagConstraints(x, y, width, height, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
    }
}

