/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TreeTableHeaderCellRenderer
extends DefaultTableCellRenderer {
    private Color defaultBackgroundColor;
    private Border defaultBorder;
    private Color defaultForegroundColor;
    private TableCellRenderer delegateRenderer;

    public TreeTableHeaderCellRenderer() {
        this(new DefaultTableCellRenderer());
    }

    public TreeTableHeaderCellRenderer(TableCellRenderer renderer) {
        this.delegateRenderer = renderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object valueObject, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Component component = this.delegateRenderer != null ? this.delegateRenderer.getTableCellRendererComponent(table, valueObject, isSelected, hasFocus, rowIndex, columnIndex) : super.getTableCellRendererComponent(table, valueObject, isSelected, hasFocus, rowIndex, columnIndex);
        if (component instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)component;
            renderer.setBackground(this.defaultBackgroundColor);
            renderer.setBorder(this.defaultBorder);
            renderer.setForeground(this.defaultForegroundColor);
            renderer.setFont(table.getFont());
            renderer.setHorizontalAlignment(2);
            this.setText(valueObject == null ? "" : valueObject.toString());
        }
        return component;
    }

    @Override
    public void updateUI() {
        this.defaultBackgroundColor = UIManager.getColor("TableHeader.background");
        this.defaultBorder = UIManager.getBorder("TableHeader.cellBorder");
        this.defaultForegroundColor = UIManager.getColor("TableHeader.foreground");
    }
}

