/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.threads.CategoryOutputThread;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Chmod {
    protected static final Logger s_logger = Logger.getLogger(Chmod.class.getName());
    private static final String CHMOD_CMD = "/bin/chmod";
    private static final String ATTRIB_CMD = "attrib";
    private static final String CHMOD_RECURSE_FLAG = "-R";

    public static boolean chmod(String file, String mode, boolean recursive) {
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(CHMOD_CMD);
            if (recursive) {
                cmdList.add(CHMOD_RECURSE_FLAG);
            }
            cmdList.add(mode);
            cmdList.add(file);
            Process process = Runtime.getRuntime().exec(cmdList.toArray(new String[cmdList.size()]));
            if (s_logger.isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer("Executing: ");
                Iterator i = cmdList.iterator();
                while (i.hasNext()) {
                    sb.append('\"').append(i.next()).append("\" ");
                }
                s_logger.fine(sb.toString());
                CategoryOutputThread output = new CategoryOutputThread(process.getInputStream(), "output");
                CategoryOutputThread error = new CategoryOutputThread(process.getErrorStream(), "error");
                output.start();
                error.start();
            }
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, "Error encoutered during chmod", e);
            return false;
        }
    }

    public static void wildcardChmod(File file, String mode, FileFilter filter) {
        if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            if (files != null) {
                for (int x = 0; x < files.length; ++x) {
                    Chmod.wildcardChmod(files[x], mode, filter);
                }
            }
        } else {
            Chmod.chmod(file.getPath(), mode, false);
        }
    }

    public static boolean attrib(File file, String attrib, boolean recursive) {
        try {
            CategoryOutputThread error;
            CategoryOutputThread output;
            Iterator i;
            StringBuffer sb;
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(ATTRIB_CMD);
            String[] atts = attrib.split("\\s+");
            for (int i2 = 0; atts != null && i2 < atts.length; ++i2) {
                cmdList.add(atts[i2]);
            }
            cmdList.add(file.getAbsolutePath());
            Process ps = Runtime.getRuntime().exec(cmdList.toArray(new String[cmdList.size()]));
            if (s_logger.isLoggable(Level.FINE)) {
                sb = new StringBuffer("Executing:");
                i = cmdList.iterator();
                while (i.hasNext()) {
                    sb.append(" \"").append(i.next()).append('\"');
                }
                s_logger.fine(sb.toString());
                output = new CategoryOutputThread(ps.getInputStream(), "output");
                error = new CategoryOutputThread(ps.getErrorStream(), "error");
                output.start();
                error.start();
            }
            ps.waitFor();
            if (ps.exitValue() != 0) {
                return false;
            }
            if (recursive && file.isDirectory()) {
                cmdList.remove(file.getAbsolutePath());
                cmdList.add("*");
                cmdList.add("/S");
                cmdList.add("/D");
                ps = Runtime.getRuntime().exec(cmdList.toArray(new String[cmdList.size()]), null, file);
                if (s_logger.isLoggable(Level.FINE)) {
                    sb = new StringBuffer("Executing:");
                    i = cmdList.iterator();
                    while (i.hasNext()) {
                        sb.append(" \"").append(i.next()).append('\"');
                    }
                    sb.append(" in [").append(file).append("]");
                    s_logger.fine(sb.toString());
                    output = new CategoryOutputThread(ps.getInputStream(), "output");
                    error = new CategoryOutputThread(ps.getErrorStream(), "error");
                    output.start();
                    error.start();
                }
                ps.waitFor();
                return ps.exitValue() == 0;
            }
            return true;
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, "Error encoutered during chmod", e);
            return false;
        }
    }

    public static void wildcardAttrib(File file, String attrib, FileFilter filter) {
        if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            if (files != null) {
                for (int x = 0; x < files.length; ++x) {
                    Chmod.wildcardAttrib(files[x], attrib, filter);
                }
            }
        } else {
            Chmod.attrib(file, attrib, false);
        }
    }
}

