/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;

public class FileEncodingHelper {
    public static final int BOM = 0;
    public static final int DECLARED = 1;

    public static String detect(File file) throws IOException {
        return FileEncodingHelper.detect(file, 0, true);
    }

    public static String detect(File file, int method, boolean system) throws IOException {
        String encoding = null;
        switch (method) {
            case 0: {
                encoding = FileEncodingHelper.detectBOM(file);
                break;
            }
            case 1: {
                encoding = FileEncodingHelper.detectDeclared(file);
                break;
            }
            default: {
                throw new IllegalArgumentException("Detection method #" + method + " is not supported.");
            }
        }
        if (encoding != null && !Charset.isSupported(encoding)) {
            encoding = null;
        }
        if (!system) {
            return encoding;
        }
        return encoding != null ? encoding : System.getProperty("file.encoding");
    }

    public static String detectDeclared(File file) throws IOException {
        if (file.getName().endsWith(".xml")) {
            return FileEncodingHelper.findXmlEncodingDeclaration(file);
        }
        if (file.getName().endsWith(".jsp")) {
            return FileEncodingHelper.findJspEncodingDeclaration(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findXmlEncodingDeclaration(File file) throws IOException {
        String encoding = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            int index;
            encoding = null;
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            String line = br.readLine();
            if (line != null && (line = line.trim()).startsWith("<?") && (index = line.toLowerCase().indexOf("encoding=")) != -1) {
                char c = line.charAt(index += 9);
                while (c == ' ') {
                    c = line.charAt(++index);
                }
                String encap = null;
                if (c == '\'') {
                    encap = "'";
                }
                if (c == '\"') {
                    encap = "\"";
                }
                if (c == '`') {
                    encap = "`";
                }
                if (encap == null) {
                    encap = "?";
                } else {
                    ++index;
                }
                encoding = line.substring(index, line.indexOf(encap, index)).trim();
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException iOException) {}
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findJspEncodingDeclaration(File file) throws IOException {
        String encoding = null;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            encoding = null;
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.toLowerCase().trim().startsWith("<%@ page")) continue;
                boolean page = false;
                int index = line.indexOf("pageEncoding=");
                if (index == -1) {
                    index = line.indexOf("contentType=");
                } else {
                    page = true;
                }
                if (index == -1) continue;
                index = page ? (index += 13) : (index += 12);
                char c = line.charAt(index);
                while (c == ' ') {
                    c = line.charAt(++index);
                }
                String encap = null;
                if (c == '\'') {
                    encap = "'";
                }
                if (c == '\"') {
                    encap = "\"";
                }
                if (c == '`') {
                    encap = "`";
                }
                if (page) {
                    if (encap == null) {
                        encap = "%";
                    } else {
                        ++index;
                    }
                    encoding = line.substring(index, line.indexOf(encap, index)).trim();
                } else {
                    if (encap == null) {
                        encap = "%";
                    }
                    if ((index = line.toLowerCase().indexOf("charset=", index + 1)) == -1) continue;
                    encoding = line.substring(index += 8, line.indexOf(encap, index + 1)).trim();
                }
                break;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException iOException) {}
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectBOM(File file) throws IOException {
        String encoding = null;
        FileInputStream is = null;
        try {
            encoding = null;
            is = new FileInputStream(file);
            byte[] bom = new byte[4];
            is.read(bom, 0, 4);
            int zero = new Byte(bom[0]).intValue();
            int one = new Byte(bom[1]).intValue();
            int two = new Byte(bom[2]).intValue();
            int three = new Byte(bom[3]).intValue();
            if (zero < 0) {
                zero += 256;
            }
            if (one < 0) {
                one += 256;
            }
            if (two < 0) {
                two += 256;
            }
            if (three < 0) {
                three += 256;
            }
            if (zero == 239 && one == 187 && two == 191) {
                encoding = "UTF-8";
            } else if (zero == 254 && one == 255) {
                encoding = "UTF-16BE";
            } else if (zero == 255 && one == 254) {
                encoding = "UTF-16LE";
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return encoding;
    }
}

