/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.JdkHelper;
import com.oracle.cie.common.util.JdkVersion;
import java.io.File;

public class JVMEntry {
    String _vendor = "";
    String _version = "";
    String _vmType = "";
    String _home = "";
    String _productName = null;
    String _productVersion = null;
    boolean _currentProduct = false;

    public JVMEntry(String vendor, String version, String home) {
        if (vendor != null) {
            this._vendor = vendor;
        }
        if (version != null) {
            this._version = version;
        }
        if (home != null) {
            this._home = home;
            this._vmType = JdkHelper.getVMType(new File(this._home));
        }
    }

    public JVMEntry(String home) {
        if (home != null) {
            this._home = home;
            this._version = JdkHelper.getJdkVersion(this._home);
            this._vendor = JdkHelper.getJdkVendor(this._home);
            this._vmType = JdkHelper.getVMType(new File(this._home));
        }
    }

    public String getVendor() {
        return this._vendor;
    }

    public String getVMType() {
        return this._vmType;
    }

    public String getVersion() {
        return this._version;
    }

    public String getHome() {
        return this._home;
    }

    public JdkVersion getJdkVersion() {
        return new JdkVersion(this._version);
    }

    public String getProductName() {
        return this._productName;
    }

    public void setProductName(String productName) {
        this._productName = productName;
    }

    public String getProductVersion() {
        return this._productVersion;
    }

    public void setProductVersion(String productVersion) {
        this._productVersion = productVersion;
    }

    public boolean isCurrentProduct() {
        return this._currentProduct;
    }

    public void setCurrentProduct(boolean currentProduct) {
        this._currentProduct = currentProduct;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String emptyString = " ";
        if (this._vendor != null && this._vendor.trim().length() > 0) {
            sb.append(this._vendor).append(emptyString);
        }
        if (this._vmType != null && this._vmType.trim().length() > 0) {
            sb.append(this._vmType).append(emptyString);
        }
        sb.append("SDK ").append(this._version).append(" @ ").append(this._home);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this._home != null) {
            return this._home.equals(((JVMEntry)o).getHome());
        }
        return false;
    }

    public int hashCode() {
        int hash = 9;
        hash = 31 * hash + (null == this._home ? 0 : this._home.hashCode());
        return hash;
    }
}

