/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IObjectStore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class ObjectStoreInvocationHandler
implements InvocationHandler {
    protected static final Logger s_logger = Logger.getLogger(IObjectStore.class.getName());
    private IObjectStore _os = null;

    public ObjectStoreInvocationHandler(IObjectStore os) {
        this._os = os;
        s_logger.fine("ObjectStore <" + this._os.getNamespace() + "> instantiated.");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StringBuffer sb = new StringBuffer();
        if (args != null) {
            sb.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                sb.append(",").append(args[i]);
            }
        }
        s_logger.fine("ObjectStore <" + this._os.getNamespace() + "> " + method.getName() + " parameters (" + sb.toString() + ")");
        Object obj = method.invoke((Object)this._os, args);
        s_logger.fine("ObjectStore <" + this._os.getNamespace() + "> " + method.getName() + " returned (" + obj + ")");
        return obj;
    }
}

