/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;

public class TempFileHandler {
    private static Logger _log = Logger.getLogger(TempFileHandler.class.getName());
    private static File _tempFolder = null;
    private static Map<String, File> _tempFileTrack = new HashMap<String, File>();

    public static synchronized File getTempFolder() throws IOException {
        return TempFileHandler.getTempFolder(null, null, true);
    }

    public static synchronized File getTempFolder(String prefix, String suffix) throws IOException {
        return TempFileHandler.getTempFolder(prefix, suffix, false);
    }

    public static synchronized File getTempFolder(String prefix, String suffix, boolean cache) throws IOException {
        return TempFileHandler.getTempFolder(prefix, suffix, cache, null);
    }

    public static synchronized File getTempFolder(String prefix, String suffix, boolean cache, File parentDir) throws IOException {
        if (_tempFolder == null || !cache) {
            String secureTemp = System.getProperty("CIE_TMPDIR");
            File temp = !StringUtil.isNullOrEmpty(secureTemp) ? new File(secureTemp) : TempFileHandler.createTempFolder(prefix, suffix, parentDir);
            if (!(temp.exists() && temp.canRead() && temp.canWrite() && temp.canExecute())) {
                throw new IOException("Temp folder does not have read/write/execute permission for current user. " + temp.getAbsolutePath());
            }
            if (cache) {
                _tempFolder = temp;
            }
            _log.fine("Temp files dir: " + temp.getAbsolutePath());
            return temp;
        }
        return _tempFolder;
    }

    private static File createTempFolder(String prefix, String suffix, File parentDir) throws IOException {
        File temp;
        prefix = StringUtil.isNullOrEmpty(prefix, true) ? "config-wiz-" : prefix.replace('/', '_').replace('\\', '_');
        Random r = new Random();
        String folderName = prefix + r.nextInt(400) + "-" + System.currentTimeMillis();
        if (suffix != null) {
            suffix = suffix.replace('/', '_').replace('\\', '_');
            folderName = folderName + suffix;
        }
        if (parentDir == null) {
            parentDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (!(temp = new File(parentDir, folderName)).exists()) {
            boolean created = temp.mkdirs();
            if (!created) {
                _log.severe("Cannot create temp folder at " + temp.getAbsolutePath());
                throw new IOException("Cannot create temp folder at " + temp.getAbsolutePath());
            }
        } else if (!temp.isDirectory()) {
            _log.severe("Cannot create temp folder at " + temp.getAbsolutePath() + " because existing location is not a directory.");
            throw new IOException("Cannot create temp folder at " + temp.getAbsolutePath() + " because existing location is not a directory.");
        }
        _log.fine("Created new Temp files dir: " + temp.getAbsolutePath());
        temp.deleteOnExit();
        return temp;
    }

    public static File getTempFile(String prefix, String suffix) throws IOException {
        return TempFileHandler.getTempFile(prefix, suffix, null);
    }

    public static File getTempFile(String prefix, String suffix, File parentDir) throws IOException {
        if (prefix == null) {
            _log.fine("The prefix passed in for Temp file creation is null.");
            prefix = "config-";
        } else {
            prefix = prefix.replace('/', '_').replace('\\', '_');
        }
        if (suffix == null) {
            _log.fine("The suffix passed in for Temp file creation is null.");
            suffix = ".tmp";
        } else {
            suffix = suffix.replace('/', '_').replace('\\', '_');
        }
        if (parentDir == null) {
            parentDir = TempFileHandler.getTempFolder();
        }
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        _log.fine("Creating temp file: prefix=" + prefix + ", suffix=" + suffix + ", parentDir=" + parentDir);
        File f = File.createTempFile(prefix, suffix, parentDir);
        f.deleteOnExit();
        return f;
    }

    public static void addTempFileToTrackMap(String fileName, File f) {
        if (fileName == null || f == null) {
            _log.fine("Unable to add a file in tracking map");
        }
        if (!_tempFileTrack.containsKey(fileName)) {
            _tempFileTrack.put(fileName, f);
        }
    }

    public static Map<String, File> getTempFileTrackMap() {
        return _tempFileTrack;
    }
}

