/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.ReflectionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipHelper {
    private static final int BUFFER_SIZE = 4096;

    public static final void unzip(String zipFilePath, String destDirectory) throws FileNotFoundException, IOException {
        ZipHelper.unzip(new File(zipFilePath), new File(destDirectory));
    }

    public static final void unzip(File zipFile, File destDir) throws FileNotFoundException, IOException {
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        if (ZipHelper.apacheUnzip(zipFile, destDir)) {
            return;
        }
        ZipInputStream zipIS = null;
        try {
            zipIS = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = zipIS.getNextEntry();
            while (entry != null) {
                String filePath = destDir.getPath() + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    ZipHelper.extractFile(zipIS, filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIS.closeEntry();
                entry = zipIS.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (zipIS != null) {
                    zipIS.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void extractFile(ZipInputStream zipIS, String destPath) throws FileNotFoundException, IOException {
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(destPath));
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIS.read(bytesIn)) != -1) {
                ((BufferedOutputStream)bos).write(bytesIn, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        boolean isZipped = false;
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            isZipped = new ZipInputStream(in).getNextEntry() != null;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return isZipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean apacheUnzip(File archiveFile, File destDir) throws FileNotFoundException, IOException {
        Object zipFile = null;
        try {
            try {
                zipFile = ReflectionHelper.createObject("org.apache.commons.compress.archivers.zip.ZipFile", new Class[]{File.class}, new Object[]{archiveFile}, null);
                Enumeration zipEntries = (Enumeration)ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipFile", zipFile, "getEntriesInPhysicalOrder", new Class[0], new Object[0]);
                while (zipEntries.hasMoreElements()) {
                    Object entry = zipEntries.nextElement();
                    String entryName = (String)ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipArchiveEntry", entry, "getName", new Class[0], new Object[0]);
                    File outFile = new File(destDir, entryName);
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    if (Boolean.parseBoolean(ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipArchiveEntry", entry, "isDirectory", new Class[0], new Object[0]).toString())) {
                        outFile.mkdir();
                        continue;
                    }
                    InputStream zipStream = null;
                    FileOutputStream outFileStream = null;
                    zipStream = (InputStream)ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipFile", zipFile, "getInputStream", new Class[]{entry.getClass()}, new Object[]{entry});
                    outFileStream = new FileOutputStream(outFile);
                    try {
                        ReflectionHelper.process("org.apache.commons.compress.utils.IOUtils", null, "copy", new Class[]{InputStream.class, OutputStream.class}, new Object[]{zipStream, outFileStream});
                        if ((Integer.parseInt(ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipArchiveEntry", entry, "getUnixMode", new Class[0], new Object[0]).toString()) & 0x40) == 0) continue;
                        outFile.setExecutable(true);
                    }
                    finally {
                        zipStream.close();
                        ((OutputStream)outFileStream).close();
                    }
                }
            }
            catch (Throwable throwable) {
                ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipFile", null, "closeQuietly", new Class[]{zipFile.getClass()}, new Object[]{zipFile});
                throw throwable;
            }
            ReflectionHelper.process("org.apache.commons.compress.archivers.zip.ZipFile", null, "closeQuietly", new Class[]{zipFile.getClass()}, new Object[]{zipFile});
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

